
/*******************************************************************************
 *
 * TempSensorMode.c
 *
 ******************************************************************************/

#include <driverlib.h>
#include "TempSensorMode.h"

#define NUM_SAMPLES    (64)
volatile unsigned int raw[NUM_SAMPLES] = {0};
volatile float  adc_corrected[NUM_SAMPLES] = {0};
volatile unsigned long rawSum = 0;
volatile unsigned int simpleAverage = 0;
volatile unsigned int rawIndex = 0;

#ifdef USE_R9_33K
const int16_t   temperatures[] =
{
 0,
 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
};


const uint16_t adcLow[] =
{
 2898, 2871, 2844, 2815, 2787, 2757, 2727, 2696, 2664, 2632,
 2599, 2566, 2532, 2498, 2463, 2428, 2392, 2356, 2319, 2283,
 2246, 2208, 2171, 2133, 2095, 2057, 2018, 1979, 1940, 1901,
 1863, 1824, 1785, 1747, 1709, 1671, 1634, 1596, 1559, 1523,
 1487,
};


const uint16_t adcCenter[] =
{
 2909, 2882, 2855, 2827, 2798, 2769, 2738, 2707, 2676, 2644,
 2611, 2578, 2544, 2509, 2474, 2439, 2403, 2367, 2330, 2293,
 2256, 2218, 2180, 2142, 2104, 2065, 2027, 1989, 1950, 1912,
 1873, 1835, 1797, 1759, 1721, 1684, 1647, 1610, 1573, 1537,
 1501,

};


uint16_t adcHigh[] =
{
 2920, 2894, 2866, 2838, 2809, 2780, 2750, 2719, 2687, 2655,
 2622, 2589, 2555, 2520, 2485, 2450, 2414, 2377, 2340, 2303,
 2265, 2228, 2189, 2151, 2113, 2074, 2036, 1998, 1960, 1922,
 1884, 1846, 1808, 1771, 1733, 1696, 1659, 1623, 1587, 1551,
 1515,
};


#endif

#ifdef USE_R9_100K

const int16_t   temperatures[] =
{
#ifdef FULL_SCALE
 -40, -39, -38, -37, -36, -35, -34, -33, -32, -31,
 -30, -29, -28, -27, -26, -25, -24, -23, -22, -21,
 -20, -19, -18, -17, -16, -15, -14, -13, -12, -11,
 -10,
 -9, -8, -7, -6, -5, -4, -3, -2, -1,
#endif
 0, 
 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 
 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
#ifdef FULL_SCALE
 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
 91, 92, 93, 94, 95, 96, 97, 98, 99,
 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
 120, 121, 122, 123, 124, 125
#endif
};


const uint16_t adcLow[] =
{
#ifdef FULL_SCALE
 3317, 3304, 3290, 3276, 3260, 3244, 3227, 3209, 3191, 3171,
 3151, 3130, 3108, 3085, 3061, 3036, 3010, 2983, 2955, 2927,
 2897, 2866, 2835, 2802, 2769, 2735, 2699, 2663, 2627, 2589,
 2551, 2512, 2472, 2432, 2391, 2349, 2307, 2265, 2222, 2179,
#endif
 2136, 2092, 2048, 2004, 1961, 1917, 1873, 1829, 1786, 1743,
 1700, 1657, 1615, 1573, 1532, 1491, 1451, 1411, 1372, 1333,
 1295, 1258, 1221, 1186, 1150, 1116, 1082, 1048, 1016, 984,
 953, 922, 893, 864, 836, 809, 782, 757, 732, 708, 684,

#ifdef FULL_SCALE
 662,
 640, 618, 598, 578, 558, 540, 522, 504, 487, 471, 455, 440,
 425, 411, 397, 383, 371, 358, 346, 335, 324, 313, 302, 292,
 283, 273, 264, 256, 247, 239, 231, 224, 217, 210, 203, 196,
 190, 184, 178, 172, 167, 162, 157, 152, 147, 142, 138, 134,
 129, 125, 122, 118, 114, 111, 107, 104, 101, 98, 95, 92, 90,
 87, 84, 82, 79, 77, 75, 73, 71, 69, 67, 65, 63, 61, 59, 58,
 56, 55, 53, 52, 50, 49, 47, 46
#endif
};



const uint16_t adcCenter[] =
{
#ifdef FULL_SCALE
 3326, 3313, 3299, 3285, 3270, 3255, 3238, 3221, 3203, 3184,
 3164, 3143, 3121, 3099, 3075, 3051, 3025, 2999, 2971, 2943,
 2914, 2884, 2852, 2820, 2787, 2753, 2718, 2682, 2646, 2608, 
 2570, 2531, 2491, 2451, 2410, 2369, 2326, 2284, 2241, 2198,
#endif
 2154, 2110, 2066, 2022, 1978, 1934, 1890, 1846, 1802, 1758,
 1715, 1672, 1629, 1587, 1545, 1503, 1463, 1422, 1383, 1344,
 1305, 1268, 1231, 1194, 1159, 1124, 1090, 1056, 1024, 992,
 961, 931, 902, 873, 845, 818, 792, 766, 741,  717, 694,

#ifdef FULL_SCALE
 671, 649, 627, 607, 587, 567, 549, 530,
 513, 496, 479, 463, 448, 433, 419, 405, 392, 379,
 366, 354, 342, 331, 320, 310, 300, 290, 280, 271,
 262, 254, 246, 238, 230, 223, 215, 209, 202, 196,
 189, 183, 178, 172, 167, 162, 157, 152, 147, 142,
 138, 134, 130, 126, 122, 118, 115, 111, 108, 105,
 102,
 99, 96, 93, 90, 88, 85, 83, 80, 78, 76,
 73, 71, 69, 67, 66, 64, 62, 60, 59, 57,
 55, 54, 52, 51, 50, 48
#endif
};


uint16_t adcHigh[] =
{
#ifdef FULL_SCALE
 3334, 3321, 3308, 3295, 3280, 3265, 3249, 3232, 3214, 3196,
 3176, 3156, 3135, 3112, 3089, 3065, 3040, 3014, 2987, 2959,
 2930, 2900, 2869, 2838, 2805, 2771, 2736, 2701, 2664, 2627,
 2589, 2550, 2510, 2470, 2429, 2388, 2345, 2303, 2260, 2216,
#endif
 2173, 2128, 2084, 2040, 1995, 1951, 1906, 1862, 1818, 1774,
 1730, 1686, 1643, 1600, 1558, 1516, 1475, 1434, 1394, 1354,
 1315, 1277, 1240, 1203, 1167, 1131, 1098, 1064, 1032, 1001,
 970, 940, 910, 882, 854, 827, 801, 775, 750, 726, 703,

#ifdef FULL_SCALE
 680, 658, 637, 616, 596, 576, 558, 539, 522,
 505, 488, 472, 457, 442, 427, 413, 400, 387, 374, 
 362, 350, 339, 328, 317, 307, 297, 287, 278, 269, 
 261, 252, 244, 236, 229, 222, 215, 208, 201, 195, 
 189, 183, 177, 172, 167, 162, 157, 152, 147, 143,
 138, 134, 130, 126, 122, 119, 115, 112, 109, 105, 
 102, 
 99, 97, 94, 91, 88, 86, 83, 81, 79,
 77, 74, 72, 70, 68, 66, 65, 63, 61, 
 59, 58, 56, 55, 53, 52, 50
#endif
};

#endif



/*
 * TimerA UpMode Configuration Parameter
 */
Timer_A_initUpModeParam initUpParam_A1 =
{
    TIMER_A_CLOCKSOURCE_ACLK,               /*!< ACLK Clock Source              */
    TIMER_A_CLOCKSOURCE_DIVIDER_1,          /*!< ACLK/1 = 32768Hz               */
    0x2000,                                 /*!< Timer period                   */
    TIMER_A_TAIE_INTERRUPT_DISABLE,         /*!< Disable Timer interrupt        */
    TIMER_A_CCIE_CCR0_INTERRUPT_DISABLE ,   /*!< Disable CCR0 interrupt         */
    TIMER_A_DO_CLEAR                        /*!< Clear value                    */
};

Timer_A_initCompareModeParam initCompParam =
{
    TIMER_A_CAPTURECOMPARE_REGISTER_1,        /*!< Compare register 1           */
    TIMER_A_CAPTURECOMPARE_INTERRUPT_DISABLE, /*!< Disable Compare interrupt    */
    TIMER_A_OUTPUTMODE_RESET_SET,             /*!< Timer output mode 7          */
    0x1000                                    /*!< Compare value                */
};


/*
 * The exponential moving average is a type of IIR filter
 * that is easy to implement in C and uses minimal resources.
 * Unlike a simple moving average,
 * it does not require a RAM buffer to store previous samples.
 * It just has to store one value (the previous average).
 *
 * An exponential moving average is expressed as the following equation:
 *
 * avg[n] = (in * alpha) + avg[n-1]*(1-alpha).
 *
 * where:
 * in: is the current adc reading
 * alpha: is the exponential smoothing constant
 * avg[n]: is the new average
 * avg[n-1]: is the previous computed average
 *
 *
 * Implementing this equation using floating point math is straightforward
 * but using fixed point variables is a little tricky.
 * The code  below uses 32-bit signed integers
 * for the average and input values.
 * Intermediate values need to use
 * 64-bit math to avoid overflow errors.
 *
 * Alpha is an Exponential Smoothing Constant
 * Alpha values close to zero represent
 * heavy averaging while an alpha
 * value of one has no averaging.
 */

int32_t dsp_ema_i32(int32_t in, int32_t average, uint16_t alpha)
{
    int64_t tmp0;
    tmp0 = (int64_t)in * (alpha) + (int64_t)average * (65536 - alpha);
    return (int32_t)((tmp0 + 32768) / 65536);

}

float x = 0.1;

int16_t getTemperature(dataSet_e dataSet, unsigned int adcVal)
{
    int16_t ambientTemperature = 0;
    uint16_t adcLowIndex = 0;
    uint16_t adcCenterIndex = 0;
    uint16_t adcHighIndex = 0;
    uint32_t numItems;
    //log_print(LOG_ALWAYS," Entering %s\n\r", __FUNCTION__);

    switch (dataSet)
    {
    case ADC_LOW:
    {
        numItems = sizeof(adcLow)/sizeof(uint16_t);
        for (adcLowIndex =0; adcLowIndex < numItems; adcLowIndex++)
        {
            if ( adcVal > adcLow[adcLowIndex])
            {
                ambientTemperature = temperatures[adcLowIndex-1];
                break;
            }
        }
    }
    break;

    case ADC_CENTER:
    {
        numItems = sizeof(adcCenter)/sizeof(uint16_t);
        for (adcCenterIndex =0; adcCenterIndex < numItems; adcCenterIndex++)
        {
            if ( adcVal > adcCenter[adcCenterIndex])
            {
                ambientTemperature = temperatures[adcCenterIndex-1];
                break;
            }
        }
    }
    break;
    case ADC_HIGH:
    {
        numItems = sizeof(adcHigh)/sizeof(uint16_t);
        for (adcHighIndex =0; adcHighIndex < numItems; adcHighIndex++)
        {
            if ( adcVal > adcHigh[adcHighIndex])
            {
                ambientTemperature = temperatures[adcHighIndex-1];
                break;
            }
        }
    }
    break;


    default:
    {

    }
    break;
    }


    return ambientTemperature;
}

/*
 * Notes:
 */
unsigned int tempSensor(averagingMethod_e averagingMethod)
{
    unsigned int avg = 0;
    //log_print(LOG_ALWAYS," Entering %s\n\r", __FUNCTION__);

    switch (averagingMethod)
    {

    /* Calculate the average with a simple averaging algorithm */

    case SIMPLE_AVERAGE:
    {
        //log_print(LOG_ALWAYS,">>>> %s\n\r", "SIMPLE_AVERAGE" );
        int i;
        while(mode == TEMPSENSOR_MODE)
        {
            __bis_SR_register(GIE);             /*!< interrupts enabled             */
            __no_operation();                   /*!< Only for debugger              */

            if (tempSensorRunning)
            {
                raw[rawIndex] = ADC12MEM0;
                _delay_cycles(10000);
                rawSum += raw[rawIndex];
                rawIndex++;
                if (rawIndex == NUM_SAMPLES)
                {
                    simpleAverage = rawSum / NUM_SAMPLES;
                    rawIndex = 0;
                    rawSum = 0;
                    for (i = 0; i < NUM_SAMPLES; i++)
                    {
                        raw[i] = 0;
                    }
                    break;
                }
            }
        }
        avg = simpleAverage;

    }
    break;

    /*
     * Calculate the average with a simple averaging algorithm
     *
     * Apply ADC Gain factor
     * ADC(gain_corrected = ADC(raw) * CAL_ADC_GAIN_FACTOR * 1/2^15
     *
     */
    case SIMPLE_AVERAGE_AND_GAIN:
    {
        //log_print(LOG_ALWAYS,">>>> %s\n\r", "SIMPLE_AVERAGE_AND_GAIN" );
        int i;
        float adcGain = TLV_CAL_ADC_GAIN_FACTOR;
        float adcOffset = TLV_CAL_ADC_OFFSET;
        float adc12Ref  = TLV_REF_12V;

        while(mode == TEMPSENSOR_MODE)
        {
            __bis_SR_register(GIE);             /*!< interrupts enabled             */
            __no_operation();                   /*!< Only for debugger              */

            if (tempSensorRunning)
            {
                raw[rawIndex] = ADC12MEM0;
                adc_corrected[rawIndex] =
                        (int)((float)(raw[rawIndex] * adc12Ref / 32768.0) * (adcGain / 32768.0)) + adcOffset;

                _delay_cycles(10000);
                rawSum += adc_corrected[rawIndex];
                rawIndex++;
                if (rawIndex == NUM_SAMPLES)
                {
                    simpleAverage = rawSum / NUM_SAMPLES;
                    rawIndex = 0;
                    rawSum = 0;
                    for (i = 0; i < NUM_SAMPLES; i++)
                    {
                        raw[i] = 0;
                        adc_corrected[i] = 0;
                    }
                    break;
                }
            }
        }
        avg = simpleAverage;

    }
    break;
    /* Calculate the average with an exponential moving average algorithm */

    case EXPONENTIAL_MOVING_AVERAGE:
    {
        //log_print(LOG_ALWAYS,">>>> %s\n\r", "EXPONENTIAL_MOVING_AVERAGE" );
        static int expMovAverage = 0;
        int adcVal;
        int n = NUM_SAMPLES;

        while (n--)
        {
            adcVal = ADC12MEM0;
            expMovAverage = dsp_ema_i32(adcVal, expMovAverage, DSP_EMA_I32_ALPHA(0.1));
        }
        avg = expMovAverage;
    }
    break;

    }

    return avg;
}


/*
 * Notes:
 */
void tempSensorModeInit()
{
    tempSensorRunning = 1;
    bool status;
    //log_print(LOG_ALWAYS," Entering %s\n\r", __FUNCTION__);

    /*
     * Select internal ref = 1.2V
     */
    Ref_A_setReferenceVoltage(REF_A_BASE,
                              REF_A_VREF1_2V);

    /*
     * Internal Reference ON
     */

    Ref_A_enableReferenceVoltage(REF_A_BASE);

    /*
     * Disable the internal temperature sensor
     */
    Ref_A_disableTempSensor(REF_A_BASE);

    /*
     * Wait for ready
     */
    while(!Ref_A_isVariableReferenceVoltageOutputReady(REF_A_BASE));


    /*
     * Enable the voltage output on P1.1
     */
    Ref_A_enableReferenceVoltageOutput(REF_A_BASE);

    /*
     * Initialize the ADC12B Module
     *
     * Base address of ADC12B Module
     * Use internal ADC12B bit as sample/hold signal to start conversion
     * USE MODOSC 5MHZ Digital Oscillator as clock source
     * Use default clock divider/pre-divider of 1
     */
    ADC12_B_initParam initParam = {0};

    /*
     *  this information is device specific
     * is the signal that will trigger
     * a sample-and-hold for an input signal to be converted
     * Note: Digging for the meaning of this information has been a
     *       bit of a challenge
     *       The value of this data member is the field ADC12SHSx
     *       in the control register 1
     *       (see Table 34-5. ADC12CTL1 Register Description in user's guide)
     *       One has to refer to the specific device data sheet to understand
     *       the function of those bits
     *       For the MSP430FR6989 the definitions of the valid values are in the table
     *          Table 6-17. ADC12_B Trigger Signal Connections
     *       ADC12SHSx CONNECTED TRIGGER
     *       BINARY         DECIMAL     SOURCE
     *       000            0           Software (ADC12SC)
     *       001            1           Timer_A TA0 CCR1 output
     *       010            2           Timer_B TB0 CCR0 output
     *       011            3           Timer_B TB0 CCR1 output
     *       100            4           Timer_A TA1 CCR1 output<--- We select this one
     *       101            5           Timer_A TA2 CCR1 output
     *       110            6           Timer_A TA3 CCR1 output
     *       111            7           Reserved (DVSS)
     *
     * This means that the conversion will be triggered by Timer_A TA1 CCR1 reaching
     * the programmed value.
     */

    /*
     *  ADC12 Sample/Hold Source: 4
     */
    initParam.sampleHoldSignalSourceSelect = ADC12_B_SAMPLEHOLDSOURCE_4;

    /*
     * ADC12 Clock Source Select: 0
     */
    initParam.clockSourceSelect |= ADC12_B_CLOCKSOURCE_ACLK;

    /*
     * ADC12 Clock Divider Select: 0
     */
    initParam.clockSourceDivider |= ADC12_B_CLOCKDIVIDER_1;

    /*
     * ADC12 Clock predivider Select: /1
     */
    initParam.clockSourcePredivider |= ADC12_B_CLOCKPREDIVIDER__1;

#ifdef INTERNAL_TEMPERATURE_SENSOR
    /*
     *     ADC12 Internal TempSensor select
     */
    initParam.internalChannelMap |= ADC12_B_TEMPSENSEMAP;
#else
    /*
     * ADC12 Internal Channel 0 select
     */
    initParam.internalChannelMap |= ADC12_B_MAPINTCH0;
#endif

    /*
     *  Work done by the driverlib ADC driver
     *  the work done is as follows:
     *
     *      - Make sure the ENC bit is cleared before initializing the ADC12
     *      - Turn OFF ADC12B Module & Clear Interrupt Registers
     *
     *      - Set ADC12B Control 1:
     *          - Setup the Sample-and-Hold Source
     *          - Set Clock Divider
     *          - Set Clock Pre-Divider
     *
     *      - Set ADC12B Control 2
     *          - Default resolution to 12-bits
     *
     *      - Set ADC12B Control 3
     *          - // Map internal channels
     */
    status = ADC12_B_init(ADC12_B_BASE, &initParam);
    if (status == STATUS_SUCCESS)
    {

    }
    else
    {

    }

    /*
     * Enable the ADC12B module
     * Clear ENC bit
     * Enable the ADC12B Module
     */
    ADC12_B_enable(ADC12_B_BASE);

    /*
     * Base address of ADC12B Module
     *
     * SAMPCON signal source from the sampling timer
     * For memory buffers 0-7 sample/hold for 256 clock cycles
     * For memory buffers 8-15 sample/hold for 4 clock cycles (default)
     * Disable Multiple Sampling
     */
    ADC12_B_setupSamplingTimer(ADC12_B_BASE,
                               ADC12_B_CYCLEHOLD_256_CYCLES,
                               ADC12_B_CYCLEHOLD_4_CYCLES,
                               ADC12_B_MULTIPLESAMPLESDISABLE);

    /*
     * Configure Memory Buffer
     *
     * Base address of the ADC12B Module
     * Configure memory buffer 0
     * Map input A30 to memory buffer 0
     * Vref+ = VRef+
     * Vref- = Vref-
     * Memory buffer 0 is the end of a sequence
     */
    ADC12_B_configureMemoryParam configureMemoryParam = {0};

    /*
     * selected memory buffer to set the configuration for
     */
    configureMemoryParam.memoryBufferControlIndex = ADC12_B_MEMORY_0;

 #ifdef INTERNAL_TEMPERATURE_SENSOR
    /*
     * the input that will store the converted data into the specified memory buffer
     */
    configureMemoryParam.inputSourceSelect = ADC12_B_INPUT_TCMAP;
#else
    /*
     * the input that will store the converted data into the specified memory buffer
     */
    configureMemoryParam.inputSourceSelect |= ADC12_B_INPUT_A3; /*!< Pin 36 TEMP_READ P1.3 */
#endif

    /*
     * the reference voltage source to set as the upper/lower limits for
     * the conversion stored in the specified memory.
     */
    configureMemoryParam.refVoltageSourceSelect |=
        ADC12_B_VREFPOS_INTBUF_VREFNEG_VSS;

    /*
     * Indicates that the specified memory buffer will be the end of the
     * sequence if a sequenced conversion mode is selected
     */
    configureMemoryParam.endOfSequence |= ADC12_B_ENDOFSEQUENCE;

    /*
     * Sets the window comparator mode
     */
    configureMemoryParam.windowComparatorSelect |=
        ADC12_B_WINDOW_COMPARATOR_DISABLE;

    /*
     * Sets the differential mode
     */
    configureMemoryParam.differentialModeSelect |=
        ADC12_B_DIFFERENTIAL_MODE_DISABLE;

    /*
     * Configures the controls of the selected memory buffer.
     */
    ADC12_B_configureMemory(ADC12_B_BASE, &configureMemoryParam);

    /*
     * Clears ADC12B selected interrupt flags.
     * Modified registers are ADC12IFG .
     */
    ADC12_B_clearInterrupt(ADC12_B_BASE,
                           0,
                           ADC12_B_IFG0
                           );

    /*
     * Enable memory buffer 0 interrupt
     */
    ADC12_B_enableInterrupt(ADC12_B_BASE,
                            ADC12_B_IE0,
                            0,
                            0);

    /*
     * Start ADC conversion
     *  Enables/Starts an Analog-to-Digital Conversion.
     */
    ADC12_B_startConversion(ADC12_B_BASE,
                            ADC12_B_START_AT_ADC12MEM0,
                            ADC12_B_REPEATED_SINGLECHANNEL);




    /*
     * Configure the Timer A for triggered ADC conversion
     *  TimerA1.1 (125ms ON-period) - ADC conversion trigger signal
     *  Configures Timer_A in up mode.
     */
    Timer_A_initUpMode(TIMER_A1_BASE, &initUpParam_A1);

    /*
     * Initializes Compare Mode
     */
    Timer_A_initCompareMode(TIMER_A1_BASE, &initCompParam);

    /*
     * Start timer A1 in up mode
     * Starts Timer_A counter
     */
    Timer_A_startCounter(TIMER_A1_BASE,
        TIMER_A_UP_MODE
        );

    __bis_SR_register(GIE);         /*!< enable interrupts */
    __no_operation();
}
