/*******************************************************************************
 *
 * TempSensorMode.h
 *
 ******************************************************************************/

#ifndef VALIDATION_THERMISTOR_TEMPSENSORMODE_H_
#define VALIDATION_THERMISTOR_TEMPSENSORMODE_H_

#include <stdio.h>
#include <string.h>

#include "log.h"
#include "debug.h"

#define TEMPSENSOR_MODE       2


/*
 *  lists the contents of the device descriptor
 *  tag-lengthvalue (TLV) structure */
// See device datasheet for TLV table memory mapping

/*
 * Info Block
 */
#define TLV_INFO_LEN
#define TLV_CRC_LEN
#define TLV_DEVICE_ID
#define TLV_HW_REV
#define TLV_FW_REV

/*
 * Die Record
 */
#define TLV_DIE_RECORD_TAG
#define TLV_RECORD_LEN
#define TLV_LOTWAFER_ID
#define TLV_DIE_X_POSITION
#define TLV_DIE_Y_POSITION
#define TLV_TEST_RESULTS


/*
 * ADC12B Calibration
 */
#define TLV_ADC12B_CALIBRATION_TAG      *((unsigned char *)0x01A14)         /*!<    */
#define TLV_ADC12B_CALIBRATION_LENGTH   *((unsigned char *)0x01A15)         /*!<    */
#define TLV_CAL_ADC_GAIN_FACTOR         *((unsigned int  *)0x01A16)         /*!<    */
#define TLV_CAL_ADC_OFFSET              *((unsigned int  *)0x01A18)         /*!<    */
#define TLV_ADC_12VREFTS_30             *((unsigned int  *)0x01A1A)         /*!<    */
#define TLV_ADC_12VREFTS 85             *((unsigned int  *)0x01A1C)         /*!<    */
#define TLV_ADC_20VREFTS_30             *((unsigned int  *)0x01A1E)         /*!<    */
#define TLV_ADC_20VREFTS_85             *((unsigned int  *)0x01A20)         /*!<    */
#define TLV_ADC_25VREFTS_30             *((unsigned int  *)0x01A22)         /*!<    */
#define TLV_ADC_25VREFTS_85             *((unsigned int  *)0x01A24)         /*!<    */

/*
 * REF Calibration
 */
#define TLV_REF_CAL_TAG             *((unsigned char  *)0x01A26)         /*!<    */
#define TLV_REF_CAL_LEN             *((unsigned char  *)0x01A27)         /*!<    */
#define TLV_REF_12V                 *((unsigned int   *)0x01A28)         /*!<    */
#define TLV_REF_20V                 *((unsigned int   *)0x01A2A)         /*!<    */
#define TLV_REF_25V                 *((unsigned int  *)0x01A2C)          /*!<    */

/*
 * Ramdom Number
 *
 */
#define TLV_RND_TAG
#define TLV_RND_LEN
#define TLV_RND_128BIT

/*
 * BSL Configuration
 */
#define TLV_BSL_TAG
#define TLV_BSL_LEN
#define TLV_BSL_INTERFACE
#define TLV_BSL_CONFIG


/*========================= END OF TLV ===== */

#define DSP_EMA_I32_ALPHA(x) ((uint16_t)(x * 65535))




typedef enum
{
    ADC_LOW = 0,
    ADC_CENTER,
    ADC_HIGH
}dataSet_e;

typedef enum
{
    SIMPLE_AVERAGE = 0,
    SIMPLE_AVERAGE_AND_GAIN,
    EXPONENTIAL_MOVING_AVERAGE

}averagingMethod_e ;


extern volatile unsigned char mode;

extern Timer_A_initUpModeParam initUpParam_A0;

extern volatile unsigned char tempSensorRunning;


int32_t dsp_ema_i32(int32_t in, int32_t average, uint16_t alpha);

int16_t getTemperature(dataSet_e dataSet, unsigned int adcVal);

unsigned int tempSensor(averagingMethod_e averagingMethod);

void tempSensorModeInit(void);

#endif /* VALIDATION_THERMISTOR_TEMPSENSORMODE_H_ */
