/*!	\file debug.h
*   \brief Contains MACROS for ASSERT and TRACE that can be
* enabled or disabled based on the DEBUG macro.
* If disabled, the statements compile out.
*
*/

/*
 * debug.h
 *
 *  Created on: Feb 28, 2020
 *      Author: first
 */

#ifndef INCLUDE_DEBUG_H_
#define INCLUDE_DEBUG_H_

/**
 ******************************************************************************

 ******************************************************************************
*/

#include <stdlib.h>           /*!< Standard library definitons                */
#include "log.h"              /*!< Message logging definitions                */

#define ASSERT_FAILED (-2)    /*!< Exit code used in case of failed alert     */

#ifdef DEBUG

/**
 * Define the ASSERT Macro
 */
#define ASSERT(x) \
if (!(x)) { \
 log_print(LOG_ERROR, "\r\n\r\nASSERT FAILED %s at %d in %s\r\n", #x, __LINE__, __func__ ); \
 exit( ASSERT_FAILED ); \
}while(0)

#else

/**
 * Define the ASSERT Macro
 * to be empty
 */
#define ASSERT(x)

#endif


#ifdef DEBUG

/**
 * TRACE needs to use the ## in front of VA_ARGS to handle the case of
 * when there are no parameters to pass through. This is a GCC specific
 * extenstion (see https://gcc.gnu.org/onlinedocs/cpp/Variadic-Macros.html)
 */
#define TRACE(format, ...) \
log_print( LOG_TRACE, format, ##__VA_ARGS__ );

#else

/**
 * Define TRACE Macro
 * to be empty
 */
#define TRACE( ... )

#endif


#endif /* INCLUDE_DEBUG_H_ */
