
/*******************************************************************************
 *
 * main.c
 *
 ******************************************************************************/

#include <driverlib.h>

#include "HAL_UART.h"
#include "TempSensorMode.h"

/*
 * Vref+ Voltage
 */
#define ADC_VREF_PORT       (GPIO_PORT_P1)      /*!< ADC Vref+ voltage on P1            */
#define ADC_VREF_PIN        (GPIO_PIN1)         /*!< ADC Vref+ voltage Pin 1            */


/*
 * Temperature Sensor
 */
#define ADC_TEMP_PORT        (GPIO_PORT_P1)     /*!< ADC Temperature sensor Port on P1  */
#define ADC_TEMP_PIN         (GPIO_PIN3)        /*!< ADC Temperature sensor Pin 3       */


volatile unsigned char tempSensorRunning = 0;

volatile unsigned char mode = TEMPSENSOR_MODE;



/*
 * TimerA0 UpMode Configuration Parameter
 */
Timer_A_initUpModeParam initUpParam_A0 =
{
        TIMER_A_CLOCKSOURCE_SMCLK,              /*!< SMCLK Clock Source         */
        TIMER_A_CLOCKSOURCE_DIVIDER_1,          /*!< SMCLK/4 = 2MHz             */
        30000,                                  /*!< 15ms debounce period       */
        TIMER_A_TAIE_INTERRUPT_DISABLE,         /*!< Disable Timer interrupt    */
        TIMER_A_CCIE_CCR0_INTERRUPT_ENABLE ,    /*!< Enable CCR0 interrupt      */
        TIMER_A_DO_CLEAR,                       /*!< Clear value                */
        true                                    /*!< Start Timer                */
};

/*
 * Initialization calls
 */
void Init_GPIO(void);
void Init_Clock(void);


/*
 * Main routine
 */
int main(void)
{
    unsigned int sensorReading = 0;
    int16_t ambientTemperature1 = 0;
    int16_t ambientTemperature2 = 0;
    int16_t ambientTemperature3 = 0;
    int16_t ambientTemperature4 = 0;
    int16_t ambientTemperature5 = 0;
    int16_t ambientTemperature6 = 0;
    int16_t ambientTemperature7 = 0;
    int16_t ambientTemperature8 = 0;
    int16_t ambientTemperature9 = 0;

    /*
     * Stop watchdog timer
     */
    WDT_A_hold(__MSP430_BASEADDRESS_WDT_A__);

    /*
     * Init the GPIO
     */
    Init_GPIO();

    /*
     * Init the clock system
     */
    Init_Clock();

    /*
     * Initialize UART back channel
     */
    UART_initGPIO();
    UART_init();

    /*
     *  Initialize UART Debug Port
     */
    UART0_initGPIO();
    UART0_init();



    /*
     * Disable the GPIO power-on default high-impedance mode to activate
     * previously configured port settings
     */
    PMM_unlockLPM5();

    __enable_interrupt();




    while(1)
    {
        tempSensorModeInit();                                           /*!< initialize temperature mode            */

        sensorReading = tempSensor(SIMPLE_AVERAGE);                     /*!< Read temperature sensor                */

        ambientTemperature1 = getTemperature(ADC_LOW ,sensorReading);   /*!< Convert sensor reading to temperature  */
        ambientTemperature2 = getTemperature(ADC_CENTER,sensorReading); /*!< Convert sensor reading to temperature  */
        ambientTemperature3 = getTemperature(ADC_HIGH,sensorReading);   /*!< Convert sensor reading to temperature  */

        log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 1: ", ambientTemperature1);
        log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 2: ", ambientTemperature2);
        log_print(LOG_ALWAYS,"%s  %d\n\r\n\r", "ambient tempature 3: ", ambientTemperature3);



        sensorReading = tempSensor(EXPONENTIAL_MOVING_AVERAGE);         /*!< Read temperature sensor                */

        ambientTemperature4 = getTemperature(ADC_LOW ,sensorReading);   /*!< Convert sensor reading to temperature  */
        ambientTemperature5 = getTemperature(ADC_CENTER,sensorReading); /*!< Convert sensor reading to temperature  */
        ambientTemperature6 = getTemperature(ADC_HIGH,sensorReading);   /*!< Convert sensor reading to temperature  */

        log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 4: ", ambientTemperature4);
        log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 5: ", ambientTemperature5);
        log_print(LOG_ALWAYS,"%s  %d\n\r\n\r", "ambient tempature 6: ", ambientTemperature7);



        sensorReading = tempSensor(SIMPLE_AVERAGE_AND_GAIN);         /*!< Read temperature sensor                */

         ambientTemperature7 = getTemperature(ADC_LOW ,sensorReading);   /*!< Convert sensor reading to temperature  */
         ambientTemperature8 = getTemperature(ADC_CENTER,sensorReading); /*!< Convert sensor reading to temperature  */
         ambientTemperature9 = getTemperature(ADC_HIGH,sensorReading);   /*!< Convert sensor reading to temperature  */

         log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 7: ", ambientTemperature7);
         log_print(LOG_ALWAYS,"%s  %d\n\r", "ambient tempature 8: ", ambientTemperature8);
         log_print(LOG_ALWAYS,"%s  %d\n\r\n\r", "ambient tempature 9: ", ambientTemperature9);

    }
}


/*
 * GPIO Initialization
 */
void Init_GPIO(void)
{
    /*
     * Set all GPIO pins to output low to prevent floating input and reduce power consumption
     */
    GPIO_setOutputLowOnPin(GPIO_PORT_P1, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P2, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P3, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P4, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P5, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P6, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P7, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P8, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setOutputLowOnPin(GPIO_PORT_P9, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);

    GPIO_setAsOutputPin(GPIO_PORT_P1, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P2, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P3, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P4, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P5, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P6, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P7, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P8, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
    GPIO_setAsOutputPin(GPIO_PORT_P9, GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);



    /*
     * VRef
     * P1.1
     *
     * Table 6-20. Port P1 (P1.0 to P1.3) Pin Functions
     */
    GPIO_setAsPeripheralModuleFunctionOutputPin(ADC_VREF_PORT, ADC_VREF_PIN, GPIO_TERNARY_MODULE_FUNCTION);


    /*
     * External Temperature Sensor
     * P1.3
     */
    GPIO_setAsPeripheralModuleFunctionInputPin(ADC_TEMP_PORT, ADC_TEMP_PIN, GPIO_TERNARY_MODULE_FUNCTION);  /*!< ADC Temperature Sensor is an analog input */


    /*
     * Disable the GPIO power-on default high-impedance mode
     * to activate previously configured port settings
     */
    PMM_unlockLPM5();
}

/*
 * Clock System Initialization
 */
void Init_Clock(void)
{

    /*
     * Set PJ.4 Get as Input the CLKOUT MCU from external RTC.
     * NXP PCF8523 Pin 7 CLKOUT -> PJ.4 LXFIN
     */
    GPIO_setAsPeripheralModuleFunctionInputPin(
           GPIO_PORT_PJ,
           GPIO_PIN4,
           GPIO_PRIMARY_MODULE_FUNCTION
           );

    /*
     * Set the external clock source
     * We Use the Low Frequency of 32.768KHz
     * High Frequency is not used in this call
     *
     */
    CS_setExternalClockSource(32768, 0);


#if 0
    /*
     * Initializes the XT1 crystal oscillator
     */
    CS_turnOnLFXT(CS_LFXT_DRIVE_3);

#else
    CS_bypassLFXT();
#endif

    /*
     * Initializes Clock System DCO = 8MHz
     */

    /*
     * Set DCO frequency
     */
    CS_setDCOFreq(CS_DCORSEL_0, CS_DCOFSEL_6);

    /*
     * Initializes clock signal for MCLK
     */
    CS_initClockSignal(CS_MCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);

    /*
     * Initializes clock signal for SMCLK
     */
    CS_initClockSignal(CS_SMCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);

    /*
     * Initializes clock signal for ACLK
     */
    CS_initClockSignal(CS_ACLK, CS_LFXTCLK_SELECT, CS_CLOCK_DIVIDER_1);

    return;
}



/*
 * ADC 12 Interrupt Service Routine
 */
#pragma vector=ADC12_VECTOR
__interrupt void ADC12_ISR(void)
{
    switch(__even_in_range(ADC12IV,12))
    {
    case  0:                            /*!< Vector  0:  No interrupt                   */
        __no_operation();
        break;
    case  2:                            /*!< Vector  2:  ADC12BMEMx Overflow            */
        __no_operation();
        break;
    case  4:                            /*!< Vector  4:  Conversion time overflow       */
        __no_operation();
        break;
    case  6:                            /*!< Vector  6:  ADC12BHI                       */
        __no_operation();
        break;
    case  8:                            /*!< Vector  8:  ADC12BLO                       */
        __no_operation();
        break;
    case 10:                            /*!< Vector 10:  ADC12BIN                       */
        __no_operation();
        break;
    case 12:                            /*!< Vector 12:  ADC12BMEM0 Interrupt           */
        ADC12_B_clearInterrupt(ADC12_B_BASE, 0, ADC12_B_IFG0);
        __bic_SR_register_on_exit(0);   /*!< Exit active CPU                            */
        break;                          /*!< Clear CPUOFF bit from 0(SR)                */
    case 14:                            /*!< Vector 14:  ADC12BMEM1                     */
        __no_operation();
        break;
    case 16:                            /*!< Vector 16:  ADC12BMEM2                     */
        __no_operation();
        break;
    case 18:                            /*!< Vector 18:  ADC12BMEM3                     */
        __no_operation();
        break;
    case 20:                            /*!< Vector 20:  ADC12BMEM4                     */
        __no_operation();
        break;
    case 22:                            /*!< Vector 22:  ADC12BMEM5                     */
        __no_operation();
        break;
    case 24:                            /*!< Vector 24:  ADC12BMEM6                     */
        __no_operation();
        break;
    case 26:                            /*!< Vector 26:  ADC12BMEM7                     */
        __no_operation();
        break;
    case 28:                            /*!< Vector 28:  ADC12BMEM8                     */
        __no_operation();
        break;
    case 30:                            /*!< Vector 30:  ADC12BMEM9                     */
        __no_operation();
        break;
    case 32:                            /*!< Vector 32:  ADC12BMEM10                    */
        __no_operation();
        break;
    case 34:                            /*!< Vector 34:  ADC12BMEM11                    */
        __no_operation();
        break;
    case 36:                            /*!< Vector 36:  ADC12BMEM12                    */
        __no_operation();
        break;
    case 38:                            /*!< Vector 38:  ADC12BMEM13                    */
        __no_operation();
        break;
    case 40:                            /*!< Vector 40:  ADC12BMEM14                    */
        __no_operation();
        break;
    case 42:                            /*!< Vector 42:  ADC12BMEM15                    */
        __no_operation();
        break;
    case 44:                            /*!< Vector 44:  ADC12BMEM16                    */
        __no_operation();
        break;
    case 46:                            /*!< Vector 46:  ADC12BMEM17                    */
        __no_operation();
        break;
    case 48:                            /*!< Vector 48:  ADC12BMEM18                    */
        __no_operation();
        break;
    case 50:                            /*!< Vector 50:  ADC12BMEM19                    */
        __no_operation();
        break;
    case 52:                            /*!< Vector 52:  ADC12BMEM20                    */
        __no_operation();
        break;
    case 54:                            /*!< Vector 54:  ADC12BMEM21                    */
        __no_operation();
        break;
    case 56:                            /*!< Vector 56:  ADC12BMEM22                    */
        __no_operation();
        break;
    case 58:                            /*!< Vector 58:  ADC12BMEM23                    */
        __no_operation();
        break;
    case 60:                            /*!< Vector 60:  ADC12BMEM24                    */
        __no_operation();
        break;
    case 62:                            /*!< Vector 62:  ADC12BMEM25                    */
        __no_operation();
        break;
    case 64:                            /*!< Vector 64:  ADC12BMEM26                    */
        __no_operation();
        break;
    case 66:                            /*!< Vector 66:  ADC12BMEM27                    */
        __no_operation();
        break;
    case 68:                            /*!< Vector 68:  ADC12BMEM28                    */
        __no_operation();
        break;
    case 70:                            /*!< Vector 70:  ADC12BMEM29                    */
        __no_operation();
        break;
    case 72:                            /*!< Vector 72:  ADC12BMEM30                    */
        __no_operation();
        break;
    case 74:                            /*!< Vector 74:  ADC12BMEM31                    */
        __no_operation();
        break;
    case 76:                            /*!< Vector 76:  ADC12BRDY                      */
        __no_operation();
        break;
    default:
        __no_operation();
        break;
    }
}
