/*
 * log.c
 *
 *  Created on: Feb 28, 2020
 *      Author: first
 */

#include "log.h"                    /*!<    */


/**
 * print_buffer
 */
static char print_buffer[MAX_LOG_BUFFER_SIZE];

extern uint64_t runningTicks;

#ifdef USE_DEBUG_UART
/*
 * Notes:
 */
static void log_send_string(char *message, int length) {
 /* Normally we would assert here, but because this is used by the assert
 * mechanism we silently fail
 */
 if (!message || length <= 0) return;

 while (length--) UART0_transmitCharacter(message++);
}
#endif

void _log_printf(int level, ...)
{
 va_list ap;
 const char *format;
 int length;

 uint64_t   current_time = 0;
 uint64_t   numSec = 0;
 uint64_t   numMilliSec  = 0;

 /*
 * Out put a standard header to each message so that the logging system
 * can attach a timestamp to correlate with our time stamp. In this case
 * the output is
 *
 * MP:<local time>:<message>
 */
 //current_time = runningTicks;
 current_time = 0;
 memset(print_buffer, 0, sizeof(print_buffer));
 numSec = current_time / 1000;
 numMilliSec = current_time % 1000;

 length = snprintf(print_buffer, sizeof(print_buffer), HEADER_FORMAT, (int)numSec, (int)numMilliSec);


#ifdef USE_DEBUG_UART
 log_send_string(print_buffer, length);
#else
 // otherwise just use printf
 printf(print_buffer);
#endif

 // Now print the message
 va_start(ap, level);
 format = va_arg(ap, const char *);
 length = vsnprintf(print_buffer, sizeof(print_buffer), format, ap);
 va_end(ap);

#ifdef USE_DEBUG_UART
 log_send_string(print_buffer, length);
#else
 // otherwise just use printf
 printf(print_buffer);
#endif

}



