#include "System/cs.h"

void Clock_System_init(void)
{
	// Stop Watchdog
	MAP_WDT_A_holdTimer();
	MAP_Interrupt_disableMaster();

	// Setting the external clock frequency
	MAP_CS_setExternalClockSourceFrequency(32768, 48000000);
	MAP_PCM_setCoreVoltageLevel(PCM_VCORE1);

	// Configuring pins for crystal usage
	MAP_GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_PJ, GPIO_PIN0 | GPIO_PIN1, GPIO_PRIMARY_MODULE_FUNCTION); // LFXT
	MAP_GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_PJ, GPIO_PIN2 | GPIO_PIN3, GPIO_PRIMARY_MODULE_FUNCTION); // HFXT

	//MAP_FlashCtl_setWaitState(FLASH_BANK0, 1);
	//MAP_FlashCtl_setWaitState(FLASH_BANK1, 1);

	MAP_FlashCtl_setWaitState(FLASH_BANK0, 2); // For 48 MHz
	MAP_FlashCtl_setWaitState(FLASH_BANK1, 2); // For 48 MHz

	// Starting LFXT in non-bypass mode without a timeout
	MAP_CS_startLFXT(false);
	// Starting HFXT in non-bypass mode without a timeout
	MAP_CS_startHFXT(false);

	// Initializing MCLK, HSMCLK, SMCLK and ACLK
	MAP_CS_initClockSignal(CS_MCLK, CS_HFXTCLK_SELECT, CS_CLOCK_DIVIDER_1);
	MAP_CS_initClockSignal(CS_HSMCLK, CS_HFXTCLK_SELECT, CS_CLOCK_DIVIDER_1); // Shares clock source with SMCLK
	MAP_CS_initClockSignal(CS_SMCLK, CS_HFXTCLK_SELECT, CS_CLOCK_DIVIDER_2); // Maximum HSMCLK / 2; shares clock source with HSMCLK
	MAP_CS_initClockSignal(CS_ACLK, CS_LFXTCLK_SELECT, CS_CLOCK_DIVIDER_1); // Maximum 128 kHz
	MAP_CS_initClockSignal(CS_BCLK, CS_LFXTCLK_SELECT, CS_CLOCK_DIVIDER_1); // Maximum 32768 kHz

	// Configuring Watchdog; timeout after 512k ACLK clocks (~15.6 s)
	//MAP_SysCtl_setWDTTimeoutResetType(SYSCTL_SOFT_RESET);
	//MAP_WDT_A_initWatchdogTimer(WDT_A_CLOCKSOURCE_ACLK, WDT_A_CLOCKITERATIONS_512K);
	//MAP_WDT_A_startTimer();
}
