#ifndef SYSTEM_HELPERS_H_
#define SYSTEM_HELPERS_H_

#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

unsigned char GetBit(unsigned char byte, unsigned char position);
unsigned char GetBitsFromChar(unsigned char byte, unsigned char numberOfBits, unsigned char firstBitIndex);
int GetBitsFromInt(int integer, unsigned char numberOfBits, unsigned char firstBitIndex);
void SetBit(unsigned char* byte, unsigned char position);
void ClearBit(unsigned char* byte, unsigned char position);
void ToggleBit(unsigned char* byte, unsigned char position);
unsigned char GetByte(int number, unsigned char byteNumber);
unsigned char GetByteULong(unsigned long number, unsigned char byteNumber);
int intPow(int base, int exp);
char *substring(volatile char *string, int position, int length) ;
int Int24BitTwoComplementToSignedInt(unsigned int val);
char* AppendBytesToString(char* dest, int* bytesArray, int numberOfInts, int numberOfBytesPerInt, int* newDestLength);
bool ContainsString(volatile char* string, const char* response, int stringLength);
int CompareTwoComplement(int a, int b, int integerLength);

#endif /* SYSTEM_HELPERS_H_ */
