#include <ti/devices/msp432p4xx/driverlib/driverlib.h>

#include <stdio.h>
#include "System/timers.h"

extern volatile bool adcTxFlag, adcRxFlag, adcSampleAvailable;
extern volatile bool timer32Finished;

void EUSCIB0_IRQHandler(void)
{
    unsigned int status;
    status = MAP_SPI_getEnabledInterruptStatus(EUSCI_B0_BASE);
    MAP_SPI_clearInterruptFlag(EUSCI_B0_BASE, status);

    if (status & EUSCI_B_SPI_TRANSMIT_INTERRUPT)
    {
        adcTxFlag = true;
    }
    if (status & EUSCI_B_SPI_RECEIVE_INTERRUPT)
    {
        adcRxFlag = true;
    }

    MAP_Interrupt_disableSleepOnIsrExit();
}

void PORT4_IRQHandler(void)
{
    uint32_t status;

    status = MAP_GPIO_getEnabledInterruptStatus(GPIO_PORT_P4);
    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P4, status);

    if(status & GPIO_PIN0) // ADC !DRDY
    {
        if (MAP_GPIO_getInputPinValue(GPIO_PORT_P4, GPIO_PIN0) == 0)
        {
            adcSampleAvailable = true;
            MAP_Interrupt_disableSleepOnIsrExit();
        }
    }
}

void T32_INTC_IRQHandler(void)
{
    MAP_Timer32_clearInterruptFlag(TIMER32_0_BASE);
    //MAP_Timer32_setCount(TIMER32_BASE, 96000000); // Necessary for periodic runs
    //MAP_Timer32_startTimer(TIMER32_BASE, false); // Necessary for periodic runs
    MAP_Timer32_haltTimer(TIMER32_0_BASE);
    timer32Finished = true;
    MAP_Interrupt_disableSleepOnIsrExit();
}
