#ifndef SYSTEM_TIMERS_H_
#define SYSTEM_TIMERS_H_

// Includes
#include <ti/devices/msp432p4xx/driverlib/driverlib.h>

//#define MCLK_VALUE  48000000.0
//#define MCLK_PERIOD (1.0 / MCLK_VALUE)
//#define TIMER32_MAX_PERIOD  (4294967296.0 * MCLK_PERIOD)

// Functions
void System_Timer_init(void);

void Timer32_init(void);
void Timer32_sleep_cycles(uint32_t cycles);
//void Timer32_sleep_us(uint32_t microseconds);
void Timer32_turnOff(void);

void TimerA0_init(int timeoutCycles);
void TimerA0_turnOff(void);
void TimerA0_resume(void);
void TimerA0_restart(void);

void TimerA1_init(void);
void TimerA1_turnOff(void);
void TimerA1_resume(void);
void TimerA1_restart(void);

void TimerA2_startCycles(int cycles);
void TimerA2_startHundredsMiliseconds(int hundredsMs);
void TimerA2_turnOff(void);

void TimerA3_startCycles(int cycles);
void TimerA3_startHundredsMiliseconds(int hundredsMs);
void TimerA3_turnOff(void);

#endif /* SYSTEM_TIMERS_H_ */
