#include <ti/devices/msp432p4xx/driverlib/driverlib.h>

/* Custom includes */
#include <System/cs.h>
#include <System/gpio.h>
#include <System/timers.h>
#include <ADS131A04 ADC/ADS131A04.h>
#include <stdint.h>
#include <stdbool.h>

bool adcStatus = false;

#define noSamples   1000
unsigned int readDataCh1[noSamples], readDataCh2[noSamples], readDataCh3[noSamples], readDataCh4[noSamples];
float ch1d[noSamples], ch2d[noSamples], ch3d[noSamples], ch4d[noSamples];

extern volatile bool adcSampleAvailable;

int main(void)
{
    // Enabling the FPU with stacking enabled for floating point calculations
    MAP_FPU_enableModule();
    MAP_FPU_enableLazyStacking();

    GPIO_init();
    Clock_System_init();
    Timer32_init();

    MAP_Interrupt_enableMaster(); // Enabling MASTER interrupts

    adcStatus = ADS131A04_init();
    Timer32_sleep_cycles(48000000); // 100 ms @ MCLK = 48 MHz; trebuie intarziere intre init si sample
    ADS131A04_sample(readDataCh1, readDataCh2, readDataCh3, readDataCh4, noSamples);
    int i;

    for (i = 0; i < noSamples; i++)
    {
        ch1d[i] = ADS131A04_LSB*Int24BitTwoComplementToSignedInt(readDataCh1[i]);
        ch2d[i] = ADS131A04_LSB*Int24BitTwoComplementToSignedInt(readDataCh2[i]);
        ch3d[i] = ADS131A04_LSB*Int24BitTwoComplementToSignedInt(readDataCh3[i]);
        ch4d[i] = ADS131A04_LSB*Int24BitTwoComplementToSignedInt(readDataCh4[i]);
    }

    while(1)
    {
        MAP_PCM_gotoLPM0InterruptSafe();
        MAP_Interrupt_enableMaster();
    }
}
