#include <driverlib.h>
#include "TempSensorMode.h"
#include "hal_LCD.h"

volatile int degV=0;                        //Voltage measurement

// TimerA UpMode Configuration Parameter
Timer_A_initUpModeParam initUpParam_A1 =
{
    TIMER_A_CLOCKSOURCE_ACLK,               // ACLK Clock Source
    TIMER_A_CLOCKSOURCE_DIVIDER_1,          // ACLK/1 = 32768Hz
    0x1000,                                 // Timer period
    TIMER_A_TAIE_INTERRUPT_DISABLE,         // Disable Timer interrupt
    TIMER_A_CCIE_CCR0_INTERRUPT_DISABLE ,   // Disable CCR0 interrupt
    TIMER_A_DO_CLEAR                        // Clear value
};

Timer_A_initCompareModeParam initCompParam =
{
    TIMER_A_CAPTURECOMPARE_REGISTER_1,        // Compare register 1
    TIMER_A_CAPTURECOMPARE_INTERRUPT_DISABLE, // Disable Compare interrupt
    TIMER_A_OUTPUTMODE_RESET_SET,             // Timer output mode 7
    0x1000                                    // Compare value
};

void tempSensor()
{
    //Enter LPM3 mode with interrupts enabled
    while(1)
    {
        __bis_SR_register(LPM3_bits | GIE);                       // LPM3 with interrupts enabled
        __no_operation();                                         // Only for debugger

        if (tempSensorRunning)
        {
            // Turn LED1 on when waking up to calculate temperature and update display
            P1OUT |= BIT0;

            signed short voltage = ADC12MEM0;
            degV = (((long)voltage * 3.3)/4096)*100;

            // Update temperature on LCD
            displayTemp();

            P1OUT &= ~BIT0;
        }
    }
}

void tempSensorModeInit()
{
    tempSensorRunning = 1;

    RTC_C_holdClock(RTC_C_BASE);                           // Stop stopwatch
    RTC_C_holdCounterPrescale(RTC_C_BASE, RTC_C_PRESCALE_0);

    // Initialize the ADC12B Module
    /*
     * Base address of ADC12B Module
     * Use internal ADC12B bit as sample/hold signal to start conversion
     * USE MODOSC 5MHZ Digital Oscillator as clock source
     * Use default clock divider/pre-divider of 1
     * Use Temperature Sensor internal channel
     */
    ADC12_B_initParam initParam = {0};
    initParam.sampleHoldSignalSourceSelect = ADC12_B_SAMPLEHOLDSOURCE_4;
    initParam.clockSourceSelect = ADC12_B_CLOCKSOURCE_ADC12OSC;
    initParam.clockSourceDivider = ADC12_B_CLOCKDIVIDER_1;
    initParam.clockSourcePredivider = ADC12_B_CLOCKPREDIVIDER__1;
    initParam.internalChannelMap = ADC12_B_NOINTCH;
    ADC12_B_init(ADC12_B_BASE, &initParam);

    // Enable the ADC12B module
    ADC12_B_enable(ADC12_B_BASE);

    /*
     * Base address of ADC12B Module
     * For memory buffers 0-7 sample/hold for 256 clock cycles
     * For memory buffers 8-15 sample/hold for 4 clock cycles (default)
     * Disable Multiple Sampling
     */
    ADC12_B_setupSamplingTimer(ADC12_B_BASE,
                               ADC12_B_CYCLEHOLD_256_CYCLES,
                               ADC12_B_CYCLEHOLD_4_CYCLES,
                               ADC12_B_MULTIPLESAMPLESDISABLE);

     // Configure Memory Buffer
      /*
       * Base address of the ADC12B Module
       * Configure memory buffer 0
       * Map input A7 to memory buffer 0
       * Vref+ = AVcc
       * Vref- = EXT Positive
       * Memory buffer 0 is not the end of a sequence
       */
      ADC12_B_configureMemoryParam configureMemoryParam = {0};
      configureMemoryParam.memoryBufferControlIndex = ADC12_B_MEMORY_0;
      configureMemoryParam.inputSourceSelect =        ADC12_B_INPUT_A7;
      configureMemoryParam.refVoltageSourceSelect =   ADC12_B_VREFPOS_INTBUF_VREFNEG_EXTNEG;
      configureMemoryParam.endOfSequence =            ADC12_B_ENDOFSEQUENCE;
      configureMemoryParam.windowComparatorSelect =   ADC12_B_WINDOW_COMPARATOR_DISABLE;
      configureMemoryParam.differentialModeSelect =   ADC12_B_DIFFERENTIAL_MODE_DISABLE;
      ADC12_B_configureMemory(ADC12_B_BASE, &configureMemoryParam);

    ADC12_B_clearInterrupt(ADC12_B_BASE,
                           0,
                           ADC12_B_IFG0
                           );

    // Enable memory buffer 0 interrupt
    ADC12_B_enableInterrupt(ADC12_B_BASE,
                            ADC12_B_IE0,
                            0,
                            0);

    // Start ADC conversion
    ADC12_B_startConversion(ADC12_B_BASE, ADC12_B_START_AT_ADC12MEM0, ADC12_B_REPEATED_SINGLECHANNEL);

    // TimerA1.1 (125ms ON-period) - ADC conversion trigger signal
    Timer_A_initUpMode(TIMER_A1_BASE, &initUpParam_A1);

    // Initialize compare mode to generate PWM1
    Timer_A_initCompareMode(TIMER_A1_BASE, &initCompParam);

    // Start timer A1 in up mode
    Timer_A_startCounter(TIMER_A1_BASE,
        TIMER_A_UP_MODE
        );

}

void displayTemp()
{
    clearLCD();

    // Pick C or F depending on tempUnit state

    showChar('V',pos6);


     if (degV>=100) {
        showChar((degV/100)%10 + '0',pos3);
     }
     else if (degV<100 && degV>10) {
        showChar('0',pos3);
     }

    if (degV>=10) {
        showChar((degV/10)%10+ '0',pos4);
    }
    else if (degV<10) {
        showChar('0',pos4);
        showChar('0',pos3);
    }

   if (degV>=1) {
        showChar((degV/1)%10+ '0',pos5);
   }
   else if (degV<1){
       showChar('0',pos5);
      showChar('0',pos4);
      showChar('0',pos3);
   }

    // Decimal point
    LCDMEM[pos3+1] |= 0x01;

}
