
***************************************************************************************************/
/*Include Section*/
#include <msp430.h>
#include "Clock.h"
#include "DRV_typedef.h"


/*Function Declaration*/
u8 clock_init(void);
u8 clock_initial(void);
void clock_Select(void);

/*Global Variable Declaration*/
#define MCLK_DEF   16   //16Mhz

/*Extern Declaration*/


u8 clock_init(void)
{
    u8 return_value;
    return_value =  clock_initial();    //Return value :For testing purpose
        clock_Select();


}


u8 clock_initial(void)
{
    u16 timeout;

    timeout = UCS_XT1_TIMEOUT;


    //Switch ON XT1 oscillator
       UCSCTL6 &= ~XT1OFF;

        //Highest drive setting for XT1startup
        UCSCTL6_L |= XT1DRIVE1_L + XT1DRIVE0_L;

        //Enable LF mode and clear xcap and bypass
        UCSCTL6 &= ~(XTS + XCAP_3 + XT1BYPASS);
        UCSCTL6 |= XCAP_3;

        do
        {
            UCSCTL7 &= ~(XT1LFOFFG);
//
//            //Clear OFIFG fault flag
//            SFRIFG1 &= ~OFIFG;
        }while ((UCSCTL7 & XT1LFOFFG) && --timeout);

        if (timeout){
            //set requested Drive mode
            UCSCTL6 = ( UCSCTL6 & ~(XT1DRIVE_3)) | (XT1DRIVE_0);

            return (0x01);
        } else   {
            return (0x00);
        }

}


void clock_Select(void)
{
    u16 temp = UCSCTL5;



                UCSCTL4 |= (SELA__XT1CLK | SELS__DCOCLKDIV | SELM__DCOCLKDIV);

//                UCSCTL5 = (temp & ~(DIVA_7 | DIVS_7 | DIVM_7)) | DIVM__1;


                UCSCTL3 &=  ~(SELREF_7);

                UCSCTL3 |= (SELREF__XT1CLK | FLLREFDIV_0);

                temp = UCSCTL3 & 0x00FF;
                //Note that dividers for FLLREF are slightly different
                //Hence handled differently from other CLK signals

//                SFRIFG1_L &= ~ OFIE ;
//
//                SFRIE1_L |= OFIE;
//
        // Initialize DCO to 2.45MHz
              __bis_SR_register(SCG0);               // Disable the FLL control loop
              UCSCTL0 = 0x0000;                      // Set lowest possible DCOx, MODx
              UCSCTL1 = DCORSEL_5;                   // Set RSELx for DCO = 20 MHz
              UCSCTL2 = FLLD_1 | 511;                 // Set DCO Multiplier for 16MHz
                                                     // (N + 1) * FLLRef = Fdco
                                                     // (511 + 1) * 32768 = 16MHz
                                                     // Set FLL Div = fDCOCLK/2
              __bic_SR_register(SCG0);               // Enable the FLL control loop

              __delay_cycles(7000000);
}




