/*
 * Core_F67791A.h
 *
 *  Created on: Nov 1, 2017
 *      Author: emb9
 */

#ifndef CORE_F67791A_H_
#define CORE_F67791A_H_

#include <msp430.h>
#include "DRV_typedef.h"


#define FCPU_147456HZ

#define SD24_SC SD24SC

#define SD24CCTL_CURRENT_1       SD24BCCTL6
#define SD24INCTL_CURRENT_1      SD24BINCTL6
#define SD24PRE_CURRENT_1        SD24BPRE6
#define SD24BOSR_CURRENT_1       SD24BOSR6
#define SD24MEM_CURRENT_1        SD24BMEM6
#define TST_SD24IFG_CURRENT_1    SD24BIFG & SD24IFG6
#define CLR_SD24IFG_CURRENT_1    SD24BIFG &= ~SD24IFG6
#define SET_SD24IE_CURRENT_1     SD24BIE |= SD24IE6

#define SD24CCTL_CURRENT_2       SD24BCCTL5
#define SD24INCTL_CURRENT_2      SD24BINCTL5
#define SD24PRE_CURRENT_2        SD24BPRE5
#define SD24BOSR_CURRENT_2       SD24BOSR5
#define SD24MEM_CURRENT_2        SD24BMEM5
#define TST_SD24IFG_CURRENT_2    SD24BIFG & SD24IFG5
#define CLR_SD24IFG_CURRENT_2    SD24BIFG &= ~SD24IFG5
#define SET_SD24IE_CURRENT_2     SD24BIE |= SD24IE5

#define SD24CCTL_CURRENT_3       SD24BCCTL4
#define SD24INCTL_CURRENT_3      SD24BINCTL4
#define SD24PRE_CURRENT_3        SD24BPRE4
#define SD24BOSR_CURRENT_3       SD24BOSR4
#define SD24MEM_CURRENT_3        SD24BMEM4
#define TST_SD24IFG_CURRENT_3    SD24BIFG & SD24IFG4
#define CLR_SD24IFG_CURRENT_3    SD24BIFG &= ~SD24IFG4
#define SET_SD24IE_CURRENT_3     SD24BIE |= SD24IE4


#define SD24CCTL_NEUTRAL    SD24BCCTL3
#define SD24INCTL_NEUTRAL   SD24BINCTL3
#define SD24PRE_NEUTRAL     SD24BPRE3
#define SD24BOSR_NEUTRAL    SD24BOSR3
#define SD24MEM_NEUTRAL     SD24BMEM3
#define TST_SD24IFG_NEUTRAL SD24BIFG & SD24IFG3
#define CLR_SD24IFG_NEUTRAL SD24BIFG &= ~SD24IFG3
#define SET_SD24IE_NEUTRAL  SD24BIE |= SD24IE3

#define SD24CCTL_VOLTAGE_1     SD24BCCTL2
#define SD24INCTL_VOLTAGE_1   SD24BINCTL2
#define SD24PRE_VOLTAGE_1      SD24BPRE2
#define SD24BOSR_VOLTAGE_1     SD24BOSR2
#define SD24MEM_VOLTAGE_1      SD24BMEMH2
#define TST_SD24IFG_VOLTAGE_1  SD24BIFG & SD24IFG2
#define CLR_SD24IFG_VOLTAGE_1  SD24BIFG &= ~SD24IFG2
#define SET_SD24IE_VOLTAGE_1   SD24BIE |= SD24IE2

#define SD24CCTL_VOLTAGE_2     SD24BCCTL1
#define SD24INCTL_VOLTAGE_2   SD24BINCTL1
#define SD24PRE_VOLTAGE_2      SD24BPRE1
#define SD24BOSR_VOLTAGE_2     SD24BOSR1
#define SD24MEM_VOLTAGE_2      SD24BMEMH1
#define TST_SD24IFG_VOLTAGE_2  SD24BIFG & SD24IFG1
#define CLR_SD24IFG_VOLTAGE_2  SD24BIFG &= ~SD24IFG1
#define SET_SD24IE_VOLTAGE_2   SD24BIE |= SD24IE1


#define SD24CCTL_VOLTAGE_3     SD24BCCTL0
#define SD24INCTL_VOLTAGE_3   SD24BINCTL0
#define SD24PRE_VOLTAGE_3      SD24BPRE0
#define SD24BOSR_VOLTAGE_3     SD24BOSR0
#define SD24MEM_VOLTAGE_3      SD24BMEMH0
#define TST_SD24IFG_VOLTAGE_3  SD24BIFG & SD24IFG0
#define CLR_SD24IFG_VOLTAGE_3  SD24BIFG &= ~SD24IFG0
#define SET_SD24IE_VOLTAGE_3   SD24BIE |= SD24IE0

#define SD24INCH_CURRENT    SD24INCH_0
#define SD24IFG            SD24BIFG

/*! The gain setting for the first current channel channel of the SD24,
    for devices using the SD24 sigma-delta ADC.
    This must be set to suit the shunt or CT in use. Typical values for a
    shunt are GAIN_16 (x16 gain) or GAIN_32 (x32 gain). Typical values for a
    CT are GAIN_1 (x1 gain) or GAIN_2 (x2 gain). */

#define CURRENT_PHASE_GAIN                          SD24GAIN_4


/*! The gain setting for the voltage channel of the SD24, for devices using the
    SD24 sigma-delta ADC. This is usually GAIN_1 (i.e. x1 gain). */
#define VOLTAGE_GAIN                                SD24GAIN_1


#define DEFAULT_V_PRESCALE_FACTOR   0





#endif /* CORE_F67791A_H_ */
