

/*Include Section*/
#include <msp430.h>
#include "Core_F67791A.h"


/*Function Declaration*/
void Init_SD24B(void);
static __inline__ void disable_analog_front_end(void);
static __inline__ void init_analog_front_end_normal(void);

/*Global Variable Declaration*/


/*Extern Declaration*/




void Init_SD24B(void)
{
    disable_analog_front_end();
    init_analog_front_end_normal();
}



static __inline__ void disable_analog_front_end(void)
{


         SD24INCTL_VOLTAGE_1 = 0;
         SD24CCTL_VOLTAGE_1 = 0;
         SD24PRE_VOLTAGE_1 = 0;

         SD24INCTL_VOLTAGE_2 = 0;
         SD24CCTL_VOLTAGE_2 = 0;
         SD24PRE_VOLTAGE_2 = 0;

         SD24INCTL_VOLTAGE_3 = 0;
         SD24CCTL_VOLTAGE_3 = 0;
         SD24PRE_VOLTAGE_3 = 0;

         SD24INCTL_CURRENT_1 = 0;
         SD24CCTL_CURRENT_1 = 0;
         SD24PRE_CURRENT_1 = 0;

         SD24INCTL_CURRENT_2 = 0;
         SD24CCTL_CURRENT_2 = 0;
         SD24PRE_CURRENT_2 = 0;

         SD24INCTL_CURRENT_3 = 0;
         SD24CCTL_CURRENT_3 = 0;
         SD24PRE_CURRENT_3 = 0;

         SD24INCTL_NEUTRAL = 0;
         SD24CCTL_NEUTRAL = 0;
         SD24PRE_NEUTRAL = 0;
         SD24BCTL0 = 0;
}

static __inline__ void init_analog_front_end_normal(void)
{

        REFCTL0 = REFMSTR + REFVSEL_1 + REFON;         /* Enabale Reference = 2.5V */
        SD24BCTL1 &= ~SD24GRP0SC;



        SD24BCTL0 = SD24SSEL_1  /* Clock is SMCLK */
            | SD24PDIV_3    /* Divide by 8 => ADC clock: 2MHz */
            | SD24DIV0
            | SD24REFS;     /* Use internal reference */


        /* Configure analog front-end channel 1 - Current */
          SD24INCTL_CURRENT_1 = CURRENT_PHASE_GAIN | SD24INTDLY_0;        /* Set gain for channel 1 */
          SD24CCTL_CURRENT_1 = SD24DF_1  | SD24SCS_4 /*| SD24SNGL*/ ;
          SD24BOSR_CURRENT_1 = 256 - 1;
          SD24PRE_CURRENT_1 = 0;

          /* Configure analog front-end channel 2 - Current */
          SD24INCTL_CURRENT_2 =  CURRENT_PHASE_GAIN | SD24INTDLY_0;        /* Set gain for channel 2 */
          SD24CCTL_CURRENT_2 = SD24DF_1  | SD24SCS_4 /*| SD24SNGL*/ ;       /* Set oversampling ratio to 256 (default) */
          SD24BOSR_CURRENT_2 = 256 - 1;
          SD24PRE_CURRENT_2 = 0;

          /* Configure analog front-end channel 3 - Current */
          SD24INCTL_CURRENT_3 =  CURRENT_PHASE_GAIN | SD24INTDLY_0;        /* Set gain for channel 3 */
          SD24CCTL_CURRENT_3 = SD24DF_1  | SD24SCS_4 /*| SD24SNGL */;//| SD24IE;       /* Set oversampling ratio to 256 (default) */
          SD24BOSR_CURRENT_3 = 256 - 1;
          SD24PRE_CURRENT_3 = 0;

          /* Configure analog front-end channel  - Neutral */
          SD24INCTL_NEUTRAL =  VOLTAGE_GAIN | SD24INTDLY_0;        /* Set gain for channel neutral */
          SD24CCTL_NEUTRAL = SD24DF_1  | SD24SCS_4 /*| SD24SNGL*/ ;         /* Set oversampling ratio to 256 (default) */
          SD24BOSR_NEUTRAL = 256 - 1;
          SD24PRE_NEUTRAL = 0;

          /* Configure analog front-end channel 1 - Voltage */
          SD24INCTL_VOLTAGE_1 =  VOLTAGE_GAIN | SD24INTDLY_0;
          SD24CCTL_VOLTAGE_1 = SD24DF_1 /*| SD24ALGN*/| SD24SCS_4 /*| SD24SNGL*/ ;
          SD24BOSR_VOLTAGE_1 = 256 - 1;
          SD24PRE_VOLTAGE_1 = DEFAULT_V_PRESCALE_FACTOR;


          /* Configure analog front-end channel 2 - Voltage */
          SD24INCTL_VOLTAGE_2 = VOLTAGE_GAIN | SD24INTDLY_0;
          SD24CCTL_VOLTAGE_2 = SD24DF_1 /*| SD24ALGN*/ | SD24SCS_4 /*| SD24SNGL*/ ;
          SD24BOSR_VOLTAGE_2 = 256 - 1;
          SD24PRE_VOLTAGE_2 = DEFAULT_V_PRESCALE_FACTOR;

          /* Configure analog front-end channel 3 - Voltage */
          SD24INCTL_VOLTAGE_3 =  VOLTAGE_GAIN | SD24INTDLY_0;
          SD24CCTL_VOLTAGE_3 = SD24DF_1 /*| SD24ALGN*/ | SD24SCS_4 /*| SD24SNGL*/ ;
          SD24BOSR_VOLTAGE_3 = 256 - 1;
          SD24PRE_VOLTAGE_3 = DEFAULT_V_PRESCALE_FACTOR;




          SD24BCTL1 |= SD24GRP0SC;


           SD24BIE= SD24IE6;
           __delay_cycles(0x3600);                 // Delay for 1.5V REF startup


      }
