

/*Include Section*/
#include <msp430.h>
#include"DRV_typedef.h"

/*Function Declaration*/


/*Global Variable Declaration*/
/* Arrays to store SD24_B conversion results */
 s16 V_Sample[3];
 s16 I_Sample[3];
 s16 N_Sample;

 u8 int_done = 0;
 u32 adc_result = 0;

/* Number of conversion results to store */
#define Num_of_Results 1

/*Extern Declaration*/





#pragma vector=SD24B_VECTOR
__interrupt void SD24BISR(void)

{
    P1OUT ^=0xFF;


    static unsigned int index = 0;

    switch (SD24BIV)
    {
        case SD24BIV_SD24OVIFG:             // SD24MEM Overflow
            break;
        case SD24BIV_SD24TRGIFG:            // SD24 Trigger IFG
            break;
        case SD24BIV_SD24IFG0:              // SD24MEM0 IFG
            break;
        case SD24BIV_SD24IFG1:              // SD24MEM1 IFG
            break;
        case SD24BIV_SD24IFG2:              // SD24MEM2 IFG
            break;
        case SD24BIV_SD24IFG3:              // SD24MEM3 IFG
            break;
        case SD24BIV_SD24IFG4:              // SD24MEM3 IFG
            break;
        case SD24BIV_SD24IFG5:           // SD24MEM3 IFG
            break;
        case SD24BIV_SD24IFG6:              // SD24MEM3 IFG
            SD24BIE &= ~SD24IE6;

            V_Sample[2] = (SD24BMEMH0<<8); // Save CH0 results (clears IFG)
            V_Sample[2] |= (SD24BMEML0>>8);

            V_Sample[1] = (SD24BMEMH1<<8); // Save CH1 results (clears IFG)
            V_Sample[1] |= (SD24BMEML1>>8);

            V_Sample[0] = (SD24BMEMH2<<8); // Save CH2 results (clears IFG)
            V_Sample[0] |= (SD24BMEML2>>8);

            N_Sample = (SD24BMEMH3<<8); // Save CH3 results (clears IFG)
            N_Sample |= (SD24BMEML3>>8);

            I_Sample[2] = (SD24BMEMH4<<8); // Save CH4 results (clears IFG)
            I_Sample[2] |= (SD24BMEML4>>8);

            I_Sample[1] = (SD24BMEMH5<<8); // Save CH5 results (clears IFG)
            I_Sample[1] |= (SD24BMEML5>>8);

//if  is commented we get the desired interrupt duration of 200usec

            I_Sample[0] = (SD24BMEMH6<<8); // Save CH6 results (clears IFG)	//comment this two lines	
            I_Sample[0] |= (SD24BMEML6>>8);

            if (++index == Num_of_Results)
            {
                index = 0;                  // SET BREAKPOINT HERE

            }

            break;

    }


}
