#include <msp430.h> 
#include "DRV_typedef.h"

/* Start user code for include. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */


/***********************************************************************************************************************
Global variables and functions
***********************************************************************************************************************/
/* Start user code for global. Do not edit comment generated here */
void system_init(void);
void softdelay(u16 Delayus);


extern u8 clock_init(void);
extern void InitPorts(void);
extern void TimerA_init(void);
extern void Init_SD24B(void);


/* End user code. Do not edit comment generated here */


/***********************************************************************************************************************
* Function Name: main
* Description  : This function implements main function.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/

int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;   // stop watchdog timer
    P1DIR = 0xFF;
    system_init();

    while(1)
    {
        ;
    }
	return 0;
}




void system_init(void)
{
    clock_init();            //Clock Initilisation
    InitPorts();
    TimerA_init();
    Init_SD24B();

    __bis_SR_register(GIE);

}



void softdelay(u16 Delayus)
{
    while(Delayus--);
}







