/**
 * main.c
 * Refer: msp430fr211x_adc10_10.c and msp430fr211x_euscia0_spi_12.c
 */


#include <msp430.h>

//#define ADC_ENABLE

volatile unsigned char RXData = 0;

unsigned char ADC_Result[3];                                    // 8-bit ADC conversion result array
unsigned char i;

int main(void)
{
  WDTCTL = WDTPW | WDTHOLD;                 // Stop watchdog timer

#ifdef ADC_ENABLE
  // Configure ADC A0~2 pins
     P1SEL0 |= BIT0 + BIT1 + BIT2;
     P1SEL1 |= BIT0 + BIT1 + BIT2;
#endif

  P1SEL0 |= BIT4 | BIT5 | BIT6 | BIT7;      // set 4-SPI pin as second function

  UCA0CTLW0 |= UCSWRST;                     // **Put state machine in reset**
                                            // 4-pin, 8-bit SPI slave
  UCA0CTLW0 |= UCMODE_2|UCSTEM|UCSYNC|UCMSB|UCCKPH; // UCCKPL

  // Profiling GPIOs
  P1OUT &= ~(BIT2|BIT3);
  P1DIR |= (BIT2|BIT3);

  P2OUT &= ~(BIT0|BIT1);
  P2DIR |= (BIT0|BIT1);
                                            // Clock polarity high, MSB
//  UCA0CTLW0 |= UCSSEL__ACLK;                // ACLK
//  UCA0BR0 = 0x02;                           // BRCLK = ACLK/2
//  UCA0BR1 = 0;                              //
//  UCA0MCTLW = 0;                            // No modulation

  UCA0CTLW0 &= ~UCSWRST;                    // **Initialize USCI state machine**
  UCA0IE |= UCRXIE;                         // Enable USCI_A0 RX interrupt

  PM5CTL0 &= ~LOCKLPM5;                     // Disable the GPIO power-on default high-impedance mode
                                            // to activate previously configured port settings
#ifdef ADC_ENABLE
  // Configure ADC
      ADCCTL0 |= ADCSHT_2 | ADCMSC | ADCON;                       // 16ADCclks, MSC, ADC ON
      ADCCTL1 |= ADCSHP | ADCCONSEQ_1 | ADCSSEL_1;                // ADC clock ACLK, sampling timer, s/w trig.,single sequence
      ADCCTL2 &= ~ADCRES_1;                                       // 8-bit conversion results
      ADCMCTL0 |= ADCINCH_2 | ADCSREF_0;                          // A0~2(EoS); ADCSREF_0 = Vref=ACC; ADCSREF_1 = Vref=1.5V
      ADCIE |= ADCIE0;                                            // Enable ADC conv complete interrupt

      // Configure reference
      PMMCTL0_H = PMMPW_H;                                        // Unlock the PMM registers
      PMMCTL2 |= INTREFEN;                                        // Enable internal reference
      __delay_cycles(400);                                        // Delay for reference settling
      // __no_operation();
#endif

	while(1)
	{
#ifdef ADC_ENABLE
		i = 2;
		while(ADCCTL1 & ADCBUSY);                                // Wait if ADC core is active
		ADCCTL0 |= ADCENC | ADCSC;                               // Sampling and conversion start
         __bis_SR_register(LPM0_bits | GIE);       // Enter LPM0,enable interrupts
		 __no_operation();                         // For debug,Remain in LPM0
		 __delay_cycles(5000);                     // Delay before next transmission
#endif
		UCA0IE |= UCTXIE;                      // Enable TX interrupt
		__bis_SR_register(LPM0_bits | GIE);       // Enter LPM0,enable interrupts
		  __no_operation();                         // For debug,Remain in LPM0
	    // __delay_cycles(200);                     // Delay before next transmission
		 // TXData++;

	}
   // __bis_SR_register(LPM0_bits | GIE);       // Enter LPM0, enable interrupts
}

#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector=USCI_A0_VECTOR
__interrupt void USCI_A0_ISR(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(USCI_A0_VECTOR))) USCI_A0_ISR (void)
#else
#error Compiler not supported!
#endif
{
//    while (!(UCA0IFG&UCTXIFG));             // USCI_A0 TX buffer ready?
//    UCA0TXBUF = (UCA0RXBUF) ;                  // Echo received data

	switch(__even_in_range(UCA0IV,USCI_SPI_UCTXIFG))
	  {
	    case USCI_NONE: break;                    // Vector 0 - no interrupt
	    case USCI_SPI_UCRXIFG:
//	    	P1OUT |= BIT2;
//			P1OUT &= ~BIT2;
		   RXData = UCA0RXBUF;
		   UCA0IFG &= ~UCRXIFG;
		   __bic_SR_register_on_exit(LPM0_bits);// Wake up to setup next TX
		   break;
	    case USCI_SPI_UCTXIFG:
#ifdef ADC_ENABLE
	    	if (RXData == 0x01)
	    		UCA0TXBUF = ADC_Result[2];                // Transmit characters
	    	else if (RXData == 0x02)
	    		UCA0TXBUF = ADC_Result[0];
	    	else if (RXData == 0x03)
	    		UCA0TXBUF =  ADC_Result[1];
	    	else
	    		UCA0TXBUF = 0x0F;
#else
	    	if (RXData == 0x01)
			{
				UCA0TXBUF = 0x09;
			}
			else if (RXData == 0x02)
			{
				UCA0TXBUF = 0x07;
			}
			else if (RXData == 0x03)
			{
				UCA0TXBUF = 0x08;
			}
			else
			{
				UCA0TXBUF = 0x0F;
			}

//			if (RXData == 0x01)
//			{
//				P1OUT |= BIT2;
//				UCA0TXBUF = 0x09;                // Transmit characters
//				P1OUT &= ~BIT2;
//			}
//			else if (RXData == 0x02)
//			{
//				P1OUT |= BIT3;
//				UCA0TXBUF = 0x07;
//				P1OUT &= ~BIT3;
//			}
//			else if (RXData == 0x03)
//			{
//				P2OUT |= BIT0;
//				UCA0TXBUF = 0x08;
//				P2OUT &= ~BIT0;
//			}
//			else
//			{
//				P2OUT |= BIT1;
//				UCA0TXBUF = 0x0F;
//				P2OUT &= ~BIT1;
//			}
#endif

	    	UCA0IE &= ~UCTXIE;
	        break;
	    default: break;
	  }
}

#ifdef ADC_ENABLE
// ADC interrupt service routine
#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector=ADC_VECTOR
__interrupt void ADC_ISR(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(ADC_VECTOR))) ADC_ISR (void)
#else
#error Compiler not supported!
#endif
{
    switch(__even_in_range(ADCIV,ADCIV_ADCIFG))
    {
        case ADCIV_NONE:
            break;
        case ADCIV_ADCOVIFG:
            break;
        case ADCIV_ADCTOVIFG:
            break;
        case ADCIV_ADCHIIFG:
            break;
        case ADCIV_ADCLOIFG:
            break;
        case ADCIV_ADCINIFG:
            break;
        case ADCIV_ADCIFG:
            ADC_Result[i] = ADCMEM0;
            if(i == 0)
            {
                __bic_SR_register_on_exit(LPM0_bits);              // Exist LPM0
            }
            else
            {
                i--;
            }
            break;
        default:
            break;
    }
}
#endif
