/*
  Digital Pot Control

  This example controls an Analog Devices AD5206 digital potentiometer.
  The AD5206 has 6 potentiometer channels. Each channel's pins are labeled
  A - connect this to voltage
  W - this is the pot's wiper, which changes when you set it
  B - connect this to ground.

 The AD5206 is SPI-compatible,and to command it, you send two bytes,
 one with the channel number (0 - 5) and one with the resistance value for the
 channel (0 - 255).

 The circuit:
  * All A pins  of AD5206 connected to +5V
  * All B pins of AD5206 connected to ground
  * An LED and a 220-ohm resisor in series connected from each W pin to ground
  * CS - to digital pin 10  (SS pin)
  * SDI - to digital pin 11 (MOSI pin)
  * CLK - to digital pin 13 (SCK pin)

 created 10 Aug 2010
 by Tom Igoe

 Thanks to Heather Dewey-Hagborg for the original tutorial, 2005

*/


// inslude the SPI library:
#include <SPI.h>


// set pin 10 as the slave select for the digital pot:
const int slaveSelectPin = 15;

void setup() {
  // set the slaveSelectPin as an output:
  pinMode(slaveSelectPin, OUTPUT);
  // initialize SPI:
  SPI.begin();
  // Ref: https://arduino.stackexchange.com/questions/16348/how-do-you-use-spi-on-an-arduino
  // SPI.beginTransaction (SPISettings (20000, MSBFIRST, SPI_MODE0));  // 20 kHz clock, MSB first, mode 2
  SPI.setFrequency(50000);
  Serial.begin(115200);
}

void loop() {
  for (int ch = 1; ch <= 3; ch++) {
    Serial.print("ch: ");
    Serial.print(" ");
    Serial.println(ch);
    adc_spi_read(ch);
    delay(2000);
    // delayMicroseconds(10);
  }

}

void adc_spi_read(int value) {
  unsigned int result = 0;   // result to return
  // delay(1);
  // take the SS pin low to select the chip:
  digitalWrite(slaveSelectPin, LOW);
  result = SPI.transfer(value);
  // take the SS pin high to de-select the chip:
  digitalWrite(slaveSelectPin, HIGH);
  Serial.print("result: ");
  // Serial.println((float) (result/255) * 3.3);
  Serial.println(result);
  Serial.println();
}
