/*
 *  ======== Board.c ========
 *  Configured TI-Drivers module definitions
 */

#include <stddef.h>

#ifndef DeviceFamily_MSP432E401Y
#define DeviceFamily_MSP432E401Y
#endif

#include <ti/devices/DeviceFamily.h>

#include <Board2.h>

/*
 *  =============================== ADCBuf ===============================
 */

#include <ti/drivers/ADCBuf.h>
#include <ti/drivers/adcbuf/ADCBufMSP432E4.h>

#include <ti/devices/msp432e4/inc/msp432.h>

#define Board_ADCBUFCOUNT 2

/*
 *  ======== adcbufMSP432E4Objects ========
 */
ADCBufMSP432E4_Object adcbufMSP432E4Objects[Board_ADCBUFCOUNT];

/*
 *  ======== ADCBuf0 Channels ========
 */
ADCBufMSP432E4_Channels adcBuf0MSP432E4Channels[] = {
    /* Board_ADCBUF0CHANNEL0 */
    {
        .adcPin = ADCBufMSP432E4_PB_4_A10,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL1 */
    {
        .adcPin = ADCBufMSP432E4_PB_5_A11,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL2 */
    {
        .adcPin = ADCBufMSP432E4_PD_0_A15,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL3 */
    {
        .adcPin = ADCBufMSP432E4_PD_1_A14,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL4 */
    {
        .adcPin = ADCBufMSP432E4_PD_2_A13,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL5 */
    {
        .adcPin = ADCBufMSP432E4_PD_3_A12,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL6 */
    {
        .adcPin = ADCBufMSP432E4_PD_4_A7,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL7 */
    {
        .adcPin = ADCBufMSP432E4_PD_5_A6,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL8 */
    {
        .adcPin = ADCBufMSP432E4_PD_6_A5,
        .adcSequence = ADCBufMSP432E4_Seq_1,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL9 */
    {
        .adcPin = ADCBufMSP432E4_PD_7_A4,
        .adcSequence = ADCBufMSP432E4_Seq_1,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL10 */
    {
        .adcPin = ADCBufMSP432E4_PE_0_A3,
        .adcSequence = ADCBufMSP432E4_Seq_1,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF0CHANNEL11 */
    {
        .adcPin = ADCBufMSP432E4_PE_1_A2,
        .adcSequence = ADCBufMSP432E4_Seq_1,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
};

/*
 *  ======== ADCBuf0 Sequencer Priorities ========
 */
static ADCBufMSP432E4_SequencePriorities seqPriorities0[ADCBufMSP432E4_SEQUENCER_COUNT] = {
    /* Sequencer 0 */
    ADCBufMSP432E4_Priority_0,
    /* Sequencer 1 */
    ADCBufMSP432E4_Priority_1,
    /* Sequencer 2 */
    ADCBufMSP432E4_Seq_Disable,
    /* Sequencer 3 */
    ADCBufMSP432E4_Seq_Disable,
};

/*
 *  ======== ADCBuf0 Sequencer Trigger Sources ========
 */
static ADCBufMSP432E4_TriggerSource triggerSource0[ADCBufMSP432E4_SEQUENCER_COUNT] = {
    /* Sequencer 0 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 1 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 2 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 3 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
};


/*
 *  ======== ADC1Buf Channels ========
 */
ADCBufMSP432E4_Channels adcBuf1MSP432E4Channels[] = {
    /* Board_ADCBUF1CHANNEL0 */
    {
        .adcPin = ADCBufMSP432E4_PE_2_A1,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL1 */
    {
        .adcPin = ADCBufMSP432E4_PE_3_A0,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL2 */
    {
        .adcPin = ADCBufMSP432E4_PE_4_A9,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL3 */
    {
        .adcPin = ADCBufMSP432E4_PE_5_A8,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL4 */
    {
        .adcPin = ADCBufMSP432E4_PK_0_A16,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL5 */
    {
        .adcPin = ADCBufMSP432E4_PK_1_A17,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL6 */
    {
        .adcPin = ADCBufMSP432E4_PK_2_A18,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
    /* Board_ADCBUF1CHANNEL7 */
    {
        .adcPin = ADCBufMSP432E4_PK_3_A19,
        .adcSequence = ADCBufMSP432E4_Seq_0,
        .adcInputMode = ADCBufMSP432E4_SINGLE_ENDED,
        .adcDifferentialPin = ADCBufMSP432E4_PIN_NONE,
        .adcInternalSource = ADCBufMSP432E4_INTERNAL_SOURCE_MODE_OFF,
        .refVoltage = 3300000
    },
};

/*
 *  ======== ADCBuf1 Sequencer Priorities ========
 */
static ADCBufMSP432E4_SequencePriorities seqPriorities1[ADCBufMSP432E4_SEQUENCER_COUNT] = {
    /* Sequencer 0 */
    ADCBufMSP432E4_Priority_0,
    /* Sequencer 1 */
    ADCBufMSP432E4_Seq_Disable,
    /* Sequencer 2 */
    ADCBufMSP432E4_Seq_Disable,
    /* Sequencer 3 */
    ADCBufMSP432E4_Seq_Disable,
};

/*
 *  ======== ADCBuf1 Sequencer Trigger Sources ========
 */
static ADCBufMSP432E4_TriggerSource triggerSource1[ADCBufMSP432E4_SEQUENCER_COUNT] = {
    /* Sequencer 0 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 1 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 2 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
    /* Sequencer 3 trigger source */
    ADCBufMSP432E4_TIMER_TRIGGER,
};


/*
 *  ======== adcbufMSP432E4HWAttrs ========
 */
const ADCBufMSP432E4_HWAttrsV1 adcbufMSP432E4HWAttrs[Board_ADCBUFCOUNT] = {
    /* Board_ADCBUF0 */
    {
     /* The sentinel value of ~(0) is used to indicate that the lowest possible priority should be used. */
        .intPriority = ~0,
        .adcBase = ADC0_BASE,
        .channelSetting = adcBuf0MSP432E4Channels,
        .sequencePriority = seqPriorities0,
        .adcTriggerSource = triggerSource0,
        .modulePhase =  ADCBufMSP432E4_Phase_Delay_0,
        .refSource = ADCBufMSP432E4_VREF_INTERNAL,
        .useDMA = 1,
        .adcTimerSource = TIMER1_BASE
    },
    {
        .intPriority = ~0,
        .adcBase = ADC1_BASE,
        .channelSetting = adcBuf1MSP432E4Channels,
        .sequencePriority = seqPriorities1,
        .adcTriggerSource = triggerSource1,
        .modulePhase =  ADCBufMSP432E4_Phase_Delay_0,
        .refSource = ADCBufMSP432E4_VREF_INTERNAL,
        .useDMA = 1,
        .adcTimerSource = TIMER1_BASE
    },
};

/*
 *  ======== ADCBuf_config ========
 */
const ADCBuf_Config ADCBuf_config[Board_ADCBUFCOUNT] = {
    /* Board_ADCBUF0 */
    {
        .fxnTablePtr = &ADCBufMSP432E4_fxnTable,
        .object = &adcbufMSP432E4Objects[Board_ADCBUF0],
        .hwAttrs = &adcbufMSP432E4HWAttrs[Board_ADCBUF0]
    },
    /* Board_ADCBUF1 */
    {
        .fxnTablePtr = &ADCBufMSP432E4_fxnTable,
        .object = &adcbufMSP432E4Objects[Board_ADCBUF1],
        .hwAttrs = &adcbufMSP432E4HWAttrs[Board_ADCBUF1]
    },
};

const uint_least8_t ADCBuf_count = Board_ADCBUFCOUNT;
