/******************************************************************************/
/* LINKER COMMAND FILE FOR MSPBoot BOOTLOADER USING MSP430G2553  */
/* File generated with MSPBootLinkerGen.pl on 07-18-2017 */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* The following definitions can be changed to customize the memory map for a different device
 *   or other adjustments
 *  Note that the changes should match the definitions used in MEMORY and SECTIONS
 *
 */
/* RAM Memory Addresses */
__RAM_Start = 0x200;                 /* RAM Start */
__RAM_End = 0x3FF;                     /* RAM End */
    /* RAM shared between App and Bootloader, must be reserved */
    PassWd = 0x200;                 /* Password sent by App to force boot  mode */
    StatCtrl = 0x202;             /* Status and Control  byte used by Comm */
    CI_State_Machine = 0x203;         /*  State machine variable used by Comm */
    CI_Callback_ptr = 0x204;   /* Pointer to Comm callback structure */
    /* Unreserved RAM used for Bootloader or App purposes */
    _NonReserved_RAM_Start = 0x208; /* Non-reserved RAM */

/* Flash memory addresses */
/* App area     : C000-DBFF*/
/* Download area: DC00-F7FF*/
/* Boot area    : F800-FFFF*/

__Flash_Start = 0xC000;             /* Start of Application area */
   /* Reserved Flash locations for Bootloader Area */
    __Boot_Start = 0xF800;         /* Boot flash */
    __Boot_Reset = 0xFFFE;                          /* Boot reset vector */
    __Boot_VectorTable = 0xFFE0;      /* Boot vector table */
    __Boot_SharedCallbacks_Len = 6; /* Length of shared callbacks (2 calls =4B(msp430) or 8B(msp430x) */
    __Boot_SharedCallbacks = 0xFFDA; /* Start of Shared callbacks */
     _BOOT_APPVECTOR = __Boot_SharedCallbacks;       /* Definition for application table             */
    _Appl_Proxy_Vector_Start = 0xDBC2; /* Proxy interrupt table */
    /* Reserved Flash locations for Application Area */
 
/* MEMORY definition, adjust based on definitions above */
MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    // RAM from _NonReserved_RAM_Start - __RAM_End
    RAM                     : origin = 0x208, length = 0x1F8
	// Info Mem Sections
	INFOA                   : origin = 0x10C0, length = 0x40
    INFOB                   : origin = 0x1080, length = 0x40
    INFOC                   : origin = 0x1040, length = 0x40
    INFOD                   : origin = 0x1000, length = 0x40
    // Flash from _App_Start -> (APP_PROXY_VECTORS-1)
    FLASH                   : origin = 0xC002, length = 0x1BC0
    // Interrupt Proxy table from  _App_Proxy_Vector_Start->(RESET-1)
    APP_PROXY_VECTORS       : origin = 0xDBC2, length = 60
    // App reset from _App_Reset_Vector
    RESET                   : origin = 0xDBFE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

    .text:_isr  : {}  > FLASH            /* Code ISRs                         */
    .text       : {} >> FLASH               /* CODE                 */
    .cinit      : {} > FLASH        /* INITIALIZATION TABLES*/ 
    .const      : {} >> FLASH       /* CONSTANT DATA        */
    .cio        : {} > RAM                /* C I/O BUFFER                      */
	
	.infoA     : {} > INFOA              /* MSP430 INFO FLASH Memory segments */
    .infoB     : {} > INFOB
    .infoC     : {} > INFOC
    .infoD     : {} > INFOD

    .APP_PROXY_VECTORS : {} > APP_PROXY_VECTORS /* INTERRUPT PROXY TABLE            */
    .reset       : {}               > RESET  /* MSP430 RESET VECTOR                 */
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l MSP430G2553.cmd

