//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED  string
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted
//  by Texas Instruments is distributed as "freeware".  You may,
//  only under TI's copyright in the Program, use and modify the
//  Program without any charge or restriction.  You may
//  distribute to third parties, provided that you transfer a
//  copy of this license to the third party and the third party
//  agrees to these terms by its first use of the Program. You
//  must reproduce the copyright notice and any other legend of
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains
//  copyrighted material, trade secrets and other TI proprietary
//  information and is protected by copyright laws,
//  international copyright treaties, and trade secret laws, as
//  well as other intellectual property laws.  To protect TI's
//  rights in the Program, you agree not to decompile, reverse
//  engineer, disassemble or otherwise translate any object code
//  versions of the Program to a human-readable form.  You agree
//  that in no event will you alter, remove or destroy any
//  copyright notice included in the Program.  TI reserves all
//  rights not specifically granted under this license. Except
//  as specifically provided herein, nothing in this agreement
//  shall be construed as conferring by implication, estoppel,
//  or otherwise, upon you, any license or other right under any
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//

//******************************************************************************

#include "emeter.h"
#include "math.h"
#include "Emeter_Var.h"


//------------------------------------------------------------------------------------------
float Ctr,Ptr,CT_MUL_PT;
unsigned char NXT,PROG,INC,DEC;
unsigned char F_baud,F_baud_reply,F_parity,parity_reply,F_stopbit,stopbit_reply;
unsigned char sec_2,sec_load,sec;



unsigned char disp[11],disp_1[11];
unsigned char run_para;
unsigned char cursor;
unsigned char disp_line, disp_line1;
unsigned char line_shift;
unsigned char password_page;
unsigned char password[4];
unsigned char Progmode_para;
unsigned char timeout,bl_timeout;
unsigned char tpr;
//bits b;
struct bits b={0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0};
unsigned char debounce_cnt_key4,debounce_cnt_key3,debounce_cnt_key2,debounce_cnt_key1;
unsigned char calib_para;
unsigned char temp_char[8],temp_char_1[8];
unsigned char temp_int[4];
float V_creep,V_creep_LL;
float I_creep;
unsigned char scroll = 0,fav_ret_page_time_cnt = 0, Auto_ret = 0;
unsigned int freez_page;
unsigned int dp;
unsigned long CalWatt=0.0,  WattValue=0.0;

#define NO_DP 9

unsigned char total_no_of_digits;
unsigned char No_of_digit_disp,start_of_digit_disp;
extern unsigned char ms_2_cnt, test_ms;
//unsigned char Disp_buffer[10];
unsigned int Alphanumeric_code[40]={
0x653F,	//  0
0x0206,	//  1
0xE05B,	//	2
0xE04F,	//	3
0x8066,	//	4
0xE06D,	//	5
0xE07D,	//	6
0x2007,	//	7
0xE07F,	//	8
0xE04F,	//	9
0xA077,	//	A
0xE90F,	//	B
0x6039,	//	C
0x690F,	//	D
0xE079,	//	E
0xA071,	//	F
0xE03D,	//	G
0x8076,	//	H
0x6909,	//	I
0x401E,	//	J
0x1270,	//	K
0x4038,	//	L
0x02B6,	//	M
0x10B6,	//	N
0x603F,	//	O
0xA073,	//	P
0x703F,	//	Q
0xB073,	//	R
0xE06D,	//	S
0x2901,	//	T
0x403E,	//	U
0x0630,	//	V
0x1436,	//	W
0x1680,	//	X
0x0A80,	//	Y
0x6609,	//	Z
0x8040,	//	-
0x0000,	//  BLANK
0x8074,	//  h
0x1086  //  v
};

unsigned char Alphanumeric_seg[17]={
0x01,
0x08,
0x40,
0X80,
0x40,
0x04,
0x08,
0x02,
0x02,
0x04,
0x20,
0x10,
0x20,
0x01,
0x80,
0x10,
0x80
};

unsigned char character_seg[8]={
0x01,
0x02,
0x10,
0X40,
0x20,
0x04,
0x08,
0x80
};


//**********************************************
unsigned char Char_seg_line0_2[8]={
0x01,
0x01,
0x04,
0x08,
0x04,
0x02,
0x02,
0x08
};


unsigned char Char_seg_line1_3[8]={
0x10,
0x10,
0x40,
0x80,
0x40,
0x20,
0x20,
0x80
};


unsigned char Char_seg_line3_last2[8]={
0x01,
0x02,
0x10,
0x40,
0x20,
0x04,
0x08,
0x80
};
//*******************************************************
void LCD_Display_alpha(unsigned int alpha_val, unsigned int digit, unsigned char dp);
void LCD_Display_char(unsigned char character_value, unsigned int digit, unsigned char dp);

unsigned char LCD_char_line(unsigned char line, unsigned char *ptr, unsigned char digit, unsigned char nos, unsigned char dp_pos);
void float2str(double value, unsigned char *data);
void Low_High_value_rst(void);
//******************************************
unsigned char char_value[50]=
{
								 0x3F,	//0		0
								 0x06,	//1		1
								 0x5B,	//2		2
								 0x4F,	//3		3
								 0x66,	//4		4
								 0x6D,	//5		5
								 0x7D,	//6		6
								 0x07,	//7		7
								 0x7F,	//8		8
								 0x6F,	//9		9
								 0x77,	//10    A
								 0x7C,	//11	b
								 0x39,	//12 	C
								 0x5E,	//13 	d
								 0x79,	//14 	E
								 0x71,	//15 	F
								 0x3D,	//16 	G
								 0x74,	//17 	h   //H 0x76
								 0x30,	//18 	I   // 0xF9 //0x04 i
								 0x0E,	//19 	J
								 0x72,	//20 	K
								 0x38,	//21 	L
								 0x15,	//22 	m  //0xAA
								 0x54,	//23 	N  //0xC8
								 0x5C,	//24 	o
								 0x73,	//25 	P
								 0x67,	//26 	Q
								 0x50,	//27 	r
								 0x6D,	//28 	S
								 0x78,	//29 	t
								 0x3E,	//30 	U
								 0x1C,	//31 	v
								 0x2A,	//32 	W  //0x95
								 0x00,	//33 	X
								 0x6E,	//34 	y
								 0x5B,	//35 	Z
								 0x40,	//36 	-
								 0x00,	//37 	BLANK
								 0x46,	//38 	-1
								 0x80,	//39 	.
								 0x08,	//40 	_
								 0x7F	//41 	for removing .
};

extern unsigned char value[4][9];
extern unsigned char value1[4][9];

char k_unit_on;
unsigned char percentage_load[3];
unsigned char Minus_sign=0;
void lc_glass_display(unsigned char row, double float_value, unsigned char start_digit, unsigned char total_display_digit);
void display_message(const char *p,unsigned char k);
void display_message1(char *p,unsigned char k);
float get_PF_angle(float measurnd);
void max_min_value_measurement(void);
#ifdef RTC_CALENDAR
	unsigned char Hi_limit,Lo_limit;
#endif

void Run_Mode(void)
{
	register unsigned char i,j;
	register unsigned int k,p;
	register unsigned int temp_int4, temp_int5;
    float temp_float1,temp_float2;
	unsigned char sign_check1[4];
	float disp_float[4];
	double disp_float_eng[4];
	//register unsigned long disp_long;

		  for(k=0;k<385;k++)
			array_lc[k] = 0x00;

		  for(p=0;p<11;p++)
			  disp[p]=' ';

		  array_lc[masibus]=masibus_ON;

		switch(run_para)
		{
			case 11:	     //Voltage

						 if(pm.p.system == PHASE_3P3W)
						  {
							 array_lc[three_P3W] =three_P3W_ON ;
						  }

						if((fp.en.V_rms[0]>=1000000.0)||(fp.en.V_rms[1]>=1000000.0)||(fp.en.V_rms[2]>=1000000.0)||(fp.en.V_rms[3]>=1000000.0))
							{
								 disp_float[0]=fp.en.V_rms[0]/1000000.0;
								 disp_float[1]=fp.en.V_rms[1]/1000000.0;
								 disp_float[2]=fp.en.V_rms[2]/1000000.0;
								 disp_float[3]=fp.en.V_rms[3]/1000000.0;
								 array_lc[M]=M_ON;
							 }
						 else if((fp.en.V_rms[0]>=1000.0 && fp.en.V_rms[0]<1000000.0)||(fp.en.V_rms[1]>=1000.0 && fp.en.V_rms[1]<1000000.0)||(fp.en.V_rms[2]>=1000.0 && fp.en.V_rms[2]<1000000.0)||(fp.en.V_rms[3]>=1000.0 && fp.en.V_rms[3]<1000000.0))
							{
								 disp_float[0]=fp.en.V_rms[0]/1000.0;
								 disp_float[1]=fp.en.V_rms[1]/1000.0;
								 disp_float[2]=fp.en.V_rms[2]/1000.0;
								 disp_float[3]=fp.en.V_rms[3]/1000.0;
								 array_lc[K]=K_ON;
							}
						 else
							{
								 disp_float[0]= fp.en.V_rms[0];
								 disp_float[1]= fp.en.V_rms[1];
								 disp_float[2]= fp.en.V_rms[2];
								 disp_float[3]= fp.en.V_rms[3];
							}

								lc_glass_display(0, disp_float[0], 2, 5);
                             if(pm.p.system == PHASE_3P3W)
					           {
									lc_glass_display(2, disp_float[1], 2, 5);
									lc_glass_display(1, disp_float[2], 2, 5);
								}
								else
								{
									lc_glass_display(1, disp_float[1], 2, 5);
								    lc_glass_display(2, disp_float[2], 2, 5);
								}
								lc_glass_display(3, disp_float[3], 4, 5);

								display_message1(" VOLT",NO_DP);
								array_lc[V_1]=V_1_ON;
								array_lc[V_2]=V_2_ON;
								array_lc[V_3]=V_3_ON;
								array_lc[V_4]=V_4_ON;

								array_lc[Line1]=Line1_ON;
								array_lc[Line2]=Line2_ON;
								array_lc[Line3]=Line3_ON;
								array_lc[Avg] = Avg_ON;
				break;

			case 12:	//Current
//				  if(pm.p.system == PHASE_3P3W)
//					{
//					  if((fp.en.I_rms[0]>=1000.0)||(fp.en.I_rms[2]>=1000.0)||(fp.en.I_rms[3]>=1000.0))
//						{
//								disp_float[0]=fp.en.I_rms[0]/1000.0;
//								disp_float[2]=fp.en.I_rms[2]/1000.0;
//								disp_float[3]=fp.en.I_rms[3]/1000.0;
//									array_lc[K] = K_ON;
//						}
//					 else
//						{
//							 disp_float[0]=fp.en.I_rms[0];
//							 disp_float[2]=fp.en.I_rms[2];
//							 disp_float[3]=fp.en.I_rms[3];
//						}
//					}
				// else
				  // {
					 if((fp.en.I_rms[0]>=1000.0)||(fp.en.I_rms[1]>=1000.0)||(fp.en.I_rms[2]>=1000.0)||(fp.en.I_rms[3]>=1000.0))
						{
						  disp_float[0]=fp.en.I_rms[0]/1000.0;
						  disp_float[1]=fp.en.I_rms[1]/1000.0;
						  disp_float[2]=fp.en.I_rms[2]/1000.0;
						  disp_float[3]=fp.en.I_rms[3]/1000.0;
							  array_lc[K] = K_ON;
						}
					 else
						{
							 disp_float[0]=fp.en.I_rms[0];
							 disp_float[1]=fp.en.I_rms[1];
							 disp_float[2]=fp.en.I_rms[2];
							 disp_float[3]=fp.en.I_rms[3];
						}
							lc_glass_display(1, disp_float[1], 2, 5);
							array_lc[Line2]=Line2_ON;
							array_lc[A_2] = A_2_ON ;
				  //}
						lc_glass_display(0, disp_float[0], 2, 5);
						lc_glass_display(2, disp_float[2], 2, 5);
						lc_glass_display(3, disp_float[3], 4, 5);
						array_lc[A_1] = A_1_ON ;
						array_lc[A_3] = A_3_ON ;
						array_lc[A_4] = A_4_ON ;
						array_lc[Line1]=Line1_ON;
						array_lc[Line3]=Line3_ON;
						display_message1(" AMPS",NO_DP);
						array_lc[Avg] = Avg_ON;
					  break;

			case 13:    //PF
						if(pm.p.system == PHASE_3P3W)
						{
							if(fp.en.PF[0] < 0.0)
							  {
								disp_float[0]=fp.en.PF[0]*(-1);
								array_lc[D26G] = D26G_ON;
							  }
							else
								disp_float[0]=fp.en.PF[0];
							  if(pm.p.pf_type[0] == LAG)
								 array_lc[Lag1] = Lag1_ON;
							  else if(pm.p.pf_type[0] == LEAD)
								  array_lc[Lead1] = Lead1_ON;
							  lc_glass_display(0, disp_float[0], 3, 4);

							  if(fp.en.PF[2] < 0.0)
								{
									disp_float[2]=fp.en.PF[2]*(-1);
									array_lc[D19G] = D19G_ON;
								}
								else
									disp_float[2]=fp.en.PF[2];
							  if(pm.p.pf_type[2] == LAG)
								  array_lc[Lag2] = Lag2_ON;
							  else if(pm.p.pf_type[2] == LEAD)
								  array_lc[Lead2] = Lead2_ON;
							  lc_glass_display(1, disp_float[2], 3, 4);

							  if(fp.en.PF[3] < 0.0)
								{
									disp_float[3]=fp.en.PF[3]*(-1);
									 array_lc[D5G] = D5G_ON;
								}
								else
									disp_float[3]=fp.en.PF[3];
							  if(pm.p.pf_type[3] == LAG)
								  array_lc[Lag4] = Lag4_ON;
							  else if(pm.p.pf_type[3] == LEAD)
								  array_lc[Lead4] = Lead4_ON;
							  lc_glass_display(3, disp_float[3], 5, 4);
								array_lc[three_P3W] = three_P3W_ON;
						}
					else
						{
									if(fp.en.PF[0] < 0.0)
									  {
										disp_float[0]=fp.en.PF[0]*(-1);
										array_lc[D26G] = D26G_ON;
									  }
									else
										disp_float[0]=fp.en.PF[0];
									  if(pm.p.pf_type[0] == LAG)
										 array_lc[Lag1] = Lag1_ON;
									  else if(pm.p.pf_type[0] == LEAD)
										  array_lc[Lead1] = Lead1_ON;
									  lc_glass_display(0, disp_float[0], 3, 4);

								  if(fp.en.PF[1] < 0.0)
									{
										disp_float[1]=fp.en.PF[1]*(-1);
										array_lc[D19G] = D19G_ON;
									}
									else
										disp_float[1]=fp.en.PF[1];
								  if(pm.p.pf_type[1] == LAG)
									  array_lc[Lag2] = Lag2_ON;
								  else if(pm.p.pf_type[1] == LEAD)
									  array_lc[Lead2] = Lead2_ON;
								  lc_glass_display(1, disp_float[1], 3, 4);

								  if(fp.en.PF[2] < 0.0)
									{
										disp_float[2]=fp.en.PF[2]*(-1);
										 array_lc[D12G] = D12G_ON;
									}
									else
										disp_float[2]=fp.en.PF[2];
								  if(pm.p.pf_type[2] == LAG)
									  array_lc[Lag3] = Lag3_ON;
								  else if(pm.p.pf_type[2] == LEAD)
									  array_lc[Lead3] = Lead3_ON;
								  lc_glass_display(2, disp_float[2], 3, 4);

								  if(fp.en.PF[3] < 0.0)
									{
										disp_float[3]=fp.en.PF[3]*(-1);
										 array_lc[D5G] = D5G_ON;
									}
									else
										disp_float[3]=fp.en.PF[3];
								  if(pm.p.pf_type[3] == LAG)
									  array_lc[Lag4] = Lag4_ON;
								  else if(pm.p.pf_type[3] == LEAD)
									  array_lc[Lead4] = Lead4_ON;
								  lc_glass_display(3, disp_float[3], 5, 4);
							}
									display_message1("  PF ",3);
									LCD_char_line(3, "SYS", 0, 3, 2);
									 array_lc[Line1]=Line1_ON;
									 array_lc[Line2]=Line2_ON;
									 array_lc[Line3]=Line3_ON;
									 array_lc[D33P] = D33P_ON;
								break;

			case 14:    //Phase Angle

					 if(pm.p.system == PHASE_3P3W)
					 {
						 if(fp.en.P_Reactive[3]<0.0)
						 {
							 array_lc[D26G] = D26G_ON;
							 array_lc[D19G] = D19G_ON;
						 }
	//					 else
	//					 {
	//						 led_data[0] = led_data[0] | R_NEG_BAR0_OFF;
	//						 led_data[1] = led_data[1] | Y_NEG_BAR1_OFF;
	//					 }
						 disp_float[0]=phase_ang[2];
						 disp_float[2]=phase_ang[2];

						 lc_glass_display(0, disp_float[0], 3, 4);
						 lc_glass_display(1, disp_float[2], 3, 4);
					 }
					 else
					 {
						 if(fp.en.P_Reactive[0]<0.0)
							 array_lc[D26G] = D26G_ON;
						//else
						//	led_data[0] = led_data[0] | R_NEG_BAR0_OFF;
						 disp_float[0]=phase_ang[0];
						 lc_glass_display(0, disp_float[0], 3, 4);

						if(fp.en.P_Reactive[1]<0.0)
							array_lc[D19G] = D19G_ON;
						//else
						//	led_data[1] = led_data[1] | Y_NEG_BAR1_OFF;
						disp_float[1]=phase_ang[1];
						lc_glass_display(1, disp_float[1], 3, 4);

						if(fp.en.P_Reactive[2]<0.0)
							array_lc[D12G] = D12G_ON;
						//else
						//	led_data[2] = led_data[2] | B_NEG_BAR2_OFF;
						disp_float[2]=phase_ang[2];
						lc_glass_display(2, disp_float[2], 3, 4);
					 }
						disp_float[3] = fp.en.Frequency[3];
						LCD_char_line(3, "FREQ-", 0, 5, NO_DP);
						lc_glass_display(3, disp_float[3], 5, 4);
						display_message1("PANGL",0);
						array_lc[Hz] = Hz_ON;
						array_lc[Line1]=Line1_ON;
						array_lc[Line2]=Line2_ON;
						array_lc[Line3]=Line3_ON;
					 break;

			case 21:     //phase to phase & frequency

					 if(pm.p.system == PHASE_3P4W)
					 {
						  if((fp.en.V_RY_rms>=1000000.0)||(fp.en.V_YB_rms>=1000000.0)||(fp.en.V_BR_rms>=1000000.0))
							{
							   disp_float[0]=fp.en.V_RY_rms/1000000.0;
							   disp_float[1]=fp.en.V_YB_rms/1000000.0;
							   disp_float[2]=fp.en.V_BR_rms/1000000.0;
							   array_lc[M]=M_ON;
							}
						 else if((fp.en.V_RY_rms>=1000.0 && fp.en.V_RY_rms<1000000.0)||(fp.en.V_YB_rms>=1000.0 && fp.en.V_YB_rms<1000000.0)||(fp.en.V_BR_rms>=1000.0 && fp.en.V_BR_rms<1000000.0))
							{
							  disp_float[0]=fp.en.V_RY_rms/1000.0;
							  disp_float[1]=fp.en.V_YB_rms/1000.0;
							  disp_float[2]=fp.en.V_BR_rms/1000.0;
							  array_lc[K]=K_ON;
							}
						 else
							{
							  disp_float[0]=fp.en.V_RY_rms;
							  disp_float[1]=fp.en.V_YB_rms;
							  disp_float[2]=fp.en.V_BR_rms;
							}
							disp_float[3] = fp.en.Frequency[3];

							lc_glass_display(0, disp_float[0], 2, 5);
							lc_glass_display(1, disp_float[1], 2, 5);
							lc_glass_display(2, disp_float[2], 2, 5);
							LCD_char_line(3, "FREQ-", 0, 5, NO_DP);
							lc_glass_display(3, disp_float[3], 5, 4);
							display_message1("PVOLT",0);

							 array_lc[V_1]=V_1_ON;
							 array_lc[V_2]=V_2_ON;
							 array_lc[V_3]=V_3_ON;
							 array_lc[Hz] = Hz_ON;
							 array_lc[Line1]=Line1_ON;
							 array_lc[Line2]=Line2_ON;
							 array_lc[Line3]=Line3_ON;
							 array_lc[ three_P3W]= three_P3W_ON;
					}
					break;

			case 22:	//Active Power

					for(i=0;i<4;i++)
					  {
						if(i%2)
							Minus_sign = 0x20;
						else
							Minus_sign = 0x02;

					  if(fp.en.P_Active[i] < 0.0)
					  {
						  disp_float[i] = fp.en.P_Active[i] * (-1.0);
						  if(pm.p.system == PHASE_3P3W)
						  {
							  if(i==0)
							    array_lc[D25G]=Minus_sign;
							  if(i==2)
								 array_lc[D25G-55]=0x20;
							  if(i==3)
								 array_lc[D25G-(i*55)]=Minus_sign;
						  }
						  else
						  {
						    array_lc[D25G-(i*55)]=Minus_sign;  //use where ever -ve sign is used
						  }
					  }
					 else
					  {
						 disp_float[i] = fp.en.P_Active[i];
					  }

				   }

				  if(pm.p.system == PHASE_3P3W)
				  {
					  if((disp_float[0]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
						{
						  disp_float[0]=disp_float[0]/1000000.0;
						  disp_float[2]=disp_float[2]/1000000.0;
						  disp_float[3]=disp_float[3]/1000000.0;
								array_lc[M]=M_ON;
						}
					  else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
						{
						  disp_float[0]=disp_float[0]/1000.0;
						  disp_float[2]=disp_float[2]/1000.0;
						  disp_float[3]=disp_float[3]/1000.0;
							 array_lc[K]=K_ON;
						}
					lc_glass_display(0, disp_float[0], 2, 5);
					lc_glass_display(1, disp_float[2], 2, 5);
					lc_glass_display(3, disp_float[3], 4, 5);
					array_lc[ three_P3W]= three_P3W_ON;
					 //array_lc[D18G]=0x00;
				  }
				else
				{
					  if((disp_float[0]>=1000000.0)||(disp_float[1]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
						{
						  disp_float[0]=disp_float[0]/1000000.0;
						  disp_float[1]=disp_float[1]/1000000.0;
						  disp_float[2]=disp_float[2]/1000000.0;
						  disp_float[3]=disp_float[3]/1000000.0;
						  array_lc[M]=M_ON;
						}
					  else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[1]>=1000.0 && disp_float[1]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
						{
						  disp_float[0]=disp_float[0]/1000.0;
						  disp_float[1]=disp_float[1]/1000.0;
						  disp_float[2]=disp_float[2]/1000.0;
						  disp_float[3]=disp_float[3]/1000.0;
						  array_lc[K]=K_ON;
						}
					lc_glass_display(0, disp_float[0], 2, 5);
					lc_glass_display(1, disp_float[1], 2, 5);
					lc_glass_display(2, disp_float[2], 2, 5);
					lc_glass_display(3, disp_float[3], 4, 5);
					array_lc[V_3]=V_3_ON;
					array_lc[V1_3]=V1_3_ON;
				}
					 array_lc[Sum]=Sum_ON;
					 array_lc[Line1]=Line1_ON;
					 array_lc[Line2]=Line2_ON;
					 array_lc[Line3]=Line3_ON;
					 array_lc[V_1]=V_1_ON;
					 array_lc[V1_1]=V1_1_ON;
					 array_lc[V_2]=V_2_ON;
					 array_lc[V1_2]=V1_2_ON;
					 array_lc[V_4]=V_4_ON;
					 array_lc[V1_4]=V1_4_ON;
					display_message1("PWR-P",NO_DP);
		break;

			case 23:	//Reactive Power

				for(i=0;i<4;i++)
			     {
					if(i%2)
						Minus_sign = 0x20;
					else
						Minus_sign = 0x02;

					if(fp.en.P_Reactive[i]==0.0)
					{
						disp_float[i] = fp.en.P_Reactive[i];
						sign_check1[i] = 2;
					}
					else if(fp.en.P_Reactive[i] < 0.0)
					{
						disp_float[i] = fp.en.P_Reactive[i] * (-1.0);
						if(pm.p.system == PHASE_3P3W)
						  {
							  if(i==0)
								array_lc[D25G]=Minus_sign;
							  if(i==2)
								 array_lc[D25G-55]=0x20;
							  if(i==3)
								 array_lc[D25G-(i*55)]=Minus_sign;
						  }
						  else
						  {
							array_lc[D25G-(i*55)]=Minus_sign;  //use where ever -ve sign is used
						  }
						if(pm.p.pf_type[i] == LEAD)
						 sign_check1[i] = 1;
						else
						 sign_check1[i] = 0;
					}
					else
					{
						disp_float[i] = fp.en.P_Reactive[i];
						if(pm.p.pf_type[i] == LEAD)
						 sign_check1[i] = 1;
						else
						 sign_check1[i] = 0;
					}
				   }

				if(pm.p.system == PHASE_3P3W)
				{
						 if((disp_float[0]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
							{
								disp_float[0]=disp_float[0]/1000000.0;
								disp_float[2]=disp_float[2]/1000000.0;
								disp_float[3]=disp_float[3]/1000000.0;
								array_lc[M]=M_ON;
							}
						 else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
							{
								disp_float[0]=disp_float[0]/1000.0;
								disp_float[2]=disp_float[2]/1000.0;
								disp_float[3]=disp_float[3]/1000.0;
								   array_lc[K]=K_ON;
							}

						if(sign_check1[0] == 1)
							array_lc[Lead1]=Lead1_ON;
						else if(sign_check1[0] == 0)
							array_lc[Lag1]=Lag1_ON;
						  lc_glass_display(0, disp_float[0], 2, 5);

						  if(sign_check1[2] == 1)
							array_lc[Lead2]=Lead2_ON;
						else if(sign_check1[2] == 0)
							array_lc[Lag2]=Lag2_ON;
						  lc_glass_display(1, disp_float[2], 2, 5);

						if(sign_check1[3] == 1)
							 array_lc[Lead4]=Lead4_ON;
						else if(sign_check1[3] == 0)
							 array_lc[Lag4]=Lag4_ON;
						 lc_glass_display(3, disp_float[3], 4, 5);

						 array_lc[ three_P3W]= three_P3W_ON;
				}
				else
				{
						 if((disp_float[0]>=1000000.0)||(disp_float[1]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
							{
								disp_float[0]=disp_float[0]/1000000.0;
								disp_float[1]=disp_float[1]/1000000.0;
								disp_float[2]=disp_float[2]/1000000.0;
								disp_float[3]=disp_float[3]/1000000.0;
								 array_lc[M]=M_ON;
							}
						 else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[1]>=1000.0 && disp_float[1]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
							{
								disp_float[0]=disp_float[0]/1000.0;
								disp_float[1]=disp_float[1]/1000.0;
								disp_float[2]=disp_float[2]/1000.0;
								disp_float[3]=disp_float[3]/1000.0;
								 array_lc[K]=K_ON;
							}

						if(sign_check1[0] == 1)
							array_lc[Lead1]=Lead1_ON;
						else if(sign_check1[0] == 0)
							array_lc[Lag1]=Lag1_ON;
						  lc_glass_display(0, disp_float[0], 2, 5);

						if(sign_check1[1] == 1)
							array_lc[Lead2]=Lead2_ON;
						else if(sign_check1[1] == 0)
							array_lc[Lag2]=Lag2_ON;
						 lc_glass_display(1, disp_float[1], 2, 5);

						if(sign_check1[2] == 1)
							array_lc[Lead3]=Lead3_ON;
						else if(sign_check1[2] == 0)
							array_lc[Lag3]=Lag3_ON;
						 lc_glass_display(2, disp_float[2], 2, 5);

						if(sign_check1[3] == 1)
							array_lc[Lead4]=Lead4_ON;
						else if(sign_check1[2] == 0)
							array_lc[Lag4]=Lag4_ON;
						 lc_glass_display(3, disp_float[3], 4, 5);

						 array_lc[V_3 ]=V_3_ON;
						 array_lc[A_3]=A_3_ON;
						 array_lc[r_3]=r_3_ON;
				}
						array_lc[V_1 ]=V_1_ON;
						array_lc[A_1]=A_1_ON;
						array_lc[r_1]=r_1_ON;
						array_lc[V_2 ]=V_2_ON;
						array_lc[A_2]=A_2_ON;
						array_lc[r_2]=r_2_ON;
						array_lc[V_4 ]=V_4_ON;
						array_lc[A_4]=A_4_ON;
						array_lc[r_4]=r_4_ON;
						array_lc[Sum]=Sum_ON;
						array_lc[Line1]=Line1_ON;
						array_lc[Line2]=Line2_ON;
						array_lc[Line3]=Line3_ON;
						display_message1("PWR-Q",NO_DP);
			break;

			case 24:	//Apparent Power

				  for(i=0;i<4;i++)
					 disp_float[i] = fp.en.P_Apparent[i];

				if(pm.p.system == PHASE_3P3W)
				{
						if((disp_float[0]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
							{
							   disp_float[0]=disp_float[0]/1000000.0;
							   disp_float[2]=disp_float[2]/1000000.0;
							   disp_float[3]=disp_float[3]/1000000.0;
							   array_lc[M]=M_ON;
							}
						else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
							{
								disp_float[0]=disp_float[0]/1000.0;
								disp_float[2]=disp_float[2]/1000.0;
								disp_float[3]=disp_float[3]/1000.0;
								array_lc[K]=K_ON;
							}
						 lc_glass_display(0, disp_float[0], 2, 5);
						 lc_glass_display(1, disp_float[2], 2, 5);
						 lc_glass_display(3, disp_float[3], 4, 5);
						 array_lc[ three_P3W]= three_P3W_ON;
				}
				else
				{
						if((disp_float[0]>=1000000.0)||(disp_float[1]>=1000000.0)||(disp_float[2]>=1000000.0)||(disp_float[3]>=1000000.0))
							{
							   disp_float[0]=disp_float[0]/1000000.0;
							   disp_float[1]=disp_float[1]/1000000.0;
							   disp_float[2]=disp_float[2]/1000000.0;
							   disp_float[3]=disp_float[3]/1000000.0;
								array_lc[M]=M_ON;
							}
						else if((disp_float[0]>=1000.0 && disp_float[0]<1000000.0)||(disp_float[1]>=1000.0 && disp_float[1]<1000000.0)||(disp_float[2]>=1000.0 && disp_float[2]<1000000.0)||(disp_float[3]>=1000.0 && disp_float[3]<1000000.0))
							{
								disp_float[0]=disp_float[0]/1000.0;
								disp_float[1]=disp_float[1]/1000.0;
								disp_float[2]=disp_float[2]/1000.0;
								disp_float[3]=disp_float[3]/1000.0;
								array_lc[K]=K_ON;
							}
								lc_glass_display(0, disp_float[0], 2, 5);
								lc_glass_display(1, disp_float[1], 2, 5);
								lc_glass_display(2, disp_float[2], 2, 5);
								lc_glass_display(3, disp_float[3], 4, 5);
								array_lc[V_3 ]=V_3_ON;
								array_lc[A_3]=A_3_ON;
				   }
								array_lc[V_1 ]=V_1_ON;
								array_lc[A_1]=A_1_ON;
								array_lc[V_2 ]=V_2_ON;
								array_lc[A_2]=A_2_ON;
								array_lc[V_4 ]=V_4_ON;
								array_lc[A_4]=A_4_ON;
								array_lc[Sum]=Sum_ON;
								array_lc[Line1]=Line1_ON;
								array_lc[Line2]=Line2_ON;
								array_lc[Line3]=Line3_ON;
								display_message1("PWR-S",NO_DP);
			break;

			case 31:    //Active Energy Import

						  k_unit_on = 0;
					   if(pm.p.system == PHASE_3P3W)
						{
								 if(uniterngy_act_import[3]>=1000000.0)
								  {
										 disp_float_eng[0]=(uniterngy_act_import[0]/1000000.0);
										 disp_float_eng[2]=(uniterngy_act_import[2]/1000000.0);
										 disp_float_eng[3]=(uniterngy_act_import[3]/1000000.0);
										 array_lc[G] = G_ON;
								 }
							  else if((uniterngy_act_import[3]>=1000.0) && (uniterngy_act_import[3]<1000000.0))
								{
								  disp_float_eng[0]=(uniterngy_act_import[0]/1000.0);
								  disp_float_eng[2]=(uniterngy_act_import[2]/1000.0);
								  disp_float_eng[3]=(uniterngy_act_import[3]/1000.0);
										 array_lc[M] = M_ON;
								}
							  else
							   {
								  disp_float_eng[0]=uniterngy_act_import[0];
								  disp_float_eng[2]=uniterngy_act_import[2];
								  disp_float_eng[3]=uniterngy_act_import[3];
										 array_lc[K] = K_ON;
										 k_unit_on = 1;
							   }
										 array_lc[three_P3W] =  three_P3W_ON;
						}
					   else
						{

							 if(uniterngy_act_import[3]>=1000000.0)
								 {
								 disp_float_eng[0]=(uniterngy_act_import[0]/1000000.0);
								 disp_float_eng[1]=(uniterngy_act_import[1]/1000000.0);
								 disp_float_eng[2]=(uniterngy_act_import[2]/1000000.0);
								 disp_float_eng[3]=(uniterngy_act_import[3]/1000000.0);
										 array_lc[G] = G_ON;
								 }
							else if((uniterngy_act_import[3]>=1000.0) && (uniterngy_act_import[3]<1000000.0))
								{
								disp_float_eng[0]=(uniterngy_act_import[0]/1000.0);
								disp_float_eng[1]=(uniterngy_act_import[1]/1000.0);
								disp_float_eng[2]=(uniterngy_act_import[2]/1000.0);
								disp_float_eng[3]=(uniterngy_act_import[3]/1000.0);
										 array_lc[M] = M_ON;
								}
							else
								{
								disp_float_eng[0]=uniterngy_act_import[0];
								disp_float_eng[1]=uniterngy_act_import[1];
								disp_float_eng[2]=uniterngy_act_import[2];
								disp_float_eng[3]=uniterngy_act_import[3];
										 array_lc[K] = K_ON;
										 k_unit_on = 1;
								}
							 array_lc[V_3]=V_3_ON;
							 array_lc[V1_3]=V1_3_ON;
							 array_lc[h_3]=h_3_ON;
						}

						for(i=0;i<4;i++)
						  {
							 if(pm.p.system == PHASE_3P3W)
							   {
								   if (i==1)
									   i=2;
							   }
							  if(i==3)
								  No_of_digit_disp = 9;
							  else
								  No_of_digit_disp = 7;

								  start_of_digit_disp = 0;

							  if(k_unit_on)
							  {
								   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
								   {
									   No_of_digit_disp = 6;

									   if(i==3)
										 start_of_digit_disp = 3;
									   else
										 start_of_digit_disp = 1;

								   }
								   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
								   {
										No_of_digit_disp = 7;
										start_of_digit_disp = 2;

								   }
								   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
								   {
										start_of_digit_disp = 1;
										No_of_digit_disp = 8;
								   }
							   }
								  if(pm.p.system == PHASE_3P3W)
								  {
									  if (i==2)
									lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									  else
									lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
								  }
								 else
								   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
							}

										array_lc[Imp]=Imp_ON;
										array_lc[Sum]=Sum_ON;
										array_lc[Line1]=Line1_ON;
										array_lc[Line2]=Line2_ON;
										array_lc[Line3]=Line3_ON;
										array_lc[V_1]=V_1_ON;
										array_lc[V1_1]=V1_1_ON;
										array_lc[V_2]=V_2_ON;
										array_lc[V1_2]=V1_2_ON;
										array_lc[V_4]=V_4_ON;
										array_lc[V1_4]=V1_4_ON;
										array_lc[h_1]=h_1_ON;
										array_lc[h_2]=h_2_ON;
										array_lc[h_4]=h_4_ON;
										display_message1(" I Wh",1);
					   break;

					case 32:  //Active Energy export

							k_unit_on = 0;
						 if(pm.p.system == PHASE_3P3W)
							{
								 if(uniterngy_act_export[3]>=1000000.0)
								 {
								 disp_float_eng[0]=(uniterngy_act_export[0]/1000000.0);
								 disp_float_eng[2]=(uniterngy_act_export[2]/1000000.0);
								 disp_float_eng[3]=(uniterngy_act_export[3]/1000000.0);
										 array_lc[G] = G_ON;
								 }
								else if((uniterngy_act_export[3]>=1000.0) && (uniterngy_act_export[3]<1000000.0))
								{
									disp_float_eng[0]=(uniterngy_act_export[0]/1000.0);
									disp_float_eng[2]=(uniterngy_act_export[2]/1000.0);
									disp_float_eng[3]=(uniterngy_act_export[3]/1000.0);

										 array_lc[M] = M_ON;
								}
							 else
							   {
								 disp_float_eng[0]=(uniterngy_act_export[0]);
								 disp_float_eng[2]=(uniterngy_act_export[2]);
								 disp_float_eng[3]=(uniterngy_act_export[3]);
											array_lc[K] = K_ON;
											k_unit_on = 1;
							   }
								array_lc[three_P3W] =  three_P3W_ON;

							}
						 else
						   {
							 if(uniterngy_act_export[3]>=1000000.0)
							 {
								 disp_float_eng[0]=(uniterngy_act_export[0]/1000000.0);
								 disp_float_eng[1]=(uniterngy_act_export[1]/1000000.0);
								 disp_float_eng[2]=(uniterngy_act_export[2]/1000000.0);
								 disp_float_eng[3]=(uniterngy_act_export[3]/1000000.0);
									 array_lc[G] = G_ON;
							 }
						else if((uniterngy_act_export[3]>=1000.0) && (uniterngy_act_export[3]<1000000.0))
							{
							disp_float_eng[0]=(uniterngy_act_export[0]/1000.0);
							disp_float_eng[1]=(uniterngy_act_export[1]/1000.0);
							disp_float_eng[2]=(uniterngy_act_export[2]/1000.0);
							disp_float_eng[3]=(uniterngy_act_export[3]/1000.0);
									 array_lc[M] = M_ON;
							}
						else
							{
							disp_float_eng[0]=(uniterngy_act_export[0]);
							disp_float_eng[1]=(uniterngy_act_export[1]);
							disp_float_eng[2]=(uniterngy_act_export[2]);
							disp_float_eng[3]=(uniterngy_act_export[3]);
									 array_lc[K] = K_ON;
									 k_unit_on = 1;
							}
							 array_lc[V_3]=V_3_ON;
							 array_lc[V1_3]=V1_3_ON;
							 array_lc[h_3]=h_3_ON;
					}

						 for(i=0;i<4;i++)
						  {
							 if(pm.p.system == PHASE_3P3W)
							   {
								   if (i==1)
									   i=2;
							   }
							  if(i==3)
								  No_of_digit_disp = 9;
							  else
								  No_of_digit_disp = 7;

								  start_of_digit_disp = 0;

							  if(k_unit_on)
							  {
								   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
								   {
									   No_of_digit_disp = 6;

									   if(i==3)
										 start_of_digit_disp = 3;
									   else
										 start_of_digit_disp = 1;

								   }
								   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
								   {
										No_of_digit_disp = 7;
										start_of_digit_disp = 2;

								   }
								   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
								   {
										start_of_digit_disp = 1;
										No_of_digit_disp = 8;
								   }
							   }
								  if(pm.p.system == PHASE_3P3W)
								  {
									  if (i==2)
									lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									  else
									lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
								  }
								 else
								   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
							}
										array_lc[Exp]=Exp_ON;
										array_lc[Sum]=Sum_ON;
										array_lc[Line1]=Line1_ON;
										array_lc[Line2]=Line2_ON;
										array_lc[Line3]=Line3_ON;
										array_lc[V_1]=V_1_ON;
										array_lc[V1_1]=V1_1_ON;
										array_lc[V_2]=V_2_ON;
										array_lc[V1_2]=V1_2_ON;
										array_lc[V_4]=V_4_ON;
										array_lc[V1_4]=V1_4_ON;
										array_lc[h_1]=h_1_ON;
										array_lc[h_2]=h_2_ON;
										array_lc[h_4]=h_4_ON;
										display_message1(" E Wh",1);
						break;

			case 33:  //Reactive Energy Import

							k_unit_on = 0;
						if(pm.p.system == PHASE_3P3W)
						{
							 if  (uniterngy_React_lag[3]>=1000000.0)
								{
									disp_float_eng[0]=uniterngy_React_lag[0]/1000000.0;
									disp_float_eng[2]=uniterngy_React_lag[2]/1000000.0;
									disp_float_eng[3]=uniterngy_React_lag[3]/1000000.0;
									 array_lc[G] = G_ON;
								}
							else if((uniterngy_React_lag[3]>=1000.0) && (uniterngy_React_lag[3]<1000000.0))
								{
								disp_float_eng[0]=uniterngy_React_lag[0]/1000.0;
								disp_float_eng[2]=uniterngy_React_lag[2]/1000.0;
								disp_float_eng[3]=uniterngy_React_lag[3]/1000.0;
									 array_lc[M] = M_ON;
								}
							 else
							   {
								 disp_float_eng[0]=uniterngy_React_lag[0];
								 disp_float_eng[2]=uniterngy_React_lag[2];
								 disp_float_eng[3]=uniterngy_React_lag[3];
									 array_lc[K] = K_ON;
									 k_unit_on=1;
							   }
								   array_lc[three_P3W] =  three_P3W_ON;
						}
						else
						{
								 if(uniterngy_React_lag[3]>=1000000.0)
									{
									 disp_float_eng[0]=uniterngy_React_lag[0]/1000000.0;
									 disp_float_eng[1]=uniterngy_React_lag[1]/1000000.0;
									 disp_float_eng[2]=uniterngy_React_lag[2]/1000000.0;
									 disp_float_eng[3]=uniterngy_React_lag[3]/1000000.0;
											 array_lc[G] = G_ON;
									}
						   else if((uniterngy_React_lag[3]>=1000.0) && (uniterngy_React_lag[3]<1000000.0))
									{
								   disp_float_eng[0]=uniterngy_React_lag[0]/1000.0;
								   disp_float_eng[1]=uniterngy_React_lag[1]/1000.0;
								   disp_float_eng[2]=uniterngy_React_lag[2]/1000.0;
								   disp_float_eng[3]=uniterngy_React_lag[3]/1000.0;
											 array_lc[M] = M_ON;
									}
								 else
								   {
									 disp_float_eng[0]=uniterngy_React_lag[0];
									 disp_float_eng[1]=uniterngy_React_lag[1];
									 disp_float_eng[2]=uniterngy_React_lag[2];
									 disp_float_eng[3]=uniterngy_React_lag[3];
											 array_lc[K] = K_ON;
												 k_unit_on=1;
								   }
								 array_lc[V_3 ]=V_3_ON;
								 array_lc[A_3]=A_3_ON;
								 array_lc[r_3]=r_3_ON;
								 array_lc[h_3]=h_3_ON;
							 }

						   for(i=0;i<4;i++)
							  {
								 if(pm.p.system == PHASE_3P3W)
								   {
									   if (i==1)
										   i=2;
								   }
								  if(i==3)
									  No_of_digit_disp = 9;
								  else
									  No_of_digit_disp = 7;

									  start_of_digit_disp = 0;

								  if(k_unit_on)
								  {
									   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
									   {
										   No_of_digit_disp = 6;

										   if(i==3)
											 start_of_digit_disp = 3;
										   else
											 start_of_digit_disp = 1;

									   }
									   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
									   {
											No_of_digit_disp = 7;
											start_of_digit_disp = 2;

									   }
									   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
									   {
											start_of_digit_disp = 1;
											No_of_digit_disp = 8;
									   }
								   }
									  if(pm.p.system == PHASE_3P3W)
									  {
										  if (i==2)
										lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
										  else
										lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									  }
									 else
									   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
								}

								 array_lc[V_1 ]=V_1_ON;			//VArh
								 array_lc[A_1]=A_1_ON;
								 array_lc[r_1]=r_1_ON;
								 array_lc[h_1]=h_1_ON;
								 array_lc[V_2 ]=V_2_ON;
								 array_lc[A_2]=A_2_ON;
								 array_lc[r_2]=r_2_ON;
								 array_lc[h_2]=h_2_ON;
								 array_lc[V_4 ]=V_4_ON;
								 array_lc[A_4]=A_4_ON;
								 array_lc[r_4]=r_4_ON;
								 array_lc[h_4]=h_4_ON;
								 array_lc[Imp]=Imp_ON;
								 array_lc[Sum]=Sum_ON;
								 array_lc[Line1]=Line1_ON;
								 array_lc[Line2]=Line2_ON;
								 array_lc[Line3]=Line3_ON;
								 display_message1("IVARh",0);

						break;

						case 34:   //Reactive Energy export

								k_unit_on = 0;
							 if(pm.p.system == PHASE_3P3W)
							 {
									   if(uniterngy_React_lead[3]>=1000000.0)
									{
										disp_float_eng[0]=uniterngy_React_lead[0]/1000000.0;
										disp_float_eng[2]=uniterngy_React_lead[2]/1000000.0;
										disp_float_eng[3]=uniterngy_React_lead[3]/1000000.0;
											array_lc[G] = G_ON;
									}
								 else if((uniterngy_React_lead[3]>=1000.0) && (uniterngy_React_lead[3]<1000000.0))
									{
									 disp_float_eng[0]=uniterngy_React_lead[0]/1000.0;
									 disp_float_eng[2]=uniterngy_React_lead[2]/1000.0;
									 disp_float_eng[3]=uniterngy_React_lead[3]/1000.0;
										   array_lc[M] = M_ON;
									}
								 else
								   {
									 disp_float_eng[0]=uniterngy_React_lead[0];
									 disp_float_eng[2]=uniterngy_React_lead[2];
									 disp_float_eng[3]=uniterngy_React_lead[3];
											   array_lc[K] = K_ON;
											   k_unit_on=1;
								   }
								  array_lc[three_P3W] =  three_P3W_ON;
							 }
						 else
							 {
									if(uniterngy_React_lead[3]>=1000000.0)
									{
										disp_float_eng[0]=uniterngy_React_lead[0]/1000000.0;
										disp_float_eng[1]=uniterngy_React_lead[1]/1000000.0;
										disp_float_eng[2]=uniterngy_React_lead[2]/1000000.0;
										disp_float_eng[3]=uniterngy_React_lead[3]/1000000.0;
												 array_lc[G] = G_ON;
									}
								 else if(uniterngy_React_lead[3]>=1000.0 && uniterngy_React_lead[3]<1000000.0)
									 {
									 disp_float_eng[0]=uniterngy_React_lead[0]/1000.0;
									 disp_float_eng[1]=uniterngy_React_lead[1]/1000.0;
									 disp_float_eng[2]=uniterngy_React_lead[2]/1000.0;
									 disp_float_eng[3]=uniterngy_React_lead[3]/1000.0;
												 array_lc[M] = M_ON;
									}
								 else
								   {
									 disp_float_eng[0]=uniterngy_React_lead[0];
									 disp_float_eng[1]=uniterngy_React_lead[1];
									 disp_float_eng[2]=uniterngy_React_lead[2];
									 disp_float_eng[3]=uniterngy_React_lead[3];
												array_lc[K] = K_ON;
													 k_unit_on=1;
								   }
									array_lc[V_3 ]=V_3_ON;
									 array_lc[A_3]=A_3_ON;
									 array_lc[r_3]=r_3_ON;
									 array_lc[h_3]=h_3_ON;
							}

								for(i=0;i<4;i++)
								  {
									 if(pm.p.system == PHASE_3P3W)
									   {
										   if (i==1)
											   i=2;
									   }
									  if(i==3)
										  No_of_digit_disp = 9;
									  else
										  No_of_digit_disp = 7;

										  start_of_digit_disp = 0;

									  if(k_unit_on)
									  {
										   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
										   {
											   No_of_digit_disp = 6;

											   if(i==3)
												 start_of_digit_disp = 3;
											   else
												 start_of_digit_disp = 1;

										   }
										   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
										   {
												No_of_digit_disp = 7;
												start_of_digit_disp = 2;

										   }
										   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
										   {
												start_of_digit_disp = 1;
												No_of_digit_disp = 8;
										   }
									   }
										  if(pm.p.system == PHASE_3P3W)
										  {
											  if (i==2)
											lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
											  else
											lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
										  }
										 else
										   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									}
									 array_lc[V_1 ]=V_1_ON;			//VArh
									 array_lc[A_1]=A_1_ON;
									 array_lc[r_1]=r_1_ON;
									 array_lc[h_1]=h_1_ON;
									 array_lc[V_2 ]=V_2_ON;
									 array_lc[A_2]=A_2_ON;
									 array_lc[r_2]=r_2_ON;
									 array_lc[h_2]=h_2_ON;
									 array_lc[V_4 ]=V_4_ON;
									 array_lc[A_4]=A_4_ON;
									 array_lc[r_4]=r_4_ON;
									 array_lc[h_4]=h_4_ON;
									 array_lc[Exp]=Exp_ON;
									 array_lc[Sum]=Sum_ON;
									 array_lc[Line1]=Line1_ON;
									 array_lc[Line2]=Line2_ON;
									 array_lc[Line3]=Line3_ON;
									 display_message1("EVARh",0);
						break;

						case 41:	//Apparent Energy

								k_unit_on=0;
								if(pm.p.system == PHASE_3P3W)
								{
									 if(uniterngy_apparent[3]>=1000000.0)
										{
											 disp_float_eng[0]=uniterngy_apparent[0]/1000000.0;
											 disp_float_eng[2]=uniterngy_apparent[2]/1000000.0;
											 disp_float_eng[3]=uniterngy_apparent[3]/1000000.0;
													 array_lc[G] = G_ON;
										}
									 else if((uniterngy_apparent[3]>=1000.0) && (uniterngy_apparent[3]<1000000.0))
										{
										 disp_float_eng[0]=uniterngy_apparent[0]/1000.0;
										 disp_float_eng[2]=uniterngy_apparent[2]/1000.0;
										 disp_float_eng[3]=uniterngy_apparent[3]/1000.0;
													 array_lc[M] = M_ON;
										}
									 else
									   {
										 disp_float_eng[0]=uniterngy_apparent[0];
										 disp_float_eng[2]=uniterngy_apparent[2];
										 disp_float_eng[3]=uniterngy_apparent[3];
													array_lc[K] = K_ON;
														 k_unit_on=1;
									   }
												   array_lc[three_P3W] =  three_P3W_ON;
								}
							else
								{
								 if(uniterngy_apparent[3]>=1000000.0)
									{
									 disp_float_eng[0]=uniterngy_apparent[0]/1000000.0;
									 disp_float_eng[1]=uniterngy_apparent[1]/1000000.0;
									 disp_float_eng[2]=uniterngy_apparent[2]/1000000.0;
									 disp_float_eng[3]=uniterngy_apparent[3]/1000000.0;
													array_lc[G] = G_ON;
									}
								 else if((uniterngy_apparent[3]>=1000.0) && (uniterngy_apparent[3]<1000000.0))
									{
									 disp_float_eng[0]=uniterngy_apparent[0]/1000.0;
									 disp_float_eng[1]=uniterngy_apparent[1]/1000.0;
									 disp_float_eng[2]=uniterngy_apparent[2]/1000.0;
									 disp_float_eng[3]=uniterngy_apparent[3]/1000.0;
													array_lc[M] = M_ON;
									}
								 else
								   {
									 disp_float_eng[0]=uniterngy_apparent[0];
									 disp_float_eng[1]=uniterngy_apparent[1];
									 disp_float_eng[2]=uniterngy_apparent[2];
									 disp_float_eng[3]=uniterngy_apparent[3];
													array_lc[K] = K_ON;
													   k_unit_on=1;
								   }
								 array_lc[V_3 ]=V_3_ON;
								 array_lc[A_3]=A_3_ON;
								 array_lc[h_3]=h_3_ON;
								}
								 for(i=0;i<4;i++)
								  {
									 if(pm.p.system == PHASE_3P3W)
									   {
										   if (i==1)
											   i=2;
									   }
									  if(i==3)
										  No_of_digit_disp = 9;
									  else
										  No_of_digit_disp = 7;

										  start_of_digit_disp = 0;

									  if(k_unit_on)
									  {
										   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
										   {
											   No_of_digit_disp = 6;

											   if(i==3)
												 start_of_digit_disp = 3;
											   else
												 start_of_digit_disp = 1;

										   }
										   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
										   {
												No_of_digit_disp = 7;
												start_of_digit_disp = 2;

										   }
										   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
										   {
												start_of_digit_disp = 1;
												No_of_digit_disp = 8;
										   }
									   }
										  if(pm.p.system == PHASE_3P3W)
										  {
											  if (i==2)
											lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
											  else
											lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
										  }
										 else
										   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									}
									 array_lc[V_1 ]=V_1_ON;			//VArh
									 array_lc[A_1]=A_1_ON;
									 array_lc[h_1]=h_1_ON;
									 array_lc[V_2 ]=V_2_ON;
									 array_lc[A_2]=A_2_ON;
									 array_lc[h_2]=h_2_ON;
									 array_lc[V_4 ]=V_4_ON;
									 array_lc[A_4]=A_4_ON;
									 array_lc[h_4]=h_4_ON;
									 array_lc[Sum]=Sum_ON;
									 array_lc[Line1]=Line1_ON;
									 array_lc[Line2]=Line2_ON;
									 array_lc[Line3]=Line3_ON;
									 display_message1("  VAh",NO_DP);

						break;

						case 42:     //Energy Overflow count
									display_message1(" E-OF",NO_DP);
									disp[0]='I';
									decimal_to_array(whi_ovcnt, 2, &disp[1]);
									disp[3]=' ';
									disp[4]='E';
									decimal_to_array(whe_ovcnt, 2, &disp[5]);
									LCD_char_line(0,&disp[0],0, 7, 0);

									disp[0]='I';
									decimal_to_array(vari_ovcnt, 2, &disp[1]);
									disp[3]=' ';
									disp[4]='E';
									decimal_to_array(vare_ovcnt, 2, &disp[5]);
									LCD_char_line(1,&disp[0],0, 7, 0);

									for(i=0;i<5;i++)
									  disp[i]=' ';
									decimal_to_array(va_ovcnt, 2, &disp[5]);
									LCD_char_line(2,&disp[0],0, 7, 9);

									 array_lc[D31P] = D31P_ON;
									 array_lc[V_1]=V_1_ON;
									 array_lc[h_1]=h_1_ON;
									 array_lc[V1_1]=V1_1_ON;
									 array_lc[V_2 ]=V_2_ON;
									 array_lc[A_2]=A_2_ON;
									 array_lc[r_2]=r_2_ON;
									 array_lc[h_2]=h_2_ON;
									 array_lc[V_3]=V_3_ON;
									 array_lc[A_3]=A_3_ON;
									 array_lc[h_3]=h_3_ON;
									 array_lc[D28P] = D28P_ON;
									 array_lc[D21P] = D21P_ON;
						 break;

			case 43:   // Import / Export run Hour
									display_message1(" HOUR",NO_DP);
									LCD_char_line(0, "I RUN", 0, 5, 0);
									LCD_char_line(2, "E RUN", 0, 5, 0);

									decimal_to_array(LOAD_IMP.HOUR.hour, 5, &disp[0]);
									decimal_to_array(LOAD_IMP.HOUR.min, 2, &disp[5]);
									LCD_char_line(1,&disp[0],0, 7, 4);

									decimal_to_array(LOAD_EXP.HOUR.hour,5, &disp[0]);
									decimal_to_array(LOAD_EXP.HOUR.min, 2, &disp[5]);
									LCD_char_line(3,&disp[0],2, 7, 4);
						break;

			case 44:    //ON / LOAD Hour
									display_message1(" HOUR",NO_DP);
									LCD_char_line(0, "ON", 0, 2, NO_DP);
									LCD_char_line(2, "TOT RUN", 0, 7, 2);

									decimal_to_array(ON.HOUR.hour, 5, &disp[0]);
									decimal_to_array(ON.HOUR.min, 2, &disp[5]);
									LCD_char_line(1,&disp[0],0, 7, 4);

									decimal_to_array(LOAD.HOUR.hour,5, &disp[0]);
									decimal_to_array(LOAD.HOUR.min, 2, &disp[5]);
									LCD_char_line(3,&disp[0],2, 7, 4);
							break;

				case 51:	//Voltage & Current unbalance
									display_message1("UNBAL",4);
									disp_float[0]=fp.en.Volt_Unbalance;
									disp_float[2]=fp.en.Current_Unbalance;
									lc_glass_display(0,disp_float[0], 3, 4);
									lc_glass_display(2,disp_float[2], 3, 4);
									LCD_char_line(0, "V", 1, 1, 0);
									LCD_char_line(2, "I", 1, 1, 0);
									array_lc[PERCENTAGE]=PERCENTAGE_ON;
									array_lc[V_1]=V_1_ON;
									array_lc[A_3]=A_3_ON;

							break;

				case 52:   //power interruption count
									display_message1("PINTR",0);
									LCD_char_line(0, "COUNT", 1, 5, NO_DP);
									decimal_to_array(P_intr, 5, &disp[0]);
									LCD_char_line(2,&disp[0],1, 5, NO_DP);
						   break;

				case 53:    //CTR , CT Secondary / PTR , PT Secondary
									display_message1("CTPTR",1);
									temp_int4 = (unsigned int)(pm.p.ctr/1000);
									temp_int5=(unsigned int)(pm.p.ctr - (temp_int4 * 1000));
									decimal_to_array(temp_int4, 4, &disp[0]);
									decimal_to_array(temp_int5, 3, &disp[4]);
									LCD_char_line(0,&disp[0],0, 7, 3);

									LCD_char_line(1, "CTSEC-", 0, 6, 1);
									decimal_to_array(pm.p.Irated, 1, &disp[0]);
									LCD_char_line(1,&disp[0],6, 1, NO_DP);

									temp_int4 = (unsigned int)(pm.p.ptr/1000);
									temp_int5=(unsigned int)(pm.p.ptr - (temp_int4 * 1000));
									decimal_to_array(temp_int4, 4, &disp[0]);
									decimal_to_array(temp_int5, 3, &disp[4]);
									LCD_char_line(2,&disp[0],0, 7, 3);

									LCD_char_line(3, "PTSEC-", 0, 6, 1);
									decimal_to_array(pm.p.Vrated,3, &disp[0]);
									LCD_char_line(3,&disp[0],6, 3, NO_DP);

									array_lc[D31P] = D31P_ON;
									array_lc[D32P] = D32P_ON;
									//array_lc[A_1] = A_1_ON ;
									array_lc[A_2] = A_2_ON ;
									//array_lc[V_3]=V_3_ON;
									array_lc[V_4]=V_4_ON;
						break;

					case 54:	//pulse o/p,S-ID,BAUD
							display_message1(" COMM",4);
							LCD_char_line(0, "PLSOP-", 0, 6, 2);
							decimal_to_array(pm.p.plsconstant, 5, &disp[0]);
							LCD_char_line(1,&disp[0],2, 5, NO_DP);
							decimal_to_array(pm.p.power, 1, &disp[0]);
							LCD_char_line(0,&disp[0],6, 1, NO_DP);

							LCD_char_line(2, "SID-", 0, 4, 0);
							decimal_to_array(pm.p.SLAVE_ADDRESS,3, &disp[0]);
							LCD_char_line(2,&disp[0],4, 3, NO_DP);

							//LCD_char_line(3, "BAUD", 0, 4, 3);
							if(pm.p.baud == 9600)
							{
							   decimal_to_array(pm.p.baud,4, &disp[0]);
							   LCD_char_line(3,&disp[0],1, 4, NO_DP);
							}
							else
							{
								decimal_to_array(pm.p.baud,5, &disp[0]);
								LCD_char_line(3,&disp[0],0, 5, NO_DP);
							}
							switch(pm.p.parity)
							{
								case 0: LCD_char_line(3, "-N", 5, 2, NO_DP);
								break;
								case 1: LCD_char_line(3, "-O", 5, 2, NO_DP);
								break;
								case 2: LCD_char_line(3, "-E", 5, 2, NO_DP);
								break;
								default: LCD_char_line(3, "-N", 5, 2, NO_DP);
								break;
							}
							switch(pm.p.stop_bit)
							{

								case 1: LCD_char_line(3, "-1", 7, 2, NO_DP);
								break;
								case 2: LCD_char_line(3, "-2", 7, 2, NO_DP);
								break;
								default: LCD_char_line(3, "-1", 7, 2, NO_DP);
								break;
							}

						break;
				 #ifdef FFT
				case 61:    // THD for Voltage
							display_message1(" VTHD",1);
							disp_float[0]=fft[0][8];
							disp_float[1]=fft[1][8];
							disp_float[2]=fft[2][8];
							lc_glass_display(0,disp_float[0], 3, 4);
							if(pm.p.system == PHASE_3P4W)
							  {
								  lc_glass_display(1,disp_float[1], 3, 4);
							  }
							 lc_glass_display(2,disp_float[2], 3, 4);
							 array_lc[Line1]=Line1_ON;
							 array_lc[Line2]=Line2_ON;
							 array_lc[Line3]=Line3_ON;
							 array_lc[PERCENTAGE]=PERCENTAGE_ON;
						break;

				 case 62:    // THD for Current
							disp_float[0]=fft[3][8];
							disp_float[1]=fft[4][8];
							disp_float[2]=fft[5][8];
							lc_glass_display(0,disp_float[0], 3, 4);
							if(pm.p.system == PHASE_3P4W)
								{
								  lc_glass_display(1,disp_float[1], 3, 4);
								}
							lc_glass_display(2,disp_float[2], 3, 4);
							array_lc[Line1]=Line1_ON;
							array_lc[Line2]=Line2_ON;
							array_lc[Line3]=Line3_ON;
							array_lc[PERCENTAGE]=PERCENTAGE_ON;
							 display_message1(" ITHD",1);
						break;
				  #endif

				 #ifdef RTC_CALENDAR
				  case 63:	// Rising Demand & Real time,Date
								  display_message1(" RDMD",1);
									if(pm.p.demand_type)
									{
										array_lc[V_1]=V_1_ON;
										array_lc[A_1]=A_1_ON;
									}
									else
									{
										array_lc[V_1]=V_1_ON;
										array_lc[V1_1]=V1_1_ON;
									}
								  if(fp.en.Rising_Demand>=1000000.0)
									{
										disp_float[0]=fp.en.Rising_Demand/1000000.0;
										array_lc[G]=G_ON;
									}
								  else if(fp.en.Rising_Demand>=1000.0)
									{
										disp_float[0]=fp.en.Rising_Demand/1000.0;
										array_lc[M]=M_ON;
									}
								  else
									{
									  disp_float[0]= fp.en.Rising_Demand;
										array_lc[K]=K_ON;;
									}
								  lc_glass_display(0,disp_float[0], 0, 7);

								decimal_to_array(Hour, 2, &disp[0]);
								decimal_to_array(Min, 2, &disp[2]);
								decimal_to_array(Sec, 2, &disp[4]);
								LCD_char_line(2,&disp[0],0, 6, NO_DP);

								disp[2]='-';
								disp[5]='-';
								decimal_to_array(Date, 2, &disp[0]);
								decimal_to_array(Month, 2, &disp[3]);
								decimal_to_array(Year, 2, &disp[6]);
								LCD_char_line(3,&disp[0],0, 8, NO_DP);

								array_lc[D9P]=D9P_ON;
								array_lc[D11P]=D11P_ON;
								array_lc[D13P]=D13P_ON;
								array_lc[D16P]=D16P_ON;
								decimal_to_array(pm.p.Int_time, 2, &disp[0]);
								if(pm.p.Dem_method == 0)
								{
								  LCD_char_line(1, "BL-", 0, 3, NO_DP);  //bloc
								  LCD_char_line(1,&disp[0],3, 2, NO_DP);
								}
							  else
								{
								  LCD_char_line(1, "SL-", 0, 3, NO_DP); //slide
								  decimal_to_array(pm.p.Sub_int_time, 2, &disp[2]);
								  LCD_char_line(1,&disp[0],3, 4, 1);
								}
								array_lc[time]=time_ON;
						break;

				   case 64:    // Maximum Demand & Time,Date

							   if(pm.p.demand_type)
							   {
								   array_lc[V_1]=V_1_ON;
								   array_lc[A_1]=A_1_ON;
							   }
							 else
							   {
								   array_lc[V_1]=V_1_ON;
								   array_lc[V1_1]=V1_1_ON;
							   }

							   if(fp.en.Max_Demand>=1000000.0)
								{
								   disp_float[0]=fp.en.Max_Demand/1000000.0;
								   array_lc[G]=G_ON;
								}
							   else if(fp.en.Max_Demand>=1000.0)
								{
								   disp_float[0]=fp.en.Max_Demand/1000.0;
								   array_lc[M]=M_ON;
								}
							   else
								{
								   disp_float[0]=fp.en.Max_Demand;
								   array_lc[K]=K_ON;
								}
							    lc_glass_display(0,disp_float[0], 0, 7);

								decimal_to_array(MD.Date_Time.hour, 2, &disp[0]);
								decimal_to_array(MD.Date_Time.min, 2, &disp[2]);
								//decimal_to_array(MD.Date_Time.sec, 2, &disp[4]);
								LCD_char_line(2,&disp[0],0, 4, NO_DP);

								disp[2]='-';
								disp[5]='-';
								decimal_to_array(MD.Date_Time.date, 2, &disp[0]);
								decimal_to_array(MD.Date_Time.month, 2, &disp[3]);
								decimal_to_array(MD.Date_Time.year, 2, &disp[6]);
								LCD_char_line(3,&disp[0],0, 8, NO_DP);

								array_lc[D9P]=D9P_ON;
								array_lc[D11P]=D11P_ON;
								//array_lc[D13P]=D13P_ON;
								//array_lc[D16P]=D16P_ON;
								display_message1(" MDMD",1);
					break;

				   case 71:    //Day Import Energy (Wh & Varh)

						  k_unit_on = 0;

							 if((day_act_imp >= 1000000.0) || (day_React_lag >= 1000000.0))
								 {
									 disp_float_eng[0]=(double)((double)day_act_imp/1000000.0);
									 disp_float_eng[1]=(double)((double)day_React_lag/1000000.0);
											 array_lc[G] = G_ON;
								 }
							else if(((day_act_imp>=1000.0) && (day_act_imp<1000000.0)) || ((day_React_lag>=1000.0) && (day_React_lag<1000000.0)))
								{
									disp_float_eng[0]=(double)((double)day_act_imp/1000.0);
									disp_float_eng[1]=(double)((double)day_React_lag/1000.0);
										 array_lc[M] = M_ON;
								}
							else
								{
									disp_float_eng[0]=(double)day_act_imp;
									disp_float_eng[1]=(double)day_React_lag;
										 array_lc[K] = K_ON;
										 k_unit_on = 1;
								}

						for(i=0;i<2;i++)
						  {
//							 if(pm.p.system == PHASE_3P3W)
//							   {
//								   if (i==1)
//									   i=2;
//							   }
							  if(i==3)
								  No_of_digit_disp = 9;
							  else
								  No_of_digit_disp = 7;

								  start_of_digit_disp = 0;

							  if(k_unit_on)
							  {
								   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
								   {
									   No_of_digit_disp = 6;

									   if(i==3)
										 start_of_digit_disp = 3;
									   else
										 start_of_digit_disp = 1;

								   }
								   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
								   {
										No_of_digit_disp = 7;
										start_of_digit_disp = 2;

								   }
								   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
								   {
										start_of_digit_disp = 1;
										No_of_digit_disp = 8;
								   }
							   }
//								  if(pm.p.system == PHASE_3P3W)
//								  {
//									  if (i==2)
//									lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
//									  else
//									lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
//								  }
//								 else
								   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
							}

										array_lc[Imp]=Imp_ON;
										array_lc[Sum]=Sum_ON;

										array_lc[V_1]=V_1_ON;
										array_lc[V1_1]=V1_1_ON;
										array_lc[h_1]=h_1_ON;

										array_lc[V_2]=V_2_ON;
										array_lc[A_2]=A_2_ON;
										array_lc[r_2]=r_2_ON;
										array_lc[h_2]=h_2_ON;

										display_message1(" IMP ",NO_DP);
										LCD_char_line(3, "DAYENERGY", 0, 9, 2);
					   break;

				   case 72:    //Day Export Energy (Wh & Varh)

							  k_unit_on = 0;

								 if((day_act_exp >= 1000000.0) || (day_React_lead >= 1000000.0))
									 {
										 disp_float_eng[0]=(double)((double)day_act_exp/1000000.0);
										 disp_float_eng[1]=(double)((double)day_React_lead/1000000.0);
												 array_lc[G] = G_ON;
									 }
								else if(((day_act_exp>=1000.0) && (day_act_exp<1000000.0)) || ((day_React_lead>=1000.0) && (day_React_lead<1000000.0)))
									{
										disp_float_eng[0]=(double)((double)day_act_exp/1000.0);
										disp_float_eng[1]=(double)((double)day_React_lead/1000.0);
											 array_lc[M] = M_ON;
									}
								else
									{
										disp_float_eng[0]=(double)day_act_exp;
										disp_float_eng[1]=(double)day_React_lead;
											 array_lc[K] = K_ON;
											 k_unit_on = 1;
									}

							for(i=0;i<2;i++)
							  {
	   //							 if(pm.p.system == PHASE_3P3W)
	   //							   {
	   //								   if (i==1)
	   //									   i=2;
	   //							   }
								  if(i==3)
									  No_of_digit_disp = 9;
								  else
									  No_of_digit_disp = 7;

									  start_of_digit_disp = 0;

								  if(k_unit_on)
								  {
									   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
									   {
										   No_of_digit_disp = 6;

										   if(i==3)
											 start_of_digit_disp = 3;
										   else
											 start_of_digit_disp = 1;

									   }
									   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
									   {
											No_of_digit_disp = 7;
											start_of_digit_disp = 2;

									   }
									   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
									   {
											start_of_digit_disp = 1;
											No_of_digit_disp = 8;
									   }
								   }
	   //								  if(pm.p.system == PHASE_3P3W)
	   //								  {
	   //									  if (i==2)
	   //									lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
	   //									  else
	   //									lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
	   //								  }
	   //								 else
									   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
								}

							                array_lc[Exp]=Exp_ON;
											array_lc[Sum]=Sum_ON;

											array_lc[V_1]=V_1_ON;
											array_lc[V1_1]=V1_1_ON;
											array_lc[h_1]=h_1_ON;

											array_lc[V_2]=V_2_ON;
											array_lc[A_2]=A_2_ON;
											array_lc[r_2]=r_2_ON;
											array_lc[h_2]=h_2_ON;

											display_message1(" EXP ",NO_DP);
											LCD_char_line(3, "DAYENERGY", 0, 9, 2);
						   break;

				   case 73:	//Apparent Energy

								k_unit_on=0;

								 if(day_apparent>=1000000.0)
									{
									 disp_float_eng[0]=(double)((double)day_apparent/1000000.0);
													array_lc[G] = G_ON;
									}
								 else if((day_apparent>=1000.0) && (day_apparent<1000000.0))
									{
									 disp_float_eng[0]=(double)((double)day_apparent/1000.0);
													array_lc[M] = M_ON;
									}
								 else
								   {
									 disp_float_eng[0]=(double)day_apparent;
													array_lc[K] = K_ON;
													   k_unit_on=1;
								   }
\

								 for(i=0;i<1;i++)
								  {
//									 if(pm.p.system == PHASE_3P3W)
//									   {
//										   if (i==1)
//											   i=2;
//									   }
									  if(i==3)
										  No_of_digit_disp = 9;
									  else
										  No_of_digit_disp = 7;

										  start_of_digit_disp = 0;

									  if(k_unit_on)
									  {
										   if((disp_float_eng[i]>=0)&&(disp_float_eng[i]<10))
										   {
											   No_of_digit_disp = 6;

											   if(i==3)
												 start_of_digit_disp = 3;
											   else
												 start_of_digit_disp = 1;

										   }
										   else if((disp_float_eng[i]>=10)&&(disp_float_eng[i]<100)&&(i==3))
										   {
												No_of_digit_disp = 7;
												start_of_digit_disp = 2;

										   }
										   else if((disp_float_eng[i]>=100)&&(disp_float_eng[i]<1000)&&(i==3))
										   {
												start_of_digit_disp = 1;
												No_of_digit_disp = 8;
										   }
									   }
//										  if(pm.p.system == PHASE_3P3W)
//										  {
//											  if (i==2)
//											lc_glass_display(i-1, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
//											  else
//											lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
//										  }
//										 else
										   lc_glass_display(i, disp_float_eng[i], start_of_digit_disp, No_of_digit_disp);
									}
									 array_lc[V_1 ]=V_1_ON;			//VAh
									 array_lc[A_1]=A_1_ON;
									 array_lc[h_1]=h_1_ON;

									 array_lc[Sum]=Sum_ON;

									 display_message1("  VAh",NO_DP);
									LCD_char_line(3, "DAYENERGY", 0, 9, 2);

						break;


				  #endif

				  default:

				  break;
			}

		if(b.freez)
		{

			  Manualscroll_led_on();

			if((NXT) && (sec_2))
			{
				NXT=0;
				run_para=11;
				sec_2=0;
			}
			if((NXT) && (sec_2==0))
			{
				NXT=0;
				fav_ret_page_time_cnt = 0;
				run_para = run_para + 1;

				if(run_para == 15)	run_para = 11;
				if(pm.p.system == PHASE_3P3W)
				{
					if(run_para == 25)	run_para = 22;
				}
				else
				{
					if(run_para == 25)	run_para = 21;
				}
				if(run_para == 35)	run_para = 31;
				if(run_para == 45)  run_para = 41;
				if(run_para == 55)  run_para = 51;
				if(run_para == 65)  run_para = 61;
				if(run_para == 74)  run_para = 71;
				#ifndef FFT
					if(run_para == 61 || run_para == 62 )  run_para = 63;
				#endif
				#ifndef RTC_CALENDAR
					if(run_para == 63)  run_para = 61;
				#endif

			}

			if(DN)
			{
				DEC=0;
				fav_ret_page_time_cnt = 0;
				run_para = run_para + 10;

				#ifdef RTC_CALENDAR
					#ifdef FFT                                                     //14
				        if(run_para == 81)   run_para = 11;
						if(run_para == 82)   run_para = 12;
						if(run_para == 83)   run_para = 13;
						if(run_para == 74)   run_para = 14;
					#else
						if(run_para == 81)   run_para = 11;
						if(run_para == 61)   run_para = 71;
						if(run_para == 82)   run_para = 12;
						if(run_para == 62)   run_para = 72;
						if(run_para == 83)   run_para = 13;
						if(run_para == 74)   run_para = 14;
					#endif
				#else
					#ifdef FFT
						if(run_para == 71)   run_para = 11;
						if(run_para == 72)   run_para = 12;
						if(run_para == 63)   run_para = 13;
						if(run_para == 64)   run_para = 14;
					#else
						if(run_para == 61)   run_para = 11;
						if(run_para == 62)   run_para = 12;
						if(run_para == 63)   run_para = 13;
						if(run_para == 64)   run_para = 14;
					#endif
				#endif

				if(pm.p.system == PHASE_3P3W)
				{
					if(run_para == 21)	run_para = 31;
				}
			}
			if(UP)
			{
				INC=0;
				fav_ret_page_time_cnt = 0;
				run_para = run_para - 10;

			    #ifdef RTC_CALENDAR
					#ifdef FFT                                                     //14
				        if(run_para == 1)   run_para = 71;
						if(run_para == 2)   run_para = 72;
						if(run_para == 3)   run_para = 73;
						if(run_para == 4)   run_para = 64;
					#else
						if(run_para == 1)   run_para = 71;
						if(run_para == 61)   run_para = 51;
						if(run_para == 2)   run_para = 72;
						if(run_para == 62)   run_para = 52;
						if(run_para == 3)   run_para = 73;
						if(run_para == 4)   run_para = 64;
					#endif
				#else
					#ifdef FFT
						if(run_para == 1)   run_para = 61;
						if(run_para == 2)   run_para = 62;
						if(run_para == 3)   run_para = 53;
						if(run_para == 4)   run_para = 54;
					#else
						if(run_para == 1)   run_para = 51;
						if(run_para == 2)   run_para = 52;
						if(run_para == 3)   run_para = 53;
						if(run_para == 4)   run_para = 54;
					#endif
				#endif

					if(pm.p.system == PHASE_3P3W)
					{
						if(run_para == 21)	run_para = 11;
					}
			}
			if(Auto_ret)
			{
				 if(fav_ret_page_time_cnt >= FAV_RET_PAGE_TIME)
				  {
					    b.freez = 0;
					    Auto_ret = 0;
						fav_ret_page_time_cnt = 0;
				  }
			}
			else
			{
				if(fav_ret_page_time_cnt >= FAV_RET_PAGE_TIME)
				 {
					run_para = freez_page;
					fav_ret_page_time_cnt = 0;
				 }
			}
		}
		else
		{

			 Manualscroll_led_off();
			if((NXT)||(UP)||(DN))
			{
				DEC=0;NXT=0;INC=0;
				b.freez = 1;
                Auto_ret = 1;
			}
		 if(scroll >= SCROLL_TIME)
			{
				scroll = 0;
				//b.disp = 1;
				run_para++;
				if(pm.p.system == PHASE_3P3W)
				{
				   if(run_para == 15)	run_para = 22;
				}
				else
				{
				   if(run_para == 15)	run_para = 21;
				}
				if(run_para == 25)	run_para = 31;
				if(run_para == 35)	run_para = 41;
				if(run_para == 45)	run_para = 51;
                #ifdef FFT
				     if(run_para == 55)	run_para = 61;
				#else
				     if(run_para == 55)	run_para = 63;
			    #endif

				#ifdef RTC_CALENDAR
				     if(run_para == 65)	run_para = 71;
				     if(run_para == 74)	run_para = 11;
				#else
				     if(run_para == 63)	run_para = 11;
				#endif
			}
		}



	   	    	//********************************** Percentage load bar ******************************
				switch(quadrant)
				{
				   case 0:
					   fp.en.Eng_Quadrant = 0;
				   break;
				   case 1:
					   array_lc[FIRST_QUADRNT] = FIRST_QUADRNT_ON;
					   fp.en.Eng_Quadrant = 1;
				   break;
				   case 2:
					   array_lc[SECOND_QUADRNT] = SECOND_QUADRNT_ON;
					   fp.en.Eng_Quadrant = 2;
				   break;
				   case 3:
					   array_lc[THIRD_QUADRNT] = THIRD_QUADRNT_ON;
					   	fp.en.Eng_Quadrant = 3;
				   break;
				   case 4:
					   array_lc[FOURTH_QUADRNT] = FOURTH_QUADRNT_ON;
					   	fp.en.Eng_Quadrant = 4;
				   break;
				}
				f_en.Phase.Eng_Quadrant=(unsigned long)fp.en.Eng_Quadrant;


//				for(i=0;i<3;i++)
//				{
////					if(pm.p.system == PHASE_3P3W)
////					 {
////					   if(i==1)
////					   {
////						  i=2;
////						  percentage_load[1]=0;
////					   }
////					 }
//					if(PF.current[i] > 1.1*pm.p.Irated)
//					{
//						percentage_load[i] = 120;
//					}
//					else if((PF.current[i] <= 1.1*pm.p.Irated)&&(PF.current[i] > 0.9*pm.p.Irated))
//					{
//						percentage_load[i] = 100;
//					}
//					else if((PF.current[i] <= 0.9*pm.p.Irated)&&(PF.current[i] > 0.7*pm.p.Irated))
//					{
//						percentage_load[i] = 80;
//					}
//					else if((PF.current[i] <= 0.7*pm.p.Irated)&&(PF.current[i] > 0.5*pm.p.Irated))
//					{
//						percentage_load[i] = 60;
//					}
//					else if((PF.current[i] <= 0.5*pm.p.Irated)&&(PF.current[i] > 0.3*pm.p.Irated))
//					{
//						percentage_load[i] = 40;
//					}
//					else if((PF.current[i] <= 0.3*pm.p.Irated)&&(PF.current[i] > 0.015*pm.p.Irated))
//					{
//						percentage_load[i] = 20;
//					}
//					else
//					{
//						percentage_load[i] = 0;
//					}
//
//					if(PF.current[i]==0.0)
//					percentage_load[i] = 0;
//				}
			  /* hours.data.I1_per_load = (unsigned int)(PF.current[0]*10000)/pm.p.Irated;
			   hours.data.I2_per_load = (unsigned int)(PF.current[1]*10000)/pm.p.Irated;
			   hours.data.I3_per_load = (unsigned int)(PF.current[2]*10000)/pm.p.Irated;*/

			switch(percentage_load[0])
				  {
					case 20:
						array_lc[I1_per_20]= I1_per_20_ON ;
					break;
					case 40:
						array_lc[I1_per_20]= I1_per_20_ON ;
						array_lc[I1_per_40]= I1_per_40_ON ;
					break;
					case 60:
						array_lc[I1_per_20]= I1_per_20_ON ;
						array_lc[I1_per_40]= I1_per_40_ON ;
						array_lc[I1_per_60]= I1_per_60_ON ;
					break;
					case 80:
						array_lc[I1_per_20]= I1_per_20_ON ;
						array_lc[I1_per_40]= I1_per_40_ON ;
						array_lc[I1_per_60]= I1_per_60_ON ;
						array_lc[I1_per_80]= I1_per_80_ON ;
					break;
					case 100:
						array_lc[I1_per_20]= I1_per_20_ON ;
						array_lc[I1_per_40]= I1_per_40_ON ;
						array_lc[I1_per_60]= I1_per_60_ON ;
						array_lc[I1_per_80]= I1_per_80_ON ;
						array_lc[I1_per_100]= I1_per_100_ON ;
					break;
					case 120:
						array_lc[I1_per_20]= I1_per_20_ON ;
						array_lc[I1_per_40]= I1_per_40_ON ;
						array_lc[I1_per_60]= I1_per_60_ON ;
						array_lc[I1_per_80]= I1_per_80_ON ;
						array_lc[I1_per_100]= I1_per_100_ON ;
						array_lc[I1_per_120]= I1_per_120_ON ;
					break;
					default:

					break;
				 }

			switch(percentage_load[1])
				{
					case 20:
						array_lc[I2_per_20]= I2_per_20_ON ;
					break;
					case 40:
						array_lc[I2_per_20]= I2_per_20_ON ;
						array_lc[I2_per_40]= I2_per_40_ON ;
					break;
					case 60:
						array_lc[I2_per_20]= I2_per_20_ON ;
						array_lc[I2_per_40]= I2_per_40_ON ;
						array_lc[I2_per_60]= I2_per_60_ON ;
					break;
					case 80:
						array_lc[I2_per_20]= I2_per_20_ON ;
						array_lc[I2_per_40]= I2_per_40_ON ;
						array_lc[I2_per_60]= I2_per_60_ON ;
						array_lc[I2_per_80]= I2_per_80_ON ;
					break;
					case 100:
						array_lc[I2_per_20]= I2_per_20_ON ;
						array_lc[I2_per_40]= I2_per_40_ON ;
						array_lc[I2_per_60]= I2_per_60_ON ;
						array_lc[I2_per_80]= I2_per_80_ON ;
						array_lc[I2_per_100]= I2_per_100_ON ;
					break;
					case 120:
						array_lc[I2_per_20]= I2_per_20_ON ;
						array_lc[I2_per_40]= I2_per_40_ON ;
						array_lc[I2_per_60]= I2_per_60_ON ;
						array_lc[I2_per_80]= I2_per_80_ON ;
						array_lc[I2_per_100]= I2_per_100_ON ;
						array_lc[I2_per_120]= I2_per_120_ON ;
					break;
					default:

					break;
				}

			switch(percentage_load[2])
				{
					case 20:
						array_lc[I3_per_20]= I3_per_20_ON ;
					break;
					case 40:
						array_lc[I3_per_20]= I3_per_20_ON ;
						array_lc[I3_per_40]= I3_per_40_ON ;
					break;
					case 60:
						array_lc[I3_per_20]= I3_per_20_ON ;
						array_lc[I3_per_40]= I3_per_40_ON ;
						array_lc[I3_per_60]= I3_per_60_ON ;
					break;
					case 80:
						array_lc[I3_per_20]= I3_per_20_ON ;
						array_lc[I3_per_40]= I3_per_40_ON ;
						array_lc[I3_per_60]= I3_per_60_ON ;
						array_lc[I3_per_80]= I3_per_80_ON ;
					break;
					case 100:
						array_lc[I3_per_20]= I3_per_20_ON ;
						array_lc[I3_per_40]= I3_per_40_ON ;
						array_lc[I3_per_60]= I3_per_60_ON ;
						array_lc[I3_per_80]= I3_per_80_ON ;
						array_lc[I3_per_100]= I3_per_100_ON ;
					break;

					case 120:
						array_lc[I3_per_20]= I3_per_20_ON ;
						array_lc[I3_per_40]= I3_per_40_ON ;
						array_lc[I3_per_60]= I3_per_60_ON ;
						array_lc[I3_per_80]= I3_per_80_ON ;
						array_lc[I3_per_100]= I3_per_100_ON ;
						array_lc[I3_per_120]= I3_per_120_ON ;
					break;
					default:

					break;
				}

   	     	if(!init_disp)
   	     	    LC_display();						// Real Time Read & Rising Demand and MAX Demand calculation

         if(PROG)
			{
				PROG=0;
				b.run_mode = 0;
				b.password_check = 1;
				password_page = 1;
				cursor = 3/*9*/;
				b.edit = 0;
				password[3] = 1;
				password[2] = 0;
				password[1] = 0;
				password[0] = 0;
			}
     }

	void Password_Mode(void)
	{

		unsigned int k;
		register unsigned int temp_int;
		register unsigned char i,l;

		for(k=0;k<385;k++)
				array_lc[k] = 0x00;
		  array_lc[masibus]=masibus_ON;
		  array_lc[SETUP]=SETUP_ON;
		switch(password_page)
		{
			case 1:
				LCD_char_line(0, "ENTER", 1, 5, NO_DP);

				if(PROG)
				{
					PROG=0;
					//temp_char = password[0]*1000 + password[1]*100 + password[2]*10 + password[3];
					temp_int = array_to_decimal(&password[0],4);
					if((temp_int == pm.p.PSWD)||(temp_int == 1975))
					{
						password_page = 2;
						timeout = 1;
					}
					else
					{
						password_page = 3;
						timeout = 2;
					}
				}
				if(NXT)
				 {	NXT=0; cursor--;				if(cursor==255)					cursor = 3;	}
				if(INC)
				 {	INC=0; password[cursor]++;	if(password[cursor] > 9)		password[cursor] = 0;}
				if(DEC)
				 {	DEC=0; password[cursor]--;	if(password[cursor] == 255)		password[cursor] = 9;}
			break;

			case 2:
				LCD_char_line(0, "TRUE", 1, 4, NO_DP);
			break;

			case 3:
				LCD_char_line(0, "FALSE", 1, 5, NO_DP);
			break;

			case 4:
				    display_message1(" MODE",NO_DP);
				    if((disp_line==0)||(disp_line==1)||(disp_line==2)||(disp_line==3))
				    {
						LCD_char_line(0, "EDIT", 1, 4, NO_DP);
						if(b.freez)
						{
							LCD_char_line(1, "MSCROL", 1, 6, 0);

						}
						else
							LCD_char_line(1, "ASCROL", 1, 6, 0);
							LCD_char_line(2, "RESET", 1, 5, NO_DP);
							LCD_char_line(3, "RUN MODE", 1, 8, NO_DP);
				    }
				    if(disp_line==4)
				    {
						if(b.bl_mode)
							LCD_char_line(0, "BLAUTO", 1, 6, 1);
						else
							LCD_char_line(0, "BLON", 1, 4, 1);
				    }

				if(DN)
				 {
					  DEC=0;
				      disp_line++;
				  if(disp_line > 4)
					 disp_line = 0;
				 }
				if(UP)
				 {
					   INC=0;
					   disp_line--;
					if(disp_line == 255)
						disp_line = 4;
				 }

				if((disp_line==0)||(disp_line==4))
					array_lc[D24G]=D24G_ON;
				else if(disp_line==1)
					array_lc[D17G]=D17G_ON;
				else if(disp_line==2)
					array_lc[D10G]=D10G_ON;
				else if(disp_line==3)
					array_lc[D1G]=D1G_ON;

				if(NXT)
				{	NXT=0;
				    b.password_check = 0;
				    b.run_mode = 1;
				}
				if(PROG)
				{
					PROG=0;
					if(disp_line == 0)
					{
						b.password_check = 0;
						b.program_mode = 1;
						//Progmode_para = 0;
                        Progmode_para = 10;
						disp_line = 0;
						disp_line1 = 0;
						line_shift = 0;
						b.edit = 0;

					}
					else if(disp_line == 1)
					{
						//b.password_check = 0;
						//b.calib_mode = 1;
						//calib_para = 0;
						b.freez = ~b.freez;
						if(b.freez)
						{

							freez_page = run_para;
							//eeP1WR_eeprom(FREEZ_PAGE, freez_page);
							Auto_ret = 0;
						}
						else
						{

							freez_page = 0;
							//eeP1WR_eeprom(FREEZ_PAGE, freez_page);
						}
						scroll = 0;
						//bar_led_cntr = 0;
					}
					else if(disp_line == 2)
					{
						b.password_check = 0;
						b.reset_reg_mode = 1;
						disp_line1 = 0;
						disp_line = 0;
						line_shift = 0;

					}
					else if(disp_line == 3)
					{
						b.password_check = 0;
						b.run_mode = 1;

					}
					else if(disp_line == 4)
					{
						b.bl_mode = ~b.bl_mode;
						//eeP1WR_eeprom(BL_MODE, b.bl_mode);
						if(b.bl_mode)
						bl_timeout = 120;
					}
				}
			break;





			default:

			break;
		}

		if(password_page < 4)
		{
			display_message1("CNFIG",NO_DP);
			LCD_char_line(1, "PSWRD", 1, 5, NO_DP);
			disp[3] = password[3];
			disp[2] = password[2];
			disp[1] = password[1];
			disp[0] = password[0];
			if(b.blink)
				disp[cursor] = ' ';
			LCD_char_line(2,&disp[0],1, 4, NO_DP);

			if((timeout == 0)&&(password_page == 3))
			{
				b.password_check = 0;
				b.run_mode = 1;
			}
			else if((timeout == 0)&&(password_page == 2))
			{
				password_page = 4;
				disp_line = 0;
			}
		}
		LC_display();
	}

	void Program_Mode(void)  //SD16
	{
		register unsigned int temp_int2, temp_int3,V_value,I_value,P_const,INT_value,SBINT_value;
		register unsigned char i,l,j;
        unsigned int k;

		for(k=0;k<385;k++)
				array_lc[k] = 0x00;
		  array_lc[masibus]=masibus_ON;
		  array_lc[SETUP]=SETUP_ON;
		switch(Progmode_para)
		{
			case 10:
				display_message1("CT-PT",NO_DP);
				LCD_char_line(0, "CTR", 1, 3, NO_DP);
				LCD_char_line(1, "SEC-CT", 1, 6, NO_DP);
				LCD_char_line(2, "PTR", 1, 3, NO_DP);
				LCD_char_line(3, "SEC-PT", 1, 6, NO_DP);

             break;

			case 20:
				display_message1(" COMM",NO_DP);
				LCD_char_line(0, "S-ID", 1, 4, NO_DP);
				LCD_char_line(1, "BAUD", 1, 4, NO_DP);
				LCD_char_line(2, "BITS", 1, 4, NO_DP);
				LCD_char_line(3, "DATA-TYP", 1, 8, NO_DP);
				disp_line1=0;
			break;

			case 30:
				display_message1("SYSST",2);
				array_lc[D31P]=D31P_ON;
				LCD_char_line(0, "PSWRD", 1, 5, NO_DP);
				LCD_char_line(1, "SYSTEM", 1, 6, NO_DP);
				LCD_char_line(2, "PLS-OP", 1, 6, NO_DP);
			#ifdef RTC_CALENDAR
				LCD_char_line(3, "TIMEDATE", 1, 8, 3);
			#endif
				 disp_line1=0;
			break;

         	 #ifdef RTC_CALENDAR
				case 40:
					display_message1(" DMD ",3);
					LCD_char_line(0, "DMD-ON", 1, 6, NO_DP);
					LCD_char_line(1, "METHOD", 1, 6, NO_DP);
					LCD_char_line(2, "IN-TM", 1, 5, NO_DP);
					if(pm.p.Dem_method)
					  LCD_char_line(3, "SBIN-TM", 1, 7, 1);
				break;
         	 #endif

				case 11:
						 LCD_char_line(0, "CTR", 1, 3, NO_DP);
						 temp_int2 = (unsigned int)(pm.p.ctr/1000);
						 temp_int3 = (unsigned int)(pm.p.ctr - (temp_int2 * 1000));
					 	 decimal_to_array(temp_int2, 4, &temp_char[0]);
					 	 decimal_to_array(temp_int3, 3, &temp_char[4]);

						if(b.edit)
						{
							if(INC)
							{ INC=0; temp_char[cursor]++; if(temp_char[cursor] > 9) temp_char[cursor] = 0;}
							if(DEC)
							{ DEC=0; temp_char[cursor]--; if(temp_char[cursor] == 255) temp_char[cursor] = 9;}
							if(NXT)
							{ NXT=0; cursor--; if(cursor == 255) cursor = 6;}

							temp_int2 = array_to_decimal(&temp_char[0], 4);
							temp_int3 = array_to_decimal(&temp_char[4], 3);

							if(temp_int2==0)
							{
								temp_int2 = 1;
								decimal_to_array(temp_int2, 4, &temp_char[0]);
							}

							pm.p.ctr=(unsigned long)((unsigned long)temp_int2*1000) + temp_int3;
							Ctr = (float)((float)pm.p.ctr/1000);

							if(PROG)
							{
								PROG=0;
								b.edit = 0;
								//Store data into FRAM
								CalWatt=0.0;	WattValue=0.0;
								CT_MUL_PT = Ctr;
								CT_MUL_PT *= Ptr;
								//eeP1WR_eeprom_float(CTR,Ctr);
								//pm.p.ctr = (unsigned long)(Ctr  * 1000.0);
								pm.p.ct_mbusratio[1] = 0x0000ffff & pm.p.ctr;
								pm.p.ct_mbusratio[0] = 0x0000ffff & (pm.p.ctr>>16);
							}
						}
						if((b.blink) && (b.edit))
						  temp_char[cursor] = ' ';
						 LCD_char_line(1,&temp_char[0],0, 7, 3);
			    break;

				case 12:
						  LCD_char_line(0, "SEC-CT", 1, 6, NO_DP);
						  I_value=pm.p.Irated;
						  decimal_to_array(I_value, 1, &temp_char[0]);
						 if(b.edit)
							{
								if(INC || DEC)
								{
									INC=0;
									DEC=0;
									if(pm.p.Irated == 1)
										pm.p.Irated = 5;
									else
										pm.p.Irated = 1;
								}
								if(PROG)
								{
									PROG=0;
									b.edit = 0;
									if(pm.p.power<5)
									{            //pulse constant for Killo unit
										 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant);
									}
									else
									{
										 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant); //pulse constant for Mega unit
										 EnergyPerPulse1*=1000;
									}
									CalWatt=0.0;	WattValue=0.0;
									//SD16_Init();
									init_delay=10;
									//gain_set();
									//eeP1WR_eeprom(IRATED, pm.p.Irated);
									I_creep = (float)((float)(0.0009) * (float)(pm.p.Irated));   	//I_creep = 0.1% of Irated into Resolution used in MSP it is 10000 here
																												//I_creep = (0.1/100) * Irated[i.e.5A] * 10000 = less than equal 4.5mA ac approx for 5A
								}
							}
						   if((b.blink) && (b.edit))
							   temp_char[0] = ' ';
						   LCD_char_line(1,&temp_char[0],3, 1, NO_DP);

					   break;

				case 13:
					     LCD_char_line(0, "PTR", 2, 3, NO_DP);
						 temp_int2 = (unsigned int)(pm.p.ptr/1000);
						 temp_int3 = (unsigned int)(pm.p.ptr - (temp_int2 * 1000));
						 decimal_to_array(temp_int2, 4, &temp_char[0]);
						 decimal_to_array(temp_int3, 3, &temp_char[4]);

						if(b.edit)
						{
							if(INC)
							{ INC=0; temp_char[cursor]++; if(temp_char[cursor] > 9) temp_char[cursor] = 0;}
							if(DEC)
							{ DEC=0; temp_char[cursor]--; if(temp_char[cursor] == 255) temp_char[cursor] = 9;}
							if(NXT)
							{ NXT=0; cursor--;  if(cursor == 255) cursor = 6;}

							temp_int2 = array_to_decimal(&temp_char[0], 4);
							temp_int3 = array_to_decimal(&temp_char[4], 3);

							if(temp_int2==0)
							{
								temp_int2 = 1;
								decimal_to_array(temp_int2, 4, &temp_char[0]);
							}

							pm.p.ptr=(unsigned long)((unsigned long)temp_int2*1000) + temp_int3;
							Ptr = (float)((float)pm.p.ptr/1000);

							if(PROG)
							{
								PROG=0;
								b.edit = 0;
								//Store data into FRAM
								CalWatt=0.0;	WattValue=0.0;
								CT_MUL_PT = Ctr;
								CT_MUL_PT *= Ptr;
								//eeP1WR_eeprom_float(PTR, Ptr);
								//pm.p.ptr = (unsigned long)(Ptr  * 1000.0);
								pm.p.pt_mbusratio[1] = 0x0000ffff & pm.p.ptr;
								pm.p.pt_mbusratio[0] = 0x0000ffff & (pm.p.ptr>>16);
							}
						}

						if((b.blink) && (b.edit))
						  temp_char[cursor] = ' ';
						 LCD_char_line(1,&temp_char[0],0, 7, 3);

					break;

				case 14:
						LCD_char_line(0, "SEC-PT", 1, 6, NO_DP);
//						V_value=pm.p.Vrated;
//						decimal_to_array(V_value, 1, &temp_char[0]);
					    if(b.edit)
						{
							if(pm.p.Vrated == 64)
								temp_int2 = 1;
							else if(pm.p.Vrated == 110)
								temp_int2 = 2;
							else if(pm.p.Vrated == 120)
								temp_int2 = 3;
							else if(pm.p.Vrated == 240)
								temp_int2 = 4;

							if(INC)
							{	INC=0; temp_int2++;		if(temp_int2 > 4)		temp_int2 = 1;		}
							if(DEC)
							{	DEC=0; temp_int2--;		if(temp_int2 < 1)		temp_int2 = 4;		}

							if(temp_int2 == 1)
								pm.p.Vrated = 64;
							else if(temp_int2 == 2)
								pm.p.Vrated = 110;
							else if(temp_int2 == 3)
								pm.p.Vrated = 120;
							else if(temp_int2 == 4)
								pm.p.Vrated = 240;
							if(PROG)
							{
								PROG=0;
								b.edit = 0;
								//eeP1WR_eeprom(VRATED, pm.p.Vrated);
								CalWatt=0.0;	WattValue=0.0;
								init_delay=10;
								//SD16_Init();
								//gain_set();
								V_creep = (0.08) * (float)pm.p.Vrated;   	//V_creep = 8% of Vrated into Resolution used in MSP it is 100 here																		//V_creep = (8/100) * Vrated[i.e.240V] * 100 = less than 19.20V ac approx for 240V
								V_creep_LL = 0.138 * (float)pm.p.Vrated;
							}
						}
					    V_value=pm.p.Vrated;
					    decimal_to_array(V_value,3, &temp_char[0]);

					   if((b.blink) && (b.edit))
					     {
							   temp_char[0] = ' ';
							   temp_char[1] = ' ';
							   temp_char[2] = ' ';
					     }
						   LCD_char_line(1,&temp_char[0],2, 3, NO_DP);
					   break;


				case 21:
					          LCD_char_line(0, "S-ID", 2, 4, NO_DP);
							  temp_int2 = pm.p.SLAVE_ADDRESS;
							  decimal_to_array(temp_int2, 3, &temp_char[0]);
							if(b.edit)
							{
								if(INC)
								{	INC=0; temp_char[cursor]++;	if(temp_char[cursor] > 9)		temp_char[cursor] = 0;		}
								if(DEC)
								{	DEC=0; temp_char[cursor]--;	if(temp_char[cursor] == 255)	temp_char[cursor] = 9;		}
								if(NXT)
								{	NXT=0; cursor--;					if(cursor==255)						cursor = 2;					}

								temp_int2 = array_to_decimal(&temp_char[0], 3);
								if(temp_int2 > 247)
								{
									temp_int2 = 247;
									decimal_to_array(temp_int2, 3, &temp_char[0]);
								}
								if(temp_int2 < 1)
								{
									temp_int2 = 1;
									decimal_to_array(temp_int2, 3, &temp_char[0]);
								}
								pm.p.SLAVE_ADDRESS = temp_int2;
								if(PROG)
								{
									PROG=0;
									b.edit = 0;
								   //eeP1WR_eeprom(MODBUS_ADDRESS, pm.p.SLAVE_ADDRESS);

								}
							}
							if((b.blink) && (b.edit))
							  temp_char[cursor] = ' ';
							 LCD_char_line(1,&temp_char[0],3, 3, NO_DP);
					 break;

				case 22:
					LCD_char_line(0, "BAUD", 2, 4, NO_DP);

					if(b.edit)
					{
						if(pm.p.baud == 38400)
							temp_int2 = 1;
						else if(pm.p.baud == 9600)
							temp_int2 = 2;
						else if(pm.p.baud == 19200)
							temp_int2 = 3;
//							cursor = 2;//12
						if(INC)
						{	INC=0; temp_int2++;		if(temp_int2 > 3)		temp_int2 = 1;		}
						if(DEC)
						{	DEC=0; temp_int2--;		if(temp_int2 < 1)		temp_int2 = 3;		}

						if(temp_int2 == 1)
							pm.p.baud = 38400;
						else if(temp_int2 == 2)
							pm.p.baud = 9600;
						else if(temp_int2 == 3)
							pm.p.baud = 19200;
						if(PROG)
						{
							PROG=0;
							b.edit = 0;
							//eeP1WR_eeprom(BAUD_RATE, pm.p.baud);
							F_baud = 1;
						}
					}
					decimal_to_array(pm.p.baud,5, &temp_char[0]);
				   if((b.blink) && (b.edit))
					 {
						   temp_char[0] = ' ';
						   temp_char[1] = ' ';
						   temp_char[2] = ' ';
						   temp_char[3] = ' ';
						   temp_char[4] = ' ';
					 }
					 LCD_char_line(1,&temp_char[0],2, 5, NO_DP);
				   break;

				case 23:
						  LCD_char_line(0, "PARITY", 1, 6, NO_DP);
						  LCD_char_line(2, "STOP", 1, 4, NO_DP);

					  if((b.edit)&&(disp_line1 == 0))
						{
						    if(INC)
							{	INC=0; pm.p.parity++;		if(pm.p.parity > 2)		pm.p.parity = 0;		}
							if(DEC)
							{	DEC=0; pm.p.parity--;		if(pm.p.parity == 65535)		pm.p.parity = 2;		}


							if(PROG)
							{
								 PROG=0;
								 //eeP1WR_eeprom(PARITY, pm.p.parity);
								 F_parity = 1;
								 b.edit = 0;
							}
					   }

					  if((b.edit)&&(disp_line1 == 1))
						{
						   if((INC)||(DEC))
							{	INC=0;DEC=0;
								if(pm.p.stop_bit == 1)
									pm.p.stop_bit = 2;
								else if(pm.p.stop_bit == 2)
									pm.p.stop_bit = 1;
							}
							if(PROG)
							{
								PROG=0;
								//eeP1WR_eeprom(STOP_BIT, pm.p.stop_bit);
								F_stopbit = 1;
								b.edit = 0;
							}
						 }

						 if(!b.edit)
						 {
							 if(disp_line1==0)
								array_lc[D24G]=D24G_ON;
							else if(disp_line1==1)
								array_lc[D10G]=D10G_ON;
						 }

						if((b.blink) && (b.edit) && (disp_line1==0))
							LCD_char_line(1, "         ", 0, 9, NO_DP);
						else
						{
							switch(pm.p.parity)
							{
								case 0: LCD_char_line(1, "NONE", 2, 4, NO_DP);
								break;
								case 1: LCD_char_line(1, "ODD ", 2, 4, NO_DP);
								break;
								case 2: LCD_char_line(1, "EVEN", 2, 4, NO_DP);
								break;
								default: LCD_char_line(1, "NONE", 2, 4, NO_DP);
								break;
							}
						}


					   if((b.blink) && (b.edit) && (disp_line1==1))
						   LCD_char_line(3, "         ", 0, 9, NO_DP);
					   else
					   {
						   switch(pm.p.stop_bit)
							{

								case 1: LCD_char_line(3, "1", 4, 1, NO_DP);
								break;
								case 2: LCD_char_line(3, "2", 4, 1, NO_DP);
								break;
								default: LCD_char_line(3, "1", 4, 1, NO_DP);
								break;
							}
					   }
				break;


				case 24:
						  LCD_char_line(0, "DATATYP", 0, 7, 3);
						 if(b.edit)
							{
							 if(INC || DEC)
								{
									INC=0;DEC=0;
									if(pm.p.type == 0) 	pm.p.type = 1;
									else				pm.p.type = 0;
								}
								if(PROG)
								{
									PROG=0;
									b.edit = 0;
									//eeP1WR_eeprom(MODBUS_TYPE, pm.p.type);
								}
							}
						   if((b.blink) && (b.edit))
							   LCD_char_line(1, "    ", 2, 4, NO_DP);
						   else
						   {
							   switch(pm.p.type)
								{
									case 0:
										LCD_char_line(1, "REAL", 2, 4, NO_DP);
									break;

									case 1:
										LCD_char_line(1, "LONG", 2, 4, NO_DP);
									break;

									default:
										LCD_char_line(1, "REAL", 2, 4, NO_DP);
									break;
								}
						   }
					   break;

				case 31:
					  LCD_char_line(0, "PASWRD", 1, 6, NO_DP);
					  temp_int2 = pm.p.PSWD;
					  decimal_to_array(temp_int2, 4, &temp_char[0]);
					if(b.edit)
					{
						if(INC)
						{	INC=0; temp_char[cursor]++;	if(temp_char[cursor] > 9)		temp_char[cursor] = 0;		}
						if(DEC)
						{	DEC=0; temp_char[cursor]--;	if(temp_char[cursor] == 255)	temp_char[cursor] = 9;		}
						if(NXT)
						{	NXT=0; cursor--;					if(cursor==255)						cursor = 3;					}

						temp_int2 = array_to_decimal(&temp_char[0], 4);

						if(temp_int2 == 0)
						{
							temp_int2 = 1;
							decimal_to_array(temp_int2, 4, &temp_char[0]);
						}
						pm.p.PSWD = temp_int2;
						if(PROG)
						{
							PROG=0;
							b.edit = 0;
							//eeP1WR_eeprom(PASSWORD, pm.p.PSWD);

						}
					}
					if((b.blink) && (b.edit))
					  temp_char[cursor] = ' ';
					 LCD_char_line(1,&temp_char[0],2, 4, NO_DP);
			 break;

				case 32:

					  LCD_char_line(0, "SYSTEM", 1, 6, NO_DP);
					 if(b.edit)
						{
						 if(INC || DEC)
							{
								INC=0;DEC=0;
								if(pm.p.system == PHASE_3P3W) 	pm.p.system = PHASE_3P4W;
								else							pm.p.system = PHASE_3P3W;
							}
							if(PROG)
							{
								PROG=0;
								b.edit = 0;
								run_para = 11;
								freez_page = run_para;
								//eeP1WR_eeprom(FREEZ_PAGE, freez_page);
								//eeP1WR_eeprom(SYSTEM, pm.p.system);
							}
						}
					   if((b.blink) && (b.edit))
						   LCD_char_line(1, "    ", 2, 4, NO_DP);
					   else
					   {
						   switch(pm.p.system)
							{
						        case PHASE_3P3W:
									LCD_char_line(1, "3P3W", 2, 4, NO_DP);
								break;

						        case PHASE_3P4W:
									LCD_char_line(1, "3P4W", 2, 4, NO_DP);
								break;

								default:
									LCD_char_line(1, "3P4W", 2, 4, NO_DP);
								break;
							}
					   }
				   break;

				case 33:
						  LCD_char_line(0, "PLS-OP", 1, 6, NO_DP);
						  LCD_char_line(2, "UNIT", 3, 4, NO_DP);

						   temp_int2 = pm.p.plsconstant;
						   decimal_to_array(temp_int2, 5, &temp_char[0]);

					  if((b.edit)&&(disp_line1 == 0))
						{
							if(INC)
							{	INC=0; temp_char[cursor]++;	if(temp_char[cursor] > 9)		temp_char[cursor] = 0;		}
							if(DEC)
							{	DEC=0; temp_char[cursor]--;	if(temp_char[cursor] == 255)	temp_char[cursor] = 9;		}
							if(NXT)
							{	NXT=0;    cursor--;             if(cursor == 255)                   cursor = 4;     }

							temp_int2 = array_to_decimal(&temp_char[0], 5);
							if(temp_int2 > 60000)
							{
								temp_int2 = 3600;
								decimal_to_array(temp_int2, 5, &temp_char[0]);
							}
							if(temp_int2 < 100)
							{
								temp_int2 = 3600;
								decimal_to_array(temp_int2, 5, &temp_char[0]);
							}
							pm.p.plsconstant = temp_int2;
							decimal_to_array(pm.p.plsconstant, 5, &temp_char[0]);


							if(PROG)
							{
								PROG=0;
								//eeP1WR_eeprom(PLS_CONSTANT, pm.p.plsconstant);
								//disp_line++;
								if(pm.p.plsconstant<100 || pm.p.plsconstant>60000 || pm.p.plsconstant==0 || (pm.p.plsconstant%100)!=0)
								{
									pm.p.plsconstant=3600;
									//eeP1WR_eeprom(PLS_CONSTANT, pm.p.plsconstant);
								}
								if(pm.p.power<5)
								{            //pulse constant for Killo unit
									 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant);
								}
								else
								{
									 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant); //pulse constant for Mega unit
									 EnergyPerPulse1*=1000;
								}
								CalWatt=0.0;	WattValue=0.0;
								b.edit = 0;
							}
					   }

					  if((b.edit)&&(disp_line1 == 1))
						{
							if(INC)
							{	INC=0; pm.p.power++;	if(pm.p.power > 9)		pm.p.power = 0;		}
							if(DEC)
							{	DEC=0; pm.p.power--;	if(pm.p.power == 0xFFFF)pm.p.power = 9;		}
							if(PROG)
							{
								PROG=0;
								//eeP1WR_eeprom(PULSE_OP, pm.p.power);
								if(pm.p.power<5)
								{            //pulse constant for Killo unit
									 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant);
								}
								else
								{
									 EnergyPerPulse1=(float)(921600000/pm.p.plsconstant); //pulse constant for Mega unit
									 EnergyPerPulse1*=1000;
								}
								CalWatt=0.0;	WattValue=0.0;
								b.edit = 0;
							}
						 }

						 if(!b.edit)
						 {
							 if(disp_line1==0)
								array_lc[D24G]=D24G_ON;
							else if(disp_line1==1)
								array_lc[D10G]=D10G_ON;
						 }

						if((b.blink) && (b.edit) && (disp_line1==0))
						   temp_char[cursor] = ' ';
							LCD_char_line(1,&temp_char[0],2, 5, NO_DP);

						   if((b.blink) && (b.edit) && (disp_line1==1))
							   LCD_char_line(3, "         ", 0, 9, NO_DP);
						   else
						   {
						   switch(pm.p.power)
							{
								case 0: LCD_char_line(3, "WH-I 0", 3, 6, NO_DP);
								break;
								case 1: LCD_char_line(3, "WH-E 1", 3, 6, NO_DP);
								break;
								case 2: LCD_char_line(3, "VARH-I 2", 1, 8, NO_DP);
								break;
								case 3: LCD_char_line(3, "VARH-E 3", 1, 8, NO_DP);
								break;
								case 4: LCD_char_line(3, "VAH 4", 4, 5, NO_DP);
								break;
								case 5: LCD_char_line(3, "MWH-I 5", 2, 7, NO_DP);
								break;
								case 6: LCD_char_line(3, "MWH-E 6", 2, 7, NO_DP);
								break;
								case 7: LCD_char_line(3, "MVARH-I 7", 0, 9, NO_DP);
								break;
								case 8: LCD_char_line(3, "MVARH-E 8", 0, 9, NO_DP);
								break;
								case 9: LCD_char_line(3, "MVAH 9", 3, 6, NO_DP);
								break;
								default: LCD_char_line(3, "WH-I 0", 3, 6, NO_DP);
								break;
							}
						   }
				break;

			#ifdef RTC_CALENDAR
				case 34:
				        LCD_char_line(0, "TIME", 2, 4, NO_DP);
				        LCD_char_line(1, "DATE", 2, 4, NO_DP);
				        if((b.edit)&&(disp_line1 == 0))
						{
							if(INC)
							{	INC=0; temp_char[cursor]++;	if(temp_char[cursor] > Hi_limit)		temp_char[cursor] = Lo_limit;		}
							if(DEC)
							{	DEC=0; temp_char[cursor]--;	if((temp_char[cursor] == 255)||(temp_char[cursor] < Lo_limit))	temp_char[cursor] = Hi_limit;		}
							if(NXT)
							{
								NXT=0;
								cursor = cursor-2;
								if(cursor ==255 )
									cursor = 5;
	//							if(disp_line == 2)
	//							{
									Lo_limit = 0;
									if(cursor == 1)
										Hi_limit = 23;
									else
										Hi_limit = 59;
								//}

							}
							 Hour=temp_char[1];
							 Min=temp_char[3];
							 Sec=temp_char[5];
						   if(PROG)
							{
									PROG=0;
								 b.temp_bit = 0;
								//if((temp_char[6] != Rtc.Data.hour)||(temp_char[3] < Rtc.Data.min)||(temp_char[3] >= (RD.Date_Time.min + pm.p.Int_time)))
								//	b.temp_bit = 1;
								Rtc_bcd.Data.sec = DECIMAL_2_BCD(temp_char[5]);
								Rtc_bcd.Data.min = DECIMAL_2_BCD(temp_char[3]);
								Rtc_bcd.Data.hour = DECIMAL_2_BCD(temp_char[1]);
								Write_RTC(SECONDS, &Rtc_bcd.Array[0], 3);
								b.edit = 0;
							}
						}
				        if((b.edit)&&(disp_line1 == 1))
						{
							if(INC)
							{	INC=0; temp_char_1[cursor]++;	if(temp_char_1[cursor] > Hi_limit)		temp_char_1[cursor] = Lo_limit;		}
							if(DEC)
							{	DEC=0; temp_char_1[cursor]--;	if((temp_char_1[cursor] == 255)||(temp_char_1[cursor] < Lo_limit))	temp_char_1[cursor] = Hi_limit;		}
							if(NXT)
							{
								NXT=0;
							   cursor = cursor-3;
							  if(cursor == 254)
								  cursor = 7;
								if(cursor == 7)
								{
									Lo_limit = 0;
									Hi_limit = 99;
								}
								else if(cursor == 4)
								{
									Lo_limit = 1;
									Hi_limit = 12;
								}
								else
								{
									if(temp_char_1[4]==2)
									{
									 if(temp_char_1[7]%4==0)
									  Lo_limit = 1,Hi_limit = 29;
									 else
										 Lo_limit = 1,Hi_limit = 28;
									}
									 else if((temp_char_1[4]==1)||(temp_char_1[4]==3)||(temp_char_1[4]==5)||(temp_char_1[4]==7)||(temp_char_1[4]==8)||(temp_char_1[4]==10)||(temp_char_1[4]==12))
									  Lo_limit = 1,Hi_limit = 31;
									else
									  Lo_limit = 1,Hi_limit = 30;

								 }

							}

							 Date= temp_char_1[1];//6
							 Month=temp_char_1[4];//3
							 Year=temp_char_1[7];//0
						   if(PROG)
							{
									PROG=0;
									b.temp_bit = 0;
									//if((temp_char[0] != Rtc.Data.year)||(temp_char[3] != Rtc.Data.month)||(temp_char[6] != Rtc.Data.year))
									//	b.temp_bit = 1;
									Rtc_bcd.Data.year = DECIMAL_2_BCD(temp_char_1[7]);
									Rtc_bcd.Data.month = DECIMAL_2_BCD(temp_char_1[4]);
									Rtc_bcd.Data.date = DECIMAL_2_BCD(temp_char_1[1]);
									Write_RTC(MONTHS, &Rtc_bcd.Array[5], 2);
									Write_RTC(DATES, &Rtc_bcd.Array[3], 1);
								b.edit = 0;
							}
						}

				        if(!b.edit)
						{
				        	if(disp_line1==0)
								array_lc[D24G]=D24G_ON;
							else if(disp_line1==1)
								array_lc[D17G]=D17G_ON;
				        	 temp_char[1] = Hour;
						     temp_char[3] = Min;
						     temp_char[5] = Sec;
						     temp_char_1[1] = Date;
						     temp_char_1[4] = Month;
						     temp_char_1[7] = Year;
						}

				        if((b.blink) && (b.edit) && (disp_line1==0))
				        {
						   if(cursor==5)
							{
							   disp[4] = ' ';
							   disp[5] = ' ';
							   decimal_to_array( temp_char[1], 2, &disp[0]);
							   decimal_to_array( temp_char[3], 2, &disp[2]);
							}
							else if(cursor==3)
							{
								disp[2] = ' ';
								disp[3] = ' ';
								 decimal_to_array( temp_char[1], 2, &disp[0]);
								 decimal_to_array( temp_char[5], 2, &disp[4]);
							}
							else if(cursor==1)
							{
								disp[0] = ' ';
								disp[1] = ' ';
								 decimal_to_array( temp_char[3], 2, &disp[2]);
								 decimal_to_array( temp_char[5], 2, &disp[4]);
							}
				        }
				        else
				        {
							decimal_to_array( temp_char[1], 2, &disp[0]);
							decimal_to_array( temp_char[3], 2, &disp[2]);
							decimal_to_array( temp_char[5], 2, &disp[4]);
				        }
  					    LCD_char_line(2,&disp[0],0, 6, NO_DP);
  					    array_lc[D11P]=D11P_ON;
						array_lc[D13P]=D13P_ON;
						array_lc[D9P]=D9P_ON;
						array_lc[D16P]=D16P_ON;


						if((b.blink) && (b.edit) && (disp_line1==1))
						{
						   if(cursor==7)
							{
							   disp_1[6] = ' ';
							   disp_1[7] = ' ';
							   decimal_to_array( temp_char_1[1], 2, &disp_1[0]);
							   decimal_to_array( temp_char_1[4], 2, &disp_1[3]);
							}
							else if(cursor==4)
							{
								disp_1[3] = ' ';
								disp_1[4] = ' ';
								 decimal_to_array( temp_char_1[1], 2, &disp_1[0]);
								 decimal_to_array( temp_char_1[7], 2, &disp_1[6]);
							}
							else if(cursor==1)
							{
								disp_1[0] = ' ';
								disp_1[1] = ' ';
								 decimal_to_array( temp_char_1[4], 2, &disp_1[3]);
								 decimal_to_array( temp_char_1[7], 2, &disp_1[6]);
							}
						}
						else
						{
							decimal_to_array( temp_char_1[1], 2, &disp_1[0]);
							decimal_to_array( temp_char_1[4], 2, &disp_1[3]);
							decimal_to_array( temp_char_1[7], 2, &disp_1[6]);
						}
						disp_1[2]='-';
						disp_1[5]='-';
						disp_1[8]=' ';
						LCD_char_line(3,&disp_1[0],0, 9, NO_DP);
				  break;

//				case 34:
//					LCD_char_line(0, "DATE", 2, 4, NO_DP);
//
//					if(b.edit)
//					{
//						if(INC)
//						{	INC=0; temp_char[cursor]++;	if(temp_char[cursor] > Hi_limit)		temp_char[cursor] = Lo_limit;		}
//						if(DEC)
//						{	DEC=0; temp_char[cursor]--;	if((temp_char[cursor] == 255)||(temp_char[cursor] < Lo_limit))	temp_char[cursor] = Hi_limit;		}
//						if(NXT)
//						{
//							NXT=0;
//						   cursor = cursor-3;
//						  if(cursor == 254)
//							  cursor = 7;
//							if(cursor == 7)
//							{
//								Lo_limit = 0;
//								Hi_limit = 99;
//							}
//							else if(cursor == 4)
//							{
//								Lo_limit = 1;
//								Hi_limit = 12;
//							}
//							else
//							{
//								if(temp_char[4]==2)
//								{
//								 if(temp_char[7]%4==0)
//								  Lo_limit = 1,Hi_limit = 29;
//								 else
//									 Lo_limit = 1,Hi_limit = 28;
//								}
//								 else if((temp_char[4]==1)||(temp_char[4]==3)||(temp_char[4]==5)||(temp_char[4]==7)||(temp_char[4]==8)||(temp_char[4]==10)||(temp_char[4]==12))
//								  Lo_limit = 1,Hi_limit = 31;
//								else
//								  Lo_limit = 1,Hi_limit = 30;
//
//							 }
//
//						}
//
//						 Date= temp_char[1];//6
//						 Month=temp_char[4];//3
//						 Year=temp_char[7];//0
//					 if(PROG)
//						{
//								PROG=0;
//								b.temp_bit = 0;
//								//if((temp_char[0] != Rtc.Data.year)||(temp_char[3] != Rtc.Data.month)||(temp_char[6] != Rtc.Data.year))
//								//	b.temp_bit = 1;
//								Rtc_bcd.Data.year = DECIMAL_2_BCD(temp_char[7]);
//								Rtc_bcd.Data.month = DECIMAL_2_BCD(temp_char[4]);
//								Rtc_bcd.Data.date = DECIMAL_2_BCD(temp_char[1]);
//								Write_RTC(MONTHS, &Rtc_bcd.Array[5], 2);
//								Write_RTC(DATES, &Rtc_bcd.Array[3], 1);
//							b.edit = 0;
//						}
//					}
//					if(!b.edit)
//					{
//						temp_char[1] = Date;
//						temp_char[4] = Month;
//						temp_char[7] = Year;
//					}
//
//					if((b.blink) && (b.edit))
//					{
//					   if(cursor==7)
//						{
//						   disp[6] = ' ';
//						   disp[7] = ' ';
//						   decimal_to_array( temp_char[1], 2, &disp[0]);
//						   decimal_to_array( temp_char[4], 2, &disp[3]);
//						}
//						else if(cursor==4)
//						{
//							disp[3] = ' ';
//							disp[4] = ' ';
//							 decimal_to_array( temp_char[1], 2, &disp[0]);
//							 decimal_to_array( temp_char[7], 2, &disp[6]);
//						}
//						else if(cursor==1)
//						{
//							disp[0] = ' ';
//							disp[1] = ' ';
//							 decimal_to_array( temp_char[4], 2, &disp[3]);
//							 decimal_to_array( temp_char[7], 2, &disp[6]);
//						}
//					}
//					else
//					{
//						decimal_to_array( temp_char[1], 2, &disp[0]);
//						decimal_to_array( temp_char[4], 2, &disp[3]);
//						decimal_to_array( temp_char[7], 2, &disp[6]);
//					}
//					disp[2]='-';
//					disp[5]='-';
//					disp[8]=' ';
//					LCD_char_line(3,&disp[0],0, 9, NO_DP);
//					break;

				case 41:
						LCD_char_line(0, "DMD-ON", 1, 6, 2);
						  if(b.edit)
							{
								if(DEC || INC)
								 {
									DEC=0;INC=0;
									if(pm.p.demand_type)	pm.p.demand_type = 0;
									else					pm.p.demand_type = 1;
								 }
								 if(PROG)
								 {
									PROG=0;
									b.edit = 0;
									b.temp_bit = 0;
									//eeP1WR_eeprom(DEMAND_ON, pm.p.demand_type);
									if(temp_int[0] != pm.p.demand_type)
										b.temp_bit = 1;
									if(b.temp_bit)
										MD_rst();
								 }
							}

						 if((b.blink) && (b.edit))
							   LCD_char_line(1, "  ", 3, 2, NO_DP);
						   else
						   {
							   switch(pm.p.demand_type)
								{
									case 0:
										LCD_char_line(1, "W ", 3, 2, NO_DP);
									break;

									case 1:
										LCD_char_line(1, "VA", 3, 2, NO_DP);
									break;

									default:
										LCD_char_line(1, "W ", 3, 2, NO_DP);
									break;
								}
						   }

					break;
		case 42:
							LCD_char_line(0, "METHOD", 1, 6, NO_DP);
							if(b.edit)
							{
								if(DEC || INC)
								{
									DEC=0;INC=0;
									if(pm.p.Dem_method)	    pm.p.Dem_method = 0;
									else					pm.p.Dem_method = 1;
								}
								if(PROG)
								{
									PROG=0;
									b.edit = 0;
									b.temp_bit = 0;
									//eeP1WR_eeprom(DEMAND_METHOD, pm.p.Dem_method);
									if(temp_int[1] != pm.p.Dem_method)
										b.temp_bit = 1;
									if(b.temp_bit)
										MD_rst();
								}
							}

							 if((b.blink) && (b.edit))
								   LCD_char_line(1, "     ", 2, 5, NO_DP);
							   else
							   {
								   switch(pm.p.Dem_method)
									{
										case 0:
											LCD_char_line(1, "BLOC ", 2, 5, NO_DP);
										break;

										case 1:
											LCD_char_line(1, "SLIDE", 2, 5, NO_DP);
										break;

										default:
											LCD_char_line(1, "BLOC ", 2, 5, NO_DP);
										break;
									}
							   }
					break;
		case 43:
							LCD_char_line(0, "IN-TM", 1, 5, NO_DP);
							if(b.edit)
							{
								if(DEC || INC)
								{

									DEC=0;INC=0;
									if(pm.p.Int_time == 15)		pm.p.Int_time = 30;
									else						pm.p.Int_time = 15;
								}
								if(PROG)
								{
									PROG=0;
									b.edit = 0;
									b.temp_bit = 0;
									 if(pm.p.Int_time%pm.p.Sub_int_time==0)
										//eeP1WR_eeprom(DEMAND_INTERVAL, pm.p.Int_time);
									 else
										pm.p.Sub_int_time=1;
										//eeP1WR_eeprom(DEMAND_SUB_INTERVAL, pm.p.Sub_int_time);
										if(temp_int[2] != pm.p.Int_time)
											b.temp_bit = 1;
										if(b.temp_bit)
											MD_rst();
								}
							}
							INT_value=pm.p.Int_time;
							decimal_to_array(INT_value, 2, &temp_char[0]);

						   if((b.edit)&&(b.blink))
							{
								temp_char[0] = ' ';
								temp_char[1] = ' ';
							}
							LCD_char_line(1,&temp_char[0],3, 2, NO_DP);

					break;
		case 44:
					   LCD_char_line(0, "SBIN-TM", 0, 7, 1);
					   if(b.edit)
					   {
						if(pm.p.Int_time == 15)
						{
							if(INC)
							{
								INC=0;
								if(pm.p.Sub_int_time == 1)
									pm.p.Sub_int_time = 3;
								else if(pm.p.Sub_int_time == 3)
									pm.p.Sub_int_time = 5;
								else if(pm.p.Sub_int_time == 5)
									pm.p.Sub_int_time = 1;
							}
							if(DEC)
							{
								DEC=0;
								if(pm.p.Sub_int_time == 5)
									pm.p.Sub_int_time = 3;
								else if(pm.p.Sub_int_time == 3)
									pm.p.Sub_int_time = 1;
								else if(pm.p.Sub_int_time == 1)
									pm.p.Sub_int_time = 5;
							 }
						   }
						  else if(pm.p.Int_time == 30)
						   {
							if(INC)
							{
								INC=0;
								if(pm.p.Sub_int_time < 3)
									pm.p.Sub_int_time++;
								else if(pm.p.Sub_int_time == 3)
									pm.p.Sub_int_time = 5;
								else if(pm.p.Sub_int_time == 5)
									pm.p.Sub_int_time = 6;
								else if(pm.p.Sub_int_time == 6)
									pm.p.Sub_int_time = 10;
								else if(pm.p.Sub_int_time == 10)
									pm.p.Sub_int_time = 1;
							}
							if(DEC)
							{
								/*if(pm.p.Sub_int_time < 3)
									pm.p.Sub_int_time++;
								else if(pm.p.Sub_int_time == 3)
									pm.p.Sub_int_time = 5;
								else if(pm.p.Sub_int_time == 5)
									pm.p.Sub_int_time = 6;
								else if(pm.p.Sub_int_time == 6)
									pm.p.Sub_int_time = 10;
								else if(pm.p.Sub_int_time == 10)
									pm.p.Sub_int_time = 1;	*/
								DEC=0;
								if(pm.p.Sub_int_time == 10)
									pm.p.Sub_int_time = 6;
								else if(pm.p.Sub_int_time == 6)
									pm.p.Sub_int_time = 5;
								else if(pm.p.Sub_int_time == 5)
									pm.p.Sub_int_time = 3;
								else if((pm.p.Sub_int_time == 3)||(pm.p.Sub_int_time == 2))
									pm.p.Sub_int_time--;
								else if(pm.p.Sub_int_time == 1)
									pm.p.Sub_int_time = 10;
							}
						}
						if(PROG)
						{
							PROG=0;
							b.edit = 0;
							b.temp_bit = 0;
							//eeP1WR_eeprom(DEMAND_SUB_INTERVAL, pm.p.Sub_int_time);
							if(temp_int[3] != pm.p.Sub_int_time)
								b.temp_bit = 1;
							if(b.temp_bit)
								MD_rst();
						}
					   }

						SBINT_value= pm.p.Sub_int_time;
						decimal_to_array(SBINT_value, 2, &temp_char[0]);

						 if((b.edit)&&(b.blink))
						  {
							 temp_char[0] = ' ';
							 temp_char[1] = ' ';
						  }
						 LCD_char_line(1,&temp_char[0],3, 2, NO_DP);
				break;
			#endif
		}
	if((Progmode_para==10 || Progmode_para==20 || Progmode_para==30 || Progmode_para==40))
	{
	  if(b.edit==0)
	  {
		if(INC)
		{
			INC=0;
			Progmode_para=Progmode_para+10;
            #ifndef RTC_CALENDAR
			if(Progmode_para>=40)
				Progmode_para=10;
           #else
			if(Progmode_para>=50)
			   Progmode_para=10;
			#endif
		}
		if(DEC)
		{
			DEC=0;
			Progmode_para=Progmode_para-10;
           #ifndef RTC_CALENDAR
			if(Progmode_para == 0)
				Progmode_para = 30;
           #else
			if(Progmode_para == 0)
			   Progmode_para = 40;
			#endif
		}
		if(PROG)
		 {
			 PROG=0;
			 b.edit=1;
		 }
		if(NXT)
		 {
			NXT=0;
			b.password_check = 1;
			b.program_mode = 0;
			password_page = 4;
			disp_line = 0;
		 }
	 }
   else
     {
	   if(DN)
		{
		     DEC=0;
		    disp_line++;
		    if(disp_line > 3)
		      disp_line = 0;
           #ifndef RTC_CALENDAR
		    if((Progmode_para==30)&&(disp_line==3))
		    	disp_line=0;
			#else
		    if((pm.p.Dem_method==0)&&(disp_line==3)&&(Progmode_para==40))
		       disp_line=0;
			#endif
		}
		if(UP)
		{
			INC=0;
			disp_line--;
			if(disp_line == 255)
			   disp_line = 3;
			#ifndef RTC_CALENDAR
		    if((Progmode_para==30)&&(disp_line==3))
		    	disp_line=2;
			#else
			if((pm.p.Dem_method==0)&&(disp_line==3)&&(Progmode_para==40))
			   disp_line=2;
			#endif
		}

		if(disp_line==0)
			array_lc[D24G]=D24G_ON;
		else if(disp_line==1)
			array_lc[D17G]=D17G_ON;
		else if(disp_line==2)
			 array_lc[D10G]=D10G_ON;
		else if(disp_line==3)
			 array_lc[D1G]=D1G_ON;

		if(PROG)
		{
			PROG=0;
			b.edit=0;
			Progmode_para = Progmode_para + disp_line+1;
		}
		if(NXT)
		{
			NXT=0;
			b.edit=0;
			disp_line=0;
		}
      }
	}
	else
	{
		if(b.edit==0)
		{
			if(PROG)
			{
				PROG=0;
				b.edit = 1;
				cursor = 0;
				if((Progmode_para == 11)||(Progmode_para == 13))
					cursor = 6;
				if(Progmode_para == 21)
					cursor = 2;
				if(Progmode_para == 31)
					cursor = 3;
				if(Progmode_para == 33)
					cursor = 4;
              #ifdef RTC_CALENDAR
				if(Progmode_para == 34)
				{
					if(disp_line1==0)
					{
						Lo_limit = 0;
						Hi_limit = 59;
						cursor=5;
					}
					else if(disp_line1==1)
					{
						Lo_limit = 0;
						Hi_limit = 99;
						cursor=7;
					}
				}
              #endif
			}
			if(NXT)
			{
				NXT=0;
				Progmode_para = Progmode_para - (Progmode_para%10);
				b.edit=1;
			}
			if(DEC)
			{
			  DEC=0;
			  if((Progmode_para == 23)||(Progmode_para == 33)||(Progmode_para == 34))
			  {
				  if(disp_line1==0)
				   disp_line1=1;
			   else
				   disp_line1=0;
			  }
			}
			if(INC)
			{
			  INC=0;
			  if((Progmode_para == 23)||(Progmode_para == 33)||(Progmode_para == 34))
			  {
				  if(disp_line1==0)
					 disp_line1=1;
				 else
				   disp_line1=0;
			  }
			}
		}
	}
	LC_display();
}

void Rst_reg_mode(void)
{
	register unsigned char i;
	register unsigned int k;

		for(k=0;k<384;k++)
		    array_lc[k] = 0x00;
		array_lc[masibus]=masibus_ON;
		array_lc[SETUP]=SETUP_ON;

			if(!b.edit)
			{
		         if(disp_line==0  || disp_line==1 || disp_line==2 || disp_line==3)
		             {
		        	    LCD_char_line(0,"ACT-I",1, 5, NO_DP);
						LCD_char_line(1,"ACT-E",1, 5, NO_DP);
						LCD_char_line(2,"RACT-I",1, 6, 0);
						LCD_char_line(3,"RACT-E",1, 6, 0);
		             }
		         if(disp_line==4  || disp_line==5 || disp_line==6 || disp_line==7)
					 {
		        	    LCD_char_line(0,"ENERGY",1, 6, NO_DP);
					    LCD_char_line(1,"HOUR",1, 4, NO_DP);
					    LCD_char_line(2,"PINTR",1, 5, 0);
					    LCD_char_line(3,"LOW-HIGH",1, 8, NO_DP);
					 }
		         if(disp_line==8 || disp_line==9)
					 {
                     #ifndef RTC_CALENDAR
					    LCD_char_line(0,"ALL",1, 3, NO_DP);

                     #else
						 LCD_char_line(0,"MD",1, 2, NO_DP);
		        	     LCD_char_line(1,"ALL",1, 3, NO_DP);
                     #endif
					 }

					if(DN)
					{
						DEC=0;
						disp_line++;
                    #ifdef RTC_CALENDAR
						if(disp_line > 9)
						{
							//Progmode_para = 1;
							disp_line=0;
						}
                     #else
						if(disp_line > 8)
						{
							//Progmode_para = 1;
							disp_line=0;
						}
                    #endif
					}
					if(UP)
					{
						INC=0;
						disp_line--;
						if(disp_line == 255)
						{
                          #ifdef RTC_CALENDAR
							disp_line = 9;
                          #else
							disp_line = 8;
                          #endif
						}
					}

					if(PROG)
					{
						PROG=0;
						b.edit = 1;
						tpr = disp_line;
						disp_line1 = 1;//2
					}
					if(NXT)
					{
						NXT=0;
						b.password_check = 1;
						b.reset_reg_mode = 0;
						password_page = 4;
						disp_line = 2;
					}

				 if(disp_line == 0 || disp_line == 4 || disp_line == 8)
					 array_lc[D24G]=D24G_ON;
				if(disp_line == 1 || disp_line == 5 || disp_line == 9)
					array_lc[D17G]=D17G_ON;
				if(disp_line == 2 || disp_line == 6)
					array_lc[D10G]=D10G_ON;
				if(disp_line == 3 || disp_line == 7)
					array_lc[D1G]=D1G_ON;
			}
		else
		{

			LCD_char_line(0,"RESET",2, 5, 9);
			LCD_char_line(1,"YES",2, 3, 9);
			LCD_char_line(2,"NO",2, 2, 9);

			if(disp_line1 == 1)//2
				array_lc[D17G]=D17G_ON;

			if(disp_line1 == 2)//3
				array_lc[D10G]=D10G_ON;

			if(INC || DEC)
			{
				INC=0;DEC=0;
				if(disp_line1 == 1)	disp_line1 = 2;
				else if(disp_line1 == 2) disp_line1 = 1;
			}
			if(NXT)
			{
				NXT=0;
					b.edit = 0;
					disp_line = tpr;
			}
			if(PROG)
			{
			  PROG=0;
			  if(disp_line1 == 1)
			   {
				switch(disp_line)
				{
					case 0:	//Reset Kwh Import
						WattValue=0.0;
						CalWatt=0.0;
						for(i=0;i<4;i++)
						{
							fp.en.act_import[i]=0.0;
							f_en.Phase.act_import[i]=0;
							uniterngy_act_import[i]=0.0;
							//eeP1WR_eeprom_double((lkwh_R_import + (i * 8)), 0);
						}

							day_act_imp = 0;
							cntr_act_imp = 0;
							fp3.en3.Day_act_import = 0;
							f_en3.Phase3.Day_act_import = 0;
							//eeP1WR_eeprom_float(day_kwh_T_imp,0);
							//eeP1WR_eeprom_float(day_kwh_T_imp_cntr,0 );

						whi_ovcnt=0;
						//eeP1WR_eeprom(OV_WI,whi_ovcnt);
					break;

					case 1:	//Reset Kwh Export
						WattValue=0.0;
						CalWatt=0.0;
						for(i=0;i<4;i++)
						{
							fp.en.act_export[i]=0.0;
							f_en.Phase.act_export[i]=0;
							uniterngy_act_export[i]=0.0;
							//eeP1WR_eeprom_double((lkwh_R_export + (i * 8)), 0);
						}

						  day_act_exp = 0;
						  cntr_act_exp = 0;
						  fp3.en3.Day_act_export = 0;
						  f_en3.Phase3.Day_act_export = 0;
						  //eeP1WR_eeprom_float(day_kwh_T_exp,0);
						 // eeP1WR_eeprom_float(day_kwh_T_exp_cntr,0 );

						whe_ovcnt=0;
						//eeP1WR_eeprom(OV_WE,whe_ovcnt);
					break;

					case 2:	//Reset Kvarh Lag
						WattValue=0.0;
						CalWatt=0.0;
						for(i=0;i<4;i++)
						{
							fp.en.React_lag[i]=0.0;
							f_en.Phase.React_lag[i]=0;
							uniterngy_React_lag[i]=0.0;
							//eeP1WR_eeprom_double((lkvarh_R_import + (i * 8)), 0);
						}

						   day_React_lag = 0;
						   cntr_React_lag = 0;
						   fp3.en3.Day_React_import = 0;
						   f_en3.Phase3.Day_React_import = 0;
						  // eeP1WR_eeprom_float(day_kvarh_T_imp,0);
						  // eeP1WR_eeprom_float(day_kvarh_T_imp_cntr,0 );

						vari_ovcnt=0;
						//eeP1WR_eeprom(OV_VARI,vari_ovcnt);
					break;

					case 3:	//Reset Kvarh Lead
						WattValue=0.0;
						CalWatt=0.0;
						for(i=0;i<4;i++)
						{
							fp.en.React_lead[i]=0.0;
							f_en.Phase.React_lead[i]=0;
							uniterngy_React_lead[i]=0.0;
							//eeP1WR_eeprom_double((lkvarh_R_export + (i * 8)), 0);
						}

						   day_React_lead = 0;
						   cntr_React_lead = 0;
						   fp3.en3.Day_React_export = 0;
						   f_en3.Phase3.Day_React_export = 0;
						   //eeP1WR_eeprom_float(day_kvarh_T_exp,0);
						   //eeP1WR_eeprom_float(day_kvarh_T_exp_cntr,0 );

						vare_ovcnt=0;
						//eeP1WR_eeprom(OV_VARE,vare_ovcnt);
					break;

					case 4:	//Reset All Energy
						//resetallres();//Reset all Regs(Energy)
					break;

					case 5:
						Hour_rst();//Reset ON,LOAD,IDLE hours
					break;

	               case 6:
						P_intr = 0;
						hours.data.P_intr_cnt = 0;
						//eeP1WR_eeprom(SVS,P_intr);
					break;

	               case 7:
	            	   Low_High_value_rst();
					break;

					#ifdef RTC_CALENDAR
					case 8:
						MD_rst();//Reset Max Demand
					break;

					case 9:
						P_intr = 0;
						hours.data.P_intr_cnt = 0;
						//eeP1WR_eeprom(SVS,P_intr);
						//resetallres();//Reset all Regs(Energy)
						Hour_rst();   //Reset ON,LOAD,IDLE hours
						MD_rst();     //Reset Max Demand
						Low_High_value_rst();
					break;
				#else
					case 8:
						P_intr = 0;
						hours.data.P_intr_cnt = 0;
						//eeP1WR_eeprom(SVS,P_intr);
						//resetallres();//Reset all Regs
						Hour_rst();   //Reset ON,LOAD,IDLE hours
						Low_High_value_rst();
					break;
				#endif
				}
				disp_line =tpr;
			}
			else
				disp_line =tpr;
			b.edit = 0;
		}
	}
	 LC_display();
}

void lc_glass_display(unsigned char row, double float_value, unsigned char start_digit, unsigned char total_display_digit)
{
	unsigned char i,dp;
    unsigned long long_value;
    if(float_value==0.0)
    {
    	if(row==3)
    	{
    		start_digit = 6;
    	}
    	else
    	{
    		start_digit = 4;
    	}
    	total_display_digit=3;
    	dp=0;
    }
    else if((float_value>=0)&&(float_value<10))
	{
		dp=0;
		long_value = (unsigned long)(float_value * 100000000.0);
	}
	else if((float_value>=10)&&(float_value<100))
	{
		dp=1;
		long_value = (unsigned long)(float_value * 10000000.0);
	}
	else if((float_value>=100)&&(float_value<1000))
	{
		dp=2;
		long_value = (unsigned long)(float_value * 1000000.0);
	}
	else if((float_value>=1000)&&(float_value<10000))
	{
		dp=3;
		long_value = (unsigned long)(float_value * 100000.0);
	}

	  //float2str(float_value, &Disp_buffer[0]);
	  long_to_array(long_value, 9, &disp[0]);
	 // LCD_char_line(row, &Disp_buffer[0], start_digit, total_display_digit, dp);
	  LCD_char_line(row, &disp[0], start_digit, total_display_digit, dp);
}

void display_message(const char *p,unsigned char k)					//moreover the value of k is 0 or 3
{
	 unsigned char i,j;
	 for(i = 0 ; i < 4 ; i++)
	 {
	  	   j = *p;
		   if(j > 64) j = j - 55;		 //condition for A-Z
		   else if(j > 47) j = j - 48;	 //condition for 0 - 9
		   else if(j == 45) j = j - 9;	 //condition for - sign
		   else if(j == 32) j = j + 5;   //condition for space
		   else if(j == 46) j = j - 7;	 // condition for .
		  	  //else if(j == ) j = j;         //condition for -1  /**/
   	 	  // display_digit[i] = segment1[j];

		     value[k][i]=char_value[j];
		   //P1 =display_digit[segment_counter];
       			p++;
	 }
}

//***********************
void long_to_array(unsigned long value, unsigned char length, unsigned char *array)
{
	 unsigned long temp_int, temp_int1;
//	if(length > 5)
//		length = 5;

	while(length)
	{
		temp_int = (unsigned long)value/(unsigned long)(powf (10, (length-1)));
		temp_int1 = temp_int;
		//*(array + length - 1) =  (unsigned char)(temp_int - (((unsigned int)(temp_int1/10))*10));
		*(array++) =  (unsigned char)(temp_int - (((unsigned long)(temp_int1/10))*10));
		length--;
		//BCD[length] = (unsigned char)(temp_long - (((unsigned int)(temp_long1/10))*10));
	}	// to get ascii add 0x30 to array
}



void decimal_to_array(unsigned int value, unsigned char length, unsigned char *array) 
{
	register unsigned int temp_int, temp_int1;
	if(length > 5)
		length = 5;
	
	while(length)
	{
		temp_int = (unsigned int)value/(unsigned int)(powf (10, (length-1)));
		temp_int1 = temp_int;
		//*(array + length - 1) =  (unsigned char)(temp_int - (((unsigned int)(temp_int1/10))*10));
		*(array++) =  (unsigned char)(temp_int - (((unsigned int)(temp_int1/10))*10));
		length--;
		//BCD[length] = (unsigned char)(temp_long - (((unsigned int)(temp_long1/10))*10)); 
	}	// to get ascii add 0x30 to array
}


unsigned int array_to_decimal(unsigned char *array, unsigned char length)
{
	register unsigned int temp_int;
	temp_int = 0;
	while(length)
	{
		//temp_int += (*(array + length - 1)) * powf (10, (length-1));
		temp_int += (*(array ++)) * powf (10, (length-1));
		length--;
	}	
	return temp_int;
}
void Hour_rst(void)
 {
	ON.HOUR.sec = 0;
	ON.HOUR.min = 0;
	ON.HOUR.hour = 0;
	//eeP1WR_eeprom_float(ON_HOURS, ON.Hours_data);
	sec = 0;

    LOAD.HOUR.sec = 0;
    LOAD.HOUR.min = 0;
    LOAD.HOUR.hour = 0;
    //eeP1WR_eeprom_float(LOAD_HOURS, LOAD.Hours_data);
	sec_load = 0;

	IDLE.HOUR.sec = 0;
	IDLE.HOUR.min = 0;
	IDLE.HOUR.hour = 0;
	//eeP1WR_eeprom_float(IDLE_HOURS, IDLE.Hours_data);

	LOAD_IMP.HOUR.sec = 0;
	LOAD_IMP.HOUR.min = 0;
	LOAD_IMP.HOUR.hour = 0;
	//eeP1WR_eeprom_float(LOAD_IMP_HOURS, LOAD_IMP.Hours_data);

	LOAD_EXP.HOUR.sec = 0;
	LOAD_EXP.HOUR.min = 0;
	LOAD_EXP.HOUR.hour = 0;
	//eeP1WR_eeprom_float(LOAD_EXP_HOURS, LOAD_EXP.Hours_data);
 }

void Low_High_value_rst(void)
{
	 unsigned char ph_num1 = 0,ph_num2 = 0;

	      for(ph_num1=0; ph_num1<3; ph_num1++)
		   {
				fp_peak.en_peak.V_rms_max[ph_num1] = fp.en.V_rms[ph_num1];
				//eeP1WR_eeprom_float((R_Volt_max + (ph_num1 * 4)),fp_peak.en_peak.V_rms_max[ph_num1]);

				fp_peak.en_peak.V_rms_min[ph_num1] = fp.en.V_rms[ph_num1];
				//eeP1WR_eeprom_float((R_Volt_min + (ph_num1 * 4)),fp_peak.en_peak.V_rms_min[ph_num1]);

				fp_peak.en_peak.I_rms_max[ph_num1] = fp.en.I_rms[ph_num1];
				//eeP1WR_eeprom_float((R_Curr_max + (ph_num1 * 4)),fp_peak.en_peak.I_rms_max[ph_num1]);

				fp_peak.en_peak.I_rms_min[ph_num1] = fp.en.I_rms[ph_num1];
				//eeP1WR_eeprom_float((R_Curr_min + (ph_num1 * 4)),fp_peak.en_peak.I_rms_min[ph_num1]);
		   }

		 for(ph_num2=0; ph_num2<4; ph_num2++)
		   {
				 fp_peak.en_peak.PF_max[ph_num2] = fp.en.PF[ph_num2];
				 //eeP1WR_eeprom_float((R_PF_max + (ph_num2 * 4)),fp_peak.en_peak.PF_max[ph_num2]);

				 fp_peak.en_peak.PF_min[ph_num2] = fp.en.PF[ph_num2];
				 //eeP1WR_eeprom_float((R_PF_min + (ph_num2 * 4)),fp_peak.en_peak.PF_min[ph_num2]);
		   }

			fp_peak.en_peak.Sys_P_Active_max = fp.en.P_Active[3];
			//eeP1WR_eeprom_float((T_P_Act_max),fp_peak.en_peak.Sys_P_Active_max);

			fp_peak.en_peak.Sys_P_Active_min = fp.en.P_Active[3];
			//eeP1WR_eeprom_float((T_P_Act_min),fp_peak.en_peak.Sys_P_Active_min);

			fp_peak.en_peak.Sys_P_Reactive_max = fp.en.P_Reactive[3];
			//eeP1WR_eeprom_float((T_P_Ract_max),fp_peak.en_peak.Sys_P_Reactive_max);

			fp_peak.en_peak.Sys_P_Reactive_min = fp.en.P_Reactive[3];
			//eeP1WR_eeprom_float((T_P_Ract_min),fp_peak.en_peak.Sys_P_Reactive_min);

			fp_peak.en_peak.Sys_P_Apparent_max = fp.en.P_Apparent[3];
			//eeP1WR_eeprom_float((T_P_App_max),fp_peak.en_peak.Sys_P_Apparent_max);

			fp_peak.en_peak.Sys_P_Apparent_min = fp.en.P_Apparent[3];
			//eeP1WR_eeprom_float((T_P_App_min),fp_peak.en_peak.Sys_P_Apparent_min);

			fp_peak.en_peak.Frequency_max = fp.en.Frequency[3];
			//eeP1WR_eeprom_float((Freq_max),fp_peak.en_peak.Frequency_max);

			fp_peak.en_peak.Frequency_min = fp.en.Frequency[3];
			//eeP1WR_eeprom_float((Freq_min),fp_peak.en_peak.Frequency_min);
}

void max_min_value_measurement(void)
{
	 uint8_t ph_num1 = 0,ph_num2 = 0;

				   for(ph_num1=0; ph_num1<3; ph_num1++)
				   {

					   if(fp.en.V_rms[ph_num1] > V_creep)
					   {
							if(fp.en.V_rms[ph_num1] > fp_peak.en_peak.V_rms_max[ph_num1])
							{
								fp_peak.en_peak.V_rms_max[ph_num1] = fp.en.V_rms[ph_num1];
								//eeP1WR_eeprom_float((R_Volt_max + (ph_num1 * 4)),fp_peak.en_peak.V_rms_max[ph_num1]);
							}
							if(fp.en.V_rms[ph_num1] < fp_peak.en_peak.V_rms_min[ph_num1])
							{
								fp_peak.en_peak.V_rms_min[ph_num1] = fp.en.V_rms[ph_num1];
								//eeP1WR_eeprom_float((R_Volt_min + (ph_num1 * 4)),fp_peak.en_peak.V_rms_min[ph_num1]);
							}
					   }

					   if(fp.en.I_rms[ph_num1] > I_creep)
					   {
							if(fp.en.I_rms[ph_num1] > fp_peak.en_peak.I_rms_max[ph_num1])
							{
								fp_peak.en_peak.I_rms_max[ph_num1] = fp.en.I_rms[ph_num1];
								//eeP1WR_eeprom_float((R_Curr_max + (ph_num1 * 4)),fp_peak.en_peak.I_rms_max[ph_num1]);
							}
							if(fp.en.I_rms[ph_num1] < fp_peak.en_peak.I_rms_min[ph_num1])
							{
								fp_peak.en_peak.I_rms_min[ph_num1] = fp.en.I_rms[ph_num1];
								//eeP1WR_eeprom_float((R_Curr_min + (ph_num1 * 4)),fp_peak.en_peak.I_rms_min[ph_num1]);
							}
					   }
				   }

				   if(fp.en.V_rms[3] > V_creep)
				   	{
					   if(fp.en.Frequency[3] > fp_peak.en_peak.Frequency_max)
						{
							fp_peak.en_peak.Frequency_max = fp.en.Frequency[3];
							//eeP1WR_eeprom_float((Freq_max),fp_peak.en_peak.Frequency_max);
						}
						if(fp.en.Frequency[3] < fp_peak.en_peak.Frequency_min)
						{
							fp_peak.en_peak.Frequency_min = fp.en.Frequency[3];
							//eeP1WR_eeprom_float((Freq_min),fp_peak.en_peak.Frequency_min);
						}
				   	}

            	   if((fp.en.V_rms[3] > V_creep) && (fp.en.I_rms[3] > I_creep))
            	   {
						if(fp.en.P_Active[3] >= 0.0)
						{
							if(fp.en.P_Active[3] > fp_peak.en_peak.Sys_P_Active_max)
							{
								fp_peak.en_peak.Sys_P_Active_max = fp.en.P_Active[3];
								//eeP1WR_eeprom_float(T_P_Act_max,fp_peak.en_peak.Sys_P_Active_max);
							}
							if(fp.en.P_Active[3] < fp_peak.en_peak.Sys_P_Active_min)
							{
								fp_peak.en_peak.Sys_P_Active_min = fp.en.P_Active[3];
								//eeP1WR_eeprom_float(T_P_Act_min,fp_peak.en_peak.Sys_P_Active_min);
							}
						}
						else
						{
							if(fp.en.P_Active[3] < fp_peak.en_peak.Sys_P_Active_max)
							{
								fp_peak.en_peak.Sys_P_Active_max = fp.en.P_Active[3];
								//eeP1WR_eeprom_float(T_P_Act_max,fp_peak.en_peak.Sys_P_Active_max);
							}
							if(fp.en.P_Active[3] > fp_peak.en_peak.Sys_P_Active_min)
							{
								fp_peak.en_peak.Sys_P_Active_min = fp.en.P_Active[3];
								//eeP1WR_eeprom_float(T_P_Act_min,fp_peak.en_peak.Sys_P_Active_min);
							}
						}

						if(fp.en.P_Reactive[3] >= 0.0)
						{
							if(fp.en.P_Reactive[3] > fp_peak.en_peak.Sys_P_Reactive_max)
							{
								fp_peak.en_peak.Sys_P_Reactive_max = fp.en.P_Reactive[3];
								//eeP1WR_eeprom_float(T_P_Ract_max,fp_peak.en_peak.Sys_P_Reactive_max);
							}
							if(fp.en.P_Reactive[3] < fp_peak.en_peak.Sys_P_Reactive_min)
							{
								fp_peak.en_peak.Sys_P_Reactive_min = fp.en.P_Reactive[3];
								//eeP1WR_eeprom_float(T_P_Ract_min,fp_peak.en_peak.Sys_P_Reactive_min);
							}
						}
						else
						{
							if(fp.en.P_Reactive[3] < fp_peak.en_peak.Sys_P_Reactive_max)
							{
								fp_peak.en_peak.Sys_P_Reactive_max = fp.en.P_Reactive[3];
								//eeP1WR_eeprom_float(T_P_Ract_max,fp_peak.en_peak.Sys_P_Reactive_max);
							}
							if(fp.en.P_Reactive[3] > fp_peak.en_peak.Sys_P_Reactive_min)
							{
								fp_peak.en_peak.Sys_P_Reactive_min = fp.en.P_Reactive[3];
								//eeP1WR_eeprom_float(T_P_Ract_min,fp_peak.en_peak.Sys_P_Reactive_min);
							}
						}

						if(fp.en.P_Apparent[3] > fp_peak.en_peak.Sys_P_Apparent_max)
						{
							fp_peak.en_peak.Sys_P_Apparent_max = fp.en.P_Apparent[3];
							//eeP1WR_eeprom_float(T_P_App_max,fp_peak.en_peak.Sys_P_Apparent_max);
						}
						if(fp.en.P_Apparent[3] < fp_peak.en_peak.Sys_P_Apparent_min)
						{
							fp_peak.en_peak.Sys_P_Apparent_min = fp.en.P_Apparent[3];
							//eeP1WR_eeprom_float(T_P_App_min,fp_peak.en_peak.Sys_P_Apparent_min);
						}
            	   }

            	   for(ph_num2=0; ph_num2<4; ph_num2++)
            	    {
            	      if(fp.en.PF[ph_num2] == 1.0)
						{

						}
						else
						{
							if(fp.en.PF[ph_num2] >= 0)
							{
								if(fp.en.PF[ph_num2] > fp_peak.en_peak.PF_max[ph_num2])
								{
									fp_peak.en_peak.PF_max[ph_num2] = fp.en.PF[ph_num2];
									//eeP1WR_eeprom_float((R_PF_max + (ph_num2 * 4)),fp_peak.en_peak.PF_max[ph_num2]);
								}
								if(fp.en.PF[ph_num2] < fp_peak.en_peak.PF_min[ph_num2])
								{
									fp_peak.en_peak.PF_min[ph_num2] = fp.en.PF[ph_num2];
									//eeP1WR_eeprom_float((R_PF_min + (ph_num2 * 4)),fp_peak.en_peak.PF_min[ph_num2]);
								}
							}
							else
							{
								if(fp.en.PF[ph_num2] < fp_peak.en_peak.PF_max[ph_num2])
								{
									fp_peak.en_peak.PF_max[ph_num2] = fp.en.PF[ph_num2];
									//eeP1WR_eeprom_float((R_PF_max + (ph_num2 * 4)),fp_peak.en_peak.PF_max[ph_num2]);
								}
								if(fp.en.PF[ph_num2] > fp_peak.en_peak.PF_min[ph_num2])
								{
									fp_peak.en_peak.PF_min[ph_num2] = fp.en.PF[ph_num2];
									//eeP1WR_eeprom_float((R_PF_min + (ph_num2 * 4)),fp_peak.en_peak.PF_min[ph_num2]);
								}
							}
						}
            	    }
}

float get_PF_angle(float measurnd)
{
	float angle;
		angle=acos(measurnd);
		angle=angle*57.2957795;  // convert to degree
	return(angle);
}


/*
float get_PF_angle(float measurnd,unsigned int pf_type)
{
	float angle;
	if(pf_type==LAG || pf_type==UNITY)
	{
		if(measurnd>=0)
		{
		angle=acos(measurnd);
		angle=angle*57.2957795;  // convert to degree
		}
		else
		{
			angle=acos(measurnd);
			angle=360-(angle*57.2957795);  // convert to degree
		}
	}
	else if(pf_type==LEAD)
	{
		if(measurnd>=0)
		{
			angle=acos(measurnd);
			angle=360-(angle*57.2957795);  // convert to degree
		}
		else
		{
			angle=acos(measurnd);
			angle=angle*57.2957795;  // convert to degree
		}
	}
	return(angle);
}
*/
//------------------------------------------------------------------------------------------


void LCD_Display_alpha(unsigned int alpha_val, unsigned int digit, unsigned char dp)
{

	register unsigned char i;
	register unsigned int arr_digit;

	arr_digit = (375 - (digit*17));

	for(i=0;i<16;i++)
	{
		if((alpha_val>>i)&(0x0001))
			array_lc[arr_digit]=Alphanumeric_seg[i];

		arr_digit++;
	}
	if(dp)
		array_lc[arr_digit]=Alphanumeric_seg[16];

}

void display_message1(char *p,unsigned char k)					//moreover the value of k is 0 or 3
{
	 register unsigned char i,j, dp;

	 for(i = 0 ; i < 5 ; i++)
	 {
		 if(i==k)
			 dp = 1;
		 else
			 dp = 0;
	  	   j = *p;
	  	   if(j == 104)
	  		   j = j - 66;          // for h
	  	   else if(j == 118)
	  		   j = j - 79;
	  	   else if(j > 64)
	  		   j = j - 55;		 //condition for A-Z
		   else if(j > 47)
			   j = j - 48;	 //condition for 0 - 9
		   else if(j == 45)
			   j = j - 9;	 //condition for - sign
		   else if(j == 32)
			   j = j + 5;   //condition for space
		   //else if(j == 46) j = j - 7;	 // condition for .
		  	  //else if(j == ) j = j;         //condition for -1  /**/
   	 	  // display_digit[i] = segment1[j];

		     //value[k][i]=char_value[j];
		   if(i>=1)
			   LCD_Display_alpha(Alphanumeric_code[j], i, dp);
		   else
		   {
				 LCD_Display_char(char_value[j], i, dp);
		   }

		   //P1 =display_digit[segment_counter];
       			p++;
	 }
}


void LCD_Display_char(unsigned char character_value, unsigned int digit, unsigned char dp)
{

	register unsigned char i;
	register unsigned int arr_digit1;

	arr_digit1 = 375 ;

	for(i=0;i<7;i++)
	{
		if((character_value>>i)&(0x01))
			array_lc[arr_digit1]=character_seg[i];

		arr_digit1++;
	}
	if(dp)
		array_lc[arr_digit1]=character_seg[7];

}
//***************************************************
unsigned char LCD_char_line(unsigned char line, unsigned char *ptr, unsigned char digit, unsigned char nos, unsigned char dp_pos)
{
	// line - it must be 0 to 3
	// *ptr - Unsigned char string (< 7 for line 0,1,2) & (< 9 for line 3)
	// digit - from which location display will start
	// nos  - how much digit you want to write
	// position of DP  - how much digit you want to write

     register unsigned char i, j,char_no;
	 register unsigned int seg_digit, seg_offset;

	 dp_pos += digit;


	if(line == 3)
	{
		seg_offset = 71;
		if((digit + nos) > 9)
			return 0;
	}
	else if(line < 3)
	{
		seg_offset = 252 - (55 * line);
		if((digit + nos) > 7)
			return 0;
	}
	else
		return 0;
	for(j=0;j<nos;j++)
	{
		char_no = *ptr;
		if(char_no > 64) char_no = char_no - 55;		 //condition for A-Z
		else if(char_no > 47) char_no = char_no - 48;	 //condition for 0 - 9
		else if(char_no == 45) char_no = char_no - 9;	 //condition for - sign
		else if(char_no == 32) char_no = char_no + 5;    //condition for space
		else if(char_no == 46) char_no = char_no - 7;	 // condition for .

		seg_digit = (unsigned int)(digit*8);
		seg_digit += seg_offset;

		for(i=0;i<7;i++)
		{
			if((char_value[char_no]>>i)&(0x01))
			{
				if((line == 3)&&(seg_digit >= 127))
					array_lc[seg_digit] = Char_seg_line3_last2[i];
				else if(line % 2)
					array_lc[seg_digit] = Char_seg_line1_3[i];
				else
				    array_lc[seg_digit] = Char_seg_line0_2[i];
			}
			seg_digit++;

		}
		if((line<3)&&(dp_pos < 6)||(line==3)&&(dp_pos < 8))
		{
			if(digit == dp_pos)
			{
				if(line % 2)
					array_lc[seg_digit] = Char_seg_line1_3[7];
				else
					array_lc[seg_digit] = Char_seg_line0_2[7];
			}
		}

		digit++;
		ptr++;
	}
	return 1;
}
void cal_long_value(void)
{
  register unsigned char i,l;

  for(i=0;i<4;i++)
  {

	f_en.Phase.I_rms[i] = (unsigned long)(fp.en.I_rms[i] * 1000.0);
	f_en.Phase.P_Active[i] = (long)fp.en.P_Active[i];                        //chetan unsigned long   26-8-14
	f_en.Phase.P_Apparent[i] = (long)fp.en.P_Apparent[i];                     //chetan unsigned long  26-8-14
	f_en.Phase.P_Reactive[i] = (long)fp.en.P_Reactive[i];                     //chetan unsigned long  26-8-14
	f_en.Phase.V_rms[i] = (unsigned long)(fp.en.V_rms[i]*10.0);
   // fp.en.Frequency[i]=(float)f_en.Phase.Frequency[i]/10.0;
    fp.en.Frequency[i]=(float)f_en.Phase.Frequency[i]/100.0;
    f_en.Phase.PF[i] = (long)(fp.en.PF[i] * 1000.0);                          //chetan unsigned long  26-8-14
    //fp.en.PF[0]=st_eng;
    fp.en.act_import[i]=(float)uniterngy_act_import[i];
    fp.en.act_export[i]=(float)uniterngy_act_export[i];
    fp.en.React_lag[i]=(float)uniterngy_React_lag[i];
    fp.en.React_lead[i]=(float)uniterngy_React_lead[i];
    fp.en.apparent[i]=(float)uniterngy_apparent[i];
    f_en.Phase.act_import[i]=(unsigned long)(fp.en.act_import[i]*10);
    f_en.Phase.act_export[i]=(unsigned long)(fp.en.act_export[i]*10);
    f_en.Phase.React_lag[i]=(unsigned long)(fp.en.React_lag[i]*10);
    f_en.Phase.React_lead[i]=(unsigned long)(fp.en.React_lead[i]*10);
    f_en.Phase.apparent[i]=(unsigned long)(fp.en.apparent[i]*10);

    f_en_peak.Phase_peak.PF_max[i] = (long)(fp_peak.en_peak.PF_max[i] * 1000.0);
    f_en_peak.Phase_peak.PF_min[i] = (long)(fp_peak.en_peak.PF_min[i] * 1000.0);
  }

  for(l=0;l<3;l++)
	{
	  f_en_peak.Phase_peak.V_rms_max[l] = (unsigned long)(fp_peak.en_peak.V_rms_max[l]*10.0);
	  f_en_peak.Phase_peak.V_rms_min[l] = (unsigned long)(fp_peak.en_peak.V_rms_min[l]*10.0);

	  f_en_peak.Phase_peak.I_rms_max[l] = (unsigned long)(fp_peak.en_peak.I_rms_max[l] * 1000.0);
	  f_en_peak.Phase_peak.I_rms_min[l] = (unsigned long)(fp_peak.en_peak.I_rms_min[l] * 1000.0);
	}
	  f_en_peak.Phase_peak.Frequency_max = (unsigned long)(fp_peak.en_peak.Frequency_max*100.0);
	  f_en_peak.Phase_peak.Frequency_min = (unsigned long)(fp_peak.en_peak.Frequency_min*100.0);
	  f_en_peak.Phase_peak.Sys_P_Active_max = (long)fp_peak.en_peak.Sys_P_Active_max;
	  f_en_peak.Phase_peak.Sys_P_Active_min = (long)fp_peak.en_peak.Sys_P_Active_min;
	  f_en_peak.Phase_peak.Sys_P_Reactive_max = (long)fp_peak.en_peak.Sys_P_Reactive_max;
	  f_en_peak.Phase_peak.Sys_P_Active_min = (long)fp_peak.en_peak.Sys_P_Active_min;
	  f_en_peak.Phase_peak.Sys_P_Apparent_max = (long)fp_peak.en_peak.Sys_P_Apparent_max;
	  f_en_peak.Phase_peak.Sys_P_Active_min = (long)fp_peak.en_peak.Sys_P_Active_min;


	  fp3.en3.Day_act_import =(float)day_act_imp;
	  fp3.en3.Day_act_export=(float)day_act_exp;
	  fp3.en3.Day_React_import=(float)day_React_lag;
	  fp3.en3.Day_React_export=(float)day_React_lead;
	  fp3.en3.Day_apparent =(float)day_apparent;
	  f_en3.Phase3.Day_act_import=(unsigned long)(fp3.en3.Day_act_import*10);
	  f_en3.Phase3.Day_act_export=(unsigned long)(fp3.en3.Day_act_export*10);
	  f_en3.Phase3.Day_React_import=(unsigned long)(fp3.en3.Day_React_import*10);
	  f_en3.Phase3.Day_React_export=(unsigned long)(fp3.en3.Day_React_export*10);
	  f_en3.Phase3.Day_apparent=(unsigned long)(fp3.en3.Day_apparent*10);

	  f_en.Phase.Ph_angle[0] = (unsigned long)(fp.en.Ph_angle[0] * 100.0);
	  f_en.Phase.Ph_angle[1] = (unsigned long)(fp.en.Ph_angle[1] * 100.0);
	  f_en.Phase.Ph_angle[2] = (unsigned long)(fp.en.Ph_angle[2] * 100.0);
    Mb.Mbuspara.Sys_Frequency = fp.en.Frequency[3];
  	Mb.Mbuspara.V_rms[0] = fp.en.V_rms[0];
  	Mb.Mbuspara.I_rms[0] = fp.en.I_rms[0];
  	Mb.Mbuspara.V_rms[1] = fp.en.V_rms[1];
  	Mb.Mbuspara.I_rms[1] = fp.en.I_rms[1];
  	Mb.Mbuspara.V_rms[2] = fp.en.V_rms[2];
  	Mb.Mbuspara.I_rms[2] = fp.en.I_rms[2];
  	Mb.Mbuspara.V_rms[3] = fp.en.V_rms[3];
  	Mb.Mbuspara.I_rms[3] = fp.en.I_rms[3];
  	Mb.Mbuspara.Sys_P_Active = fp.en.P_Active[3];
  	Mb.Mbuspara.Sys_P_Reactive = fp.en.P_Reactive[3];
  	Mb.Mbuspara.Sys_P_Apparent = fp.en.P_Apparent[3];
  	Mb.Mbuspara.Sys_act_import = fp.en.act_import[3];
  	Mb.Mbuspara.Sys_act_export = fp.en.act_export[3];
  	Mb.Mbuspara.Sys_React_lag = fp.en.React_lag[3];
  	Mb.Mbuspara.Sys_React_lead = fp.en.React_lead[3];
  	Mb.Mbuspara.Sys_apparent = fp.en.apparent[3];


  	Mb_l.Mbuspara_l.Sys_Frequency = f_en.Phase.Frequency[3];
	Mb_l.Mbuspara_l.V_rms[0] = f_en.Phase.V_rms[0];
	Mb_l.Mbuspara_l.I_rms[0] = f_en.Phase.I_rms[0];
	Mb_l.Mbuspara_l.V_rms[1] = f_en.Phase.V_rms[1];
	Mb_l.Mbuspara_l.I_rms[1] = f_en.Phase.I_rms[1];
	Mb_l.Mbuspara_l.V_rms[2] = f_en.Phase.V_rms[2];
	Mb_l.Mbuspara_l.I_rms[2] = f_en.Phase.I_rms[2];
	Mb_l.Mbuspara_l.V_rms[3] = f_en.Phase.V_rms[3];
	Mb_l.Mbuspara_l.I_rms[3] = f_en.Phase.I_rms[3];
	Mb_l.Mbuspara_l.Sys_P_Active = f_en.Phase.P_Active[3];
	Mb_l.Mbuspara_l.Sys_P_Reactive = f_en.Phase.P_Reactive[3];
	Mb_l.Mbuspara_l.Sys_P_Apparent = f_en.Phase.P_Apparent[3];
	Mb_l.Mbuspara_l.Sys_act_import = f_en.Phase.act_import[3];
	Mb_l.Mbuspara_l.Sys_act_export = f_en.Phase.act_export[3];
	Mb_l.Mbuspara_l.Sys_React_lag = f_en.Phase.React_lag[3];
	Mb_l.Mbuspara_l.Sys_React_lead = f_en.Phase.React_lead[3];
	Mb_l.Mbuspara_l.Sys_apparent = f_en.Phase.apparent[3];

  f_en.Phase.Volt_Unbalance = (unsigned long)(fp.en.Volt_Unbalance * 100.0);
  f_en.Phase.Current_Unbalance = (unsigned long)(fp.en.Current_Unbalance * 100.0);
  f_en.Phase.I_neutral = (unsigned long)(fp.en.I_neutral * 1000.0);

  f_en.Phase.V_RY_rms = (unsigned long)(fp.en.V_RY_rms * 10.0);
  f_en.Phase.V_YB_rms = (unsigned long)(fp.en.V_YB_rms * 10.0);
  f_en.Phase.V_BR_rms = (unsigned long)(fp.en.V_BR_rms * 10.0);

   	#ifdef FFT
       register unsigned char t=0,j,g;
//       for(i=0;i<3;i++)
//	  	 {
//	  		fp.en.V_thd[i] = fft[i][8];
//	  		f_en.Phase.V_thd[i] = (unsigned long)(fp.en.V_thd[i] * 100.0);
//	  		fp.en.I_thd[i] = fft[i+3][8];
//	  		f_en.Phase.I_thd[i] = (unsigned long)(fp.en.I_thd[i] * 100.0);
//	  	 }

       for(g=0;g<3;g++)
	  	{
	  	  for(j=1;j<=8;j++)
	  	  {
            fp1.en1.V_harm[t]=fft[g][j];
			f_en1.Phase1.V_harm[t]=(unsigned long)(fp1.en1.V_harm[t] * 100.0);
			fp1.en1.I_harm[t]=fft[g+3][j];
			f_en1.Phase1.I_harm[t]=(unsigned long)(fp1.en1.I_harm[t] * 100.0);
			t++;
	  	   }
        }
   #endif

    #ifdef RTC_CALENDAR
		f_en.Phase.Max_Demand  = (unsigned long)(fp.en.Max_Demand * 10.0);
		f_en.Phase.Rising_Demand = (unsigned long)(fp.en.Rising_Demand * 10.0);

	#endif

}

void float2str(double value, unsigned char *data)
{
	register unsigned char k1, x;
	register double tempdoub;
	register unsigned long templong, temppow;
	unsigned char bytes;

	//if(bytes > 4)
	//	bytes = 4;
	//if(bytes > 7)
	  bytes = 9;
	if((value > 450000000.000)||(value < -450000000.000))
		value = 0.000;
	x=1;
	temppow=10;
	value += 0.00000006;

	tempdoub=value;
	if(tempdoub<0.0)tempdoub*=(-1.0);
	templong=(long)tempdoub;
	tempdoub-=templong;
	while(templong>=temppow)
	{
		temppow*=10;
		x++;
	}
	data+=x;
//	if(x>4)
//	{
//		x = 5;
//		bytes = 0;
//	}
	for(k1=x;k1>0;k1--)
	{
		data--;
		*data=((templong%10)+0x30);
		templong/=10;
	}
	if(bytes)
	{
		data+=x;
	//	*data='.';
		//data++;

		for(k1=0;k1<bytes;k1++)
		{
			tempdoub*=10;
			x=(unsigned char)tempdoub;
			tempdoub-=x;
			*data=x+0x30;
			data++;
		}
	}
}

