//#ifndef LC_GLASS_H_
#define LC_GLASS_H_
#define SDA1_PORT		1
#define SCL1_PORT		2
#define VAR_LCD			0
#define SLAVE_LC_ADDR_WR 	0x78    //3C
#define SLAVE_LC_ADDR_RD 	0x79    //3D


#define BitSet(A,B)   (A |=  (0x01<<(B)))
#define BitReset(A,B) (A &= ~(0x01<<(B)))
#define BitTrue(A, B) ((A) & (0x01<<(B)))

#define SET_SDA1     BitSet(P10OUT,SDA1_PORT)
#define SET_SCL1     BitSet(P10OUT,SCL1_PORT)
#define RST_SDA1      BitReset(P10OUT,SDA1_PORT)
#define RST_SCL1      BitReset(P10OUT,SCL1_PORT)
#define CONF_SDA1_IP   BitReset(P10DIR,SDA1_PORT)
#define CONF_SDA1_OP   BitSet(P10DIR,SDA1_PORT)
#define GET_SDA1_LVL   BitTrue(P10IN,SDA1_PORT)
#define SET_VAR		   BitSet(P10OUT,VAR_LCD)
#define RST_VAR		   BitReset(P10OUT,VAR_LCD)


#define masibus 					1		//T1
#define masibus_ON 					0x01
#define WARNING 					2		//T2
#define WARNING_ON 					0x02
#define SETUP 						3	//T5
#define SETUP_ON 					0x20
#define PERCENTAGE 					4		//T6
#define PERCENTAGE_ON 					0x08
#define FOURTH_QUADRNT 					5	//T7
#define FOURTH_QUADRNT_ON 					0x08
#define FIRST_QUADRNT 					6	//T8
#define FIRST_QUADRNT_ON 					0x04
#define THIRD_QUADRNT	 				7	//T9
#define THIRD_QUADRNT_ON  					0x10
#define SECOND_QUADRNT	 				8	//T10
#define SECOND_QUADRNT_ON  					0x02
#define K 					9
#define K_ON 					0x40
#define M 					10
#define M_ON 					0x01
#define G 					11
#define G_ON 					0x01
#define I1_per_20 					12		//T14
#define I1_per_20_ON 					0x01
#define I1_per_40  					13		//T15
#define I1_per_40_ON  					0x01
#define I1_per_60					14		//T16
#define I1_per_60_ON 					0x01
#define I1_per_80 					15		//T17
#define I1_per_80_ON 					0x01
#define I1_per_100					16		//T18
#define I1_per_100_ON 					0x01
#define I1_per_120 					17		//T19
#define I1_per_120_ON 					0x02
#define V_1 					18			//T20
#define V_1_ON 					0x02
#define V1_1					19			//T21
#define V1_1_ON 					0x02
#define A_1					20
#define A_1_ON 					0x02
#define r_1 					21			//T23
#define r_1_ON 					0x02
#define h_1 					22			//T24
#define h_1_ON 					0x02
#define I2_per_20 					23		//T25
#define I2_per_20_ON 					0x04
#define I2_per_40 					24		//T26
#define I2_per_40_ON 					0x04
#define I2_per_60					25		//T27
#define I2_per_60_ON 					0x04
#define I2_per_80  					26		//T28
#define I2_per_80_ON 					0x04
#define I2_per_100 					27		//T29
#define I2_per_100_ON 					0x04
#define I2_per_120					28		//T30
#define I2_per_120_ON 					0x04
#define V_2	 				29
#define V_2_ON 					0x08
#define V1_2 					30			//T32
#define V1_2_ON 					0x08
#define A_2					31
#define A_2_ON 					0x08
#define r_2 					32			//T34
#define r_2_ON 					0x08
#define h_2  					33			//T35
#define h_2_ON					0x08
#define I3_per_20  					34		//T36
#define I3_per_20_ON  					0x10
#define I3_per_40  					35		//T37
#define I3_per_40_ON					0x10
#define I3_per_60					36		//T38
#define I3_per_60_ON 					0x10
#define I3_per_80	 				37		//T39
#define I3_per_80_ON 					0x10
#define I3_per_100	 				38		//T40
#define I3_per_100_ON 					0x10
#define I3_per_120					39		//T41
#define I3_per_120_ON 					0x08
#define V_3 					40			//T42
#define V_3_ON 					0x20
#define V1_3 					41			//T43
#define V1_3_ON 					0x20
#define A_3 					42			//T44
#define A_3_ON 					0x20
#define r_3 					43			//T45
#define r_3_ON 					0x20
#define h_3	 				44
#define h_3_ON 					0x20
#define Hz	 				45
#define Hz_ON 					0x40
#define Gen 					46			//T48
#define Gen_ON 					0x80
#define MAINS	 				47			//T49
#define MAINS_ON 					0x40
#define V_4	 				48
#define V_4_ON 					0x80
#define V1_4       					49		//T51
#define V1_4_ON 					0x40
#define A_4     					50		//T52
#define A_4_ON 					0x40
#define r_4        					51		//T53
#define r_4_ON 					0x40
#define h_4       					52		//T54
#define h_4_ON 					0x80
#define Line1	        				53	//T55
#define Line1_ON 					0x04
#define three_P3W       					54	//T56
#define three_P3W_ON 					0x02
#define Lag1      					55		//T57
#define Lag1_ON 					0x08
#define Lead1     					56		//T58
#define Lead1_ON 					0x10
#define Line2			        		57	//T59
#define Line2_ON			 		0x20
#define Lag2				 	58			//T60
#define Lag2_ON 					0x40
#define Lead2			         		59	//T61
#define Lead2_ON			 		0x80
#define time				     	60		//T62
#define time_ON 					0x01
#define Line3  				       	61		//T63
#define Line3_ON 					0x04
#define Lag3					62			//T64
#define Lag3_ON 					0x08
#define Lead3				       	63		//T65
#define Lead3_ON 					0x10
#define Imp					64			//T66
#define Imp_ON 					0x20
#define Exp					65			//T67
#define Exp_ON 					0x40
#define Lag4     					66		//T68
#define Lag4_ON					0x80
#define Lead4   			    		67	//T69
#define Lead4_ON 					0x40
#define Sum 					68			//T70
#define Sum_ON				 	0x80
#define Avg  				      	69		//T71
#define Avg_ON 					0x20
#define N    					70			//T72
#define N_ON 					0x10
#define D1A		        			71
#define D1A_ON 					0x10
#define D1B		        			72
#define D1B_ON 					0x10
#define D1C		        			73
#define D1C_ON 					0x40
#define D1D		        			74
#define D1D_ON 					0x80
#define D1E		        			75
#define D1E_ON 					0x40
#define D1F		       			76
#define D1F_ON 					0x20
#define D1G		        			77
#define D1G_ON 					0x20
#define D1P		       				78
#define D1P_ON 					0x80		//P1
#define D2A		        			79
#define D2A_ON 					0x10
#define D2B		        			80
#define D2B_ON 					0x10
#define D2C		        			81
#define D2C_ON 					0x40
#define D2D		        			82
#define D2D_ON 					0x80
#define D2E		        			83
#define D2E_ON 					0x40
#define D2F		        			84
#define D2F_ON 					0x20
#define D2G		        			85
#define D2G_ON 					0x20
#define D2P		        			86
#define D2P_ON 					0x80		//P2
#define D3A		        			87
#define D3A_ON 					0x10
#define D3B		        			88
#define D3B_ON 					0x10
#define D3C		       			89
#define D3C_ON 					0x40
#define D3D		        			90
#define D3D_ON 					0x80
#define D3E		        			91
#define D3E_ON 					0x40
#define D3F		        			92
#define D3F_ON 					0x20
#define D3G		        			93
#define D3G_ON 					0x20
#define D3P		        			94
#define D3P_ON 					0x80		//P3
#define D4A		        			95
#define D4A_ON 					0x10
#define D4B		        			96
#define D4B_ON 					0x10
#define D4C		        			97
#define D4C_ON 					0x40
#define D4D		        			98
#define D4D_ON 					0x80
#define D4E		        			99
#define D4E_ON 					0x40
#define D4F		       			100
#define D4F_ON 					0x20
#define D4G		       			101
#define D4G_ON 					0x20
#define D4P		        			102		//P4
#define D4P_ON	        				0x80
#define D5A		      		 	103
#define D5A_ON 					0x10
#define D5B		      			104
#define D5B_ON 					0x10
#define D5C		        		105
#define D5C_ON 					0x40
#define D5D		     			106
#define D5D_ON 					0x80
#define D5E		       			107
#define D5E_ON 					0x40
#define D5F		       			108
#define D5F_ON 					0x20
#define D5G		      		 	109
#define D5G_ON 					0x20
#define D5P		    	  		110
#define D5P_ON 					0x80
#define D6A		       			111			//P6
#define D6A_ON 					0x10
#define D6B		        			112
#define D6B_ON 					0x10
#define D6C		        			113
#define D6C_ON 					0x40
#define D6D		        			114
#define D6D_ON 					0x80
#define D6E		       			115
#define D6E_ON 					0x40
#define D6F		        			116
#define D6F_ON 					0x20
#define D6G		       			117
#define D6G_ON 					0x20
#define D6P		       			118
#define D6P_ON 					0x80
#define D7A		        			119
#define D7A_ON 					0x10
#define D7B		        			120
#define D7B_ON 					0x10
#define D7C		        			121
#define D7C_ON 					0x40
#define D7D		        			122
#define D7D_ON 					0x80
#define D7E		        			123
#define D7E_ON 					0x40
#define D7F		        			124
#define D7F_ON 					0x20
#define D7G		        			125
#define D7G_ON 					0x20
#define D7P		      		 	126			//P7
#define D7P_ON 					0x80
#define D8A		    		 	127
#define D8A_ON 					0x01
#define D8B		    		   	128
#define D8B_ON 					0x02
#define D8C		  			129
#define D8C_ON 					0x10
#define D8D		  			130
#define D8D_ON 					0x40
#define D8E		  			131
#define D8E_ON 					0x20
#define D8F		      			132
#define D8F_ON 					0x04
#define D8G		      			133
#define D8G_ON 					0x08
#define D8P		 			134
#define D8P_ON 					0x80
#define D9A		      			135
#define D9A_ON 					0x01
#define D9B		        			136
#define D9B_ON 					0x02
#define D9C		        			137
#define D9C_ON 					0x10
#define D9D		        			138
#define D9D_ON 					0x40
#define D9E		       			139
#define D9E_ON 					0x20
#define D9F		       			140
#define D9F_ON 					0x04
#define D9G		        			141
#define D9G_ON 					0x08
#define D10A		       			142
#define D10A_ON 					0x01
#define D10B		    			143
#define D10B_ON 					0x01
#define D10C		    			144
#define D10C_ON 					0x04
#define D10D		    			145
#define D10D_ON 					0x08
#define D10E		    			146
#define D10E_ON 					0x04
#define D10F		    			147
#define D10F_ON 					0x02
#define D10G		    			148
#define D10G_ON 					0x02
#define D10P	        				149	//P10
#define D10P_ON 					0x08
#define D11A		   			150
#define D11A_ON 					0x01
#define D11B		    			151
#define D11B_ON 					0x01
#define D11C		    			152
#define D11C_ON 					0x04
#define D11D		   			153
#define D11D_ON 					0x08
#define D11E		    			154
#define D11E_ON 					0x04
#define D11F		    			155
#define D11F_ON 					0x02
#define D11G		    			156
#define D11G_ON 					0x02
#define D11P		   			157
#define D11P_ON 					0x08
#define D12A		   			158
#define D12A_ON 					0x01
#define D12B	        				159
#define D12B_ON 					0x01
#define D12C		    			160
#define D12C_ON 					0x04
#define D12D		    			161
#define D12D_ON 					0x08
#define D12E		    			162
#define D12E_ON 					0x04
#define D12F		    			163
#define D12F_ON 					0x02
#define D12G		    			164
#define D12G_ON 					0x02
#define D12P		   			165
#define D12P_ON 					0x08		//P12
#define D13A		    			166
#define D13A_ON 					0x01
#define D13B		 			167
#define D13B_ON 					0x01
#define D13C		   			168
#define D13C_ON 					0x04
#define D13D		   			169
#define D13D_ON 					0x08
#define D13E		    			170
#define D13E_ON 					0x04
#define D13F		    			171
#define D13F_ON 					0x02
#define D13G		    			172
#define D13G_ON 					0x02
#define D13P	       			 	173
#define D13P_ON 					0x08
#define D14A		   			174
#define D14A_ON 					0x01
#define D14B		    			175
#define D14B_ON 					0x01
#define D14C		   			176
#define D14C_ON 					0x04
#define D14D		   			177
#define D14D_ON 					0x08
#define D14E		    			178
#define D14E_ON 					0x04
#define D14F		  			179
#define D14F_ON 					0x02
#define D14G		    			180
#define D14G_ON 					0x02
#define D14P	       			 	181
#define D14P_ON 					0x08
#define D15A		    			182
#define D15A_ON 					0x01
#define D15B		 			183
#define D15B_ON 					0x01
#define D15C		 			184
#define D15C_ON 					0x04
#define D15D		   	 		185
#define D15D_ON 					0x08
#define D15E		    			186
#define D15E_ON 					0x04
#define D15F		    			187
#define D15F_ON 					0x02
#define D15G		    			188
#define D15G_ON 					0x02
#define D15P	        				189
#define D15P_ON 					0x08
#define D16A		   			190
#define D16A_ON 					0x01
#define D16B		   			191
#define D16B_ON 					0x01
#define D16C		    			192
#define D16C_ON 					0x04
#define D16D		    			193
#define D16D_ON 					0x08
#define D16E		   			194
#define D16E_ON 					0x04
#define D16F		    			195
#define D16F_ON 					0x02
#define D16G		    			196
#define D16G_ON 					0x02
#define D17A		    			197
#define D17A_ON 					0x10
#define D17B		  			198
#define D17B_ON 					0x10
#define D17C		   			199
#define D17C_ON 					0x40
#define D17D		    			200
#define D17D_ON 					0x80
#define D17E		    			201
#define D17E_ON 					0x40
#define D17F		    			202
#define D17F_ON 					0x20
#define D17G		    			203
#define D17G_ON 					0x20
#define D17P	        				204
#define D17P_ON 					0x80
#define D18A		    			205
#define D18A_ON 					0x10
#define D18B		    			206
#define D18B_ON 					0x10
#define D18C		    			207
#define D18C_ON 					0x40
#define D18D		   			208
#define D18D_ON 					0x80
#define D18E		   			209
#define D18E_ON 					0x40
#define D18F		    			210
#define D18F_ON 					0x20
#define D18G		    			211
#define D18G_ON 					0x20
#define D18P	        				212
#define D18P_ON 					0x80
#define D19A		    			213
#define D19A_ON 					0x10
#define D19B		   			214
#define D19B_ON 					0x10
#define D19C		  			215
#define D19C_ON 					0x40
#define D19D		   			216
#define D19D_ON 					0x80
#define D19E		    			217
#define D19E_ON 					0x40
#define D19F		    			218
#define D19F_ON 					0x20
#define D19G		    			219
#define D19G_ON 					0x20
#define D19P	        				220
#define D19P_ON 					0x80
#define D20A				    	221
#define D20A_ON 					0x10
#define D20B		    			222
#define D20B_ON 					0x10
#define D20C		    			223
#define D20C_ON 					0x40
#define D20D		    			224
#define D20D_ON 					0x80
#define D20E		    			225
#define D20E_ON 					0x40
#define D20F		    			226
#define D20F_ON 					0x20
#define D20G		  			227
#define D20G_ON 					0x20
#define D20P	     			   	228
#define D20P_ON 					0x80
#define D21A		   			229
#define D21A_ON 					0x10
#define D21B		    			230
#define D21B_ON 					0x10
#define D21C		    			231
#define D21C_ON 					0x40
#define D21D		    			232
#define D21D_ON 					0x80
#define D21E		    			233
#define D21E_ON 					0x40
#define D21F		    			234
#define D21F_ON 					0x20
#define D21G		    			235
#define D21G_ON 					0x20
#define D21P	        				236
#define D21P_ON 					0x80
#define D22A		    			237
#define D22A_ON 					0x10
#define D22B		    			238
#define D22B_ON 					0x10
#define D22C		    			239
#define D22C_ON 					0x40
#define D22D		   			240
#define D22D_ON 					0x80
#define D22E		    			241
#define D22E_ON 					0x40
#define D22F		    			242
#define D22F_ON 					0x20
#define D22G		    			243
#define D22G_ON 					0x20
#define D22P	   			     	244
#define D22P_ON 					0x80
#define D23A		   			245
#define D23A_ON 					0x10
#define D23B		  			246
#define D23B_ON 					0x10
#define D23C		    			247
#define D23C_ON 					0x40
#define D23D		    			248
#define D23D_ON 					0x80
#define D23E		    			249
#define D23E_ON 					0x40
#define D23F		    			250
#define D23F_ON 					0x20
#define D23G		    			251
#define D23G_ON 					0x20
#define D24A		    			252
#define D24A_ON 					0x01
#define D24B		    			253
#define D24B_ON 					0x01
#define D24C		    			254
#define D24C_ON 					0x04
#define D24D		    			255
#define D24D_ON 					0x08
#define D24E		   			256
#define D24E_ON 					0x04
#define D24F		    			257
#define D24F_ON 					0x02
#define D24G		    			258
#define D24G_ON 					0x02
#define D24P	   			     	259
#define D24P_ON 					0x08
#define D25A		    			260
#define D25A_ON 					0x01
#define D25B		    			261
#define D25B_ON 					0x01
#define D25C		    			262
#define D25C_ON 					0x04
#define D25D		    			263
#define D25D_ON 					0x08
#define D25E		   			    264
#define D25E_ON 					0x04
#define D25F		    			265
#define D25F_ON 					0x02
#define D25G		    			266
#define D25G_ON 					0x02
#define D25P	   			     	267
#define D25P_ON 					0x08
#define D26A		    			268
#define D26A_ON 					0x01
#define D26B		    			269
#define D26B_ON 					0x01
#define D26C		    			270
#define D26C_ON 					0x04
#define D26D		    			271
#define D26D_ON 					0x08
#define D26E		   			272
#define D26E_ON 					0x04
#define D26F		    			273
#define D26F_ON 					0x02
#define D26G		    			274
#define D26G_ON 					0x02
#define D26P	   			     	275
#define D26P_ON 					0x08
#define D27A		    			276
#define D27A_ON 					0x01
#define D27B		    			277
#define D27B_ON 					0x01
#define D27C		    			278
#define D27C_ON 					0x04
#define D27D		    			279
#define D27D_ON 					0x08
#define D27E		   			280
#define D27E_ON 					0x04
#define D27F		    			281
#define D27F_ON 					0x02
#define D27G		    			282
#define D27G_ON 					0x02
#define D27P	   			     	283
#define D27P_ON 					0x08
#define D28A		    			284
#define D28A_ON 					0x01
#define D28B		    			285
#define D28B_ON 					0x01
#define D28C		    			286
#define D28C_ON 					0x04
#define D28D		    			287
#define D28D_ON 					0x08
#define D28E		   			288
#define D28E_ON 					0x04
#define D28F		    			289
#define D28F_ON 					0x02
#define D28G		    			290
#define D28G_ON 					0x02
#define D28P	   			     	291
#define D28P_ON 					0x08
#define D29A		    			292
#define D29A_ON 					0x01
#define D29B		    			293
#define D29B_ON 					0x01
#define D29C		    			294
#define D29C_ON 					0x04
#define D29D		    			295
#define D29D_ON 					0x08
#define D29E		   			296
#define D29E_ON 					0x04
#define D29F		    			297
#define D29F_ON 					0x02
#define D29G		    			298
#define D29G_ON 					0x02
#define D29P	   			     	299
#define D29P_ON 					0x08
#define D30A		    			300
#define D30A_ON 					0x01
#define D30B		    			301
#define D30B_ON 					0x01
#define D30C		    			302
#define D30C_ON 					0x04
#define D30D		    			303
#define D30D_ON 					0x08
#define D30E		   			304
#define D30E_ON 					0x04
#define D30F		    			305
#define D30F_ON 					0x02
#define D30G		    			306
#define D30G_ON 					0x02

#define D31A		    			307
#define D31A_ON 					0x01
#define D31B		    			308
#define D31B_ON 					0x08
#define D31C		    			309
#define D31C_ON 					0x40
#define D31D		    			310
#define D31D_ON 					0x80
#define D31E		    			311
#define D31E_ON 					0x40
#define D31F		    			312
#define D31F_ON 					0x04
#define D31G		    			313
#define D31G_ON 					0x08
#define D31H		    			314
#define D31H_ON 					0x02
#define D31I		    			315
#define D31I_ON 					0x02
#define D31J		    			316
#define D31J_ON 					0x04
#define D31K		    			317
#define D31K_ON 					0x20
#define D31L		    			318
#define D31L_ON 					0x10
#define D31M		   			319
#define D31M_ON 					0x20
#define D31N		    			320
#define D31N_ON 					0x01
#define D31O		    			321
#define D31O_ON 					0x80
#define D31Q		    			322
#define D31Q_ON 					0x10
#define D31P		    			323
#define D31P_ON 					0x80

#define D32A		    			324
#define D32A_ON 					0x01
#define D32B		    			325
#define D32B_ON 					0x08
#define D32C		    			326
#define D32C_ON 					0x40
#define D32D		    			327
#define D32D_ON 					0x80
#define D32E		    			328
#define D32E_ON 					0x40
#define D32F		    			329
#define D32F_ON 					0x04
#define D32G		    			330
#define D32G_ON 					0x08
#define D32H		    			331
#define D32H_ON 					0x02
#define D32I		    			332
#define D32I_ON 					0x02
#define D32J		    			333
#define D32J_ON 					0x04
#define D32K		    			334
#define D32K_ON 					0x20
#define D32L		    			335
#define D32L_ON 					0x10
#define D32M		   			    336
#define D32M_ON 					0x20
#define D32N		    			337
#define D32N_ON 					0x01
#define D32O		    			338
#define D32O_ON 					0x80
#define D32Q		    			339
#define D32Q_ON 					0x10
#define D32P		    			340
#define D32P_ON 					0x80

#define D33A		    			341
#define D33A_ON 					0x01
#define D33B		    			342
#define D33B_ON 					0x08
#define D33C		    			343
#define D33C_ON 					0x40
#define D33D		    			344
#define D33D_ON 					0x80
#define D33E		    			345
#define D33E_ON 					0x40
#define D33F		    			346
#define D33F_ON 					0x04
#define D33G		    			347
#define D33G_ON 					0x08
#define D33H		    			348
#define D33H_ON 					0x02
#define D33I		    			349
#define D33I_ON 					0x02
#define D33J		    			350
#define D33J_ON 					0x04
#define D33K		    			351
#define D33K_ON 					0x20
#define D33L		    			352
#define D33L_ON 					0x10
#define D33M		   			353
#define D33M_ON 					0x20
#define D33N		    			354
#define D33N_ON 					0x01
#define D33O		    			355
#define D33O_ON 					0x80
#define D33Q		    			356
#define D33Q_ON 					0x10
#define D33P		    			357
#define D33P_ON 					0x80

#define D34A		    			358
#define D34A_ON 					0x01
#define D34B		    			359
#define D34B_ON 					0x08
#define D34C		    			360
#define D34C_ON 					0x40
#define D34D		    			361
#define D34D_ON 					0x80
#define D34E		    			362
#define D34E_ON 					0x40
#define D34F		    			363
#define D34F_ON 					0x04
#define D34G		    			364
#define D34G_ON 					0x08
#define D34H		    			365
#define D34H_ON 					0x02
#define D34I		    			366
#define D34I_ON 					0x02
#define D34J		    			367
#define D34J_ON 					0x04
#define D34K		    			368
#define D34K_ON 					0x20
#define D34L		    			369
#define D34L_ON 					0x10
#define D34M		   			370
#define D34M_ON 					0x20
#define D34N		    			371
#define D34N_ON 					0x01
#define D34O		    			372
#define D34O_ON 					0x80
#define D34Q		    			373
#define D34Q_ON 					0x10
#define D34P		    			374
#define D34P_ON 					0x80

#define D35A		    		 	375
#define D35A_ON 					0x01
#define D35B		    		   	376
#define D35B_ON 					0x02
#define D35C		  			377
#define D35C_ON 					0x10
#define D35D		  			378
#define D35D_ON 					0x40
#define D35E		  			379
#define D35E_ON 					0x20
#define D35F		      			380
#define D35F_ON 					0x04
#define D35G		      			381
#define D35G_ON 					0x08
#define D35P		 			382
#define D35P_ON 					0x80

#define D9P					383
#define D9P_ON					0x80
#define D16P					384
#define D16P_ON					0x08



extern void I2C1_Start_Bit(void);
extern void I2C1_Stop_Bit(void);
extern unsigned char I2C1_Get_Ack(void);
extern unsigned char DataSendToI2C1(unsigned char rdata);
extern unsigned char DataRecvFromI2C1(void);

extern void CallNop1(void);
extern void I2C1_Delay(void);
	//void Read_LC(unsigned char addr, unsigned char* ptr_data, unsigned char bytes);
	//void Write_LC(unsigned char addr, unsigned char* ptr_data, unsigned char bytes);
extern void write_LC(unsigned char* ptr_data, unsigned char bytes);

extern unsigned char LC_init_data[55], LC_data[55];


//#endif /* LC_GLASS_H_ */
