/* ============================================================================ */
/* Copyright (c) 2014, Texas Instruments Incorporated                           */
/*  All rights reserved.                                                        */
/*                                                                              */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  *  Redistributions of source code must retain the above copyright           */
/*     notice, this list of conditions and the following disclaimer.            */
/*                                                                              */
/*  *  Redistributions in binary form must reproduce the above copyright        */
/*     notice, this list of conditions and the following disclaimer in the      */
/*     documentation and/or other materials provided with the distribution.     */
/*                                                                              */
/*  *  Neither the name of Texas Instruments Incorporated nor the names of      */
/*     its contributors may be used to endorse or promote products derived      */
/*     from this software without specific prior written permission.            */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" */
/*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,       */
/*  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR      */
/*  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR            */
/*  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,       */
/*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         */
/*  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; */
/*  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,    */
/*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR     */
/*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,              */
/*  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                          */
/* ============================================================================ */

/******************************************************************************/
/* lnk_msp430f47177.cmd - LINKER COMMAND FILE FOR LINKING MSP430F47177 PROGRAMS     */
/*                                                                            */
/*   Usage:  lnk430 <obj files...>    -o <out file> -m <map file> lnk.cmd     */
/*           cl430  <src files...> -z -o <out file> -m <map file> lnk.cmd     */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/* These linker options are for command line linking only.  For IDE linking,  */
/* you should set your linker options in Project Properties                   */
/* -c                                               LINK USING C CONVENTIONS  */
/* -stack  0x0100                                   SOFTWARE STACK SIZE       */
/* -heap   0x0100                                   HEAP AREA SIZE            */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/* Version: 1.127                                                             */
/*----------------------------------------------------------------------------*/

/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* RAM Memory Addresses */
__RAM_Start = 0x1100;                 /* RAM Start */
__RAM_End = 0x30FF;                     /* RAM End */
    /* RAM shared between App and Bootloader, must be reserved */
    PassWd = 0x1100;                 /* Password sent by App to force boot  mode */
    StatCtrl = 0x1102;             /* Status and Control  byte used by Comm */
    CI_State_Machine = 0x1103;         /*  State machine variable used by Comm */
    CI_Callback_ptr = 0x1104;   /* Pointer to Comm callback structure */
    /* Unreserved RAM used for Bootloader or App purposes */
    _NonReserved_RAM_Start = 0x1108; /* Non-reserved RAM */

/* Flash memory addresses */
__Flash_Start = 0x3100;             /* Start of Application area */
   /* Reserved Flash locations for Bootloader Area */
    __Boot_Start = 0xFA00;         /* Boot flash */
    __Boot_Reset = 0xFFFE;                          /* Boot reset vector */
    __Boot_VectorTable = 0xFFC0;      /* Boot vector table */
    __Boot_SharedCallbacks_Len = 6; /* Length of shared callbacks (2 calls =4B(msp430) or 8B(msp430x) */
    __Boot_SharedCallbacks = 0xFFBA; /* Start of Shared callbacks */
     _BOOT_APPVECTOR = __Boot_SharedCallbacks;       /* Definition for application table             */
    _Appl_Proxy_Vector_Start = 0xF982; /* Proxy interrupt table */
    /* Reserved Flash locations for Application Area */
MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    // RAM from _NonReserved_RAM_Start - __RAM_End
    RAM                     : origin = 0x1108, length = 0x1FF8
   // USBRAM                  : origin = 0x0200, length = 0x800
	// Info Mem Sections
	INFOA                   : origin = 0x10C0, length = 0x40
    INFOB                   : origin = 0x1080, length = 0x40
    INFOC                   : origin = 0x1040, length = 0x40
    INFOD                   : origin = 0x1000, length = 0x40
    // Flash from _App_Start -> (APP_PROXY_VECTORS-1)
    FLASH                   : origin = 0x3102, length = 0xC880
    //FLASH2                  : origin = 0x10000, length = 0xA000
    // Interrupt Proxy table from  _App_Proxy_Vector_Start->(RESET-1)
    APP_PROXY_VECTORS       : origin = 0xF982, length = 124
    // App reset from _App_Reset_Vector
    RESET                   : origin = 0xF9FE, length = 0x0002    //0xF9FE
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

    .text:_isr  : {}  > FLASH            /* Code ISRs                         */
    //#ifndef __LARGE_CODE_MODEL__
       .text       : {} >> FLASH               /* CODE                 */
   // #else
     //   .text       : {} >> FLASH | FLASH2      /* CODE                 */
   // #endif

        .cinit      : {} > FLASH        /* INITIALIZATION TABLES*/
   // #ifndef __LARGE_DATA_MODEL__
        .const      : {} >> FLASH       /* CONSTANT DATA        */
   // #else
     //   .const      : {} >> FLASH2 | FLASH    /* CONSTANT DATA        */
  //  #endif

    .cio        : {} > RAM                /* C I/O BUFFER                      */

	.infoA     : {} > INFOA              /* MSP430 INFO FLASH Memory segments */
    .infoB     : {} > INFOB
    .infoC     : {} > INFOC
    .infoD     : {} > INFOD

    .APP_PROXY_VECTORS : {} > APP_PROXY_VECTORS /* INTERRUPT PROXY TABLE            */
   /* .int00       : {}               > INT00
    .int01       : {}               > INT01
    .int02       : {}               > INT02
    .int03       : {}               > INT03
    .int04       : {}               > INT04
    .int05       : {}               > INT05
    .int06       : {}               > INT06
    .int07       : {}               > INT07
    .int08       : {}               > INT08
    .int09       : {}               > INT09
    .int10       : {}               > INT10
    .int11       : {}               > INT11
    .int12       : {}               > INT12
    .int13       : {}               > INT13
    .int14       : {}               > INT14
    DMA          : { * ( .int15 ) } > INT15 type = VECT_INIT
    BASICTIMER   : { * ( .int16 ) } > INT16 type = VECT_INIT
    PORT2        : { * ( .int17 ) } > INT17 type = VECT_INIT
    USCIAB1TX    : { * ( .int18 ) } > INT18 type = VECT_INIT
    USCIAB1RX    : { * ( .int19 ) } > INT19 type = VECT_INIT
    PORT1        : { * ( .int20 ) } > INT20 type = VECT_INIT
    TIMERA1      : { * ( .int21 ) } > INT21 type = VECT_INIT
    TIMERA0      : { * ( .int22 ) } > INT22 type = VECT_INIT
    SD16A        : { * ( .int23 ) } > INT23 type = VECT_INIT
    USCIAB0TX    : { * ( .int24 ) } > INT24 type = VECT_INIT
    USCIAB0RX    : { * ( .int25 ) } > INT25 type = VECT_INIT
    WDT          : { * ( .int26 ) } > INT26 type = VECT_INIT
    COMPARATORA   : { * ( .int27 ) } > INT27 type = VECT_INIT
    TIMERB1      : { * ( .int28 ) } > INT28 type = VECT_INIT
    TIMERB0      : { * ( .int29 ) } > INT29 type = VECT_INIT
    NMI          : { * ( .int30 ) } > INT30 type = VECT_INIT*/
    .reset       : {}               > RESET  /* MSP430 RESET VECTOR         */ 
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l msp430f47177.cmd

