
#define NOP     __nop

#include "command.h"
#include "TI_MSPBoot_MI_16Bit.h"
#include "Var.h"
#include "TI_MSPBoot_AppMgr.h"
//#include "b_cg_serial.h"
//#include "fsl.h"
//#include "fsl_types.h"
//#include "r_cg_wdt.h"

void reset(void);
extern unsigned char rx_data;	
extern unsigned char GetByte ( unsigned long timeout );
extern unsigned char GetDelayTimerStatus (void);
extern _Bool DelayTimerUnderFlowFlag;
void Blank_Check_Error(unsigned char );
void RunCommandHandler (void);
extern unsigned char XmodemDownloadAndProgramFlash (unsigned long FlashAddress);
const unsigned char first_user_flash_address[]="0003100";    //0004000

const unsigned char strforBoot[]="  by Bootloader Instruction";
const unsigned char strforPoweron[]=" by power on reset";
const unsigned char str_intro1[]="         ||||||||||||||      |||||||||||         ||||          ||||";
const unsigned char str_intro2[]="      ||||||||||||||      |||||    |||||       ||||          ||||";
const unsigned char str_intro3[]="     ||||||||||||||      |||||       |||||     ||||          ||||";
const unsigned char str_intro4[]="    ||||                |||||         |||||   ||||          ||||";
const unsigned char str_intro5[]="   ||||                |||||        |||||    ||||          ||||";
const unsigned char str_intro6[]="   ||||||||||||       |||||      |||||     ||||          ||||";
const unsigned char str_intro7[]="     |||||||||||||    |||||     |||||      ||||        ||||";
const unsigned char str_intro8[]="       ||||||||||||| ||||||||||||||           |||||||||";

const unsigned char str1[]="CDU Bootloader Main Menu v1.0.1";
const unsigned char str2[]="----------------------------------";
const unsigned char str3[]="1......Blank Check User Area";
const unsigned char str4[]="2......Erase User Area";
const unsigned char str5[]="3......Erase User Block";
const unsigned char str6[]="4......Program Flash via XModem Download";
const unsigned char str7[]="5......Start User Program";
const unsigned char str8[]=">";
	
const unsigned char c1_str1[]="Blank checking user area...";
const unsigned char c1_str2[]="Block: ";
const unsigned char c1_str3[]=": NOT blank";
const unsigned char c1_str4[]=": BLANK";

const unsigned char c2_str1[]="Really erase ALL user blocks (Y/N)?";
const unsigned char c2_str2[]="Timed out waiting for response";
const unsigned char c2_str3[]="Comms error";
const unsigned char c2_str4[]="All blocks erase cancelled";
const unsigned char c2_str5[]="Erasing block ";
const unsigned char c2_str6[]=" >> ";
const unsigned char c2_str7[]=": Erasing success!!";
const unsigned char c2_str8[]="Erasing of block: ";
const unsigned char c2_str9[]=": FAILED";
const unsigned char c2_str10[]="All user blocks erased";

const unsigned char c3_str1[]="Enter block no to be erased as 2-digit number e.g. 08";
const unsigned char c3_str2[]=">D'";
const unsigned char c3_str3[]="Timed out waiting for block number...";
const unsigned char c3_str4[]="Invalid block number";
const unsigned char c3_str5[]="Erase block (Y/N)?";
const unsigned char c3_str6[]="Timed out waiting for confirmation";
const unsigned char c3_str7[]="Erasing of block ";
const unsigned char c3_str8[]="PASSED ";
const unsigned char c3_str9[]=" FAILED ";
const unsigned char c3_str10[]="Block erase cancelled";

const unsigned char c4_str1[]="Download to address 0x";
const unsigned char c4_str2[]=" (Y/N)?";
const unsigned char c4_str3[]="Timed out waiting for confirmation...";
const unsigned char c4_str4[]="Program Flash (Y/N)?";
const unsigned char c4_str5[]="Timed out waiting for response";
//unsigned char c4_str6[]="Comms error";
const unsigned char c4_str7[]="Flash programming cancelled";
const unsigned char c4_str8[]="Start XModem download...";
const unsigned char c4_str9[]="Xmodem Executing...";
const unsigned char c4_str10[]="Xmodem Execution end!!!";
const unsigned char c4_str11[]="Timeout";
const unsigned char c4_str12[]="Download OK";
const unsigned char c4_str13[]="Flash program FAIL";
const unsigned char c4_str14[]="NOT WORKING";

const unsigned char c5_str1[]="Run user program (Y/N)?";
const unsigned char c5_str2[]="Timed out waiting for response";
//unsigned char c5_str3[]="Comms error";
const unsigned char c5_str4[]="Run user program request cancelled";
const unsigned char c5_str5[]="Running user program...";
const unsigned char c5_str6[]="Invalid user reset address.  Staying put.";

//
// functionality of this handler will be dependent on the communication hardware interface
//
/**************************************/
/*    RunCommandHandler function      */
/**************************************/

void RunCommandHandler (void)
{
	unsigned int *ptr;
	pt2FunctionErase fp;		// function pointer used to call target program
	unsigned char rx_status;

	// check if bootloader should run by detecting activity for a 3 seconds on the
	// UART channel

	rx_status = GetByte (200); //180
	if ( rx_status == TIMEOUT )
	{
	    //P9OUT &= ~BIT7;
		// timed out - call target app if reset vector is valid
		ptr = (unsigned int *)( FIRST_USER_FLASH_ADDR );
		if ( *ptr != 0xffff )
		{
			// call user program and never return
			SendString("Timeout Occurs.... Running User Code");
			fp = (pt2FunctionErase) ptr;
			fp( 0, 0);
		}
		else
		{
			SendString("Timeout Occurs.... Please Enter Valid File");

			delay(2000);
			//reset();// return back to main
			BOOT_RESET();
			return;
		}


		ptr = (unsigned int *)( FIRST_USER_FLASH_ADDR );

		if ( *ptr != 0xffff )
		{
			SendString(c5_str5);// "Running user program..." );
			//R_UART1_Stop_B();
			// call user program and never return
			fp = (pt2FunctionErase) ptr;
			fp( 0, 0);
		}
		else
		{
			// invalid user reset address
			SendString(c5_str6);// "Invalid user reset address.  Staying put." );
			return;
		}
	}
	else
	{
		// serial activity detected
		// clear buffer
		// loop until we get a timeout
		//PurgeComms( 50 );
		// display menu

 		ShowMenu();

		while (1)
		{
			// timeout is not important as we know we have a byte waiting for us
			rx_status = GetByte (30); //100
			if ( rx_status == OK )
			{
				switch ( rx_data )
				{
					case '1':
						//Command_1();		// blank check
					break;

					case '2':
						Command_2();		// erase all user flash blocks
					break;

					case '3':
						//Command_3();		// erase specific flash block
					break;

					case '4':
						Command_4();		// xmodem download to flash memory
					break;

					case '5':
						Command_5();		// run target application
					break;
					default:
						ShowMenu();
						break;
				}
			}
		//R_WDT_Restart();
		}
	}
 }

/**************************************/
/*    ShowMenu function               */
/**************************************/
void ShowMenu (void)
{

	SendLFCR();
	SendLFCR();
	SendString("\n \r");
	SendString(str_intro1);
	SendString("\n \r");
	SendString(str_intro2);
	SendString("\n \r");
	SendString(str_intro3);
	SendString("\n \r");
	SendString(str_intro4);
	SendString("\n \r");
	SendString(str_intro5);
	SendString("\n \r");
	SendString(str_intro6);
	SendString("\n \r");
	SendString(str_intro7);
	SendString("\n \r");
	SendString(str_intro8);
	SendString("\n \r");
	SendString(str1);//"RL78G1x Bootloader Main Menu v1.0" );
	SendLFCR();
	SendString(str2);// "----------------------------------"  );
	SendLFCR();
	SendLFCR();
	SendString(str3);// "1......Blank Check User Area" );
	SendLFCR();
	SendLFCR();
	SendString(str4);// "2......Erase User Area" );
	SendLFCR();
	SendLFCR();
	SendString(str5);// "3......Erase User Block" );
	SendLFCR();
	SendLFCR();
	SendString(str6);// "4......Program Flash via XModem Download" );
	SendLFCR();
	SendLFCR();
	SendString(str7);// "5......Start User Program" );
	SendLFCR();
	SendLFCR();
	SendByte(str8);// '>' );
}

/**************************************/
/*    Command_1 function              */
/**************************************/
//void Command_1 (void)
//{
//	// blank check the user flash area
//	// the user flash area is specified as the range of addresses between
//	// 'FIRST_USER_FLASH_ADDR' and 'LAST_USER_FLASH_ADDR' inclusive
//	// these values are specified in 'command.h'
//
//
//	read_datum *address;
//	unsigned char blk,tmp,tmp2;
//	fsl_u08 my_fsl_status;
//
//	SendLFCR();
//	SendString(c1_str1);// "Blank checking user area..." );
//
//	FSL_Open();
//	FSL_PrepareFunctions();
//
//	for(blk=Start_Block; blk<No_Of_Blocks; blk++)
//	{
//		SendLFCR();
//		SendString(c1_str2);// "Block: " );
//		if(blk < 9)
//		{
//			SendByte(blk+48);
//		}
//		else
//		{
//			tmp = blk / 100;
//			SendByte(tmp+48);
//			tmp = blk % 100;
//
//			tmp = tmp / 10;
//			SendByte(tmp+48);
//			tmp = blk % 10;
//			SendByte(tmp+48);
//		}
//		my_fsl_status = FSL_BlankCheck(blk);			//Blank Check if Device is not blank issue Erase Command
//		if(my_fsl_status != FSL_OK)
//		{
//			SendString(c1_str3);// ": NOT blank" );
//			//Blank_Check_Error(blk);
//			MyErrorHandler();
//		}
//		else
//		{
//			NOP();
//			SendString(c1_str4);// ": BLANK" );
//		}
//	}
//
//	SendLFCR();
//	FSL_Close();
//
//}

/**************************************/
/*    Command_2 function              */
/**************************************/
void Command_2 (void)
{
	// erase all user flash blocks
	// the first flash block to be erased is 'FIRST_USER_FLASH_BLK' and the last
	// flash block to be erased is 'NO_OF_FLASH_BLOCKS' - 1
	// these values are defined in 'command.h' and 'flash_header.h'

	unsigned char uc,tmp1,tmp2;
	unsigned char Status;
	unsigned char rxstatus;
	unsigned char my_fsl_status;


	SendLFCR();

	SendString(c2_str1);// "Really erase ALL user blocks (Y/N)?" );
	rxstatus = GetByte( 100 );
	SendByte( rx_data );
	if ( rxstatus == TIMEOUT )
	{
		SendLFCR();
		SendString(c2_str2);// "Timed out waiting for response" );
		return;
	}
//	else if ( rxstatus == ERROR )
//	{
//		SendLFCR();
//		SendString(c2_str3);// "Comms error" );
//		return;
//	}
	else if ( !( ( rx_data == 'y' ) || ( rx_data == 'Y' ) ) )
	{
		SendLFCR();
		SendString(c2_str4);// "All blocks erase cancelled" );
		return;
	}
	SendLFCR();
	SendString(c2_str5);// "Erasing block " );
	my_fsl_status = TI_MSPBoot_MI_EraseApp();

	if(my_fsl_status == RESPONSE_APP_OK)
	    SendString(c2_str7);//": Erasing success!!");
	else
	{
	    SendString(c2_str9);// ": FAILED" );
	    SendLFCR();
        MyErrorHandler();
        return;
	}


//	FSL_Open();
//	FSL_PrepareFunctions();
//	for( uc=Start_Block; uc< No_Of_Blocks - 1; uc++ )
//	{
//		SendLFCR();
//		SendString(c2_str5);// "Erasing block " );
//		if(uc < 9){
//			SendByte(uc+48);
//		}else{
//			tmp1 = uc / 100;
//			SendByte(tmp1+48);
//			tmp1 = uc % 100;
//
//			tmp1 = tmp1 / 10;
//			SendByte(tmp1+48);
//			tmp2 = uc % 10;
//			SendByte(tmp2+48);
//		}
//		SendString (c2_str6);// " >> " );
//		// call the erase function with the block to be erased and a dummy value (0)
//
//		my_fsl_status = FSL_Erase(uc);
//		while(my_fsl_status == FSL_BUSY)
//		{
//			my_fsl_status = FSL_StatusCheck();
//			R_WDT_Restart();
//		}
//
//
//		if(my_fsl_status == FSL_OK){
//			/*if(uc < 9){
//				SendByte(uc+48);
//			}else{
//				SendByte(tmp1+48);
//				SendByte(tmp2+48);
//			}*/
//			SendString(c2_str7);//": Erasing success!!");
//
//
//		}else if(my_fsl_status != FSL_OK){
//			SendString(c2_str8);// "Erasing of block: " );
//			/*if(uc < 9){
//				SendByte(uc+48);
//			}else{
//				SendByte(tmp1+48);
//				SendByte(tmp2+48);
//			}*/
//			SendString(c2_str9);// ": FAILED" );
//			SendLFCR();
//			MyErrorHandler();
//			return;
//		}
//
//
//	}
//	FSL_Close();
	SendLFCR();

	SendString(c2_str10);// "All user blocks erased" );
}

/**************************************/
/*    Command_3 function              */
/**************************************/
//void Command_3 (void)
//{
//	// erase the specified flash block
//	unsigned char status,tmp,tmpblknm[2];
//	int tmpblk,BlockNum, Count;
//	fsl_u08 my_fsl_status;
//
//	BlockNum = 0;
//
//	SendLFCR();
//	SendString(c3_str1);// "Enter block no to be erased as 2-digit number e.g. 08" );
//	SendLFCR();
//	SendString(c3_str2);// ">D'" );
//
//	for(tmp=0;tmp<2;tmp++){
//		status = GetByte( 100 );
//		tmpblknm[tmp] = rx_data;
//		SendByte( tmpblknm[tmp] );
//		if ( status == TIMEOUT )
//		{
//			SendLFCR();
//			SendString(c3_str3);// "Timed out waiting for block number..." );
//			return;
//		}else
//			tmpblk = tmpblknm[0] - 48;
//	}
//	tmpblk = tmpblk*10;
//	tmpblk = tmpblk+(tmpblknm[1] - 48);
//	//SendByte( (tmpblk/10)+48 );
//	//SendByte( (tmpblk%10)+48 );
//	BlockNum = tmpblk;
//	if ( BlockNum > No_Of_Blocks)
//	{
//		SendLFCR();
//		SendString(c3_str4);// "Invalid block number" );
//		return;
//	}
//
//	SendLFCR();
//	SendString(c3_str5);// "Erase block (Y/N)?" );
//	status = GetByte( 100 );
//	if(status == OK)
//		SendByte( rx_data);
//
//	if ( status == TIMEOUT )
//	{
//		SendLFCR();
//		SendString(c3_str6);// "Timed out waiting for confirmation" );
//		return;
//	}
//	else if (  ( rx_data== 'y' ) || ( rx_data == 'Y' ) )
//	{
//		// call the erase function with the block to be erased and a dummy value (0)
//		//Count = BlockErase ( BlockNum, 0 );
//		FSL_Open();
//		FSL_PrepareFunctions();
//		my_fsl_status = FSL_Erase(BlockNum);
//		while(my_fsl_status == FSL_BUSY)
//		{
//			my_fsl_status = FSL_StatusCheck();
//			R_WDT_Restart();
//		}
//		if(my_fsl_status != FSL_OK)
//		MyErrorHandler();
//
//		SendLFCR();
//		SendString(c3_str7);// "Erasing of block " );
//		SendByte( (BlockNum/10) + 48 );
//		SendByte( (BlockNum%10) + 48 );
//		if ( my_fsl_status == FSL_OK )
//		{
//			SendString(c3_str8);// " PASSED " );
//		}
//		else
//		{
//			SendString(c3_str9);// " FAILED " );
//		}
//		FSL_Close();
//		return;
//	}
//	else
//	{
//		SendLFCR();
//		SendString(c3_str10);// "Block erase cancelled" );
//		FSL_Close();
//		return;
//	}
//}

/**************************************/
/*    Command_4 function              */
/**************************************/
void Command_4 (void)
{
    // download data using xmodem and program into flash
    unsigned char Status, Shift;
	volatile unsigned long Address, ul;
	unsigned char rxstatus;




	// suggest download address as the first user flash address as usually this will be the case
	SendLFCR();
	SendString(c4_str1);// "Download to address 0x" );
	SendString(first_user_flash_address);// FIRST_USER_FL_ADDR_TXT );
	SendString(c4_str2);// " (Y/N)?" );
	rxstatus = GetByte( 100 );
	SendByte( rx_data );
	SendLFCR();
	if (rxstatus == TIMEOUT )
	{
		SendLFCR();
		SendString(c4_str3);// "Timed out waiting for confirmation..." );
		return;
	}
	else if (  ( rx_data == 'y' ) || ( rx_data == 'Y' ) )
	{
		Address = FIRST_USER_FLASH_ADDR;
	}
	/*else
	{
		SendString( "Enter Flash memory base address as a 32-bit hex value e.g. AABBCCDD" );

		Address = 0;
		Shift = 28;

		SendLFCR();
		SendString( ">H'" );
		for (Status=0; Status<8; Status++)
		{
			c2s.us = GetByte( 10000 );
			if ( c2s.uc[0] == TIMEOUT )
			{
				SendLFCR();
				SendString( "Timed out waiting for address..." );
				return;
			}
			else if ( c2s.uc[0] == ERROR )
			{
				SendLFCR();
				SendString( "Comms error" );
				return;
			}
			else
			{
				if ( !isxdigit( c2s.uc[1] ) )
				{
					SendLFCR();
					SendString( "Invalid character" );
					return;
				}
				SendByte( c2s.uc[1] );
				c2s.uc[1] = toupper( c2s.uc[1] );
				// convert ASCII number to hexadecimal value
				c2s.uc[1] =  isdigit( c2s.uc[1] ) ? c2s.uc[1] - 48 : c2s.uc[1] - 55;
				ul = (unsigned long) c2s.uc[1];
				ul = ul << Shift;
				Address |= ul;
				Shift -= 4;
			}
		}

		SendLFCR();
	}*/



	SendString(c4_str4);// "Program Flash (Y/N)?" );
	rxstatus = GetByte( 100 );
	SendByte( rx_data );
	if ( rxstatus == TIMEOUT )
	{
		SendLFCR();
		SendString(c4_str5);// "Timed out waiting for response" );
		return;
	}
//	else if ( rxstatus == ERROR )
//	{
//		SendLFCR();
//		SendString(c2_str3);// "Comms error" );
//		return;
//	}
	else if ( !( ( rx_data == 'y' ) || ( rx_data == 'Y' ) ) )
	{
		SendLFCR();
		SendString(c4_str7);// "Flash programming cancelled" );
		return;
	}
	SendLFCR();
	SendString(c4_str8);// "Start XModem download..." );
	SendLFCR();
	SendString(c4_str9);// "Xmodem Executing..." );
	// start xmodem download and program the flash with the downloaded data
	Status = XmodemDownloadAndProgramFlash( Address );
	SendLFCR();
	SendString(c4_str10);// "Xmodem Execution end!!!" );
	if ( Status == XM_TIMEOUT )
		SendString(c4_str11);// "Timeout" );
	else if ( Status == XM_OK )
	{
		SendString(c4_str12);// "Download OK" );

	}
	else if ( Status == XM_PROG_FAIL )
		SendString(c4_str13);// "Flash program FAIL" );
	else SendString(c4_str14);//"NOT WORKING");

	SendLFCR();
	//c FSL_Close();
//	PurgeComms( 100 );
}

/**************************************/
/*    Command_5 function              */
/**************************************/
void Command_5 (void)
{
	// call the target application
	unsigned char rxstatus;
	unsigned int *ptr;
	pt2FunctionErase fp;

	SendLFCR();
	SendString(c5_str1);// "Run user program (Y/N)?" );
	rxstatus = GetByte( 10000 );
	SendByte( rx_data );
	if ( rxstatus == TIMEOUT )
	{
		SendLFCR();
		SendString(c5_str2);// "Timed out waiting for response" );
		return;
	}
//	else if ( rxstatus == ERROR )
//	{
//		SendLFCR();
//		SendString(c2_str3);// "Comms error" );
//		return;
//	}
	else if ( !( ( rx_data == 'y' ) || ( rx_data == 'Y' ) ) )
	{
		SendLFCR();
		SendString(c5_str4);// "Run user program request cancelled" );
		return;
	}

	SendLFCR();

	// run user program
	// check user reset address is not all erased
	//TI_MSPBoot_AppMgr_JumpToApp();
	ptr = (unsigned int *)( FIRST_USER_FLASH_ADDR );

	if ( *ptr != 0xffff )
	{
		SendString(c5_str5);// "Running user program..." );
		//R_UART1_Stop_B();
		// call user program and never return
		fp = (pt2FunctionErase) ptr;
		fp( 0, 0);
	}
	else
	{
		// invalid user reset address
		SendString(c5_str6);// "Invalid user reset address.  Staying put." );
		return;
	}
}

void reset(void)
{

    static const unsigned char illegalInstruction = 0xFF;

    void (*dummy) (void) = (void (*)(void))&illegalInstruction;

    dummy();


}
