#include "Var.h"
#include "CommonAPI.h"
//#include "r_cg_cgc.h"
//#include "fsl.h"
//#include "fsl_types.h"
#include "command.h"

//#include "r_cg_wdt.h"


unsigned int i;
unsigned char rec_val;
const unsigned char intro_str[64]="RL78/G13 UART (115200 bps) BOOT LOADER Programming...";
unsigned char tmpr;
unsigned char rx_data;	
volatile unsigned long tick_count;
unsigned char err_flag1,err_flag2,err_flag3;
unsigned char status;

extern _Bool DelayTimerUnderFlowFlag;
  
unsigned char Data_Clear[9] = {27, 91, 50, 74, 0, 27, 91, 72, 0}; 

void MyErrorHandler(void)
{
	//NOP();
	delay(100);
}
unsigned char ReadByte(void)
{      
	//while(SRIF1 == 0)R_WDT_Restart();			//Wait until a byte is received
	//SRIF1 = 0;
	while(UCA0STAT & UCBUSY != 0);
	return (UCA0RXBUF);
}
void SendByte ( unsigned char b )
{
	tx_enable;
	//delay(5);
	/*SRIF1 = 0;
	TXD1	= b;
	while(STIF1 == 0)R_WDT_Restart();			//Wait until buffer becomes empty
	STIF1 = 0;	*/
	/*IFG2 &= ~UCA0RXIFG;
	UCA0TXBUF	= b;
	while (UCA0TXIFG == 0);
	IFG2 &= ~UCA0TXIFG;*/

	while (!(IFG2&UCA0TXIFG));
		UCA0TXBUF	= b;

	//c NOP();
	delay(100);
	rx_enable;
	//delay(5);
}
unsigned char RxByteWaiting(void)
{

//	if(timer_A_flag)   //TMF03 CCTL0 & CCIFG
//	{
//
//    	 	DelayTimerUnderFlowFlag = 1;
//    	 	timer_A_flag = 0;//CCTL0 &= ~CCIFG;
//    	 	CCTL0 &= ~CCIFG;
//    	 	//R_TAU0_Channel3_Stop();
//
//    	 	TACCTL0 &= ~CCIE;
//
//	}
	if(IFG2 & UCA0RXIFG)  //SRIF1
	{
		tmpr = 1;
		//c NOP();
	}
	else
	{

		tmpr = 0;
		//c NOP();

	}

        //c NOP();
	return(tmpr);
}
//unsigned char TxByteEmpty ( void )
//{
//	//
//	// returns 1 - if the transmit register is empty
//	// returns 0 - if the transmit register is not empty
//	//
//	unsigned char tmp;
//	if( STIF1 == 0 )
//	{
//		tmp = 0;
//	}
//	else
//	{
//		tmp = 1;
//	}
//
//	return tmp;
//}
//
unsigned char GetByte ( unsigned long timeout )
{

	//	timeout = time in ms for which to timeout the data reception
	//
	//	returns a 16-bit value
	//	upper (msb) byte contains status info
	//	lower (lsb) byte contains the data received from the SCI channel
	//
	//	status:
	//	OK
	//	ERROR
	//	TIMEOUT
	//

    //P9OUT |= BIT7;
	tick_count = (unsigned long) timeout ;/// MS_PER_TIMER_COMPARE_MATCH;
	//c SRIF1 = 0;
	IFG2 &= ~UCA0RXIFG;
	//R_TAU0_Create();
	//c R_TAU0_Channel3_Start();
	CCTL0 &= ~CCIFG;
	TACCTL0 = CCIE;

	// wait for a byte to arrive
	while ( ( RxByteWaiting() == 0 ) && (tick_count!=0) )
	{

	    if(timer_A_flag)
	    {
	        --tick_count;
	        timer_A_flag=0;
	    }


//	    if (GetDelayTimerStatus())
//		{
//
//		    //C R_TAU0_Channel3_Stop();
//			// TACCTL0 &= ~CCIE;
//			if ( --tick_count )
//			{
//				//C R_TAU0_Channel3_Start();
//
//				TACCTL0 = CCIE;
//
//			}
//		}

		//c R_WDT_Restart();
	}

	if ( RxByteWaiting() == 1 )
	{

	    // read error flags and data
//		err_flag1 = (UCA0STAT & UCFE);
//        err_flag2 = (UCA0STAT & UCOE);
//        err_flag3 = (UCA0STAT & UCPE);
//		// check for errors
//		// Rx error
//		if((err_flag1)||(err_flag2)||(err_flag3))
//		{	                                 //Error
//			status = ERROR;
//		}
//		else
//		{
			// no Rx error
			rx_data = UCA0RXBUF;
			status = OK;
//		}
	}
	else
	{
	    //P9OUT ^= BIT7;
	    status = TIMEOUT;
	}

	return (status);
}
unsigned char GetDelayTimerStatus (void)
{
	if ( DelayTimerUnderFlowFlag == 1 )
	{
		//c NOP();

		DelayTimerUnderFlowFlag=0;
		return (1);

	}
	else
	{
		//c NOP();
		return (0);
	}
}
unsigned char PurgeComms(unsigned long timeout)
{
	unsigned char err_flag;

	do {
		err_flag = GetByte( timeout );
		//c R_WDT_Restart();
		return(err_flag);

	} while( (err_flag != TIMEOUT) && (err_flag != ERROR) );

}
void SendLFCR(void)
{
	SendByte(LINEFEED);
	SendByte(CARRIAGE_RETURN);
}
void SendString(unsigned char *str)
{
	unsigned short us;
	tx_enable;

	us = 0;
	while ( str[us] != 0 )
	{
		//SendByte ( (unsigned char) str[us] );
		
		//SRIF1 = 0;
		//UCA0TXBUF	= (unsigned char) str[us];
		//while(STIF1 == 0) R_WDT_Restart();			//Wait until buffer becomes empty
		//STIF1 = 0;

		/*IFG2 &= ~UCA0RXIFG;
		UCA0TXBUF	= (unsigned char) str[us];
		while (UCA0TXIFG == 0);
		IFG2 &= ~UCA0TXIFG;*/

		while (!(IFG2&UCA0TXIFG));
			UCA0TXBUF	= (unsigned char) str[us];

		delay(100);
		//c NOP();
		us++;
		
		//c R_WDT_Restart();
	}
	rx_enable;

}

void delay(int dh)
{
	unsigned char j;
	while(dh>0)
	{	
		for(j=0;j<10;j++);
		dh--;
		
	}
}

//void RunToUserCode(void)
//{
//	__far unsigned int *ptr;
//	pt2FunctionErase fp;		// function pointer used to call target program
//	unsigned char rx_status;
//	SendLFCR();
//
//	// run user program
//	// check user reset address is not all erased
//	ptr = (__far unsigned int *)( FIRST_USER_FLASH_ADDR );
//
//	if ( *ptr != 0xffff )
//	{
//		SendString(c5_str5);// "Running user program..." );
//		// call user program and never return
//		fp = (pt2FunctionErase) ptr;
//		fp( 0, 0);
//	}
//	else
//	{
//		// invalid user reset address
//		SendString(c5_str6);// "Invalid user reset address.  Staying put." );
//		return;
//	}
//}
//
//uint8_t checkuserCodeArea(void)
//{
//	__far unsigned int *ptr;
//	pt2FunctionErase fp;		// function pointer used to call target program
//	unsigned char rx_status;
//
//
//	// run user program
//	// check user reset address is not all erased
//	ptr = (__far unsigned int *)( FIRST_USER_FLASH_ADDR );
//
//	if ( *ptr != 0xffff )
//		rx_status = NOTEMPTY;
//	else
//		rx_status = EMPTY;
//
//	return rx_status;
//
//		ptr = (__far unsigned int *)( FIRST_USER_FLASH_ADDR );
//}
//
//uint8_t checkResetSource(void)
//{
//	uint8_t rx_status;
//	if((b_resf && 0x80) == 1)
//		rx_status = BY_ILLEGAL_INST;
//	else
//		rx_status = BY_POWER_ON_RESET;
//
//	return rx_status ;
//}

void RunToBootloaderCode(void)
{
	//__near fsl_write_t my_fsl_write_str;


	//unsigned char *fsl_data_buffer_u08;


	//fsl_u08 my_fsl_status;
	//fsl_descriptor_t fsl_descr;
	unsigned char us_c;
	
	for(us_c=0;us_c<9;us_c++)
	{
		SendByte(Data_Clear[us_c]);	
	}
	SendLFCR();

	SendString("MCU Reset...");
	SendLFCR();
	SendString("Reset");
	/*if((b_resf && 0x80) == 1)
		SendString(strforBoot);
	else
		SendString(strforPoweron);*/
	SendString("\n \r");
	SendString("CDU FG(115200 bps) Bootloader Programming...");// "RL78/D1x UART (19.2 Kbps) BOOT LOADER Programming..." );
	SendLFCR();
	SendString("Press any key to continue to bootloader menu, ");
	SendLFCR();
	SendString("otherwise wait for 1min to run user code...");// "RL78/D1x UART (19.2 Kbps) BOOT LOADER Programming..." );
	//fsl_descr.fsl_flash_voltage_u08 = 0x00;
	//fsl_descr.fsl_frequency_u08 = 0x14;
	//fsl_descr.fsl_auto_status_check_u08 = 0x01;

	//my_fsl_status = FSL_Init((__far fsl_descriptor_t*)&fsl_descr);
	//if(my_fsl_status != FSL_OK)
	//MyErrorHandler();
	SendLFCR();
	RunCommandHandler();
}
