/*
 * Var.h
 *
 *  Created on: Jul 22, 2019
 *      Author: chetana
 */

#ifndef VAR_H_
#define VAR_H_
#include <msp430x471x7.h>
#include "stdint.h"

#define tx_enable	P7OUT |= BIT2;
#define rx_enable	P7OUT &= ~BIT2;

#define MS_PER_TIMER_COMPARE_MATCH 	1
#define OK			0
#define ERROR			1
#define TIMEOUT			2
#define LINEFEED 		10
#define CARRIAGE_RETURN 	13

#define SOH			0x01
#define EOT			0x04
#define ACK			0x06
#define	NAK			0x15
#define CAN			0x18

#define XM_OK			0x00
#define XM_ADDRESS_ERROR	0x01
#define XM_COMMS_ERROR		0x02
#define XM_TIMEOUT		0x04
#define XM_PROG_FAIL		0x08
#define RESPONSE_APP_OK                 (0x00)  /*! Command processed OK    */

#define PROG_PASS		0x00

#define PROG_FAIL		0x02

#define Start_Block 		16
#define No_Of_Blocks		128 //230

extern unsigned char Peripherals_Check_Timeout,Peripheral_Fail[10];

typedef unsigned short read_datum;

extern unsigned char timer_A_flag;
void SendLFCR(void);

void SendByte(unsigned char a);
void MyErrorHandler(void);
void SendString(unsigned char *);
void delay(int dh);
//void Timer_A (void);
void m_assign_vectors(void);
void m_tau0_channel3_interrupt(void);
extern uint8_t CI_CMD_Rx_Data_Block(uint32_t addr, uint8_t *data, uint8_t len);
#endif /* VAR_H_ */
