/******************************************************************************/
/* LINKER COMMAND FILE FOR MSPBoot BOOTLOADER USING MSP430G2553  */
/* File generated with MSPBoot_linkergen_Flash.pl on 08-01-2017 */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* The following definitions can be changed to customize the memory map for a different device
 *   or other adjustments
 *  Note that the changes should match the definitions used in MEMORY and SECTIONS
 *
 */
/* RAM Memory Addresses */
__RAM_Start = 0x1100;                 /* RAM Start */
__RAM_End = 0x30FF;                     /* RAM End */
    /* RAM shared between App and Bootloader, must be reserved */
    PassWd = 0x1100;                 /* Password sent by App to force boot  mode */
    StatCtrl = 0x1102;             /* Status and Control  byte used by Comm */
    CI_State_Machine = 0x1103;         /*  State machine variable used by Comm */
    CI_Callback_ptr = 0x1104;   /* Pointer to Comm callback structure */
    /* Unreserved RAM used for Bootloader or App purposes */
    _NonReserved_RAM_Start = 0x1108; /* Non-reserved RAM */

/* Flash memory addresses */
_Appl_Start = 0x3100;             /* Start of Application area */
_Appl_End = 0xD7FF;                 /* End of Application area */
_Flex_Start = 0x10000;             /* Start of flex space (app or download, project-dependent) */
_Flex_End = 0x19FFF;                 /* End of flex space (app or download, project-dependent) */

    /* Reserved Flash locations for Bootloader Area */
    __Boot_Start = 0xD800;         /* Boot flash */
    __Boot_Reset = 0xFFFE;                          /* Boot reset vector */
    __Boot_VectorTable = 0xFFC0;      /* Boot vector table */
    __Boot_SharedCallbacks_Len = 6; /* Length of shared callbacks (2 calls =4B(msp430) or 8B(msp430x) */
    __Boot_SharedCallbacks = 0xFFBA; /* Start of Shared callbacks */
    _Appl_Proxy_Vector_Start = 0xD782; /* Proxy interrupt table */
    /* Reserved Flash locations for Application Area */
    _Appl_Checksum = (_Appl_Start);                   /* CRC16 of Application */
    _Appl_Start_Memory = (_Appl_Start+2);                 /* Application Area */
    _Appl_CRC_Size1 = (_Appl_End - _Appl_Start_Memory +1);         /* Number of bytes in lower memory calculated for CRC */
    _Appl_CRC_Size2 = (_Flex_End - _Flex_Start + 1); /* Number of bytes in upper memory calculated for CRC */
    _Appl_Reset_Vector = (__Boot_Start - 2);

    /* MEMORY definition, adjust based on definitions above */
MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    // RAM from _NonReserved_RAM_Start - __RAM_End
    RAM                     : origin = 0x1108, length = 0x1FF8
    // Flash from __Boot_Start -( __Boot_SharedCallbacks or INT_VECTOR_TABLE)
    FLASH                   : origin = 0xD800, length = 0x27BA
    // Shared callbacks from __Boot_SharedCallbacks + Len (when used)
    BOOT_SHARED_CALLBACKS   : origin = 0xFFBA, length = 6
    // Boot vector Table from __Boot_VectorTable- __Boot_Reset
    INT_VECTOR_TABLE        : origin = 0xFFC0, length = 0x003E     //0x003E
    //INT00                   : origin = 0xFFC0, length = 0x0002
    //INT01                   : origin = 0xFFC2, length = 0x0002
    //INT02                   : origin = 0xFFC4, length = 0x0002
    //INT03                   : origin = 0xFFC6, length = 0x0002
    //INT04                   : origin = 0xFFC8, length = 0x0002
    //INT05                   : origin = 0xFFCA, length = 0x0002
    //INT06                   : origin = 0xFFCC, length = 0x0002
    //INT07                   : origin = 0xFFCE, length = 0x0002
    //INT08                   : origin = 0xFFD0, length = 0x0002
    //INT09                   : origin = 0xFFD2, length = 0x0002
    //INT10                   : origin = 0xFFD4, length = 0x0002
    //INT11                   : origin = 0xFFD6, length = 0x0002
    //INT12                   : origin = 0xFFD8, length = 0x0002
    //INT13                   : origin = 0xFFDA, length = 0x0002
    //INT14                   : origin = 0xFFDC, length = 0x0002
    //INT15                   : origin = 0xFFDE, length = 0x0002
    //INT16                   : origin = 0xFFE0, length = 0x0002
    //INT17                   : origin = 0xFFE2, length = 0x0002
    //INT18                   : origin = 0xFFE4, length = 0x0002
    //INT19                   : origin = 0xFFE6, length = 0x0002
    //INT20                   : origin = 0xFFE8, length = 0x0002
    //INT21                   : origin = 0xFFEA, length = 0x0002
    //INT22                   : origin = 0xFFEC, length = 0x0002
    //INT23                   : origin = 0xFFEE, length = 0x0002
    //INT24                   : origin = 0xFFF0, length = 0x0002
    //INT25                   : origin = 0xFFF2, length = 0x0002
    //INT26                   : origin = 0xFFF4, length = 0x0002
    //INT27                   : origin = 0xFFF6, length = 0x0002
    //INT28                   : origin = 0xFFF8, length = 0x0002
    //INT29                   : origin = 0xFFFA, length = 0x0002
    //INT30                   : origin = 0xFFFC, length = 0x0002
    // Boot reset from __Boot_Reset-_Flash_End
    RESET                   : origin = 0xFFFE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

    .text       : {} >> FLASH         /* CODE                 */
    .cinit      : {} > FLASH        /* INITIALIZATION TABLES*/
    .const      : {} >> FLASH       /* CONSTANT DATA        */
    .cio        : {} > RAM          /* C I/O BUFFER                      */

    .BOOT_APP_VECTORS : {} > BOOT_SHARED_CALLBACKS
    /* MSP430 INTERRUPT VECTORS          */
    .BOOT_VECTOR_TABLE : {} > INT_VECTOR_TABLE
    //.int00       : {}               > INT00
    //.int01       : {}               > INT01
    //.int02       : {}               > INT02
    //.int03       : {}               > INT03
    //.int04       : {}               > INT04
    //.int05       : {}               > INT05
    //.int06       : {}               > INT06
    //.int07       : {}               > INT07
    //.int08       : {}               > INT08
    //.int09       : {}               > INT09
    //.int10       : {}               > INT10
    //.int11       : {}               > INT11
    //.int12       : {}               > INT12
    //.int13       : {}               > INT13
    //.int14       : {}               > INT14
    //DMA          : { * ( .int15 ) } > INT15 type = VECT_INIT
    //BASICTIMER   : { * ( .int16 ) } > INT16 type = VECT_INIT
    //PORT2        : { * ( .int17 ) } > INT17 type = VECT_INIT
    //USCIAB1TX    : { * ( .int18 ) } > INT18 type = VECT_INIT
    //USCIAB1RX    : { * ( .int19 ) } > INT19 type = VECT_INIT
    //PORT1        : { * ( .int20 ) } > INT20 type = VECT_INIT
    //TIMERA1      : { * ( .int21 ) } > INT21 type = VECT_INIT
    //TIMERA0      : { * ( .int22 ) } > INT22 type = VECT_INIT
    //SD16A        : { * ( .int23 ) } > INT23 type = VECT_INIT
    //USCIAB0TX    : { * ( .int24 ) } > INT24 type = VECT_INIT
    //USCIAB0RX    : { * ( .int25 ) } > INT25 type = VECT_INIT
    //WDT          : { * ( .int26 ) } > INT26 type = VECT_INIT
    //COMPARATORA   : { * ( .int27 ) } > INT27 type = VECT_INIT
    //TIMERB1      : { * ( .int28 ) } > INT28 type = VECT_INIT
    //TIMERB0      : { * ( .int29 ) } > INT29 type = VECT_INIT
    //NMI          : { * ( .int30 ) } > INT30 type = VECT_INIT
    .reset       : {}               > RESET  /* MSP430 RESET VECTOR         */ 
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l MSP430F47177.cmd

