/*	CoRTOSsuperblinkyAVR.c - Super Blinky demonstration for PIC24

	This module contains main() & the tasks for the super blinky demo.

	The program demonstrates delays, periodic signals and messages.

	It blinks the demo board LEDs forming a pseudo-random
	sequence of grey codes at somewhat pseudo-random intervals.

	2017.03.11 12:00	Changed signal counting algorithm so interrupts
							can stay enabled, only enable the timer interrupt.
	2017.03.03 10:00	Initial release

	(c) 2017 Nicholas O. Lindan,
	Released under GPL V3 https://www.gnu.org/licenses/gpl.html */

#include "CoRTOScomdefs.h"
#include "CoRTOSkernel.h"
#include "CoRTOStimer.h"
#include "CoRTOSmessage.h"
// #include "CoRTOSresource.h"
#include "CoRTOSsignal.h"
#include "CoRTOSioint.h"
#include "CoRTOStask.h"

static void task0 (void);
static void task1 (void);
static void task2 (void);
static void task3 (void);

/*	RTOS data defining tasks and the size of their stacks.

	number_of_tasks can be found in CoRTOStask.h.

	CoRTOStask.c is not used in the demonstration program -
	tasks, main() and task arrays are all in this file. */

task_address_type start_addresses [number_of_tasks] =
	{task0, task1, task2, task3};
uint16_t task_stack_size [number_of_tasks] =
	{200, 200, 200, 200};

static uint8_t led [3] = {0, 1, 2};

/*	A naive calculation:

	All three task delays line up   47 * 61 * 73 = 209,291
	All 8 LEDs are off                                 256
	led[] == 1, 2, 3                            16,777,216

	Product of probabilities                      8.99 E14
	At 10mSec/tick the sequence repeats in         284,844 years
*/

static void task0 (void)
{
	start_periodic_signal (0, 0, 47);
	while (true)
	{
		led[0] = (led[0] + 3) & 0x07;
		send_message (0, (void *)&led[0]);
		wait_for_signal (0);
	}
}

static void task1 (void)
{
	while (true)
	{
		led[1] = (led[1] + 5) & 0x07;
		send_message (0, (void *)&led[1]);
		delay (1, 61);
	}
}

static void task2 (void)
{
	while (true)
	{
		led[2] = (led[2] + 7) & 0x07;
		send_message (0, (void *)&led[2]);
		delay (2, 73);
	}
}

static void task3 (void)
{
	/*	Only needs to exist as a debugging aid. */
	static uint8_t * ptr;
	while (true)
	{
		ptr = (uint8_t *)wait_for_message (0);
		/*	Only three LEDs - red, blue & green */
		if (*ptr < 3)
			led_toggle (*ptr);
	}
}

/*	main() does nothing but initialize and start CoRTOS - 
	this would normally be done in the file CoRTOStask.c */

int main (void)
{
	initialize_delay_module ();
	initialize_message_module ();
	initialize_signal_module ();
//	initialize_resource_module ();
	initialize_io_and_interrupts ();

	timer_int_enable (true);
	start_CoRTOS ();

	while (true)
		;
	return (0);
}

