/*	CoRTOStask.h - the number of things, task declarations would go here
	if they were scattered over several modules.

	2017.03.03 10:00	Initial release

	(c) 2017 Nicholas O. Lindan,
	Released under GPL V3 https://www.gnu.org/licenses/gpl.html */

/*	Tasks are void functions taking no parameters. */
typedef void (* task_address_type) (void);

/*	This is taken care of in the super blinky demonstration program,
	declaration here is optional, though it may be convenient. */
// static task task0 (void);
// #define tn_task0 0
// static task task1 (void);
// #define tn_task1 1
// static task task2 (void);
// #define tn_task2 2
// static task task3 (void);
// #define tn_task3 3

/*	These may be defined in CoRTOStask.c, in the module containing
	main() or anyplace else convenient. */

extern task_address_type start_addresses [];
extern uint16_t task_stack_size [];

/*	The size of everything. */
#define number_of_tasks 4

#define number_of_signals 4

#define number_of_msg_queues 4
#define msg_queue_size 8

#define number_of_timers 4
#define number_of_periodic_signals 2
