#ifndef __HARDWAREPROFILE_H__
#define __HARDWAREPROFILE_H__

#include <intrinsics.h>

// Macros specific to target CPU
#define ENABLE_INTS()			__enable_interrupt()
#define DISABLE_INTS()			__disable_interrupt()
#define IS_INTS_ENABLED()       ((__get_interrupt_state() & GIE) != 0)

#define Reset() do { Diag_Flush(); PMMCTL0_H = 0xA5; PMMCTL0_L |= PMMSWPOR; while(TRUE); } while(0)

#define __NOP __no_operation

#define static_assert _Static_assert

// break if debugger is connected
#define DEBUG_BRK()				_op_code(0x4343)

#define ASSERT(exp)	while(!(exp)) { \
								DISABLE_INTS();	\
								_op_code(0x4343); /* break if debugger is connected */\
								while(TRUE) { CLR_WDT(); }; \
								}

#define __EVALUATE_STR__(X) #X
#define __EVALUATE_STR2__(X) __EVALUATE_STR__(X)
#define CLR_BIT_ATOMIC_B(reg, bitn) asm("	BIC.B #" __EVALUATE_STR2__(bitn) ", &" #reg "\r\n	.global " #reg)
#define CLR_BIT_ATOMIC_W(reg, bitn) asm("	BIC.W #" __EVALUATE_STR2__(bitn) ", &" #reg "\r\n	.global " #reg)

#define SET_BIT_ATOMIC_B(reg, bitn) asm("	BIS.B #" __EVALUATE_STR2__(bitn) ", &" #reg "\r\n	.global " #reg)
#define SET_BIT_ATOMIC_W(reg, bitn) asm("	BIS.W #" __EVALUATE_STR2__(bitn) ", &" #reg "\r\n	.global " #reg)

// Will not reconfigure, just clear
#define CLR_WDT()				WDTCTL = ((WDTCTL & 0x00FF) | (WDTPW | WDTCNTCL));

///////////////////////////////////////////////////////////
// MSP430FR5994  Definitions
///////////////////////////////////////////////////////////
#define WDTSSEL__LFMODCLK           (3*0x0020u)    /* WDT - Timer Clock Source Select: LFMODCLK as per datasheet */

///////////////////////////////////////////////////////////
// Hardware I/O pin mappings
///////////////////////////////////////////////////////////

// Specific leds
#define LED_ERROR_PORT                      P1OUT
#define LED_ERROR_PORT_DIR                  P1DIR
#define LED_ERROR_MASK                      BIT0

#define LED_OPERATIONS_PORT				    P1OUT
#define LED_OPERATIONS_PORT_DIR				P1DIR
#define LED_OPERATIONS_MASK					BIT1

// LCD HW can disrupt port & function, so clear if restart/config HW function
//#define DISABLE_LCD			do { LCDCCTL0 = 0; LCDCPCTL0 = LCDCPCTL1 = LCDCPCTL2 = LCDCPCTL3 = 0; } while(0)
#define DISABLE_CAP_TOUCH 		do { CAPTIO0CTL = CAPTIO1CTL = 0; } while(0)


#endif // #ifndef __HARDWAREPROFILE_H__
