/*
 *  Strange CPU misbehavior test program.
 *
 *      Hardware : MSP430FR5994 LaunchPad Development Kit (MSP-EXP430FR5994)
 *      CPU : 78C85QW G4 / MSP430FR5994 / REV C
 *      Hardware Customizations : Connect J7 (Enables LED1 - Red), no additional HW needed
 *      Compiler : CCS Version: 9.3.0.00012
 *      Compiler changed settings :
 *           - disable all optimizations on debug build (used for this tests)
 *           - disable FPU
 *           - "C Dialect" : Compile program in C11 mode (--c11)
 *           - adjust floating point numbers support - no
 *           - stack : 1000
 *           - heap : 0
 *
 *
 */

#include "main.h"

#include "InitializeBoard.h"

////////////////////////////////////////////////////////////////////////////////////////////////
// Static sanity checks
////////////////////////////////////////////////////////////////////////////////////////////////
// Fixed types check, if any fail, correct type in GenericTypesDefs.h
static_assert(sizeof(INT8) == 1, "Incorrect fixed type size!");
static_assert(sizeof(UINT8) == 1, "Incorrect fixed type size!");
static_assert(sizeof(BYTE) == 1, "Incorrect fixed type size!");

static_assert(sizeof(INT16) == 2, "Incorrect fixed type size!");
static_assert(sizeof(UINT16) == 2, "Incorrect fixed type size!");

static_assert(sizeof(INT32) == 4, "Incorrect fixed type size!");
static_assert(sizeof(UINT32) == 4, "Incorrect fixed type size!");

static_assert(sizeof(INT64) == 8, "Incorrect fixed type size!");
static_assert(sizeof(UINT64) == 8, "Incorrect fixed type size!");

////////////////////////////////////////////////////////////////////////////////////////////////
// Global Variables
////////////////////////////////////////////////////////////////////////////////////////////////
UINT16 g_nBlinkTimer;

#pragma LOCATION(g_nTVal, 0x214c)               // This is important for reproducing problem
volatile UINT64 g_nTVal;                        // Different sizes, causes different hangs effects (seems UINT16 works...at least for 30 min)

////////////////////////////////////////////////////////////////////////////////////////////////
// ISRs
////////////////////////////////////////////////////////////////////////////////////////////////
#pragma vector=unused_interrupts
interrupt void user_trap_function()
{
	// code for handling all interrupts that do not have specific ISRs
	ASSERT(FALSE);
}

// TAxCCR0
#pragma vector=TIMER2_A0_VECTOR
__interrupt void TIMER2_A0_ISR()
{
	//	ASSERT(TA2CCTL0 & CCIFG);				// IF Flags cleared automatically before enter here

//    __NOP();                                  // Not really helpful for different sizes of g_nTVal
	g_nTVal++;
}

////////////////////////////////////////////////////////////////////////////////////////////////
// Support Functions
////////////////////////////////////////////////////////////////////////////////////////////////
void Tick_Init()
{
	TA2CTL = 0;			// Disable clock

	g_nTVal = 0;		// Clear current value

	// Configure all registers before start
	TA2CCTL0 = TA2CCTL1 = 0;
	TA2R = 0;
	TA2EX0 = TAIDEX_7;		// TAIDEX = /8

	//	TA2CCR0 = 250 - 1;		// 1 ms - one more is actual overflow
	TA2CCR0 = 50;      // for tests

	TA2CTL = TASSEL__SMCLK | ID__8 | MC__UP | TACLR; // | TAIE;			// TASSEL = SMCLK, ID = /8, MC = UP & reset, clear, int enable, intf clear - will start

	// The TAxCCR0 CCIFG interrupt flag is set when the timer counts to the TAxCCR0 value
	// Enable interrupt & clear flags
	TA2CCTL0 = CCIE;
}

UINT16 TickGet16()
{
//    __NOP();                              // Adding stuff here seems to fix the problem.
//    __NOP();                              // Adding more stuff makes problem appear again (obviously timer tick syncs with CPU execution, they run on same clocks, this is expected)

	CLR_BIT_ATOMIC_W(TA2CCTL0, CCIE);       // Without disabling interrupts everything seems to work !!!
//	TA2CCTL0 &= ~CCIE;                      // Same as above, produces same effects

//	__NOP();								// Uncomment this and problem goes away for any other arrangements

	UINT16 nRet = (UINT16) g_nTVal;

	SET_BIT_ATOMIC_W(TA2CCTL0, CCIE);

	return nRet;
}

////////////////////////////////////////////////////////////////////////////////////////////////
// Main code
////////////////////////////////////////////////////////////////////////////////////////////////
int main(void)
{
    CLR_WDT();      // Configured as 32-ms after PUC

    UINT16 nResetReason = SYSRSTIV;

	DISABLE_INTS();
	BOOL bInitOK = InitializeBoard();
	ASSERT(bInitOK);	// Infinite loop if failed

	g_nBlinkTimer = 0;
	g_nTVal = 0;

	ENABLE_INTS();

	// Various access violations (+ WDT)
    if((nResetReason >> 1) > 10)
        LED_ERROR_PORT |= LED_ERROR_MASK;

	// If device is reset, we will see this visually if LED stop flashing for a while
	__delay_cycles(16000000); // 1 s @ 16 MHz
    __delay_cycles(16000000); // 1 s @ 16 MHz
    __delay_cycles(16000000); // 1 s @ 16 MHz
    __delay_cycles(16000000); // 1 s @ 16 MHz

	Tick_Init();

	// Main loop
	while(TRUE)
	{
		UINT16 nTmrNow = TickGet16();

		// Blink on 250 timer ticks
		if(nTmrNow - g_nBlinkTimer > 250)
		{
			LED_OPERATIONS_PORT ^= LED_OPERATIONS_MASK;
			g_nBlinkTimer = nTmrNow;
		}

	    CLR_WDT();
	}

	return 0;
}
