/*
 * pinout.h
 *
 *  Created on: 18.11.2024
 *      Author: 
 */

#include <msp430.h>

#ifndef PINOUT_H_
#define PINOUT_H_

#define uchar unsigned char

#define TRUE 1
#define FALSE 0

#define NONE 0
#define PULLUP 1
#define PULLDOWN 2

enum DEVICE {
    SSIB1, SSIB2, SSIB3, SSIB4,
    SSIB5, SSIB6, SSIB7, SSIB8,
    SSIB9, SSIB10, SSIB11, SSIB12,
    SSIB13, SSIB14, SSIB15, SSIB16,
    HMC1, HMC2,
    RM1, RM2
};

// Port Bit
// Power Enable
#define BIT_PE_COMMON3V3 BIT5
#define BIT_PE_SSIB1 BIT4
#define BIT_PE_SSIB2 BIT5
#define BIT_PE_SSIB3 BIT6
#define BIT_PE_SSIB4 BIT6
#define BIT_PE_SSIB5 BIT7
#define BIT_PE_SSIB6 BIT0
#define BIT_PE_SSIB7 BIT3
#define BIT_PE_SSIB8 BIT4
#define BIT_PE_SSIB9 BIT3
#define BIT_PE_SSIB10 BIT7
#define BIT_PE_SSIB11 BIT5
#define BIT_PE_SSIB12 BIT2
#define BIT_PE_SSIB13 BIT1
#define BIT_PE_SSIB14 BIT4
#define BIT_PE_SSIB15 BIT2
#define BIT_PE_SSIB16 BIT6
#define BIT_PE_HMC1 BIT2
#define BIT_PE_HMC2 BIT7
#define BIT_PE_RM1 BIT6
#define BIT_PE_RM2 BIT3
// Isolator Enable
#define BIT_EN_SSIB1 BIT1
#define BIT_EN_SSIB2 BIT2
#define BIT_EN_SSIB3 BIT0
#define BIT_EN_SSIB4 BIT1
#define BIT_EN_SSIB5 BIT7
#define BIT_EN_SSIB6 BIT2
#define BIT_EN_SSIB7 BIT5
#define BIT_EN_SSIB8 BIT7
#define BIT_EN_SSIB9 BIT2
#define BIT_EN_SSIB10 BIT6
#define BIT_EN_SSIB11 BIT0
#define BIT_EN_SSIB12 BIT5
#define BIT_EN_SSIB13 BIT4
#define BIT_EN_SSIB14 BIT1
#define BIT_EN_SSIB15 BIT3
#define BIT_EN_SSIB16 BIT7
#define BIT_EN_HMC1 BIT0
#define BIT_EN_HMC2 BIT3
#define BIT_EN_RM1 BIT2
#define BIT_EN_RM2 BIT0
#define BIT_EN_SOMI1 BIT4
#define BIT_EN_SOMI2 BIT3
#define BIT_EN_SOMI3 BIT7
#define BIT_EN_SOMI4 BIT3
// SPI Busses
#define BIT_SPI_CLOCK1 BIT5
#define BIT_SPI_CLOCK2 BIT4
#define BIT_SPI_CLOCK3 BIT6
#define BIT_SPI_CLOCK4 BIT2
#define BIT_SPI_SOMI1 BIT1
#define BIT_SPI_SOMI2 BIT6
#define BIT_SPI_SOMI3 BIT5
#define BIT_SPI_SOMI4 BIT1
#define BIT_SPI_SIMO1 BIT0
#define BIT_SPI_SIMO2 BIT5
#define BIT_SPI_SIMO3 BIT4
#define BIT_SPI_SIMO4 BIT0
#define BIT_SPI_BUSYTX BIT7
#define BIT_SPI_BUSYRX BIT6
// Transceiver
#define BIT_UART_TX BIT0
#define BIT_UART_RX BIT1
// HMC analog set/reset lines
#define BIT_HMC_SET BIT3
#define BIT_HMC_RESET BIT4


// POUT
#define POUT_PE_COMMON3V3 P7OUT
#define POUT_PE_SSIB1 P6OUT
#define POUT_PE_SSIB2 P6OUT
#define POUT_PE_SSIB3 P6OUT
#define POUT_PE_SSIB4 PJOUT_L
#define POUT_PE_SSIB5 P6OUT
#define POUT_PE_SSIB6 P1OUT
#define POUT_PE_SSIB7 P3OUT
#define POUT_PE_SSIB8 PJOUT_L
#define POUT_PE_SSIB9 P8OUT
#define POUT_PE_SSIB10 P3OUT
#define POUT_PE_SSIB11 P5OUT
#define POUT_PE_SSIB12 P4OUT
#define POUT_PE_SSIB13 P4OUT
#define POUT_PE_SSIB14 P5OUT
#define POUT_PE_SSIB15 P8OUT
#define POUT_PE_SSIB16 P3OUT
#define POUT_PE_HMC1 P6OUT
#define POUT_PE_HMC2 P4OUT
#define POUT_PE_RM1 P4OUT
#define POUT_PE_RM2 P4OUT

#define POUT_EN_SSIB1 P1OUT
#define POUT_EN_SSIB2 P1OUT
#define POUT_EN_SSIB3 P3OUT
#define POUT_EN_SSIB4 P3OUT
#define POUT_EN_SSIB5 P2OUT
#define POUT_EN_SSIB6 P3OUT
#define POUT_EN_SSIB7 PJOUT_L
#define POUT_EN_SSIB8 PJOUT_L
#define POUT_EN_SSIB9 P8OUT
#define POUT_EN_SSIB10 P3OUT
#define POUT_EN_SSIB11 P5OUT
#define POUT_EN_SSIB12 P4OUT
#define POUT_EN_SSIB13 P4OUT
#define POUT_EN_SSIB14 P5OUT
#define POUT_EN_SSIB15 P8OUT
#define POUT_EN_SSIB16 P3OUT
#define POUT_EN_HMC1 P8OUT
#define POUT_EN_HMC2 P1OUT
#define POUT_EN_RM1 P4OUT
#define POUT_EN_RM2 P4OUT
#define POUT_EN_SOMI1 P1OUT
#define POUT_EN_SOMI2 P2OUT
#define POUT_EN_SOMI3 P5OUT
#define POUT_EN_SOMI4 P7OUT

#define POUT_SPI_CLOCK1 P1OUT
#define POUT_SPI_CLOCK2 P2OUT
#define POUT_SPI_CLOCK3 P5OUT
#define POUT_SPI_CLOCK4 P7OUT
#define POUT_SPI_SOMI1 P2OUT
#define POUT_SPI_SOMI2 P2OUT
#define POUT_SPI_SOMI3 P5OUT
#define POUT_SPI_SOMI4 P7OUT
#define POUT_SPI_SIMO1 P2OUT
#define POUT_SPI_SIMO2 P2OUT
#define POUT_SPI_SIMO3 P5OUT
#define POUT_SPI_SIMO4 P7OUT
#define POUT_SPI_BUSYTX P7OUT
#define POUT_SPI_BUSYRX P7OUT

#define POUT_UART_TX P6OUT
#define POUT_UART_RX P6OUT

#define POUT_HMC_SET P6OUT
#define POUT_HMC_RESET P7OUT

// PIN
#define PIN_PE_COMMON3V3 P7IN
#define PIN_PE_SSIB1 P6IN
#define PIN_PE_SSIB2 P6IN
#define PIN_PE_SSIB3 P6IN
#define PIN_PE_SSIB4 PJIN_L
#define PIN_PE_SSIB5 P6IN
#define PIN_PE_SSIB6 P1IN
#define PIN_PE_SSIB7 P3IN
#define PIN_PE_SSIB8 PJIN_L
#define PIN_PE_SSIB9 P8IN
#define PIN_PE_SSIB10 P3IN
#define PIN_PE_SSIB11 P5IN
#define PIN_PE_SSIB12 P4IN
#define PIN_PE_SSIB13 P4IN
#define PIN_PE_SSIB14 P5IN
#define PIN_PE_SSIB15 P8IN
#define PIN_PE_SSIB16 P3IN
#define PIN_PE_HMC1 P6IN
#define PIN_PE_HMC2 P4IN
#define PIN_PE_RM1 P4IN
#define PIN_PE_RM2 P4IN

#define PIN_EN_SSIB1 P1IN
#define PIN_EN_SSIB2 P1IN
#define PIN_EN_SSIB3 P3IN
#define PIN_EN_SSIB4 P3IN
#define PIN_EN_SSIB5 P2IN
#define PIN_EN_SSIB6 P3IN
#define PIN_EN_SSIB7 PJIN_L
#define PIN_EN_SSIB8 PJIN_L
#define PIN_EN_SSIB9 P8IN
#define PIN_EN_SSIB10 P3IN
#define PIN_EN_SSIB11 P5IN
#define PIN_EN_SSIB12 P4IN
#define PIN_EN_SSIB13 P4IN
#define PIN_EN_SSIB14 P5IN
#define PIN_EN_SSIB15 P8IN
#define PIN_EN_SSIB16 P3IN
#define PIN_EN_HMC1 P8IN
#define PIN_EN_HMC2 P1IN
#define PIN_EN_RM1 P4IN
#define PIN_EN_RM2 P4IN
#define PIN_EN_SOMI1 P1IN
#define PIN_EN_SOMI2 P2IN
#define PIN_EN_SOMI3 P5IN
#define PIN_EN_SOMI4 P7IN

#define PIN_SPI_CLOCK1 P1IN
#define PIN_SPI_CLOCK2 P2IN
#define PIN_SPI_CLOCK3 P5IN
#define PIN_SPI_CLOCK4 P7IN
#define PIN_SPI_SOMI1 P2IN
#define PIN_SPI_SOMI2 P2IN
#define PIN_SPI_SOMI3 P5IN
#define PIN_SPI_SOMI4 P7IN
#define PIN_SPI_SIMO1 P2IN
#define PIN_SPI_SIMO2 P2IN
#define PIN_SPI_SIMO3 P5IN
#define PIN_SPI_SIMO4 P7IN
#define PIN_SPI_BUSYTX P7IN
#define PIN_SPI_BUSYRX P7IN

#define PIN_UART_TX P6IN
#define PIN_UART_RX P6IN

#define PIN_HMC_SET P6IN
#define PIN_HMC_RESET P7IN

// PDIR
#define PDIR_PE_COMMON3V3 P7DIR
#define PDIR_PE_SSIB1 P6DIR
#define PDIR_PE_SSIB2 P6DIR
#define PDIR_PE_SSIB3 P6DIR
#define PDIR_PE_SSIB4 PJDIR_L
#define PDIR_PE_SSIB5 P6DIR
#define PDIR_PE_SSIB6 P1DIR
#define PDIR_PE_SSIB7 P3DIR
#define PDIR_PE_SSIB8 PJDIR_L
#define PDIR_PE_SSIB9 P8DIR
#define PDIR_PE_SSIB10 P3DIR
#define PDIR_PE_SSIB11 P5DIR
#define PDIR_PE_SSIB12 P4DIR
#define PDIR_PE_SSIB13 P4DIR
#define PDIR_PE_SSIB14 P5DIR
#define PDIR_PE_SSIB15 P8DIR
#define PDIR_PE_SSIB16 P3DIR
#define PDIR_PE_HMC1 P6DIR
#define PDIR_PE_HMC2 P4DIR
#define PDIR_PE_RM1 P4DIR
#define PDIR_PE_RM2 P4DIR

#define PDIR_EN_SSIB1 P1DIR
#define PDIR_EN_SSIB2 P1DIR
#define PDIR_EN_SSIB3 P3DIR
#define PDIR_EN_SSIB4 P3DIR
#define PDIR_EN_SSIB5 P2DIR
#define PDIR_EN_SSIB6 P3DIR
#define PDIR_EN_SSIB7 PJDIR_L
#define PDIR_EN_SSIB8 PJDIR_L
#define PDIR_EN_SSIB9 P8DIR
#define PDIR_EN_SSIB10 P3DIR
#define PDIR_EN_SSIB11 P5DIR
#define PDIR_EN_SSIB12 P4DIR
#define PDIR_EN_SSIB13 P4DIR
#define PDIR_EN_SSIB14 P5DIR
#define PDIR_EN_SSIB15 P8DIR
#define PDIR_EN_SSIB16 P3DIR
#define PDIR_EN_HMC1 P8DIR
#define PDIR_EN_HMC2 P1DIR
#define PDIR_EN_RM1 P4DIR
#define PDIR_EN_RM2 P4DIR
#define PDIR_EN_SOMI1 P1DIR
#define PDIR_EN_SOMI2 P2DIR
#define PDIR_EN_SOMI3 P5DIR
#define PDIR_EN_SOMI4 P7DIR

#define PDIR_SPI_CLOCK1 P1DIR
#define PDIR_SPI_CLOCK2 P2DIR
#define PDIR_SPI_CLOCK3 P5DIR
#define PDIR_SPI_CLOCK4 P7DIR
#define PDIR_SPI_SOMI1 P2DIR
#define PDIR_SPI_SOMI2 P2DIR
#define PDIR_SPI_SOMI3 P5DIR
#define PDIR_SPI_SOMI4 P7DIR
#define PDIR_SPI_SIMO1 P2DIR
#define PDIR_SPI_SIMO2 P2DIR
#define PDIR_SPI_SIMO3 P5DIR
#define PDIR_SPI_SIMO4 P7DIR
#define PDIR_SPI_BUSYTX P7DIR
#define PDIR_SPI_BUSYRX P7DIR

#define PDIR_UART_TX P6DIR
#define PDIR_UART_RX P6DIR

#define PDIR_HMC_SET P6DIR
#define PDIR_HMC_RESET P7DIR

// PREN
#define PREN_PE_COMMON3V3 P7REN
#define PREN_PE_SSIB1 P6REN
#define PREN_PE_SSIB2 P6REN
#define PREN_PE_SSIB3 P6REN
#define PREN_PE_SSIB4 PJREN_L
#define PREN_PE_SSIB5 P6REN
#define PREN_PE_SSIB6 P1REN
#define PREN_PE_SSIB7 P3REN
#define PREN_PE_SSIB8 PJREN_L
#define PREN_PE_SSIB9 P8REN
#define PREN_PE_SSIB10 P3REN
#define PREN_PE_SSIB11 P5REN
#define PREN_PE_SSIB12 P4REN
#define PREN_PE_SSIB13 P4REN
#define PREN_PE_SSIB14 P5REN
#define PREN_PE_SSIB15 P8REN
#define PREN_PE_SSIB16 P3REN
#define PREN_PE_HMC1 P6REN
#define PREN_PE_HMC2 P4REN
#define PREN_PE_RM1 P4REN
#define PREN_PE_RM2 P4REN

#define PREN_EN_SSIB1 P1REN
#define PREN_EN_SSIB2 P1REN
#define PREN_EN_SSIB3 P3REN
#define PREN_EN_SSIB4 P3REN
#define PREN_EN_SSIB5 P2REN
#define PREN_EN_SSIB6 P3REN
#define PREN_EN_SSIB7 PJREN_L
#define PREN_EN_SSIB8 PJREN_L
#define PREN_EN_SSIB9 P8REN
#define PREN_EN_SSIB10 P3REN
#define PREN_EN_SSIB11 P5REN
#define PREN_EN_SSIB12 P4REN
#define PREN_EN_SSIB13 P4REN
#define PREN_EN_SSIB14 P5REN
#define PREN_EN_SSIB15 P8REN
#define PREN_EN_SSIB16 P3REN
#define PREN_EN_HMC1 P8REN
#define PREN_EN_HMC2 P1REN
#define PREN_EN_RM1 P4REN
#define PREN_EN_RM2 P4REN
#define PREN_EN_SOMI1 P1REN
#define PREN_EN_SOMI2 P2REN
#define PREN_EN_SOMI3 P5REN
#define PREN_EN_SOMI4 P7REN

#define PREN_SPI_CLOCK1 P1REN
#define PREN_SPI_CLOCK2 P2REN
#define PREN_SPI_CLOCK3 P5REN
#define PREN_SPI_CLOCK4 P7REN
#define PREN_SPI_SOMI1 P2REN
#define PREN_SPI_SOMI2 P2REN
#define PREN_SPI_SOMI3 P5REN
#define PREN_SPI_SOMI4 P7REN
#define PREN_SPI_SIMO1 P2REN
#define PREN_SPI_SIMO2 P2REN
#define PREN_SPI_SIMO3 P5REN
#define PREN_SPI_SIMO4 P7REN
#define PREN_SPI_BUSYTX P7REN
#define PREN_SPI_BUSYRX P7REN

#define PREN_UART_TX P6REN
#define PREN_UART_RX P6REN

#define PREN_HMC_SET P6REN
#define PREN_HMC_RESET P7REN

// PSEL0
#define PSEL0_PE_COMMON3V3 P7SEL0
#define PSEL0_PE_SSIB1 P6SEL0
#define PSEL0_PE_SSIB2 P6SEL0
#define PSEL0_PE_SSIB3 P6SEL0
#define PSEL0_PE_SSIB4 PJSEL0_L
#define PSEL0_PE_SSIB5 P6SEL0
#define PSEL0_PE_SSIB6 P1SEL0
#define PSEL0_PE_SSIB7 P3SEL0
#define PSEL0_PE_SSIB8 PJSEL0_L
#define PSEL0_PE_SSIB9 P8SEL0
#define PSEL0_PE_SSIB10 P3SEL0
#define PSEL0_PE_SSIB11 P5SEL0
#define PSEL0_PE_SSIB12 P4SEL0
#define PSEL0_PE_SSIB13 P4SEL0
#define PSEL0_PE_SSIB14 P5SEL0
#define PSEL0_PE_SSIB15 P8SEL0
#define PSEL0_PE_SSIB16 P3SEL0
#define PSEL0_PE_HMC1 P6SEL0
#define PSEL0_PE_HMC2 P4SEL0
#define PSEL0_PE_RM1 P4SEL0
#define PSEL0_PE_RM2 P4SEL0

#define PSEL0_EN_SSIB1 P1SEL0
#define PSEL0_EN_SSIB2 P1SEL0
#define PSEL0_EN_SSIB3 P3SEL0
#define PSEL0_EN_SSIB4 P3SEL0
#define PSEL0_EN_SSIB5 P2SEL0
#define PSEL0_EN_SSIB6 P3SEL0
#define PSEL0_EN_SSIB7 PJSEL0_L
#define PSEL0_EN_SSIB8 PJSEL0_L
#define PSEL0_EN_SSIB9 P8SEL0
#define PSEL0_EN_SSIB10 P3SEL0
#define PSEL0_EN_SSIB11 P5SEL0
#define PSEL0_EN_SSIB12 P4SEL0
#define PSEL0_EN_SSIB13 P4SEL0
#define PSEL0_EN_SSIB14 P5SEL0
#define PSEL0_EN_SSIB15 P8SEL0
#define PSEL0_EN_SSIB16 P3SEL0
#define PSEL0_EN_HMC1 P8SEL0
#define PSEL0_EN_HMC2 P1SEL0
#define PSEL0_EN_RM1 P4SEL0
#define PSEL0_EN_RM2 P4SEL0
#define PSEL0_EN_SOMI1 P1SEL0
#define PSEL0_EN_SOMI2 P2SEL0
#define PSEL0_EN_SOMI3 P5SEL0
#define PSEL0_EN_SOMI4 P7SEL0

#define PSEL0_SPI_CLOCK1 P1SEL0
#define PSEL0_SPI_CLOCK2 P2SEL0
#define PSEL0_SPI_CLOCK3 P5SEL0
#define PSEL0_SPI_CLOCK4 P7SEL0
#define PSEL0_SPI_SOMI1 P2SEL0
#define PSEL0_SPI_SOMI2 P2SEL0
#define PSEL0_SPI_SOMI3 P5SEL0
#define PSEL0_SPI_SOMI4 P7SEL0
#define PSEL0_SPI_SIMO1 P2SEL0
#define PSEL0_SPI_SIMO2 P2SEL0
#define PSEL0_SPI_SIMO3 P5SEL0
#define PSEL0_SPI_SIMO4 P7SEL0
#define PSEL0_SPI_BUSYTX P7SEL0
#define PSEL0_SPI_BUSYRX P7SEL0

#define PSEL0_UART_TX P6SEL0
#define PSEL0_UART_RX P6SEL0

#define PSEL0_HMC_SET P6SEL0
#define PSEL0_HMC_RESET P7SEL0

// PSEL1
#define PSEL1_PE_COMMON3V3 P7SEL1
#define PSEL1_PE_SSIB1 P6SEL1
#define PSEL1_PE_SSIB2 P6SEL1
#define PSEL1_PE_SSIB3 P6SEL1
#define PSEL1_PE_SSIB4 PJSEL1_L
#define PSEL1_PE_SSIB5 P6SEL1
#define PSEL1_PE_SSIB6 P1SEL1
#define PSEL1_PE_SSIB7 P3SEL1
#define PSEL1_PE_SSIB8 PJSEL1_L
#define PSEL1_PE_SSIB9 P8SEL1
#define PSEL1_PE_SSIB10 P3SEL1
#define PSEL1_PE_SSIB11 P5SEL1
#define PSEL1_PE_SSIB12 P4SEL1
#define PSEL1_PE_SSIB13 P4SEL1
#define PSEL1_PE_SSIB14 P5SEL1
#define PSEL1_PE_SSIB15 P8SEL1
#define PSEL1_PE_SSIB16 P3SEL1
#define PSEL1_PE_HMC1 P6SEL1
#define PSEL1_PE_HMC2 P4SEL1
#define PSEL1_PE_RM1 P4SEL1
#define PSEL1_PE_RM2 P4SEL1

#define PSEL1_EN_SSIB1 P1SEL1
#define PSEL1_EN_SSIB2 P1SEL1
#define PSEL1_EN_SSIB3 P3SEL1
#define PSEL1_EN_SSIB4 P3SEL1
#define PSEL1_EN_SSIB5 P2SEL1
#define PSEL1_EN_SSIB6 P3SEL1
#define PSEL1_EN_SSIB7 PJSEL1_L
#define PSEL1_EN_SSIB8 PJSEL1_L
#define PSEL1_EN_SSIB9 P8SEL1
#define PSEL1_EN_SSIB10 P3SEL1
#define PSEL1_EN_SSIB11 P5SEL1
#define PSEL1_EN_SSIB12 P4SEL1
#define PSEL1_EN_SSIB13 P4SEL1
#define PSEL1_EN_SSIB14 P5SEL1
#define PSEL1_EN_SSIB15 P8SEL1
#define PSEL1_EN_SSIB16 P3SEL1
#define PSEL1_EN_HMC1 P8SEL1
#define PSEL1_EN_HMC2 P1SEL1
#define PSEL1_EN_RM1 P4SEL1
#define PSEL1_EN_RM2 P4SEL1
#define PSEL1_EN_SOMI1 P1SEL1
#define PSEL1_EN_SOMI2 P2SEL1
#define PSEL1_EN_SOMI3 P5SEL1
#define PSEL1_EN_SOMI4 P7SEL1

#define PSEL1_SPI_CLOCK1 P1SEL1
#define PSEL1_SPI_CLOCK2 P2SEL1
#define PSEL1_SPI_CLOCK3 P5SEL1
#define PSEL1_SPI_CLOCK4 P7SEL1
#define PSEL1_SPI_SOMI1 P2SEL1
#define PSEL1_SPI_SOMI2 P2SEL1
#define PSEL1_SPI_SOMI3 P5SEL1
#define PSEL1_SPI_SOMI4 P7SEL1
#define PSEL1_SPI_SIMO1 P2SEL1
#define PSEL1_SPI_SIMO2 P2SEL1
#define PSEL1_SPI_SIMO3 P5SEL1
#define PSEL1_SPI_SIMO4 P7SEL1
#define PSEL1_SPI_BUSYTX P7SEL1
#define PSEL1_SPI_BUSYRX P7SEL1

#define PSEL1_UART_TX P6SEL1
#define PSEL1_UART_RX P6SEL1

#define PSEL1_HMC_SET P6SEL1
#define PSEL1_HMC_RESET P7SEL1



#endif /* PINOUT_H_ */
