/*
 * ports.cpp
 *
 *  Created on: 18.11.2024
 *      Author: 
 */

#include "ports.h"

void initGPIOAsOutput(uchar _bit, port _out, port _dir, port _sel0, port _sel1, uchar _initValue) {
    _dir |= _bit;
    _sel0 &= ~_bit;
    _sel1 &= ~_bit;

    if (_initValue == 1)
        _out |= _bit;
    else
        _out &= ~_bit;
}

void initGPIOAsInput(uchar _bit, port _out, port _dir, port _ren, port _sel0, port _sel1, uchar _pull) {
    _dir |= _bit;
    _sel0 &= ~_bit;
    _sel1 &= ~_bit;

    if (_pull == NONE) {
        _ren &= ~_bit;
    }
    else if (_pull == PULLUP){
        _ren |= _bit;
        _out |= _bit;
    }
    else {
        _ren |= _bit;
        _out &= ~_bit;
    }
}

inline void setGPIO(port _port, uchar _bit, uchar _active) {
    if (_active)
        _port |= _bit;
    else
        _port &= ~_bit;
}

inline uchar getGPIO(port _port, uchar _bit) {
    return _port & _bit ? 1 : 0;
}

void setAllHighImpedance() {
    P8DIR = 0b00000000;     // All Input
    P8OUT = 0b00000000;     // Pull-Down selected
    P7REN = 0b00000000;     // Disable pull-down (high-impedance input)
    P8SEL1 = 0b00000000;    // GPIO Mode
    P8SEL0 = 0b00000000;

    P7DIR = 0b00000000;
    P7OUT = 0b00000000;
    P7REN = 0b00000000;
    P7SEL1 = 0b00000000;
    P7SEL0 = 0b00000000;

    P6DIR = 0b00000000;
    P6OUT = 0b00000000;
    P6REN = 0b00000000;
    P6SEL1 = 0b00000000;
    P6SEL0 = 0b00000000;

    P5DIR = 0b00000000;
    P5OUT = 0b00000000;
    P5REN = 0b00000000;
    P5SEL1 = 0b00000000;
    P5SEL0 = 0b00000000;

    P4DIR = 0b00000000;
    P4OUT = 0b00000000;
    P4REN = 0b00000000;
    P4SEL1 = 0b00000000;
    P4SEL0 = 0b00000000;

    P3DIR = 0b00000000;
    P3OUT = 0b00000000;
    P3REN = 0b00000000;
    P3SEL1 = 0b00000000;
    P3SEL0 = 0b00000000;

    P2DIR = 0b00000000;
    P2OUT = 0b00000000;
    P2REN = 0b00000000;
    P2SEL0 = 0b00000000;
    P2SEL1 = 0b00000000;

    P1DIR = 0b00000000;
    P1OUT = 0b00000000;
    P1REN = 0b00000000;
    P1SEL1 = 0b00000000;
    P1SEL0 = 0b00000000;

    PJDIR = 0b00000000;
    PJOUT = 0b00000000;
    PJREN = 0b00000000;
    PJSEL1 = 0b00000000;
    PJSEL0 = 0b00000000;
}

// Inits all PE lines. All devices are turned off.
void initAllPE() {
    initGPIOAsOutput(BIT_PE_SSIB1, POUT_PE_SSIB1, PDIR_PE_SSIB1, PSEL0_PE_SSIB1, PSEL1_PE_SSIB1, 1);
    initGPIOAsOutput(BIT_PE_SSIB2, POUT_PE_SSIB2, PDIR_PE_SSIB2, PSEL0_PE_SSIB2, PSEL1_PE_SSIB2, 1);
    initGPIOAsOutput(BIT_PE_SSIB3, POUT_PE_SSIB3, PDIR_PE_SSIB3, PSEL0_PE_SSIB3, PSEL1_PE_SSIB3, 1);
    initGPIOAsOutput(BIT_PE_SSIB4, POUT_PE_SSIB4, PDIR_PE_SSIB4, PSEL0_PE_SSIB4, PSEL1_PE_SSIB4, 1);
    initGPIOAsOutput(BIT_PE_SSIB5, POUT_PE_SSIB5, PDIR_PE_SSIB5, PSEL0_PE_SSIB5, PSEL1_PE_SSIB5, 1);
    initGPIOAsOutput(BIT_PE_SSIB6, POUT_PE_SSIB6, PDIR_PE_SSIB6, PSEL0_PE_SSIB6, PSEL1_PE_SSIB6, 1);
    initGPIOAsOutput(BIT_PE_SSIB7, POUT_PE_SSIB7, PDIR_PE_SSIB7, PSEL0_PE_SSIB7, PSEL1_PE_SSIB7, 1);
    initGPIOAsOutput(BIT_PE_SSIB8, POUT_PE_SSIB8, PDIR_PE_SSIB8, PSEL0_PE_SSIB8, PSEL1_PE_SSIB8, 1);
    initGPIOAsOutput(BIT_PE_SSIB9, POUT_PE_SSIB9, PDIR_PE_SSIB9, PSEL0_PE_SSIB9, PSEL1_PE_SSIB9, 1);
    initGPIOAsOutput(BIT_PE_SSIB10, POUT_PE_SSIB10, PDIR_PE_SSIB10, PSEL0_PE_SSIB10, PSEL1_PE_SSIB10, 1);
    initGPIOAsOutput(BIT_PE_SSIB11, POUT_PE_SSIB11, PDIR_PE_SSIB11, PSEL0_PE_SSIB11, PSEL1_PE_SSIB11, 1);
    initGPIOAsOutput(BIT_PE_SSIB12, POUT_PE_SSIB12, PDIR_PE_SSIB12, PSEL0_PE_SSIB12, PSEL1_PE_SSIB12, 1);
    initGPIOAsOutput(BIT_PE_SSIB13, POUT_PE_SSIB13, PDIR_PE_SSIB13, PSEL0_PE_SSIB13, PSEL1_PE_SSIB13, 1);
    initGPIOAsOutput(BIT_PE_SSIB14, POUT_PE_SSIB14, PDIR_PE_SSIB14, PSEL0_PE_SSIB14, PSEL1_PE_SSIB14, 1);
    initGPIOAsOutput(BIT_PE_SSIB15, POUT_PE_SSIB15, PDIR_PE_SSIB15, PSEL0_PE_SSIB15, PSEL1_PE_SSIB15, 1);
    initGPIOAsOutput(BIT_PE_SSIB16, POUT_PE_SSIB16, PDIR_PE_SSIB16, PSEL0_PE_SSIB16, PSEL1_PE_SSIB16, 1);

    initGPIOAsOutput(BIT_PE_HMC1, POUT_PE_HMC1, PDIR_PE_HMC1, PSEL0_PE_HMC1, PSEL1_PE_HMC1, 0);
    initGPIOAsOutput(BIT_PE_HMC2, POUT_PE_HMC2, PDIR_PE_HMC2, PSEL0_PE_HMC2, PSEL1_PE_HMC2, 0);

    initGPIOAsOutput(BIT_PE_RM1, POUT_PE_RM1, PDIR_PE_RM1, PSEL0_PE_RM1, PSEL1_PE_RM1, 1);
    initGPIOAsOutput(BIT_PE_RM2, POUT_PE_RM2, PDIR_PE_RM2, PSEL0_PE_RM2, PSEL1_PE_RM2, 1);
}

void setAllPE(uchar _active) {
    setGPIO(POUT_PE_SSIB1, BIT_PE_SSIB1, !_active);
    setGPIO(POUT_PE_SSIB2, BIT_PE_SSIB2, !_active);
    setGPIO(POUT_PE_SSIB3, BIT_PE_SSIB3, !_active);
    setGPIO(POUT_PE_SSIB4, BIT_PE_SSIB4, !_active);
    setGPIO(POUT_PE_SSIB5, BIT_PE_SSIB5, !_active);
    setGPIO(POUT_PE_SSIB6, BIT_PE_SSIB6, !_active);
    setGPIO(POUT_PE_SSIB7, BIT_PE_SSIB7, !_active);
    setGPIO(POUT_PE_SSIB8, BIT_PE_SSIB8, !_active);
    setGPIO(POUT_PE_SSIB9, BIT_PE_SSIB9, !_active);
    setGPIO(POUT_PE_SSIB10, BIT_PE_SSIB10, !_active);
    setGPIO(POUT_PE_SSIB11, BIT_PE_SSIB11, !_active);
    setGPIO(POUT_PE_SSIB12, BIT_PE_SSIB12, !_active);
    setGPIO(POUT_PE_SSIB13, BIT_PE_SSIB13, !_active);
    setGPIO(POUT_PE_SSIB14, BIT_PE_SSIB14, !_active);
    setGPIO(POUT_PE_SSIB15, BIT_PE_SSIB15, !_active);
    setGPIO(POUT_PE_SSIB16, BIT_PE_SSIB16, !_active);

    setGPIO(POUT_PE_HMC1, BIT_PE_HMC1, _active);
    setGPIO(POUT_PE_HMC2, BIT_PE_HMC2, _active);

    setGPIO(POUT_PE_RM1, BIT_PE_RM1, !_active);
    setGPIO(POUT_PE_RM2, BIT_PE_RM2, !_active);
}

