/*
 * File Name: mcu.h
 *
 * Description: Header file for all functions for mcu.h
 *
 * Copyright (C) 2016 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef MCU_H_
#define MCU_H_

//===============================================================

#include "MSP430.h" 		// Processor specific header
#include "types.h"
#include "VLO_Library.h"

//=====MCU constants=============================================

#define TRF_ENABLE_SET	P2DIR |= BIT2		// P2.2 is switched in output direction
#define	TRF_ENABLE		P2OUT |= BIT2		// EN pin on the TRF7970A
#define TRF_DISABLE		P2OUT &= ~BIT2

// IRQ on P2.0 or P2.7 depending on BP Version
#define IRQ_PIN_SET		P2DIR &= ~IRQ_PIN;
#define IRQ_PIN			(BIT7)      //BIT0 |
#define IRQ_PORT		P2IN
#define IRQ             (IRQ_PORT & IRQ_PIN)
#define IRQ_ON			P2IE |= IRQ_PIN
#define IRQ_OFF			P2IE &= ~IRQ_PIN
#define IRQ_EDGE_SET	P2IES &= ~IRQ_PIN		// Rising edge interrupt
#define IRQ_CLR			P2IFG = 0x00
#define IRQ_REQ_REG		P2IFG

#define LED_PORT_SET	P2DIR |= 0x38;
#define LED_ALL_OFF		P2OUT &= ~0x38;

#define LED_14443A_ON	P2OUT |= BIT4;
#define LED_14443A_OFF	P2OUT &= ~BIT4;
#define LED_14443B_ON	P2OUT |= BIT3;
#define LED_14443B_OFF	P2OUT &= ~BIT3;
#define LED_15693_ON	P2OUT |= BIT5;
#define LED_15693_OFF	P2OUT &= ~BIT5;

#if 1

#define LEDtypeAON      LED_14443A_ON       //P2OUT |= BIT4;        //P1OUT |= BIT6;
#define LEDtypeAOFF     LED_14443A_OFF      //P2OUT &= ~BIT4;       //P1OUT &= ~BIT6;

#define LEDAuth1ON      LED_14443B_ON       //P2OUT |= BIT3;        //P1OUT &= ~BIT5;
#define LEDAuth1OFF     LED_14443B_OFF      //P2OUT &= ~BIT3;       //P1OUT |= BIT5;

#define LEDAuth2ON      LED_15693_ON        //P2OUT |= BIT5;        //P1OUT |= BIT4;
#define LEDAuth2OFF     LED_15693_OFF       //P2OUT &= ~BIT5;       //P1OUT &= ~BIT4;

#define LEDAuth3ON      LED_15693_ON        //P2OUT |= BIT3;        //P1OUT |= BIT3;
#define LEDAuth3OFF     LED_15693_OFF       //P2OUT &= ~BIT3;       //P1OUT &= ~BIT3;

#define LED_MFC_READ_BLOCK_ON       LED_15693_ON    \
                                    LED_14443B_ON                       //P1OUT |= BIT2;

#define LED_MFC_READ_BLOCK_OFF      LED_15693_OFF   \
                                    LED_14443B_OFF

#endif


#define SLAVE_SELECT_PORT_SET	P2DIR |= BIT1;
#define SLAVE_SELECT_HIGH		P2OUT |= BIT1;
#define SLAVE_SELECT_LOW		P2OUT &= ~BIT1;


//********* SDM************************************************
#define SDM_TXENABLE    (BIT4)          //(BIT2)  // port 4.2   //port 1.4
#define SDM_DATA        (BIT6)          //(BIT3)  // port 4.3   //port 2.6
#define SDM_BITCLK_BIT  (BIT3)          //(BIT5)  // port 4.5   //port 1.3


#define SDM_PORT_SET    P1DIR |= SDM_TXENABLE;      \
                        P1SEL &= ~SDM_TXENABLE;   \
                        P1SEL2 &= ~SDM_TXENABLE;   \
                        P1DIR &= ~SDM_BITCLK_BIT;   \
						P1SEL &= ~SDM_BITCLK_BIT;   \
						P1SEL2 &= ~SDM_BITCLK_BIT;   \
                        P2DIR |= SDM_DATA;          \
                        P2SEL &= ~SDM_DATA;   \
                        P2SEL2 &= ~SDM_DATA;   //      \
//                      P4IES &= ~SDM_BITCLK_BIT;   \
//                      P4REN |= SDM_BITCLK_BIT;

                                    /*
                                    #define SDM_PORT_SET    P4DIR |= SDM_TXENABLE;      \
                                                            P4DIR &= ~SDM_BITCLK_BIT;   \
                                                            P4DIR |= SDM_DATA;  //      \
                                    //                      P4IES &= ~SDM_BITCLK_BIT;   \
                                    //                      P4REN |= SDM_BITCLK_BIT;
                                    */


                                    //Need to decide MOD pin in Actual Board.
                                    /*
                                    #define MOD_DIR_OUT  P2DIR |= BIT0
                                    #define MOD_OFF      P2OUT &= ~BIT0
                                    #define MOD_ON       P2OUT |= BIT0
                                    */


//#define SDM_PORT_DIR    P4DIR
//#define SDM_PORT_OUT    P4OUT
//#define SDM_PORT_IN       P4IN

#define SDM_TXENABLE_ON     P1OUT |= SDM_TXENABLE
#define SDM_TXENABLE_OFF    P1OUT &= ~SDM_TXENABLE
#define SDM_DATA_ON         P2OUT |= SDM_DATA
#define SDM_DATA_OFF        P2OUT &= ~SDM_DATA
#define SDM_BITCLK          (P1IN & SDM_BITCLK_BIT)

                                    //#define SDM_TXENABLE_ON     P4OUT |= SDM_TXENABLE
                                    //#define SDM_TXENABLE_OFF    P4OUT &= ~SDM_TXENABLE
                                    //#define SDM_DATA_ON         P4OUT |= SDM_DATA
                                    //#define SDM_DATA_OFF        P4OUT &= ~SDM_DATA
                                    //#define SDM_BITCLK          (P4IN & SDM_BITCLK_BIT)

#if 1

#define SS_PIN          BIT1

#define SS_PORT_SEL1    P2SEL
#define SS_PORT_SEL2    P2SEL2
#define SS_PORT_DIR     P2DIR
#define SS_PORT_OUT     P2OUT

#define SS_PORT_SET  SS_PORT_DIR |= SS_PIN; SS_PORT_SEL1 &= ~SS_PIN; SS_PORT_SEL2 &= ~SS_PIN;
#define SS_HIGH      SS_PORT_OUT |= SS_PIN;
#define SS_LOW       SS_PORT_OUT &= ~SS_PIN;


#define SCLK_PIN        BIT5
#define MISO_PIN        BIT6
#define MOSI_PIN        BIT7

#define SPI_PORT_SEL1   P1SEL
#define SPI_PORT_SEL2   P1SEL2  //  Not needed for F2370
#define SPI_PORT_DIR    P1DIR
#define SPI_PORT_OUT    P1OUT
#define SPI_PORT_IN     P1IN

#define MISO_DATA_SETUP     SPI_PORT_DIR &= ~MISO_PIN;  \
                            SPI_PORT_SEL1 &= ~MISO_PIN;  \
                            SPI_PORT_SEL2 &= ~MISO_PIN;


#define MISO_SPI_SETUP      SPI_PORT_SEL1 |= MISO_PIN;  \
                            SPI_PORT_SEL2 |= MISO_PIN;  \
                            SPI_PORT_DIR &= ~MISO_PIN;

#define DM1_DATA_BIT        (SPI_PORT_IN & MISO_PIN)

#endif


                                    #if 0

                                    #define SCLK_PIN        BIT3
                                    #define MISO_PIN        BIT2
                                    #define MOSI_PIN        BIT1

                                    #define SPI_PORT_SEL1   P3SEL
                                    #define SPI_PORT_SEL2   //  Not needed for F2370
                                    #define SPI_PORT_DIR    P3DIR
                                    #define SPI_PORT_OUT    P3OUT
                                    #define SPI_PORT_IN     P3IN

                                    #define SS_PIN          BIT0

                                    #define SS_PORT_SEL     P3SEL
                                    #define SS_PORT_DIR     P3DIR
                                    #define SS_PORT_OUT     P3OUT

                                    #define SS_PORT_SET  SS_PORT_DIR |= SS_PIN; SS_PORT_SEL &= ~SS_PIN;
                                    #define SS_HIGH      SS_PORT_OUT |= SS_PIN;
                                    #define SS_LOW       SS_PORT_OUT &= ~SS_PIN;

                                    #define MISO_DATA_SETUP     SPI_PORT_SEL1 &= ~MISO_PIN;  \
                                                                /*SPI_PORT_SEL2 &= ~MISO_PIN;*/  \
                                                                SPI_PORT_DIR &= ~MISO_PIN;

                                    #define MISO_SPI_SETUP      SPI_PORT_SEL1 |= MISO_PIN;  \
                                                                /*SPI_PORT_SEL2 |= MISO_PIN;*/  \
                                                                SPI_PORT_DIR &= ~MISO_PIN;

                                    #define DM1_DATA_BIT        (SPI_PORT_IN & MISO_PIN)

                                    #endif

//******************************************************************

//===============================================================





//-----Counter-timer constants-----------------------------------

#define COUNTER_VALUE	TA0CCR0					//counter register
#define START_COUNTER	TA0CTL |=  MC0			//start counter in up mode
#define STOP_COUNTER	TA0CTL &= ~(MC0 + MC1)	//stops the counter
#define RESET_COUNTER   TA0CTL |= TACLR	    	//Resets and stops counter.

//===============================================================

#define DELAY_1ms		8000	// Used for McuDelayMillisecond

//===============================================================

void MCU_setCounter(uint16_t ui16mSecTimeout);
void MCU_delayMillisecond(uint32_t n_ms);
void MCU_initClock(void);
void MCU_calculateVLOFreq(void);

//===============================================================

#endif
