/*
 * ADC12.c
 *
 *  Created on: Jun 25, 2013
 *      Author: roy
 */

#include "msp430f5528.h"
#include "misc_stuff.h"
#include "ADC12.h"

// Computations involving the temp sensor

// Vtc = ((2.52-E3) * tc) + 0.688
// V =  ((2.52-E3) * ) + 0.688         voltage output at 0 degrees C
// V = 0.688V

// The ADC12 will use the 1.5V reference
// DN @ 0C = (( 0.688 * 4095 ) / 1.5 )
// DN @ 0C = 1878

void init_ADC12( void )
{

    // Reference configuration
    // by default, REFMSTR bit == 1, Reference module controls the reference

	// select output of temperature sensor
    ADC12MCTL0 |= 0x0A; // INCH0 field == 10  temp sensor

    // The 1.5V reference is selected by default
    // In REFCTL0, REFTCOFF = 0 by default, enabling the temp sensor

	// ADC12CONSEQx, conversion mode selection bits
	// default is 00b, single channel, single conversion
	// which is what we want

	ENABLE_REFERENCE;

	// set ADC12REFBURST bit to reduce reference buffer power
	ADC12CTL2 |= 0x0004;

	// set ADC12REFBURST bit, reference is on only when converting
	ADC12CTL2 |= 0x0001;

	// Select reference sources: VR+ == VREF+ , VR- == AVSS
	// ADCSREFx bits:	001
	ADC12MCTL0 &= 0x8F;
	ADC12MCTL0 |= 0x10;

	// select the clock source, the SMCLK
	// ADC12SSELx bits
	ADC12CTL1 |= 0x0018;

	// configure the bit ADC12PDIV for divide the SMCLK by 4
	ADC12CTL2 |= 0x0100;

	// configure the bits ADC12DIVx to divide (again) by 8
	// the ADC12CLK should be operating at
	// 7.5MHz / (4 * 8) = 234KHz
	ADC12CTL1 |= 0x00E0;

	// ADC12SHS bits default to use ADC12SC as the conversion signal

	// ADC12ISSH bit defaults to a not inverted Sample Input Signal (SHI)

	// ADC12SHT0x can use the default value of 0000b, 4 sample clocks.
	// (1/234KHz) * 4 = 16uS, the minimum sample time is 3.46uS

	// ADC12SHT1x, these bits are not needed for this application.
	// They define the number of ADC12CLK cycles needed for ADC12MEM8 to
	// ADC12MEM15

	// ADC12MSC bit, valid only for sequence or repeated modes

	// ADC12SHP = 1 to get the SAMPCON signal sourced from the sampling timer
	ADC12CTL1 |= 0x0200;

	// ADC12CSTARTADDx, these 4 bits determine which conversion
	// register is used ( for the single conversion mode ).
	// By default it has a value of zero.

	ADC12_ON;

	// set bit ADC12ENC to enable conversions
	ENABLE_ADC12;

	// Trigger the first conversion
	START_ADC12_CONVERSION;

	/*
	 * Note:   See I2C_UCB1.c, pressure_sensor_task()
	 * When this function is called (about 6 times per second)
	 * A new temperature reading will be taken.
	 *
	 */

}	// end of init_ADC12() *****************************************************



