/*
 * ADC12.h
 *
 *  Created on: Jun 25, 2013
 *      Author: roy
 */

#ifndef ADC12_H_
#define ADC12_H_

// this register is in the reference module, set the REFON bit
#define ENABLE_REFERENCE		REFCTL0 |= 0x0001
#define DISABLE_REFERENCE		REFCTL0 &= 0xFFFE

// When set, the reference module has control of the reference
#define SET_REFMSTR		REFCTL0 |= 0x0080

#define ENABLE_ADC12	ADC12CTL0 |= 0x0002
#define DISABLE_ADC12	ADC12CTL0 &= 0xFFFD

// Note:  this is a self clearing bit
#define START_ADC12_CONVERSION  ADC12CTL0 |= 0x0001

#define ADC12_ON 	ADC12CTL0 |= 0x0010
#define ADC12_OFF 	ADC12CTL0 &= 0xFFEF

// The batery voltage level that indicates a low battery
// see switches.c and program_LCD, SPI_UCB0.c
#define FOUR_AND_ONE_HALF_VOLTS 	2454


#define SIZE_OF_TEMP_SENSOR_READINGS    16

// specifically calibrated for PCB_6-0, SN2
#define ZERO_DEGREES_C      1979
#define FIVE_DEGREES_C      2010

#endif /* ADC12_H_ */
