

#ifndef __BOARD_H
#define __BOARD_H

#ifdef __cplusplus
extern "C" {
#endif

#include "MSP_EXP430F5529LP.h"

#define Board_initGeneral           MSP_EXP430F5529LP_initGeneral
#define Board_initGPIO              MSP_EXP430F5529LP_initGPIO
#define Board_initI2C               MSP_EXP430F5529LP_initI2C
#define Board_initSDSPI             MSP_EXP430F5529LP_initSDSPI
#define Board_initSPI               MSP_EXP430F5529LP_initSPI
#define Board_initUART              MSP_EXP430F5529LP_initUART
#define Board_initUSB               MSP_EXP430F5529LP_initUSB
#define Board_initWatchdog          MSP_EXP430F5529LP_initWatchdog
#define Board_initWiFi              MSP_EXP430F5529LP_initWiFi

#define Board_LED_ON                MSP_EXP430F5529LP_LED_ON
#define Board_LED_OFF               MSP_EXP430F5529LP_LED_OFF
#define Board_LED0                  MSP_EXP430F5529LP_LED1
#define Board_LED1                  MSP_EXP430F5529LP_LED2
#define Board_LED2                  MSP_EXP430F5529LP_LED2
#define Board_BUTTON0               MSP_EXP430F5529LP_S1
#define Board_BUTTON1               MSP_EXP430F5529LP_S2

#define Board_I2C0                  MSP_EXP430F5529LP_I2CB0
#define Board_I2C_TMP               MSP_EXP430F5529LP_I2CB0
#define Board_I2C_NFC               MSP_EXP430F5529LP_I2CB0
#define Board_I2C_TPL0401           MSP_EXP430F5529LP_I2CB0

#define Board_SDSPI0                MSP_EXP430F5529LP_SDSPIB0

#define Board_SPI0                  MSP_EXP430F5529LP_SPIB0

#define Board_USBDEVICE             0

#define Board_UART0                 MSP_EXP430F5529LP_UARTA1

#define Board_WATCHDOG0             MSP_EXP430F5529LP_WATCHDOG

#define Board_WIFI                  MSP_EXP430F5529LP_WIFI
#define Board_WIFI_SPI              MSP_EXP430F5529LP_SPIB0

#define CPY_BUFF_SIZE               256

/* Board specific I2C addresses */
#define Board_TMP006_ADDR           (0x40)
#define Board_RF430CL330_ADDR       (0x28)
#define Board_TPL0401_ADDR          (0x40)

#ifdef __cplusplus
}
#endif

#endif /* __BOARD_H */
