/*
 * com.h
 *
 *  Created on: Jul 20, 2016
 *      Author: roy
 */

#ifndef COM_H_
#define COM_H_

// constants needed for the Virtual Register Space ( VRS ) definition
#define LOVRS			64	// length of VRS
#define LORVRS			7	// length of Ram based VRS
#define LOCA	21	// Length Of Calibration Arrays, N in other documents

// The flash portion of the VRS is stored in Info C, D
// of the msp430f5528. Each info segment contains 128 bytes, so the
// VRS must be split into 2 pieces of flash memory.

// Note these register locations are compatable with TST_47
// ConfigROM
#define VRS_REVISION_NUMBER_OFFSET		        0
#define VRS_SERIAL_NUMBER_OFFSET			    1
#define VRS_FIRMWARE_CODE_OFFSET			    2
#define VRS_ELECTRONIC_HARDWARE_CODE_OFFSET	    3
#define VRS_APPLICATION_CODE_OFFSET			    4
#define VRS_FULL_SCALE_OFFSET				    5
#define VRS_START_OF_HES_CAL_DATA_OFFSET        6
#define VRS_START_OF_PRESS_CAL_DATA_OFFSET      (7 + (LOCA-1))
#define VRS_HEATER_THRESHOLDS_OFFSET            (8 + (2 * (LOCA-1)))

// Start of RAM based VRS	****************************************************
// Note these register locations are changed from TST_47
#define VRS_HES_OFFSET					    (LOVRS - 8)
#define VRS_STATUS_OFFSET					(LOVRS - 7)
#define VRS_COMMAND_OFFSET 					(LOVRS - 6)
#define VRS_BUFFER_OFFSET					(LOVRS - 5)
#define VRS_BUFFER_COUNTER_OFFSET			(LOVRS - 4)
#define VRS_PRESSURE_OFFSET					(LOVRS - 3)
#define VRS_TEMPERATURE_READING_OFFSET      (LOVRS - 2)
// End of RAM based VRS ********************************************************
// The last entry in the VRS. 	 bits 31-16 are reserved, bits 15-0 are the crc
#define CRC16_OFFSET						(LOVRS - 1)


// Length Of Uart Read Buffer, see uart_read_fxn() in com.c
#define LOURB	16

// Transaction Code values used for the packet protocol
#define RD_REQ		0
#define RD_RESP		1
#define WR_REQ		2
#define WR_RESP		3
#define NO_PKT		7

// states for detect_packet()
#define FIND_START		0
#define FIND_TC_TL		1
#define CHECK_CRC		2

// length of a write request packet
#define LOAWRP		9

// The node ID for this node
#define MSP430_ID			1
// The node ID for the host PC
#define DESTINATION_ID 		0
// This is the maximum length of a response packet being sent back to a host
#define MAX_TX_PACKET_LENGTH		8

// Length Of Continuous Readout Packet
#define LOCRP		13

// Flags used in the VRS Status Register
#define VRS_STATUS_FLAG_FLASH_ROM_VERIFICATION	0x80000000
#define VRS_STATUS_FLAG_CALIBRATION_MODE		0x40000000
#define VRS_STATUS_FLAG_TEST_MODE				0x20000000
#define VRS_STATUS_FLAG_DO_NOT_SLEEP			0x10000000	// only used in LCD Level
//      VRS_STATUS_FLAG_HES_ISO_MODE in TST_47
#define VRS_STATUS_FLAG_CONT_READOUT_MODE		0x08000000
#define VRS_STATUS_FLAG_LCD_HEATER_ENABLED      0x04000000  // only used in LCD 4-20mA

// Flags used in the VRS Command Register
#define VRS_CMD_FLAG_CLEAR_BUFFER 				0x80000000
#define VRS_CMD_FLAG_CLEAR_BUFFER_COUNTER 		0x40000000
#define	VRS_CMD_FLAG_WRITE_FLASH				0x20000000
#define VRS_CMD_FLAG_GOTO_CALIBRATE_MODE 		0x10000000
#define VRS_CMD_FLAG_GOTO_TEST_MODE 			0x08000000
#define VRS_CMD_FLAG_DO_NOT_SLEEP	 			0x04000000	// only used in LCD Level
//      VRS_CMD_FLAG_GOTO_HES_ISI_MODE in TST_47
#define VRS_CMD_FLAG_GOTO_CONT_READOUT_MODE		0x02000000
#define VRS_CMD_FLAG_ENABLE_LCD_HEATER          0x01000000  // only used in LCD 4-20mA
#define VRS_CMD_FLAG_COEFF_SELECTION_MODE		0x00800000  // Not present in TST_47

// stuff needed to manage the flash memory
#define UNLOCK_INFO_A			FCTL3 = 0xA540
#define LOCK_INFO_A				FCTL3 = 0xA550
#define LOCK_FLASH				FCTL3 = 0xA550
#define UNLOCK_FLASH			FCTL3 = 0xA540
#define SEGMENT_ERASE			FCTL1 = 0xA502;
#define LONG_WORD_WRITE			FCTL1 = 0xA580

// When the calibrated slope (in the VRS) is set to this value
// it indicates that the unit has been configured, but NOT calibrated.
#define ERROR_VALUE_PSI 	1.0


// Codes used in the Electronic Hardware Code Register
// This code allows the firmware to determine which code it
// should be operating.
// see SPI_UCB0.c , compute_pressure()
#define VRS_EHC_VOLTAGE             1
#define VRS_EHC_4_20MA              2
#define VRS_EHC_LCD_BATTERY         5
#define VRS_EHC_LCD_4_20MA          6


/*  MSP430 Communication Port Assignments

                PCB_1       PCB_2       PCB_5       PCB_6

    UCA0        UART        UART        UART        UART

    UCA1        unused      unused      unused      4-20mA

    UCB0        DAC         4-20mA      LCD         LCD

    UCB1        HES         HES         HES         HES

*/



#endif /* COM_H_ */
