/*
 *  ======== empty_min.c ========
 */

/*
 * 5.30.17
 * Added Coefficient Selection Mode
 * Enables the java CT-7 to instruct the DUT which set of coefficients to
 * use during testing.
 *
 */

/* XDCtools Header files */
#include <xdc/std.h>
#include <stdio.h>

#include <xdc/runtime/log.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>


/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/I2C.h>
#include <ti/drivers/i2c/I2CUSCIB.h>

// This was added 6.16.16 so that the symbols generated by .cfg
// can be recognized
#include <xdc/cfg/global.h>
#include <xdc/runtime/System.h>



/* Board Header file */
#include "my_board.h"

extern  void my_board_initGPIO( void );
extern void my_board_init_I2C( void );
extern void my_board_init_UART( void );
extern void init_VRS(void);
unsigned int LED_count = 0;


Void heartBeatFxn( void )
{
	LED_count++;

	// timer0 is set up to interrupt every 25mS, so it occurs 40 times per second

	// operate the Hall Effect Sensor ( AS5510 )
	// It occurs 40 times/second ( every 25mS )
	Semaphore_post( HES_sem );

	if( LED_count == 39 )
	{
		// enable LED1 for 10mS
		GPIO_write(LED1, LED1_ON);



	}
	else
	{
		GPIO_write(LED1, LED1_OFF);
	}

	if( LED_count >= 40 )
	{
		LED_count = 0;
	}

	// disabled 11.29.16 for presssure sensor development
	// Semaphore_post( HES_sem );

	// changed to a continuously operating semaphore on 8.23.16
	// Semaphore_post( uart_read_sem );	// moved from I2C code on 8.19.16

}

/*
 *  ======== main ========
 */
int main(void)
{
	extern void set_vcore_up( void );
	extern void init_ADC12( void );

	set_vcore_up();
    // Task_Params taskParams;
    /* Call board init functions */
    // Board_initGeneral();
    my_board_initGPIO();
    my_board_init_I2C();
    my_board_init_UART();
    // Board_initSDSPI();
    // Board_initSPI();
    // Board_initUART();
    // Board_initUSB(Board_USBDEVICE);
    // Board_initWatchdog();
    // Board_initWiFi();

    /* Turn off user LED  */
    GPIO_write(LED1, LED1_OFF);

    init_ADC12();

    init_VRS();

    /* Start BIOS */
    BIOS_start();

    return (0);
}
