/*
 * my_board.c
 *
 *  Created on: May 27, 2016
 *      Author: roy
 */

#include "my_board.h"

#include <ti/drivers/GPIO.h>
#include <ti/drivers/I2C.h>
#include <ti/drivers/i2c/I2CUSCIB.h>
#include <ti/drivers/gpio/GPIOMSP430.h>

/* BIOS Header files, copied from main.c on 6.20.16   */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>


// This was added 6.16.16 so that the symbols generated by .cfg
// can be recognized
#include <xdc/cfg/global.h>
#include <xdc/std.h>
#include <xdc/runtime/System.h>
#include <xdc/runtime/Timestamp.h>
#include <msp430.h>
#include <inc/hw_memmap.h>
#include <dma.h>
#include <usci_b_i2c.h>
#include <usci_b_spi.h>
#include <ucs.h>
#include <gpio.h>
#include <pmm.h>
#include <wdt_a.h>


GPIO_PinConfig gpioPinConfigs[] =
{
    /* Output pins */
    /* LED1 */
    GPIOMSP430_P1_0 | GPIO_CFG_OUT_STD | GPIO_CFG_OUT_STR_LOW | GPIO_CFG_OUT_LOW,
};

GPIO_CallbackFxn gpioCallbackFunctions[] =
{
    NULL,  /* MSP_EXP430F5529LP_S1 */
    NULL   /* MSP_EXP430F5529LP_S2 */
};

/* The device-specific GPIO_config structure */
const GPIOMSP430_Config GPIOMSP430_config =
{
    .pinConfigs = (GPIO_PinConfig *)gpioPinConfigs,
    .callbacks = (GPIO_CallbackFxn *)gpioCallbackFunctions,
    .numberOfPinConfigs = sizeof(gpioPinConfigs)/sizeof(GPIO_PinConfig),
    .numberOfCallbacks = sizeof(gpioCallbackFunctions)/sizeof(GPIO_CallbackFxn)
};

void my_board_initGPIO( void )
{
	GPIO_init();	// this must be called before using GPIO

}


void set_vcore_up( void )
{
	/*
	 * Note: You have already been waiting for 15mS in main()
	 * before this function gets called.
	 */

	DOUBLET value;

	#define PWR_UP_COUNT 	8200	// 15mS
	#define VCORE_COUNT 	(PWR_UP_COUNT/3)
	QUADLET dwell_count;

	// Wait here for approximately 15mS,
	// until the all supplies are fully stabilized.
	for(dwell_count=0; dwell_count<PWR_UP_COUNT; dwell_count++)
	{
		__no_operation();
	}

    // unlock all of the PMM registers
	PMMCTL0_H = 0xA5;

	// set SVSH and SVMH thresholds (for DVCC)
	CONFIGURE_SVSH_SVMH;

	// set SVML to 1 in Register SVSMLCTL ( the core voltage reached level )
	SVSMLRRL_SET_TO_1;

	// Reading this register will clear flags in this register
	value = PMMIFG;
	if( value )
	{
	    __no_operation();
	}

	// wait here until this flag is set in PMMIFG
	while( SVSMLDLYIFG == 0 )
	{
		break;
	}

	// clear flags in PMMIFG
	PMMIFG = 0;
	// set PMMCOREV == 1 (raise the core voltage by 1 step)
	PMMCTL0 = ((PMMCTL0 & 0x00FC) | 0xA501);

	// Wait here for approximately 5mS, until the VCORE has stabilized.
	for(dwell_count=0; dwell_count<VCORE_COUNT; dwell_count++)
	{
		__no_operation();
	}

	// wait here until this flag is set in PMMIFG
	// this flag does not seem to be reliable !
	// without the delay above you cannot see
	// this vcore step on the scope
	/*
	while( SVMLVLRIFG == 0 )
	{
	    break;
	}
	*/

	// Program SVSL to the next level
	// write 1 to SVSLRVL in SVSMLCTL
	SVSMLCTL = ((SVSMLCTL & 0xFCFF) | 0x0100);

	// Program the core voltage 1 more step up !

	// set SVML to 1 in Register SVSMLCTL ( the core voltage reached level )
	SVSMLRRL_SET_TO_2;

	// Reading this register will clear flags in this register
	value = PMMIFG;

	// wait here until this flag is set in PMMIFG
	while( SVSMLDLYIFG == 0 )
	{
		break;
	}

	// set PMMCOREV == 2 (raise the core voltage by 1 step)
	PMMCTL0 = ((PMMCTL0 & 0x00FC) | 0xA502);


	/* Not reliable
	// wait here until this flag is set in PMMIFG
	while( SVMLVLRIFG == 0 )
	{
		break;
	}
	*/

	// Wait here for approximately 5mS, until the VCORE has stabilized.
	for(dwell_count=0; dwell_count<VCORE_COUNT; dwell_count++)
	{
		__no_operation();
	}

	// Program SVSL to the next level
	// write 2 to SVSLRVL in SVSMLCTL
	SVSMLCTL = ((SVSMLCTL & 0xFCFF) | 0x0200);

	/*
	 * After this is all done these are the settings that should be present
	 * in the PMM module.
	 * PMMCOREV == 2 (for an MCLK of 15.01MHz)
	 *
	 * SVSL
	 * 		SVSLRVL 	== 2
	 * 		SVSMLRRL	== 2
	 *
	 * SVSH
	 * 		SVSHRVL		== 2
	 * 		SVSMHRRL	== 2
	 *
	 */

}	// end of set_vcore_up() ***************************************************


