/*
 * my_board.h
 *
 *  Created on: May 27, 2016
 *      Author: roy
 */

#ifndef MY_BOARD_H_
#define MY_BOARD_H_

#include "misc_stuff.h"

#define LED1_OFF 	0
#define LED1_ON 	1

typedef enum tag_my_GPIOName
{
    LED1 = 0,

	my_GPIOCount
}
my_GPIOName;


// I2C UCB1 stuff **************************************************************
//  See I2C_open()
#define USCIB1_index	1	// USCIB1
#define USCIB0_index	0	// USCIB0

#define LENGTH_OF_I2C_WRITE_BUF		5
#define LENGTH_OF_I2C_READ_BUF		5


typedef enum tag_my_I2C
{
	the_I2C = 0,

    I2C_DRIVER_COUNT
}
my_I2C;


// Stuff for the Hall Effect Sensor ( HES ) ***********************************
// The HES is operated via the I2C Bus (using MSP430 interface UCB1)

#define ADDRESS_SENSITIVITY     0x0B

#define HES_SENSITIVITY_25mT    0x01

// end HES Stuff



#define CONFIGURE_SVSH_SVMH	 	    (SVSMHCTL &= 0xFCF8) + (SVSMHCTL |= 0x0202)
// set SVML to 1
#define SVSMLRRL_SET_TO_1	 		(SVSMLCTL &= 0xFFF8) + (SVSMLCTL |= 0x0001)
// set SVML to 2
#define SVSMLRRL_SET_TO_2	 		(SVSMLCTL &= 0xFFF8) + (SVSMLCTL |= 0x0002)




#endif /* MY_BOARD_H_ */
