/* --COPYRIGHT--,BSD
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
/*
 * demo.h
 *
 *  Created on: Dec 11, 2016
 *      Author: a0272918
 */

#ifndef DEMO_H_
#define DEMO_H_

#include "stdbool.h"

/*
 * Macros for processing CapTIvate event flags.
 */
#define TOUCH		(pSensor->bSensorTouch == true)
#define NO_TOUCH    (pSensor->bSensorTouch == false)
#define PROX		(pSensor->bSensorProx == true)
#define NO_PROX		(pSensor->bSensorProx == false)
#define NEW_TOUCH 	((pSensor->bSensorTouch == true) && (pSensor->bSensorPrevTouch == false))
#define NEG_TOUCH 	(pSensor->bSensorNegativeTouch == true)
#define EXIT_TOUCH	((pSensor->bSensorTouch == false) && (pSensor->bSensorPrevTouch == true))
#define DOMINANT 	(((tButtonSensorParams*)pSensor->pSensorParams)->ui16DominantElement)

/*
 * Enumeration of button names. These will be passed to the MSP432.
 * The MSP432 will then use another enumeration to convert the values to
 * characters.
 */
typedef enum
{	eButton0 = 0,
	eButton1,
	eButton2,


}ButtonMap_t;

/*
 *  Public functions
 */
void InitDemo(void);

#endif /* DEMO_H_ */
