/* --COPYRIGHT--,BSD
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/


// Generated by Captivate Design Center v1_30_10_00 on Thu Jan 12 16:20:52 CST 2017


//*****************************************************************************
// CAPT_UserConfig.c
//
// \version 1.04.00.00
// Released on Mon, Aug 15, 2016  5:06:13 PM
//
//*****************************************************************************

//*****************************************************************************
//
// NOTE: This is an automatically generated source code file!  The Captivate
// Design Center generates the User Configuration file automatically based
// upon the sensor layout that was created.
//
// Changes to this file will be OVERWRITTEN if a you select
// "Update Existing Project" under "Generate Source Code" in the Design Center.
//
// To avoid interference with the code generation process, keep ALL application
// code external to this file.
//
//*****************************************************************************

#include "CAPT_UserConfig.h"

//*****************************************************************************
//
//! Captivate Element Definitions
//! All elements in this application are defined below.
//! Each element has 3 components:
//!  1) a raw count array (One index per freq. scanned) (uint16_t)
//!  2) a tuning array (One index per freq. scanned) (tCaptivateElementTuning)
//!  3) a element structure (tElement)
//
//*****************************************************************************
// Sensor: numericKeypadSensor, Element: E00
uint16_t numericKeypadSensor_E00_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning numericKeypadSensor_E00_Tuning[CAPT_SELF_FREQ_CNT];
tElement numericKeypadSensor_E00 =
{
	    .ui8RxPin = 0,
	    .ui8RxBlock = 0,
	    .ui8TouchThreshold = 25,
	    .pRawCount = numericKeypadSensor_E00_RawCnts,
	    .pTuning = numericKeypadSensor_E00_Tuning,
};

// Sensor: numericKeypadSensor, Element: E01
uint16_t numericKeypadSensor_E01_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning numericKeypadSensor_E01_Tuning[CAPT_SELF_FREQ_CNT];
tElement numericKeypadSensor_E01 =
{
	    .ui8RxPin = 0,
	    .ui8RxBlock = 2,
	    .ui8TouchThreshold = 25,
	    .pRawCount = numericKeypadSensor_E01_RawCnts,
	    .pTuning = numericKeypadSensor_E01_Tuning,
};

// Sensor: numericKeypadSensor, Element: E02
uint16_t numericKeypadSensor_E02_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning numericKeypadSensor_E02_Tuning[CAPT_SELF_FREQ_CNT];
tElement numericKeypadSensor_E02 =
{
	    .ui8RxPin = 0,
	    .ui8RxBlock = 3,
	    .ui8TouchThreshold = 25,
	    .pRawCount = numericKeypadSensor_E02_RawCnts,
	    .pTuning = numericKeypadSensor_E02_Tuning,
};


// Sensor: proxAndGuardSensor, Element: E00
uint16_t proxAndGuardSensor_E00_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning proxAndGuardSensor_E00_Tuning[CAPT_SELF_FREQ_CNT];
tElement proxAndGuardSensor_E00 =
{
    .ui8RxPin = 3,
    .ui8RxBlock = 3,
    .ui8TouchThreshold = 10,
    .pRawCount = proxAndGuardSensor_E00_RawCnts,
    .pTuning = proxAndGuardSensor_E00_Tuning,
};

// Sensor: SLD00, Element: E00
uint16_t SLD00_E00_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning SLD00_E00_Tuning[CAPT_SELF_FREQ_CNT];
tElement SLD00_E00 =
{
    .ui8RxPin = 1,
    .ui8RxBlock = 0,
    .ui8TouchThreshold = 10,
    .pRawCount = SLD00_E00_RawCnts,
    .pTuning = SLD00_E00_Tuning,
};

// Sensor: SLD00, Element: E01
uint16_t SLD00_E01_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning SLD00_E01_Tuning[CAPT_SELF_FREQ_CNT];
tElement SLD00_E01 =
{
    .ui8RxPin = 1,
    .ui8RxBlock = 2,
    .ui8TouchThreshold = 10,
    .pRawCount = SLD00_E01_RawCnts,
    .pTuning = SLD00_E01_Tuning,
};

// Sensor: SLD00, Element: E02
uint16_t SLD00_E02_RawCnts[CAPT_SELF_FREQ_CNT];
tCaptivateElementTuning SLD00_E02_Tuning[CAPT_SELF_FREQ_CNT];
tElement SLD00_E02 =
{
    .ui8RxPin = 1,
    .ui8RxBlock = 3,
    .ui8TouchThreshold = 10,
    .pRawCount = SLD00_E02_RawCnts,
    .pTuning = SLD00_E02_Tuning,
};



//*****************************************************************************
//
//! Captivate Time Cycle Definitions
//! All time cycles in this application are defined below.  Time cycles are
//! groups of elements that are measured together in parallel in one time slot.
//! Each cycle has 2 components:
//!  1) an element pointer array to the member elements (tElement*)
//!  2) a cycle structure (tCycle)
//
//*****************************************************************************
// Time Cycle: numericKeypadSensor_C00
tElement* numericKeypadSensor_C00_Elements[3] =
{
    &numericKeypadSensor_E00,
    &numericKeypadSensor_E01,
    &numericKeypadSensor_E02,

};
tCycle numericKeypadSensor_C00 =
{
    .ui8NrOfElements = 3,
    .pElements = numericKeypadSensor_C00_Elements,
};


// Time Cycle: proxAndGuardSensor_C00
tElement* proxAndGuardSensor_C00_Elements[1] =
{
    &proxAndGuardSensor_E00,
};
tCycle proxAndGuardSensor_C00 =
{
    .ui8NrOfElements = 1,
    .pElements = proxAndGuardSensor_C00_Elements,
};


// Time Cycle: SLD00_C00
tElement* SLD00_C00_Elements[3] =
{
    &SLD00_E00,
    &SLD00_E01,
    &SLD00_E02,
};
tCycle SLD00_C00 =
{
    .ui8NrOfElements = 3,
    .pElements = SLD00_C00_Elements,
};



//*****************************************************************************
//
//! Captivate Sensor Definitions
//! All sensors in this application are defined below.  Sensors are
//! groups of time cycles that utilize raw measurement data to create an
//! abstract sensor type, such as a button, slider, wheel, or prox sensor.
//! Each sensor has 3 components:
//!  1) a cycle pointer array to the member time cycles (tCycle*)
//!  2) a sensor-specific parameter structure (tGenericSensorParams)
//!  3) a sensor structure (tSensor)
//
//*****************************************************************************
//Sensor: numericKeypadSensor
const tCycle* numericKeypadSensor_Cycles[1] =
{
    &numericKeypadSensor_C00,

};

tButtonSensorParams numericKeypadSensor_Params;
tSensor numericKeypadSensor =
{
    // Basic Properties
    .TypeOfSensor = eButtonGroup,
    .SensingMethod = eSelf,
    .DirectionOfInterest = eDOIDown,
    .pvCallback = NULL,
    .ui8NrOfCycles = 1,
    .pCycle = numericKeypadSensor_Cycles,
    .pSensorParams = (tGenericSensorParams*)&numericKeypadSensor_Params,
    // Conversion Control Parameters
    .ui16ConversionCount = 300,
    .ui16ConversionGain = 100,
    .ui8FreqDiv = 2,
    .ui8ChargeLength = 0,
    .ui8TransferLength = 0,
    .bModEnable = false,
    .ui8BiasControl = 3,
    .bCsDischarge = true,
    .bLpmControl = false,
    .ui8InputSyncControl = 0,
    .bTimerSyncControl = false,
    .bIdleState = true,
    // Tuning  Parameters
    .ui16ProxThreshold = 7,
    .ui16NegativeTouchThreshold = 20,
    .ui16ErrorThreshold = 8000,
    .ui16TimeoutThreshold = 1980,
    .ProxDbThreshold.DbIn = 1,
    .ProxDbThreshold.DbOut = 0,
    .TouchDbThreshold.DbIn = 1,
    .TouchDbThreshold.DbOut = 0,
    .bCountFilterEnable = true,
    .ui8CntBeta = 1,
    .bSensorHalt = false,
    .bPTSensorHalt = true,
    .bPTElementHalt = true,
    .ui8LTABeta = 7,
    .bReCalibrateEnable = true,
};

//Sensor: proxAndGuardSensor
const tCycle* proxAndGuardSensor_Cycles[1] =
{
    &proxAndGuardSensor_C00,
};

tProxSensorParams proxAndGuardSensor_Params =
{
    .pSensor = NULL,
    .ui8NumberOfSensors = 0,
};

tSensor proxAndGuardSensor =
{
    // Basic Properties
    .TypeOfSensor = eProx,
    .SensingMethod = eSelf,
    .DirectionOfInterest = eDOIDown,
    .pvCallback = NULL,
    .ui8NrOfCycles = 1,
    .pCycle = proxAndGuardSensor_Cycles,
    .pSensorParams = (tGenericSensorParams*)&proxAndGuardSensor_Params,
    // Conversion Control Parameters
    .ui16ConversionCount = 1000,
    .ui16ConversionGain = 100,
    .ui8FreqDiv = 3,
    .ui8ChargeLength = 0,
    .ui8TransferLength = 0,
    .bModEnable = false,
    .ui8BiasControl = 3,
    .bCsDischarge = true,
    .bLpmControl = false,
    .ui8InputSyncControl = 0,
    .bTimerSyncControl = false,
    .bIdleState = true,
    // Tuning  Parameters
    .ui16ProxThreshold = 20,
    .ui16NegativeTouchThreshold = 20,
    .ui16ErrorThreshold = 2000,
    .ui16TimeoutThreshold = 7920,
    .ProxDbThreshold.DbIn = 1,
    .ProxDbThreshold.DbOut = 3,
    .TouchDbThreshold.DbIn = 0,
    .TouchDbThreshold.DbOut = 15,
    .bCountFilterEnable = true,
    .ui8CntBeta = 2,
    .bSensorHalt = false,
    .bPTSensorHalt = true,
    .bPTElementHalt = true,
    .ui8LTABeta = 7,
    .bReCalibrateEnable = true,
};


//Sensor: SLD00
const tCycle* SLD00_Cycles[1] =
{
    &SLD00_C00,
};

tSliderSensorParams SLD00_Params =
{
    .ui8TotalElements = 3,
    .ui16Resolution = 100,
    .SliderBeta = 100,
    .SliderLower = 0,
    .SliderUpper = 63,
    .SliderAlgorithm = eVectors,
    .SliderFilterEnable = true,
};

tSensor SLD00 =
{
    // Basic Properties
    .TypeOfSensor = eSlider,
    .SensingMethod = eSelf,
    .DirectionOfInterest = eDOIDown,
    .pvCallback = NULL,
    .ui8NrOfCycles = 1,
    .pCycle = SLD00_Cycles,
    .pSensorParams = (tGenericSensorParams*)&SLD00_Params,
    // Conversion Control Parameters
    .ui16ConversionCount = 500,
    .ui16ConversionGain = 200,
    .ui8FreqDiv = 2,
    .ui8ChargeLength = 0,
    .ui8TransferLength = 0,
    .bModEnable = false,
    .ui8BiasControl = 3,
    .bCsDischarge = true,
    .bLpmControl = false,
    .ui8InputSyncControl = 0,
    .bTimerSyncControl = false,
    .bIdleState = true,
    // Tuning  Parameters
    .ui16ProxThreshold = 10,
    .ui16NegativeTouchThreshold = 20,
    .ui16ErrorThreshold = 8191,
    .ui16TimeoutThreshold = 10000,
    .ProxDbThreshold.DbIn = 1,
    .ProxDbThreshold.DbOut = 0,
    .TouchDbThreshold.DbIn = 1,
    .TouchDbThreshold.DbOut = 0,
    .bCountFilterEnable = false,
    .ui8CntBeta = 1,
    .bSensorHalt = false,
    .bPTSensorHalt = true,
    .bPTElementHalt = true,
    .ui8LTABeta = 7,
    .bReCalibrateEnable = true,
};


#if (CAPT_CONDUCTED_NOISE_IMMUNITY_ENABLE==true)
//*****************************************************************************
//
//! \var g_EMCConfig
//! This structure stores the EMC configuration for this application.
//
//*****************************************************************************
const tEMCConfig g_EMCConfig =
{
	// Conversion Style
	.selfModeConversionStyle = eMultiFrequency,
	.projModeConversionStyle = eMultiFrequencyWithOutlierRemoval,
	
	// Oversampling Style
	.selfModeOversamplingStyle = eNoOversampling,
	.projModeOversamplingStyle = eNoOversampling,
	
	// Jitter Filter Enable
	.bJitterFilterEnable = true,
	
	// Noise Thresholds and Calibration Noise Limits
	.ui8NoiseThreshold = 20,
	.ui16CalibrationNoiseLimit = 10,
	.ui8CalibrationTestSampleSize = 8,
		
	// Dynamic Threshold Adjustment Parameters
	.bEnableDynamicThresholdAdjustment = true,
	.ui8MaxRelThreshAdj = 76,
	.ui8NoiseLevelFilterEntryThresh = 40,
	.ui8NoiseLevelFilterExitThresh = 0,
	.ui8NoiseLevelFilterDown = 6,
	.ui8NoiseLevelFilterUp = 1,
	.coeffA = _IQ31(0.0065),
	.coeffB = _IQ31(0.050)
};
#endif

//*****************************************************************************
//
//! \var g_pCaptivateSensorArray
//! This array allows for indexed access to any
//! sensor in the configuration.
//
//*****************************************************************************
tSensor* g_pCaptivateSensorArray[CAPT_SENSOR_COUNT] =
{
    &numericKeypadSensor,
    &proxAndGuardSensor,
	&SLD00,

};


//*****************************************************************************
//
//! \var g_uiApp
//! This structure stores the global settings for this application.
//
//*****************************************************************************
tCaptivateApplication g_uiApp =
{
    .state = eUIActive,
	.pSensorList = &g_pCaptivateSensorArray[0],
    .ui8NrOfSensors = CAPT_SENSOR_COUNT,
    .ui8AppLPM = LPM3_bits,
    .bElementDataTxEnable = true,
    .bSensorDataTxEnable = true,
    .ui16ActiveModeScanPeriod = 20,
    .ui16WakeOnProxModeScanPeriod = 100,
    .ui16InactivityTimeout = 512,
    .ui8WakeupInterval = 7,
};
