#ifndef LEA_PARAMS_H_
#define LEA_PARAMS_H_

#include <stdint.h>

//*****************************************************************************
//
//! \brief Parameter structure for rmpymsf function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_rmpymsfParams;

//*****************************************************************************
//
//! \brief Parameter structure for raddms function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_raddmsParams;

//*****************************************************************************
//
//! \brief Parameter structure for rsubms function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_rsubmsParams;

//*****************************************************************************
//
//! \brief Parameter structure for rmpymlf function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_rmpymlfParams;

//*****************************************************************************
//
//! \brief Parameter structure for cmpymsf function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_cmpymsfParams;

//*****************************************************************************
//
//! \brief Parameter structure for raddml function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_raddmlParams;

//*****************************************************************************
//
//! \brief Parameter structure for rsubml function.
//
//*****************************************************************************
typedef struct {
    uint16_t vectorSize;
    uint16_t input2;
    uint16_t output;
    uint16_t input1Offset;
    uint16_t input2Offset;
    uint16_t outputOffset;
} LEA_rsubmlParams;

#endif /* LEA_PARAMS_H_ */
