//*****************************************************************************
//  Texas Instruments, Inc
//  Dec 2020
//******************************************************************************

#include "lea_intrinsics.h"
int i_real(complex_w x){return x.real;}
int i_imag(complex_w x){return x.imag;}
long i_mult_l(int x, int y){
    int x_tmp = (int) (short) x;
    int y_tmp = (int) (short) y;
    long z_tmp;

    if( (x&0xFFFF)==0x8000 && (y&0xFFFF)==0x8000 )
      z_tmp = 0x7FFFFFFF;
    else
      z_tmp = ((x_tmp*y_tmp) << 1);

    return z_tmp;
}
int i_extract_hi(long x){return ((x >> 16) & 0xFFFF);}
int i_extract_lo(long x){return (x & 0xFFFF);}
/*
int i_extract_hi(complex_w x){return x.imag;}
int i_extract_lo(complex_w x){return x.real;}
*/
int i_extract_hi_cplx(complex_w x){return x.imag;}
int i_extract_lo_cplx(complex_w x){return x.real;}
long i_mulsu_l(int x, int y){
    int x_tmp = (int) ((short) x);
    int y_tmp = (int) (y&0xffff);
    return (x_tmp*y_tmp);
}
long i_mulus_l(int x, int y){
    int y_tmp = (int) ((short) y);
    int x_tmp = (int) (x&0xffff);
    return (x_tmp*y_tmp);
}
//long i_muluu_l(int x, int y){return x*y;}
long i_muluu_l(int x, int y){
    int y_tmp = (int) (y&0xffff);
        int x_tmp = (int) (x&0xffff); 
        return (x_tmp*y_tmp);
}
//long i_shr_addsu_l(long x, long y){return (x+((y >> 16) & 0xFFFF));}
long i_shr_addsu_l(long x, long y){

  long yy;
  double tmpx,tmpy,tmpz;
  long z;

  yy = (((int)y)>>16) & 0xFFFF;

  tmpx = (double)( (int)x );
  tmpy = (double)( (int)yy );
  tmpz = tmpx+tmpy;
  if( tmpz>2147483647.0 )
    z = 2147483647;
  else if( tmpz<-2147483648.0 )
    z = -2147483648;
  else
    z = x + yy;
  
  return z;

}
//long i_shr_addss_l(long x, long y){return (x+(y >> 15));}
long i_shr_addss_l(long x, long y){

  long yy;
  double tmpx,tmpy,tmpz;
  long z;
  
  yy = (int)y;
  yy = (yy>>15);

  tmpx = (double)( (int)x );
  tmpy = (double)( (int)yy );
  tmpz = tmpx+tmpy;
  if( tmpz>2147483647.0 )
    z = 2147483647;
  else if( tmpz<-2147483648.0 )
    z = -2147483648;
  else
    z = x + yy;
  
  return z;

}
void chess_separator(){}
complex_w max_(complex_w x, complex_w y){
  complex_w tmp;
  tmp.real = (x.real > y.real) ? x.real : y.real;
  tmp.imag = (x.imag > y.imag) ? x.imag : y.imag;
  return tmp;
}
complex_w i_update_lo(complex_w x, int y){
  complex_w tmp;
  
  tmp.imag = x.imag;
  tmp.real = y;
  return tmp;
}
complex_w i_update_hi(complex_w x, int y){
  complex_w tmp;
  
  tmp.imag = y;
  tmp.real = x.real;
  return tmp;
}
complex_w maxu_(complex_w x, complex_w y){
  complex_w tmp;
  tmp.real = ((unsigned int) (short) (x.real) > (unsigned int) (short) (y.real)) ? x.real : y.real;
  tmp.imag = ((unsigned int) (short) (x.imag) > (unsigned int) (short) (y.imag)) ? x.imag : y.imag;
  return tmp;
}
complex_w min_(complex_w x, complex_w y){
  complex_w tmp;
  tmp.real = (x.real < y.real) ? x.real : y.real;
  tmp.imag = (x.imag < y.imag) ? x.imag : y.imag;
  return tmp;
}
complex_w minu_(complex_w x, complex_w y){
  complex_w tmp;
  tmp.real = ((unsigned int) (short) (x.real) < (unsigned int) (short) (y.real)) ? x.real : y.real;
  tmp.imag = ((unsigned int) (short) (x.imag) < (unsigned int) (short) (y.imag)) ? x.imag : y.imag;
  return tmp;
}
//int i_mult(int x, int y){return (x*y) >> 15;}
int i_mult(int x, int y){
    int x_tmp = (int) (short) x;
    int y_tmp = (int) (short) y;
    int z_tmp;

    if( (x&0xFFFF)==0x8000 && (y&0xFFFF)==0x8000 )
      z_tmp = 0x7FFF;
    else
      z_tmp = ((x_tmp*y_tmp)>>15);

    return z_tmp;
}
complex_w i_subh_addl(complex_w x, complex_w y){
  complex_w tmp;

  //tmp.real = x.real + y.real;
  //tmp.imag = x.imag - y.imag;
  tmp.real = (int)( ((short)x.real) + ((short)y.real) );
  tmp.imag = (int)( ((short)x.imag) - ((short)y.imag) );

  // saturation is added
  if( tmp.real>32767 )
    tmp.real = 0x07FFF;
  else if( tmp.real<-32767 )
    tmp.real = 0xFFFF8000;
  if( tmp.imag>32767 )
    tmp.imag = 0x07FFF;
  else if( tmp.imag<-32767 )
    tmp.imag = 0xFFFF8000;
  return tmp;
}
complex_w i_add_cplx(complex_w x, complex_w y){
  complex_w tmp;

  //tmp.real = x.real + y.real;
  //tmp.imag = x.imag + y.imag;
  tmp.real = (int)( ((short)x.real) + ((short)y.real) );
  tmp.imag = (int)( ((short)x.imag) + ((short)y.imag) );

  // saturation is added
  if( tmp.real>32767 )
    tmp.real = 0x07FFF;
  else if( tmp.real<-32767 )
    tmp.real = 0xFFFF8000;
  if( tmp.imag>32767 )
    tmp.imag = 0x07FFF;
  else if( tmp.imag<-32767 )
    tmp.imag = 0xFFFF8000;

  return tmp;
}
complex_w i_sub_cplx(complex_w x, complex_w y){
  complex_w tmp;

  //tmp.real = x.real - y.real;
  //tmp.imag = x.imag - y.imag;
  tmp.real = (int)( ((short)x.real) - ((short)y.real) );
  tmp.imag = (int)( ((short)x.imag) - ((short)y.imag) );

  // saturation is added
  if( tmp.real>32767 )
    tmp.real = 0x07FFF;
  else if( tmp.real<-32767 )
    tmp.real = 0xFFFF8000;
  if( tmp.imag>32767 )
    tmp.imag = 0x07FFF;
  else if( tmp.imag<-32767 )
    tmp.imag = 0xFFFF8000;

  return tmp;
}
long i_add_long(long x, long y){

  double tmpx,tmpy,tmpz;
  long z;

  tmpx = (double)( (int)x );
  tmpy = (double)( (int)y );
  tmpz = tmpx+tmpy;
  if( tmpz>2147483647.0 )
    z = 2147483647;
  else if( tmpz<-2147483648.0 )
    z = -2147483648;
  else
    z = x + y;

  return z;
}
long i_sub_long(long x, long y){
  double tmpx,tmpy,tmpz;
  long z;

  tmpx = (double)( (int)x );
  tmpy = (double)( (int)y );
  tmpz = tmpx-tmpy;
  if( tmpz>2147483647.0 )
    z = 2147483647;
  else if( tmpz<-2147483648.0 )
    z = -2147483648;
  else
    z = x - y;

  return z;
}
int i_add_short(int x, int y){

  int z;

  //z = x+y;
  z = (int)( ((short)x)+((short)y) );
  if( z>32767)
    z = 32767;
  else if( z<-32768 )
    z = -32768;
  return z;

}
int i_sub_short(int x, int y){

  int z;

  //z = x-y;
  z = (int)( ((short)x)-((short)y) );
  if( z>32767)
    z = 32767;
  else if( z<-32768 )
    z = -32768;
  return z;

}
complex_w i_addh_subl(complex_w x, complex_w y){
  complex_w tmp;
  //tmp.real = x.real - y.real;
  //tmp.imag = x.imag + y.imag;
  tmp.real = (int)( ((short)x.real) - ((short)y.real) );
  tmp.imag = (int)( ((short)x.imag) + ((short)y.imag) );
  // saturation is added
  if( tmp.real>32767 )
    tmp.real = 0x07FFF;
  else if( tmp.real<-32767 )
    tmp.real = 0xFFFF8000;
  if( tmp.imag>32767 )
    tmp.imag = 0x07FFF;
  else if( tmp.imag<-32767 )
    tmp.imag = 0xFFFF8000;
  return tmp;
}
