#include <stdint.h>
#include "lea_support/lea_support.h"
#include "lea_support/lea_intrinsics.h"

//*****************************************************************************
//  Texas Instruments, Inc
//  Dec 2020
//******************************************************************************

// LEACMD_MPYMATRIX reference c code
void lea_rmpymsf(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int16_t *ptrInput1 = (int16_t *)input1;
    int16_t *ptrInput2 = (int16_t *)input2;
    int16_t *ptrOutput = (int16_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate results */
        ptrOutput[0] = __mpysf(ptrInput1[0], ptrInput2[0]);
        ptrOutput[1] = __mpysf(ptrInput1[1], ptrInput2[1]);

        /* Increment pointers. */
        ptrInput1 += offset1*2;
        ptrInput2 += offset2*2;
        ptrOutput += offsetOutput*2;
    }
}

// LEACMD_ADDMATRIX reference c code
void lea_raddms(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int16_t *ptrInput1 = (int16_t *)input1;
    int16_t *ptrInput2 = (int16_t *)input2;
    int16_t *ptrOutput = (int16_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate results */
        ptrOutput[0] = __adds(ptrInput1[0], ptrInput2[0]);
        ptrOutput[1] = __adds(ptrInput1[1], ptrInput2[1]);

        /* Increment pointers. */
        ptrInput1 += offset1*2;
        ptrInput2 += offset2*2;
        ptrOutput += offsetOutput*2;
    }
}

// LEACMD_SUBMATRIX reference c code
void lea_rsubms(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int16_t *ptrInput1 = (int16_t *)input1;
    int16_t *ptrInput2 = (int16_t *)input2;
    int16_t *ptrOutput = (int16_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate results */
        ptrOutput[0] = __subs(ptrInput1[0], ptrInput2[0]);
        ptrOutput[1] = __subs(ptrInput1[1], ptrInput2[1]);

        /* Increment pointers. */
        ptrInput1 += offset1*2;
        ptrInput2 += offset2*2;
        ptrOutput += offsetOutput*2;
    }
}

// LEACMD_MPYLONGMATRIX reference c code
void lea_rmpymlf(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int32_t *ptrInput1 = (int32_t *)input1;
    int32_t *ptrInput2 = (int32_t *)input2;
    int32_t *ptrOutput = (int32_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate result. */
        *ptrOutput = __mpylf(*ptrInput1, *ptrInput2);

        /* Increment pointers. */
        ptrInput1 += offset1;
        ptrInput2 += offset2;
        ptrOutput += offsetOutput;
    }
}

// LEACMD_ADDLONGMATRIX reference c code
void lea_raddml(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int32_t *ptrInput1 = (int32_t *)input1;
    int32_t *ptrInput2 = (int32_t *)input2;
    int32_t *ptrOutput = (int32_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate result. */
        *ptrOutput = __addl(*ptrInput1, *ptrInput2);

        /* Increment pointers. */
        ptrInput1 += offset1;
        ptrInput2 += offset2;
        ptrOutput += offsetOutput;
    }
}

// LEACMD_SUBLONGMATRIX reference c code
void lea_rsubml(void *input1, void *input2, void *output, uint16_t length, uint16_t offset1, uint16_t offset2, uint16_t offsetOutput)
{
    uint16_t i;
    int32_t *ptrInput1 = (int32_t *)input1;
    int32_t *ptrInput2 = (int32_t *)input2;
    int32_t *ptrOutput = (int32_t *)output;

    for (i = 0; i < length; i++) {
        /* Calculate result. */
        *ptrOutput = __subl(*ptrInput1, *ptrInput2);

        /* Increment pointers. */
        ptrInput1 += offset1;
        ptrInput2 += offset2;
        ptrOutput += offsetOutput;
    }
}


