## Example Summary

Application that demonstrates switching from sleep mode (LPM0) to DEEP_SLEEP0(LPM3.5) The TI Drivers by default aggresively activate the power saving modes whenever possible. This application demonstrates how to constraint certain low power levels and allow certain low power levels. This application assumes the default policy function(policyFxn) specified in the hwattrib in the board file and the default value is PowerMSP432_sleepPolicy. Then on Board_GPIO_BUTTON0 press switches to deep sleep.

It is often best to begin application development with automatic power transitions disabled, and then after basic
application debugging is complete, enable the policy with constraints set to permit the lightest sleep state
only. Once that is found to be working, progressively release more constraints to allow transitions to
deeper sleep states.

Some devices have a hardware attribute enableParking in the board file - when enableParking is set to true, it enables automatic pin parking during LPM3 (PowerMSP432_DEEPSLEEP_0) and LPM4 (PowerMSP432_DEEPSLEEP_1) and input pins are not left floating.

## Peripherals Exercised

* `Board_GPIO_LED1` - Indicates that the board was initialized within `mainThread()`. Turns off on Board_GPIO_BUTTON1 press.
* `Board_GPIO_BUTTON0` - Switches from sleep to deep sleep

## Resources & Jumper Settings

> If you're using an IDE (such as CCS or IAR), please refer to Board.html in your project
directory for resources used and board-specific jumper settings. Otherwise, you can find
Board.html in the directory \<SDK_INSTALL_DIR\>/source/ti/boards/\<BOARD\>.


## Example Usage

* Run the example. `Board_GPIO_LED1` turns ON to indicate driver
initialization is complete.

* Pressing `Board_GPIO_BUTTON0` will turn off `Board_GPIO_LED1` and the device will enter
deep sleep.

## Application Design Details
* Every time idle loop is executed a decision is made to go into the lowest power mode
specified by the combination of selected policyFxn (PowerMSP432_sleepPolicy or PowerMSP432_deepSleepPolicy)
and the contrainsts in power modes
Device goes into SLEEP mode(LPM0) whenever in idle mode.
* On button press of Board_GPIO_BUTTON0 the low power mode switches to Deep Sleep (3.5) as sected policyFxn is now PowerMSP432_deepSleepPolicy
* The GPIOs are set to low power consumption mode

TI-RTOS:

* When building in Code Composer Studio, the configuration project will be imported
along with the example. The configuration project is referenced by the example, so it
will be built first.  These projects can be found under
\<SDK_INSTALL_DIR>\/kernel/tirtos/builds/\<BOARD\>/(release|debug)/(ccs|gcc).

FreeRTOS:

* Please view the `FreeRTOSConfig.h` header file for example configuration
information.
