/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *  ======== powerdeepsleep.c ========
 */

/* Driver Header files */
#include <ti/drivers/Power.h>
#include <ti/drivers/power/PowerMSP432.h>
#include <ti/drivers/GPIO.h>

/* Driverlib Header files */
#include <ti/devices/msp432p4xx/driverlib/driverlib.h>

/* Board Header file */
#include "Board.h"

#include <unistd.h>

/*
 *  ======== gpioButtonFxn0 ========
 *  Callback function for the GPIO interrupt on Board_GPIO_BUTTON0.
 */

void gpioButtonFxn0(uint_least8_t x)
{
    GPIO_clearInt(Board_GPIO_BUTTON0);

    GPIO_write(Board_GPIO_LED1, Board_GPIO_LED_OFF);

    /* Select PowerMSP432_deepSleepPolicy to enable transition
     * into the PowerMSP432_DEEPSLEEP_1 (LPM4)state
     */
    Power_setConstraint(PowerMSP432_DISALLOW_DEEPSLEEP_1);
//    Power_setConstraint(PowerMSP432_DISALLOW_DEEPSLEEP_0);
    Power_setPolicy((Power_PolicyFxn)PowerMSP432_deepSleepPolicy);

    /* Refer to Device datasheet for Wake-up Sources From Low Power Modes to wake up from
     * PowerMSP432_DEEPSLEEP_1
     */
}


/*
 *  ======== mainThread ========
 */
void *mainThread(void *arg0)
{
    Board_initGeneral();
    Board_initGPIO();

    GPIO_write(Board_GPIO_LED1, Board_GPIO_LED_ON);

    GPIO_setCallback(Board_GPIO_BUTTON0, gpioButtonFxn0);
    GPIO_enableInt(Board_GPIO_BUTTON0);

    while(1)
    {
        GPIO_toggle(Board_GPIO_LED2);
        sleep(5);
    }
}
