#include "msp.h"
#include "driverlib.h"
#include "stdio.h"

#define CLKFRQ 3E6
#define T 1
#define RES 0x3ff
#define MAXTEMP 150

void TA0_0_IRQHandler();
void ADC14_IRQHandler();

const Timer_A_UpModeConfig upConfig = {
                                       TIMER_A_CLOCKSOURCE_SMCLK,
                                       TIMER_A_CLOCKSOURCE_DIVIDER_64,
                                       T * CLKFRQ / 64,                               // period for 1 s
                                       TIMER_A_TAIE_INTERRUPT_DISABLE,
                                       TIMER_A_CCIE_CCR0_INTERRUPT_ENABLE,
                                       TIMER_A_DO_CLEAR
};

/**
 * main.c
 */
void main(void)
{
	WDT_A -> CTL = WDT_A_CTL_PW | WDT_A_CTL_HOLD;		// stop the watchdog timer

	// enable LEDs
	GPIO_setAsOutputPin(GPIO_PORT_P1, GPIO_PIN0);

    // configure clock to sample every second
    CS_setDCOFrequency(CLKFRQ);
    CS_initClockSignal(CS_SMCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);
    Timer_A_configureUpMode(TIMER_A0_BASE, &upConfig);  // Configure Timer A using above struct
    Interrupt_enableInterrupt(INT_TA0_0);
    Timer_A_startCounter(TIMER_A0_BASE, TIMER_A_UP_MODE);  // start Timer A

    // set reference voltage to 2.5 V
    REF_A_setReferenceVoltage(REF_A_VREF2_5V);
    REF_A_enableReferenceVoltage();

	// enable GPIO pin 5.5
	GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P5, GPIO_PIN5, GPIO_TERTIARY_MODULE_FUNCTION);

	// enable and configure ADC module
	ADC14_enableModule();
	ADC14_initModule(ADC_CLOCKSOURCE_MCLK, ADC_PREDIVIDER_1, ADC_DIVIDER_4, 0);
	ADC14_configureSingleSampleMode(ADC_MEM0, true);
	ADC14_configureConversionMemory(ADC_MEM0, ADC_VREFPOS_INTBUF_VREFNEG_VSS, ADC_INPUT_A0, false);
	ADC14_setResolution(ADC_10BIT);
	ADC14_enableSampleTimer(ADC_MANUAL_ITERATION);
	ADC14_enableInterrupt(ADC_INT0);
	Interrupt_enableInterrupt(INT_ADC14);

	Interrupt_enableMaster();
	for(; ; ) {}
//	return;
}

void TA0_0_IRQHandler() {
    ADC14_enableConversion();
    ADC14_toggleConversionTrigger();
    Timer_A_clearCaptureCompareInterrupt(TIMER_A0_BASE, TIMER_A_CAPTURECOMPARE_REGISTER_0);
    return;
}

void ADC14_IRQHandler() {
    float inVolt = ADC14_getResult(ADC_MEM0) / (float) RES * 2.5;
    float curTemp = ADC14_getResult(ADC_MEM0) / (float) RES * MAXTEMP;
    printf("Voltage: %0.3f V\nCurrent temperature: %0.2f deg F\n", inVolt, curTemp);
    if (curTemp > 75) {
        GPIO_setOutputHighOnPin(GPIO_PORT_P1, GPIO_PIN0);
    }
    else {
        GPIO_setOutputLowOnPin(GPIO_PORT_P1, GPIO_PIN0);
    }
    ADC14_clearInterruptFlag(ADC_INT0);
    return;
}
