
/* I2C-Demoprogramm zum Lesen eines einzelnen Datenbytes von einem Slave. 
 * Wenn der Master das Datenbyte = 0x03 liest, blinkt die grne LED.
 * Andernfalls blinkt die blaue LED. 
 * Der Slave wird mit der vom VLO-Timer festgelegten Rate abgefragt. 
 * I2C ist auf SMCLK. Dies ist der MASTER-Code. */

#include <msp430.h> 
#include <stdio.h>
#include <stdint.h>

//Definieren  VLO clock
# define PERIOD 20000 
# define ON 2000 
volatile uint8_t RxData;

void main(void) {
    WDTCTL = WDTPW | WDTHOLD;   
    PM5CTL0 &= ~LOCKLPM5; 
    
    P1DIR |= BIT0;
    P1OUT &= ~BIT0; 
    
    P4DIR |= BIT7;
    P4OUT &= ~BIT7; 

    CSCTL2 |= SELA__VLOCLK;  //Setzen ACLK zu VLO
    CSCTL0_H = 0xFF; 
   
    TA0CCTL0 = CCIE;
    TA0CTL |= MC_1 + TASSEL_1;
    
    // Konfigurieren eUSCI_B0 Module fr I2C 
    P1SEL0 |= BIT2 | BIT3;
    UCB0CTLW0 |= UCSWRST;
    
    //Auswhlen SMCLK, Master, Synchro-Modus, I2C
    UCB0CTLW0 |=  UCSSEL__SMCLK + UCMST + UCSYNC + UCMODE_3;
    UCB0BRW = 10;  
    UCB0I2CSA = 0x77; 
    UCB0CTLW0 &= ~UCSWRST; 

    _BIS_SR(GIE); 
    
    while(1)
    {
        TA0CCR0 = PERIOD; 
        LPM3;       
        

        UCB0IE |= UCRXIE0; //Einschalten I2C Empfangs-Interrupt
        UCB0CTL1 |= UCTXSTT; //Wecke den Slave durch Setzen des Startbits auf
        LPM0;   // Bleibe in LPM0, bis Daten empfangen werden.
        
        while (UCB0CTL1 & UCTXSTP); // Sicherstellen, dass Stoppbedingung gesendet wurde; Datenbyte empfangen
        
        if(RxData==0x03) 
          P1OUT |= BIT0; 
        else 
          P4OUT |= BIT7;
        
        UCB0IE &= ~UCRXIE0; //Ausschalten I2C-Interrupt
        TA0CCR0 = ON; 
        LPM3;
        P1OUT &= ~BIT0; 
        P4OUT &= ~BIT7;

        
    }
}
#pragma vector=TIMER0_A0_VECTOR
 __interrupt void timerfoo (void)
{
    LPM3_EXIT;
}

#pragma vector = USCI_B0_VECTOR
__interrupt void USCI_B0_ISR(void)
{
    switch(__even_in_range(UCB0IV,30))
    {
        case 0: break;         // Vector 0: No interrupts
        case 2: break;         // Vector 2: ALIFG
        case 4: break;          // Vector 4: NACKIFG
        case 6: break;         // Vector 6: STTIFG
        case 8: break;         // Vector 8: STPIFG
        case 10: break;         // Vector 10: RXIFG3
        case 12: break;         // Vector 12: TXIFG3
        case 14: break;         // Vector 14: RXIFG2
        case 16: break;         // Vector 16: TXIFG2
        case 18: break;         // Vector 18: RXIFG1
        case 20: break;         // Vector 20: TXIFG1
        case 22:                 // Vector 22: RXIFG0
             RxData = UCB0RXBUF;                   // Get RX data
             LPM0_EXIT;             // Exit active CPU
             break;
        case 24: break;         // Vector 24: TXIFG0
        case 26: break;        // Vector 26: BCNTIFG
        case 28: break;         // Vector 28: clock low timeout
        case 30: break;         // Vector 30: 9th bit
        default: break;
    }
}
